/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.scd.ISCDTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class DateRangeTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DateRangeTableModel.class);
    public static final int DATE_TYPE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int EXPRESSION = 2;
    public static final int FROM_DATE_ROW = 0;
    public static final int TO_DATE_ROW = 1;
    private static final int VISIBLE_COLUMNS = 3;
    private static final int HIDDEN_COLUMNS = 1;
    private static final int DATETYPE_WIDTH = 100;
    private static final int COLUMNNAME_WIDTH = 100;
    private static final int EXPRESSION_WIDTH = 100;
    private ISCDTransformModel m_model;
    private boolean m_bIsLoaded;
    private IModelListener m_modelListener;
    private static final String NONE = bundle.getString("DateRangeTableModel.None.txt");

    public DateRangeTableModel(ISCDTransformModel model) {
        this.m_model = model;
        this.createColumnDefinitions();
        this.m_modelListener = new ModelListener();
        this.m_model.getModel().addModelListener(this.m_modelListener);
    }

    public void dispose() {
        this.m_model.getModel().removeModelListener(this.m_modelListener);
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("DateRangeTableModel.Date.txt"), 100);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsEnumeratedTableColumn(1, bundle.getString("DateRangeTableModel.ColumnName.txt"), 100, this.getValuesList());
        ((WsEnumeratedTableColumn)this.m_aColumns[1]).setSorted(true);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("DateRangeTableModel.Expression.txt"), 100);
        this.m_aColumns[this.getColumnCount()] = new WsObjectTableColumn();
        this.m_bIsLoaded = false;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    public void moveDataToModel() {
        this.clear();
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            return;
        }
        IColumn fromColumn = this.m_model.getFromDateColumn();
        IColumn toColumn = this.m_model.getToDateColumn();
        ITextExpression fromExpression = this.m_model.getFromDateExpression();
        ITextExpression toExpression = this.m_model.getToDateExpression();
        try {
            ArrayList<String> alRow1 = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow1.add(bundle.getString("DateRangeTableModel.FromDate.txt"));
            alRow1.add(fromColumn != null ? fromColumn.getName() : NONE);
            alRow1.add(fromExpression != null ? fromExpression.getText(null, targets[0].isQuoted()) : "");
            alRow1.add((String)fromColumn);
            this.m_lData.add(alRow1);
            ArrayList<String> alRow2 = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow2.add(bundle.getString("DateRangeTableModel.ToDate.txt"));
            alRow2.add(toColumn != null ? toColumn.getName() : NONE);
            alRow2.add(toExpression != null ? toExpression.getText(null, targets[0].isQuoted()) : "");
            alRow2.add((String)toColumn);
            this.m_lData.add(alRow2);
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (CodegenException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        catch (BadServerDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
        this.m_bIsLoaded = true;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public boolean isModelLoaded() {
        return this.m_bIsLoaded;
    }

    public IColumn getColumnForRow(int iRow) {
        return (IColumn)this.getValueAt(iRow, this.getColumnCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            return;
        }
        IColumn[] columns = targets[0].getColumns();
        if (columnIndex == 1) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("DateRangeTableModel.setvalueAt: Expecting string, got: " + value.getClass().getName());
            }
            String columnName = (String)value;
            if (columnName == NONE) {
                if (rowIndex == 0) {
                    this.m_model.setFromDateColumn(null);
                    return;
                } else {
                    if (rowIndex != 1) throw new IndexOutOfBoundsException("DateRangeTableModel.setValueAt: Row index " + rowIndex + " out of bounds, must be 0 or 1");
                    this.m_model.setToDateColumn(null);
                }
                return;
            } else {
                IColumn column = null;
                for (int index = 0; index < columns.length; ++index) {
                    if (!columnName.equalsIgnoreCase(columns[index].getName())) continue;
                    column = columns[index];
                    break;
                }
                if (column == null) {
                    throw new IllegalStateException("DateRangeTableModel.setValueAt: Cannot find column named " + columnName);
                }
                this.m_model.getModel().startCompoundUndoable();
                try {
                    if (rowIndex == 0) {
                        this.m_model.setFromDateColumn(column);
                        return;
                    }
                    if (rowIndex != 1) throw new IllegalStateException("DateRangeTableModle.setValueAt: Unexpected row index: " + rowIndex);
                    this.m_model.setToDateColumn(column);
                    return;
                }
                finally {
                    this.m_model.getModel().endCompoundUndoable();
                }
            }
        } else if (columnIndex == 2) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("DateRangeTableModel.setvalueAt: Expecting string, got: " + value.getClass().getName());
            }
            String expressionText = (String)value;
            this.m_model.getModel().startCompoundUndoable();
            try {
                ITextExpression expression;
                if (rowIndex == 0) {
                    expression = this.m_model.getFromDateExpression();
                } else {
                    if (rowIndex != 1) throw new IllegalStateException("DateRangeTableModle.setValueAt: Unexpected row index: " + rowIndex);
                    expression = this.m_model.getToDateExpression();
                }
                if (expression == null) {
                    expression = this.m_model.getModel().getObjectFactory().createNewTextExpression(this.m_model.getID());
                    expression.setText(expressionText, (IObject[])columns);
                    if (rowIndex == 0) {
                        this.m_model.setFromDateExpression(expression);
                        return;
                    }
                    if (rowIndex != 1) throw new IllegalStateException("DateRangeTableModle.setValueAt: Unexpected row index: " + rowIndex);
                    this.m_model.setToDateExpression(expression);
                    return;
                }
                expression.setText(expressionText, (IObject[])columns);
                return;
            }
            finally {
                this.m_model.getModel().endCompoundUndoable();
            }
        } else {
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }

    private String[] getValuesList() {
        ITable[] targets = this.m_model.getTargetTables();
        if (targets == null || targets.length == 0) {
            return new String[]{NONE};
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(NONE);
        IColumn[] columns = targets[0].getColumns();
        for (int index = 0; index < columns.length; ++index) {
            if (columns[index].getType() != 1) continue;
            values.add(columns[index].getName());
        }
        if (values.size() < 1) {
            MessageUtil.displayMessage((String)bundle.getString("DateRangeTableModel.NoNumericColsError.txt"), (int)0);
        }
        return values.toArray(new String[0]);
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            try {
                if (type == "ModelController:UnknownChanges") {
                    DateRangeTableModel.this.moveDataToModel();
                } else if (type == "SCDTransform:FromDateColumnChanged") {
                    IColumn column = DateRangeTableModel.this.m_model.getFromDateColumn();
                    DateRangeTableModel.super.setValueAt(column != null ? column.getName() : NONE, 0, 1);
                } else if (type == "SCDTransform:FromDateExpressionChanged") {
                    ITextExpression expression = DateRangeTableModel.this.m_model.getFromDateExpression();
                    String text = expression != null ? expression.getText(null, DateRangeTableModel.this.m_model.isQuotingNeeded()) : "";
                    DateRangeTableModel.super.setValueAt(text, 0, 2);
                } else if (type == "SCDTransform:ToDateColumnChanged") {
                    IColumn column = DateRangeTableModel.this.m_model.getToDateColumn();
                    DateRangeTableModel.super.setValueAt(column != null ? column.getName() : NONE, 1, 1);
                } else if (type == "SCDTransform:ToDateExpressionChanged") {
                    ITextExpression expression = DateRangeTableModel.this.m_model.getToDateExpression();
                    String text = expression != null ? expression.getText(null, DateRangeTableModel.this.m_model.isQuotingNeeded()) : "";
                    DateRangeTableModel.super.setValueAt(text, 1, 2);
                } else if (type == "TextExpression:TextChanged") {
                    if (event.getModelObject() == DateRangeTableModel.this.m_model.getFromDateExpression()) {
                        ITextExpression expression = DateRangeTableModel.this.m_model.getFromDateExpression();
                        String text = expression.getText(null, DateRangeTableModel.this.m_model.isQuotingNeeded());
                        DateRangeTableModel.super.setValueAt(text, 0, 2);
                    } else if (event.getModelObject() == DateRangeTableModel.this.m_model.getToDateExpression()) {
                        ITextExpression expression = DateRangeTableModel.this.m_model.getToDateExpression();
                        String text = expression.getText(null, DateRangeTableModel.this.m_model.isQuotingNeeded());
                        DateRangeTableModel.super.setValueAt(text, 1, 2);
                    }
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (CodegenException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (BadServerDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            catch (ServerException e1) {
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
        }
    }
}

