/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IConditionActionSetInstance;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ConditionActionsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ConditionActionsTableModel.class);
    private static final int CONDITION_NAME_COLUMN = 0;
    private static final int ACTION_NAME_COLUMN = 1;
    public static final int CONDITIONACTIONSET_COLUMN = 2;
    private static final int CONDITION_WIDTH = 220;
    private static final int ACTION_WIDTH = 220;
    private static final int TOTAL_COLS = 2;
    private static final int TOTAL_HIDDEN_COLS = 1;
    private IConditionActionSetContainer m_container;
    private int[] m_aRowMappings;
    private IModelListener m_lsnrModel;

    public ConditionActionsTableModel(IConditionActionSetContainer container) {
        this.m_container = container;
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsEnumeratedTableColumn(0, bundle.getString("ConditionActionsTableModel.Condition.txt"), 220);
        this.m_aColumns[1] = new cActionTableColumn(1, bundle.getString("ConditionActionsTableModel.Action.txt"), 220);
        this.m_aColumns[2] = new WsMetadataTableColumn();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void setValueAt(Object obj, int iRow, int iColumn) {
        IConditionActionSet cas = (IConditionActionSet)this.getValueAt(iRow, 2);
        if (iColumn == 0) {
            IConditionActionSet template = this.findConditionActionSetTemplate((String)obj);
            ICondition tempCondition = template.getCondition();
            ICondition condition = this.m_container.getModel().getObjectFactory().createNewConditionInstance(this.m_container.getID(), cas, tempCondition);
            ((IConditionActionSetInstance)cas).setUniqueIdentifier(template.getUniqueIdentifier(), template);
            cas.setInstance(true);
            cas.setCondition(condition);
        } else if (iColumn == 1) {
            IConditionActionSet template = this.findConditionActionSetTemplate(cas.getUniqueIdentifier());
            List lTemplateActions = template.getActionList();
            for (int iAction = 0; iAction < lTemplateActions.size(); ++iAction) {
                IConditionAction tempAction = (IConditionAction)lTemplateActions.get(iAction);
                if (!tempAction.getName().equalsIgnoreCase((String)obj)) continue;
                IConditionAction action = this.m_container.getModel().getObjectFactory().createNewConditionActionInstance(this.m_container.getID(), cas, tempAction);
                cas.getActionList().clear();
                cas.getActionList().add(action);
            }
        }
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not supported.  Model does not use a store.");
    }

    public void moveDataToModel() {
        this.clear();
        WsEnumeratedTableColumn colCondition = (WsEnumeratedTableColumn)this.m_aColumns[0];
        if (this.getConditionActionSetTemplates().size() > 0) {
            List lSets = this.getConditionActionSetTemplates();
            ArrayList<String> lConditionNames = new ArrayList<String>();
            for (int iSet = 0; iSet < lSets.size(); ++iSet) {
                lConditionNames.add(((IConditionActionSet)lSets.get(iSet)).getCondition().getName());
            }
            String[] saCodeConditions = lConditionNames.toArray(new String[0]);
            colCondition.setPossibleValues(saCodeConditions);
            colCondition.setDefaultValue(saCodeConditions[0]);
        } else {
            colCondition.setDefaultValue("");
        }
        int nRows = 0;
        List lCASs = this.m_container.getConditionActionSetsList();
        for (int iCAS = 0; iCAS < lCASs.size(); ++iCAS) {
            IConditionActionSet cas = (IConditionActionSet)lCASs.get(iCAS);
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            if (cas.getCondition() != null) {
                alRow.add(cas.getCondition().getName());
            }
            alRow.add(((IConditionAction)cas.getActionList().get(0)).getName());
            alRow.add((String)cas);
            this.m_lData.add(alRow);
            ++nRows;
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not supported.  Changes are made directly to model.");
    }

    private List createRowValues(IConditionActionSet set) {
        ArrayList<String> lValues = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
        lValues.add(set.getCondition().getName());
        lValues.add(((IConditionAction)set.getActionList().get(0)).getName());
        lValues.add((String)set);
        return lValues;
    }

    public ICondition getDefaultCondition() {
        IConditionActionSet cas = (IConditionActionSet)this.getConditionActionSetTemplates().get(0);
        return cas.getCondition();
    }

    public String[] getTemplateActionNames(String sConditionName) {
        IConditionAction[] actions = this.getTemplateActions(sConditionName);
        ArrayList<String> names = new ArrayList<String>();
        for (int iAction = 0; iAction < actions.length; ++iAction) {
            names.add(actions[iAction].getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public IConditionAction getTemplateAction(String sActionId) {
        for (int iSet = 0; iSet < this.m_container.getTemplateConditionActionSetsList().size(); ++iSet) {
            IConditionActionSet set = (IConditionActionSet)this.m_container.getTemplateConditionActionSetsList().get(iSet);
            List actions = set.getActionList();
            for (int iAction = 0; iAction < actions.size(); ++iAction) {
                IConditionAction action = (IConditionAction)actions.get(iAction);
                if (!action.getUniqueIdentifier().equals(sActionId)) continue;
                return action;
            }
        }
        return null;
    }

    public IConditionAction[] getTemplateActions(String sConditionName) {
        if (sConditionName != null) {
            for (int iSet = 0; iSet < this.m_container.getTemplateConditionActionSetsList().size(); ++iSet) {
                IConditionActionSet set = (IConditionActionSet)this.m_container.getTemplateConditionActionSetsList().get(iSet);
                if (!set.getCondition().getName().equals(sConditionName)) continue;
                return set.getActions();
            }
        }
        return null;
    }

    public int getRowIndex(IConditionActionSet set) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(2) != set) continue;
            return iRow;
        }
        return -1;
    }

    public List getConditionActionSetTemplates() {
        return this.m_container.getTemplateConditionActionSetsList();
    }

    public IConditionActionSet findConditionActionSetTemplate(String searchName) {
        for (int iSet = 0; iSet < this.getConditionActionSetTemplates().size(); ++iSet) {
            IConditionActionSet set = (IConditionActionSet)this.getConditionActionSetTemplates().get(iSet);
            if (!set.getCondition().getName().equals(searchName) && !set.getUniqueIdentifier().equals(searchName)) continue;
            return set;
        }
        return null;
    }

    public IConditionActionSet getConditionActionSetForRow(int iRow) {
        return (IConditionActionSet)this.getValueAt(iRow, 2);
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            IConditionActionSet cas;
            int iRow;
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                ConditionActionsTableModel.this.moveDataToModel();
            } else if (obj == ConditionActionsTableModel.this.m_container) {
                if (sType == "Object:ConditionActionSetAdded") {
                    IConditionActionSet cas2 = (IConditionActionSet)ev.getData();
                    int iInsert = ConditionActionsTableModel.this.m_container.getConditionActionSetsList().indexOf(cas2);
                    if (cas2.getCondition() == null) {
                        ICondition condition = ConditionActionsTableModel.this.m_container.getModel().getObjectFactory().createNewConditionInstance(ConditionActionsTableModel.this.m_container.getID(), cas2, ConditionActionsTableModel.this.getDefaultCondition());
                        cas2.setCondition(condition);
                    }
                    if (cas2.getActionList().isEmpty()) {
                        IConditionAction[] actions = ConditionActionsTableModel.this.getTemplateActions(ConditionActionsTableModel.this.getDefaultCondition().getName());
                        IConditionAction action = ConditionActionsTableModel.this.m_container.getModel().getObjectFactory().createNewConditionActionInstance(ConditionActionsTableModel.this.m_container.getID(), cas2, actions[0]);
                        cas2.getActionList().add(action);
                    }
                    ConditionActionsTableModel.this.insertRow(iInsert - 1, ConditionActionsTableModel.this.createRowValues(cas2));
                } else if (sType == "Object:ConditionActionSetRemoved") {
                    ConditionActionsTableModel.this.deleteRow(ConditionActionsTableModel.this.getRowIndex((IConditionActionSet)ev.getData()));
                }
            } else if (obj instanceof IConditionActionSet && (iRow = ConditionActionsTableModel.this.getRowIndex(cas = (IConditionActionSet)obj)) != -1) {
                if (sType == "ConditionActionSetModel:ConditionChanged") {
                    ConditionActionsTableModel.super.setValueAt(cas.getCondition().getName(), iRow, 0);
                } else if (sType == "ConditionActionSet:ActionAdded") {
                    ConditionActionsTableModel.super.setValueAt(((IConditionAction)cas.getActionList().get(0)).getName(), iRow, 1);
                }
            }
        }
    }

    protected class cActionTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public cActionTableColumn(int iModelIndex, String sName, int cxWidth) {
            super(iModelIndex, sName, cxWidth);
        }

        public void populate(JTable tbl, int iRow, int iCol) {
            TableModel Model = tbl.getModel();
            String sCondition = (String)Model.getValueAt(iRow, 0);
            WsEnumeratedTableColumn colAction = (WsEnumeratedTableColumn)ConditionActionsTableModel.this.m_aColumns[1];
            String[] saActions = ConditionActionsTableModel.this.getTemplateActionNames(sCondition);
            if (saActions.length > 0) {
                colAction.setPossibleValues(saActions);
                colAction.setDefaultValue(saActions[0]);
            } else {
                colAction.setDefaultValue("");
            }
        }
    }
}

