/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IConditionActionSetInstance;
import com.sas.etl.models.other.IProperty;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.visuals.common.ConditionActionOptionEventPanel;
import com.sas.wadmin.visuals.common.ConditionActionOptionsPanel;
import com.sas.wadmin.visuals.common.ConditionActionOptionsTableModel;
import com.sas.wadmin.visuals.common.ConditionActionsTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class ConditionActionsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ConditionActionsTab.class);
    private static final int UP = 0;
    private static final int DOWN = 1;
    protected IConditionActionSetContainer m_container;
    protected ConditionActionsTableModel m_mdlConditionActions;
    protected WsTable m_tblConditionActions;
    private JScrollPane m_scrConditionActions;
    private JPanel m_pnlButtons;
    private JButton m_btnNew;
    private JButton m_btnDelete;
    private JButton m_btnMoveUp;
    private JButton m_btnMoveDown;
    private JButton m_btnActionOptions;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actActionOptions;
    private boolean m_bOrderChanged;

    public ConditionActionsTab(IConditionActionSetContainer container) {
        this.m_container = container;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("status_handling_tab");
        this.setName(bundle.getString("ConditionActionsTab.Title.txt"));
    }

    protected void initialize() {
        this.createActions();
        this.createConditionActionsTable();
        this.createButtonsPanel();
    }

    private void createConditionActionsTable() {
        this.m_mdlConditionActions = new ConditionActionsTableModel(this.m_container);
        this.m_tblConditionActions = new cPopUpOnColumnTable(this.m_mdlConditionActions);
        this.m_tblConditionActions.setColumnsReorderable(false);
        this.m_tblConditionActions.setColumnHoldingEnabled(false);
        this.m_tblConditionActions.setColumnHidingEnabled(false);
        this.m_tblConditionActions.setRowHoldingEnabled(false);
        this.m_tblConditionActions.setAutoResizeMode(3);
        this.m_tblConditionActions.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblConditionActions.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_tblConditionActions.restoreSettings("ConditionActionsTab");
        this.m_tblConditionActions.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new RowHeaderPopupMenuRequestListener());
        this.m_tblConditionActions.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new TablePopupMenuRequestListener());
        this.m_tblConditionActions.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.m_mdlConditionActions.addTableModelListener(new TheTableModelListener());
        ((WsDefaultTableRowModel)this.m_tblConditionActions.getRowModel()).addRowModelListener((WsTableRowModelListener)new TableRowModelListener());
        this.m_scrConditionActions = new JScrollPane((Component)this.m_tblConditionActions);
    }

    private void createButtonsPanel() {
        this.m_btnMoveUp = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnActionOptions = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actActionOptions);
        JToolBar barLeft = WsUIUtilities.createToolBar();
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        barLeft.add(this.m_btnMoveUp);
        barLeft.add(this.m_btnMoveDown);
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        pnlRight.add(this.m_btnActionOptions);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)barLeft, "West");
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    private void createActions() {
        this.m_actNew = new NewAction();
        this.m_actDelete = new DeleteAction();
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actActionOptions = new cActionOptionsAction();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_scrConditionActions, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_pnlButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        if (!this.m_tblConditionActions.stopCellEditing()) {
            return false;
        }
        int nRows = this.m_tblConditionActions.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            IConditionActionSet oCAS = (IConditionActionSet)this.m_mdlConditionActions.getValueAt(iRow, 2);
            List lActions = oCAS.getActionList();
            boolean bDisplayMessage = false;
            if (lActions != null && lActions.size() > 0) {
                block1: for (int iAction = 0; iAction < lActions.size(); ++iAction) {
                    IConditionAction action = (IConditionAction)lActions.get(iAction);
                    if (action.getUniqueIdentifier().equals("DIS_SENDEVENT") && action.getActionPropertiesList().size() == 0) {
                        bDisplayMessage = true;
                        break;
                    }
                    List lActionOptions = ((IConditionAction)lActions.get(iAction)).getActionPropertiesList();
                    for (int iActionOption = 0; iActionOption < lActionOptions.size(); ++iActionOption) {
                        IProperty actionProperty = (IProperty)lActionOptions.get(iActionOption);
                        if (action.getUniqueIdentifier().equals("DIS_SETTARGETCOL")) {
                            if (actionProperty.getExpression() != null) continue block1;
                            bDisplayMessage = true;
                            continue block1;
                        }
                        if (!actionProperty.getDefaultValue().equals("")) continue;
                        bDisplayMessage = true;
                        continue block1;
                    }
                }
            }
            if (!bDisplayMessage) continue;
            MessageUtil.displayMessage((String)bundle.getString("ConditionActionsTab.MissingOptionsMessage.txt"), (String)bundle.getString("ConditionActionsTab.MissingOptionsTitle.txt"), (int)0, (int)-1);
            return false;
        }
        return true;
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_mdlConditionActions.moveDataToModel();
        if (this.m_mdlConditionActions.getRowCount() > 0) {
            this.m_tblConditionActions.selectCell(0, 0);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        this.setDataChanged(false);
        this.m_bOrderChanged = false;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actActionOptions.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblConditionActions.setEditable(bEditable);
        this.m_tblConditionActions.setSortingEnabled(bEditable);
        this.m_tblConditionActions.setRowsReorderable(bEditable);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlConditionActions.dispose();
        this.m_tblConditionActions.saveSettings("ConditionActionsTab");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showActionOptionsDialog() {
        if (!this.m_tblConditionActions.stopCellEditing()) {
            return;
        }
        int iSelectedRow = this.m_tblConditionActions.convertRowIndexToModel(this.m_tblConditionActions.getCurrentRow());
        IConditionActionSet oCAS = this.m_mdlConditionActions.getConditionActionSetForRow(iSelectedRow);
        if (oCAS.getActionList().size() == 0) {
            return;
        }
        IConditionAction action = (IConditionAction)oCAS.getActionList().get(0);
        if (action.getPropertyCount() == 0) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            if (!action.getUniqueIdentifier().equals("DIS_SENDEVENT")) {
                ConditionActionOptionsPanel pnl = new ConditionActionOptionsPanel(oCAS);
                String sActionOptionsDialogTitle = bundle.getString("ConditionActionsTab.ActionOptionsDialogTitle.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sActionOptionsDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.setHelpProduct("wdb");
                dlg.setHelpTopic("action_options_win");
                dlg.setEditable(this.isEditable());
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    ConditionActionOptionsTableModel tableModel = pnl.getConditionActionOptionsTableModel();
                    for (int i = 0; i < tableModel.getRowCount(); ++i) {
                        IProperty oActionOption = (IProperty)tableModel.getValueAt(i, 2);
                        oActionOption.setDefaultValue((String)tableModel.getValueAt(i, 1));
                    }
                    if (oCAS.getUniqueIdentifier().equals("DIS_SETJOBSTATUS")) {
                        String userColumnName = pnl.getUserSuppliedColumnName();
                        if (userColumnName == null || userColumnName.isEmpty()) {
                            userColumnName = "user";
                        }
                        oCAS.setUserProperty("StatusTableUserColumn", userColumnName);
                    }
                    this.setDataChanged(true);
                }
            } else {
                IConditionActionSet tempCAS = this.m_mdlConditionActions.findConditionActionSetTemplate(oCAS.getUniqueIdentifier());
                if (tempCAS == null) {
                    return;
                }
                List tempActions = tempCAS.getActionList();
                IConditionAction tempAction = null;
                for (int iTempAction = 0; iTempAction < tempActions.size() && (tempAction = (IConditionAction)tempActions.get(iTempAction)).getUniqueIdentifier() != action.getUniqueIdentifier(); ++iTempAction) {
                }
                if (tempAction == null || tempAction.getEventPropertyTemplatesList().isEmpty()) {
                    MessageUtil.displayMessage((String)bundle.getString("ConditionActionsTab.MissingEventBrokerMessage.txt"), (String)bundle.getString("ConditionActionsTab.MissingEventBrokerTitle.txt"), (int)1, (int)-1);
                    return;
                }
                ConditionActionOptionEventPanel pnl = new ConditionActionOptionEventPanel(oCAS, tempAction.getEventPropertyTemplatesList());
                String sEventOptionsDialogTitle = bundle.getString("ConditionActionsTab.EventOptionsDialogTitle.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sEventOptionsDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    IProperty oEventPropertyTemplate = pnl.getSelectEvent();
                    List actions = oCAS.getActionList();
                    if (actions == null || actions.isEmpty()) {
                        return;
                    }
                    List lActionOptions = ((IConditionAction)actions.get(0)).getActionPropertiesList();
                    for (int iProperty = 0; iProperty < lActionOptions.size(); ++iProperty) {
                        IProperty oActionOption = (IProperty)lActionOptions.get(iProperty);
                        if (!oActionOption.getPropertyRole().equals("Event")) continue;
                        oActionOption.setPropertyName(oEventPropertyTemplate.getPropertyName());
                        oActionOption.setName(oEventPropertyTemplate.getName());
                        oActionOption.setDescription(oEventPropertyTemplate.getDescription());
                        oActionOption.setDefaultValue(oEventPropertyTemplate.getDefaultValue());
                    }
                    this.setDataChanged(true);
                }
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNewRow() {
        if (this.m_mdlConditionActions.getConditionActionSetTemplates().isEmpty()) {
            MessageUtil.displayMessage((String)bundle.getString("ConditionActionsTab.Error.txt"), (int)0);
            return;
        }
        if (!this.m_tblConditionActions.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            int iRow = this.m_tblConditionActions.convertRowIndexToModel(this.m_tblConditionActions.getLastSelectedRow());
            int iSet = iRow == -1 ? this.m_container.getConditionActionSetsList().size() - 1 : this.m_container.getConditionActionSetsList().indexOf(this.m_mdlConditionActions.getConditionActionSetForRow(iRow));
            this.m_tblConditionActions.clearSelection();
            IConditionActionSet cas = this.m_container.getModel().getObjectFactory().createNewConditionActionSetInstance(this.m_container.getID());
            IConditionActionSet tempCas = this.m_mdlConditionActions.findConditionActionSetTemplate(this.m_mdlConditionActions.getDefaultCondition().getName());
            ((IConditionActionSetInstance)cas).setUniqueIdentifier(tempCas.getUniqueIdentifier(), tempCas);
            this.m_container.getConditionActionSetsList().add(iSet + 1, cas);
            this.m_tblConditionActions.selectRow(iRow + 1);
            this.m_container.getModel().undoableEditHappened(this.m_tblConditionActions.createSelectRowUndoable(iRow + 1, false));
            int iEditColumn = Math.max(this.m_tblConditionActions.convertColumnIndexToView(this.m_mdlConditionActions.getDefaultEditColumnIndex()), 0);
            this.m_tblConditionActions.editCellAt(iRow + 1, iEditColumn);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedConditionAction() {
        if (!this.m_tblConditionActions.stopCellEditing()) {
            return;
        }
        List lCASs = this.m_container.getConditionActionSetsList();
        this.m_container.getModel().startCompoundUndoable();
        try {
            int[] aSelectedRows = this.m_tblConditionActions.getSelectedRowsFromSelectedCells();
            this.m_container.getModel().undoableEditHappened(this.m_tblConditionActions.createSelectRowsUndoable(aSelectedRows, true));
            for (int iSelectedRow = aSelectedRows.length - 1; iSelectedRow >= 0; --iSelectedRow) {
                int iRow = this.m_tblConditionActions.convertRowIndexToModel(aSelectedRows[iSelectedRow]);
                lCASs.remove(iRow);
            }
            this.m_container.getModel().undoableEditHappened(this.m_tblConditionActions.createClearSelectionUndoable(true, true));
            int iRow = Math.min(aSelectedRows[aSelectedRows.length - 1] - (aSelectedRows.length - 1), this.m_tblConditionActions.getRowCount() - 1);
            if (iRow >= 0) {
                this.m_tblConditionActions.selectRow(iRow);
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveConditionAction(int iFrom, int iTo) {
        if (!this.m_tblConditionActions.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            this.m_tblConditionActions.clearSelection();
            IConditionActionSet cas = this.m_mdlConditionActions.getConditionActionSetForRow(iFrom);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectConditionActionsUndoable(cas, true, false));
            List lCASs = this.m_container.getConditionActionSetsList();
            lCASs.remove(cas);
            lCASs.add(iTo, cas);
            this.m_tblConditionActions.selectRow(iTo);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectConditionActionsUndoable(cas, false, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    private void selectConditionActions(IConditionActionSet[] aConditionActions) {
        this.m_tblConditionActions.clearSelection();
        for (int iCAS = 0; iCAS < aConditionActions.length; ++iCAS) {
            int iRow = this.m_mdlConditionActions.getRowIndex(aConditionActions[iCAS]);
            if (iRow == -1) continue;
            this.m_tblConditionActions.addRowToSelection(this.m_tblConditionActions.convertRowIndexToView(iRow));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedConditionAction(int eDir) {
        if (!this.m_tblConditionActions.stopCellEditing()) {
            return;
        }
        List lConditionActionSets = this.m_container.getConditionActionSetsList();
        this.m_container.getModel().startCompoundUndoable();
        try {
            int[] aSelectedRows = this.m_tblConditionActions.getSelectedRowsFromSelectedCells();
            this.m_container.getModel().undoableEditHappened(this.m_tblConditionActions.createSelectRowsUndoable(aSelectedRows, true));
            if (eDir == 1) {
                int iSelectedRow = aSelectedRows.length - 1;
                while (iSelectedRow >= 0) {
                    int iRow = this.m_tblConditionActions.convertRowIndexToModel(aSelectedRows[iSelectedRow]);
                    lConditionActionSets.add(iRow + 1, lConditionActionSets.remove(iRow));
                    int n = iSelectedRow--;
                    aSelectedRows[n] = aSelectedRows[n] + 1;
                }
            } else {
                int iSelectedRow = 0;
                while (iSelectedRow < aSelectedRows.length) {
                    int iRow = this.m_tblConditionActions.convertRowIndexToModel(aSelectedRows[iSelectedRow]);
                    lConditionActionSets.add(iRow - 1, lConditionActionSets.remove(iRow));
                    int n = iSelectedRow++;
                    aSelectedRows[n] = aSelectedRows[n] - 1;
                }
            }
            this.m_tblConditionActions.selectRows(aSelectedRows);
            this.m_container.getModel().undoableEditHappened(this.m_tblConditionActions.createSelectRowsUndoable(aSelectedRows, false));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    private void updateActions() {
        boolean bSelected;
        int[] aSelectedRows = this.m_tblConditionActions.getSelectedRowsFromSelectedCells();
        boolean bEditable = this.isEditable();
        boolean bNotFirst = bSelected = aSelectedRows.length > 0;
        boolean bNotLast = bSelected;
        int iLastRow = this.m_tblConditionActions.getRowCount() - 1;
        int nSelectedRows = aSelectedRows.length;
        for (int iSelectedRow = 0; iSelectedRow < nSelectedRows; ++iSelectedRow) {
            if (aSelectedRows[iSelectedRow] == 0) {
                bNotFirst = false;
            }
            if (aSelectedRows[iSelectedRow] != iLastRow) continue;
            bNotLast = false;
        }
        this.m_actDelete.setEnabled(bEditable && bSelected);
        this.m_actNew.setEnabled(bEditable);
        this.m_actActionOptions.setEnabled(bSelected);
        this.m_actMoveUp.setEnabled(bEditable && bNotFirst);
        this.m_actMoveDown.setEnabled(bEditable && bNotLast);
    }

    protected class cPopUpOnColumnTable
    extends WsTable {
        public cPopUpOnColumnTable(WsAbstractTableModel mdl) {
            super(mdl);
        }

        public void editingStopped(ChangeEvent e) {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                int iRow = this.editingRow;
                int iCol = this.editingColumn;
                Object oldValue = this.getValueAt(iRow, iCol);
                super.editingStopped(e);
                Object newValue = this.getValueAt(iRow, iCol);
                if (newValue != null && !oldValue.equals(newValue)) {
                    if (iCol == 1) {
                        ConditionActionsTab.this.m_actActionOptions.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    } else {
                        this.removeEditor();
                    }
                }
            }
        }
    }

    private class RowHeaderPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private RowHeaderPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = ConditionActionsTab.this.m_tblConditionActions.createRowHeaderPopupMenu();
            WsUIUtilities.addSpaceIconToPopupMenu((JPopupMenu)mnuPopup);
            if (mnuPopup.getComponentCount() != 0) {
                mnuPopup.addSeparator();
            }
            mnuPopup.add(new JMenuItem((Action)ConditionActionsTab.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)ConditionActionsTab.this.m_actDelete));
            mnuPopup.add(new JMenuItem((Action)ConditionActionsTab.this.m_actActionOptions));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class TablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)ConditionActionsTab.this.m_actNew));
            mnuPopup.add(new JMenuItem((Action)ConditionActionsTab.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ConditionActionsTab.this.updateActions();
        }
    }

    private class TheTableModelListener
    implements TableModelListener {
        private TheTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (ConditionActionsTab.this.isListeningForChanges()) {
                ConditionActionsTab.this.setDataChanged(true);
            }
            if (e.getType() == 0) {
                ConditionActionsTab.this.m_tblConditionActions.clearSelection();
                ConditionActionsTab.this.m_tblConditionActions.selectCell(e.getFirstRow(), e.getColumn());
            }
            if (e.getType() == -1) {
                ConditionActionsTab.this.m_tblConditionActions.cancelCellEditing();
            }
        }
    }

    private class TableRowModelListener
    implements WsTableRowModelListener {
        private TableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)ConditionActionsTab.this.m_tblConditionActions.getRowModel();
            mdlRows.clearRowMoves();
            ConditionActionsTab.this.moveConditionAction(e.getFromIndex(), e.getToIndex());
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            ConditionActionsTab.this.setDataChanged(true);
            ConditionActionsTab.this.m_bOrderChanged = true;
        }
    }

    private class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "ConditionActionsTab.Action.New", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ConditionActionsTab.this.createNewRow();
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "ConditionActionsTab.Action.Delete", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ConditionActionsTab.this.deleteSelectedConditionAction();
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "ConditionActionsTab.Action.MoveUp", 18);
        }

        public void actionPerformed(ActionEvent e) {
            ConditionActionsTab.this.moveSelectedConditionAction(0);
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "ConditionActionsTab.Action.MoveDown", 18);
        }

        public void actionPerformed(ActionEvent e) {
            ConditionActionsTab.this.moveSelectedConditionAction(1);
        }
    }

    protected class cActionOptionsAction
    extends WsAbstractAction {
        public cActionOptionsAction() {
            super(bundle, "ConditionActionsTab.ActionOptions", true);
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            ConditionActionsTab.this.showActionOptionsDialog();
        }
    }

    private class SelectConditionActionsUndoable
    extends AbstractUndoableEdit {
        private IConditionActionSet[] m_aConditionActions;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectConditionActionsUndoable(IConditionActionSet column, boolean bOnUndo, boolean bOnRedo) {
            this(new IConditionActionSet[]{column}, bOnUndo, bOnRedo);
        }

        public SelectConditionActionsUndoable(IConditionActionSet[] aConditionActions, boolean bOnUndo, boolean bOnRedo) {
            this.m_aConditionActions = aConditionActions;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            ConditionActionsTab.this.m_tblConditionActions.cancelCellEditing();
            if (this.m_bOnUndo) {
                ConditionActionsTab.this.selectConditionActions(this.m_aConditionActions);
            }
        }

        @Override
        public void redo() {
            super.redo();
            ConditionActionsTab.this.m_tblConditionActions.cancelCellEditing();
            if (this.m_bOnRedo) {
                ConditionActionsTab.this.selectConditionActions(this.m_aConditionActions);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aConditionActions, null);
            this.m_aConditionActions = null;
        }
    }
}

