/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ConditionActionOptionsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ConditionActionOptionsTableModel.class);
    public static final int NAME_COL = 0;
    public static final int VALUE_COL = 1;
    public static final int PROPERTY_COL = 2;
    private static final int W_NAME_COL = 220;
    private static final int W_VALUE_COL = 250;
    private static final int TOTAL_COLS = 2;
    private static final int TOTAL_HIDDEN_COLS = 1;
    private IConditionActionSet m_oConditionActionSet;

    public ConditionActionOptionsTableModel(IConditionActionSet oConditionActionSet) {
        this.m_oConditionActionSet = oConditionActionSet;
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("ConditionActionOptionsTableModel.Name.txt"), 220, 200);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ConditionActionOptionsTableModel.Value.txt"), 250, 200);
        this.m_aColumns[2] = new WsMetadataTableColumn();
        WsStringTableColumn tcName_Col = (WsStringTableColumn)this.m_aColumns[0];
        tcName_Col.setEditable(false);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    private int getRowIndex(IProperty property) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(2) != property) continue;
            return iRow;
        }
        return -1;
    }

    public void populateStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("populateStore not supported.  Model does not use a store.");
    }

    public void moveDataToModel() {
        this.clear();
        List actions = this.m_oConditionActionSet.getActionList();
        if (actions == null || actions.isEmpty()) {
            return;
        }
        List lActionOptions = ((IConditionAction)actions.get(0)).getActionPropertiesList();
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        nRows = 0;
        for (int iProperty = 0; iProperty < lActionOptions.size(); ++iProperty) {
            IProperty oActionOption = (IProperty)lActionOptions.get(iProperty);
            if (!oActionOption.getPropertyRole().equals("parameter")) continue;
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(oActionOption.getName());
            if (oActionOption.getDefaultValue().equals("") && oActionOption.getName().equals("Message")) {
                alRow.add(this.m_oConditionActionSet.getCondition().getName());
            } else {
                alRow.add(oActionOption.getDefaultValue());
            }
            alRow.add((String)oActionOption);
            this.m_lData.add(alRow);
            ++nRows;
        }
        this.m_nRowInstances = nRows;
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("moveDataToStore not supported.  Changes are made directly to model.");
    }

    public int findActionRow(Property oProperty) {
        int nRows = this.getRowCount();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            if (!oProperty.equals(this.getValueAt(iRow, 2))) continue;
            return iRow;
        }
        return -1;
    }
}

