/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ChooseColumnsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ChooseColumnsPanel.class);
    private IPhysicalTable m_sourceTable;
    private cTreeListSelector m_columnSelector;
    private JTree m_tree;
    private ITransformPort<IPhysicalTable> m_port;

    public ChooseColumnsPanel(ITransformPort<IPhysicalTable> port, IPhysicalTable sourceTable) {
        this.m_sourceTable = sourceTable;
        this.m_port = port;
        this.initialize();
    }

    protected void initialize() {
        this.setHelpProduct("wdb");
        this.setHelpTopic("select_column_win");
        this.m_columnSelector = new cTreeListSelector();
        this.m_columnSelector.setCopyModeEnabled(true);
        this.m_columnSelector.setParentNodesMoveable(false);
        this.m_columnSelector.setSourceRootVisible(false);
        this.m_columnSelector.setTargetControlsVisible(true);
        this.m_columnSelector.setSourceCellRenderer(new cTreeCellRenderer());
        this.m_columnSelector.setTargetCellRenderer(new cListCellRenderer());
        this.m_tree = (JTree)this.m_columnSelector.getSourceComponent();
        this.m_tree.setShowsRootHandles(false);
        this.m_tree.setToggleClickCount(0);
        this.m_tree.addTreeSelectionListener(new cTreeSelectionListener());
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        JLabel label = (JLabel)this.m_columnSelector.getSourceLabelComponent();
        label.setText(bundle.getString("ChooseColumnsPanel.SourceLabel.txt"));
        label.setDisplayedMnemonic(bundle.getString("ChooseColumnsPanel.SourceLabel.mnem").charAt(0));
        label = (JLabel)this.m_columnSelector.getTargetLabelComponent();
        label.setText(bundle.getString("ChooseColumnsPanel.TargetLabel.txt"));
        label.setDisplayedMnemonic(bundle.getString("ChooseColumnsPanel.TargetLabel.mnem").charAt(0));
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_columnSelector), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void populateStore() {
        this.setStorePopulated(true);
    }

    public void moveDataToView() {
        DefaultTreeModel model = (DefaultTreeModel)this.m_columnSelector.getModel();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        cHeadingTreeNode genNode = new cHeadingTreeNode(bundle.getString("ChooseColumnsPanel.GeneratedHeaderName.txt"), bundle.getString("ChooseColumnsPanel.GeneratedHeaderDesc.txt"), WAdminResource.getTypeIcon((String)"Tree", (boolean)true));
        if (this.m_port != null && this.m_port.getGeneratedTable() != null) {
            for (IGeneratedTableColumn t : this.m_port.getGeneratedTable().getColumns()) {
                genNode.add(new cTempColumnTreeNode(t));
            }
        }
        rootNode.add(genNode);
        DefaultMutableTreeNode sourceNode = null;
        if (this.m_sourceTable != null && this.m_port.canIncludeSourceColumns()) {
            sourceNode = new cHeadingTreeNode(bundle.formatString("ChooseColumnsPanel.SourceHeaderName.fmt", (Object)this.m_sourceTable.getName()), bundle.getString("ChooseColumnsPanel.SourceHeaderDesc.txt"), WAdminResource.getTypeIcon((String)this.m_sourceTable.getMetadataType(), (boolean)true));
            IColumn[] aSourceColumns = this.m_sourceTable.getColumns();
            for (int i = 0; i < aSourceColumns.length; ++i) {
                sourceNode.add(new cIColumnTreeNode(aSourceColumns[i]));
            }
            rootNode.add(sourceNode);
        }
        model.setRoot(rootNode);
        if (genNode != null) {
            this.m_tree.expandPath(new TreePath(genNode.getPath()));
        }
        if (sourceNode != null) {
            this.m_tree.expandPath(new TreePath(sourceNode.getPath()));
        }
        IColumn[] aColumns = ((IPhysicalTable)this.m_port.getObject()).getColumns();
        List<TreePath> lSourceObjects = this.m_columnSelector.getMatchingSourceItems(Arrays.asList(aColumns));
        this.m_columnSelector.transferToTargetModel(lSourceObjects.toArray());
        List<IColumn> lUnmatched = this.m_columnSelector.getUnmatchingSourceItems(Arrays.asList(aColumns));
        if (lUnmatched != null && lUnmatched.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (IColumn column : lUnmatched) {
                sb.append(column.getName()).append("\n");
            }
            WATextArea textArea = new WATextArea();
            textArea.setEditable(false);
            textArea.setAutoSelect(false);
            textArea.setMargin(new Insets(5, 5, 5, 5));
            textArea.setBehavior(0);
            textArea.setText(sb.toString());
            Font fnt = textArea.getFont();
            fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
            textArea.setFont(fnt);
            JScrollPane scrollPane = new JScrollPane((Component)textArea);
            scrollPane.setPreferredSize(new Dimension(375, 300));
            MessageUtil.displayDetailsMessage((String)bundle.getString("ChooseColumnsPanel.ColumnsMissing.msg.txt"), (String)bundle.getString("ChooseColumnsPanel.ColumnsMissing.title.txt"), (int)1, (JComponent)scrollPane);
        }
    }

    public void moveDataToStore() {
        DefaultListModel mdlTarget = (DefaultListModel)this.m_columnSelector.getTargetModel();
        ArrayList lColumns = new ArrayList(mdlTarget.size());
        for (int i = 0; i < mdlTarget.getSize(); ++i) {
            lColumns.add(mdlTarget.getElementAt(i));
        }
        this.updateTableColumns((IPhysicalTable)this.m_port.getObject(), lColumns);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_columnSelector.setEnabled(bEditable);
    }

    public boolean validateData() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableColumns(IPhysicalTable table, List lColumns) {
        int nColumns = lColumns.size();
        ArrayList<IColumn> targets = new ArrayList<IColumn>();
        table.getModel().startCompoundUndoable();
        try {
            for (int iIndex = 0; iIndex < nColumns; ++iIndex) {
                TreePath path = (TreePath)lColumns.get(iIndex);
                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                Object tempColumn = node.getColumnObject();
                IColumn iMatchingColumn = this.findMatchingColumnInList(table.getColumns(), tempColumn);
                if (iMatchingColumn == null) {
                    if (tempColumn instanceof IColumn) {
                        iMatchingColumn = table.getModel().getObjectFactory().createNewColumn(table.getID());
                        ((IColumn)tempColumn).deepCopy(iMatchingColumn);
                        table.addColumn(iMatchingColumn);
                        targets.add(iMatchingColumn);
                        continue;
                    }
                    if (!(tempColumn instanceof IGeneratedTableColumn)) continue;
                    iMatchingColumn = ((IGeneratedTableColumn)tempColumn).createNewColumn(table.getModel(), table.getID(), this.m_sourceTable);
                    table.addColumn(iMatchingColumn);
                    targets.add(iMatchingColumn);
                    continue;
                }
                table.moveColumn(iMatchingColumn, iIndex);
                targets.add(iMatchingColumn);
            }
            List<IColumn> origTargets = Arrays.asList(table.getColumns());
            for (IColumn orig : origTargets) {
                if (targets.contains(orig)) continue;
                table.removeColumn(orig);
            }
        }
        finally {
            table.getModel().endCompoundUndoable();
        }
    }

    private IColumn findMatchingColumnInList(IColumn[] aOldColumns, Object newColumn) {
        for (int i = 0; i < aOldColumns.length; ++i) {
            IGeneratedTableColumn tempColumn;
            IColumn oldColumn = aOldColumns[i];
            if (newColumn instanceof IColumn) {
                IColumn newIColumn = (IColumn)newColumn;
                if (!oldColumn.getName().equals(newIColumn.getName()) || oldColumn.getType() != newIColumn.getType() || oldColumn.getLength() != newIColumn.getLength()) continue;
                return oldColumn;
            }
            if (!(newColumn instanceof IGeneratedTableColumn) || !(tempColumn = (IGeneratedTableColumn)newColumn).equals(oldColumn)) continue;
            return oldColumn;
        }
        return null;
    }

    public boolean hasSelectedColumnListChanged() {
        IPhysicalTable table = (IPhysicalTable)this.m_port.getObject();
        DefaultListModel mdlTarget = (DefaultListModel)this.m_columnSelector.getTargetModel();
        ArrayList lColumns = new ArrayList(mdlTarget.size());
        for (int i = 0; i < mdlTarget.getSize(); ++i) {
            lColumns.add(mdlTarget.getElementAt(i));
        }
        int nColumns = lColumns.size();
        ArrayList targets = new ArrayList();
        for (int iIndex = 0; iIndex < nColumns; ++iIndex) {
            TreePath path = (TreePath)lColumns.get(iIndex);
            DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
            Object tempColumn = node.getColumnObject();
            IColumn iMatchingColumn = this.findMatchingColumnInList(table.getColumns(), tempColumn);
            if (iMatchingColumn != null) continue;
            return true;
        }
        return false;
    }

    private class cTreeListSelector
    extends TreeListSelector {
        private Map<String, List<TreePath>> m_hmSources;

        private cTreeListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List lItems) {
            if (lItems == null) {
                lItems = fromAdapter.getSelectedItems();
            }
            int iIndex = fromAdapter.getLastSelectedIndex();
            if (lItems.size() > 0) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        if (fromAdapter == this.sourceAdapter) {
                            List lTargetItems = toAdapter.getAllMoveableItems();
                            Iterator iter = lItems.iterator();
                            block6: while (iter.hasNext()) {
                                Object item = iter.next();
                                for (int i = 0; i < lTargetItems.size(); ++i) {
                                    DisableableTreeNode fromNode = (DisableableTreeNode)((TreePath)item).getLastPathComponent();
                                    DisableableTreeNode toNode = (DisableableTreeNode)((TreePath)lTargetItems.get(i)).getLastPathComponent();
                                    if (!fromNode.getName().equals(toNode.getName())) continue;
                                    iter.remove();
                                    continue block6;
                                }
                            }
                            LinkedHashMap<String, TreePath> sourceLst = new LinkedHashMap<String, TreePath>();
                            for (int i = 0; i < lItems.size(); ++i) {
                                TreePath path = (TreePath)lItems.get(i);
                                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                                if (sourceLst.containsKey(node.getName())) continue;
                                sourceLst.put(node.getName(), path);
                            }
                            toAdapter.addItems(new ArrayList(sourceLst.values()));
                            List sourceItems = fromAdapter.getAllMoveableItems();
                            for (int i = 0; i < sourceItems.size(); ++i) {
                                TreePath path = (TreePath)sourceItems.get(i);
                                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                                if (!sourceLst.containsKey(node.getName())) continue;
                                node.setEnabled(false);
                            }
                        } else {
                            fromAdapter.removeItems(lItems);
                            List lSourceItems = toAdapter.getAllMoveableItems();
                            for (int i = 0; i < lItems.size(); ++i) {
                                TreePath targetPath = (TreePath)lItems.get(i);
                                DisableableTreeNode targetNode = (DisableableTreeNode)targetPath.getLastPathComponent();
                                for (int j = 0; j < lSourceItems.size(); ++j) {
                                    TreePath sourcePath = (TreePath)lSourceItems.get(j);
                                    DisableableTreeNode sourceNode = (DisableableTreeNode)sourcePath.getLastPathComponent();
                                    if (!ObjectComparator.isEqual((String)targetNode.getName(), (String)sourceNode.getName(), (boolean)false)) continue;
                                    sourceNode.setEnabled(true);
                                }
                            }
                        }
                        this.setHeadingsStatus();
                        this.selectNextEnabledItem(fromAdapter, iIndex);
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                        ChooseColumnsPanel.this.m_tree.repaint();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            DualSelectorInterface dualSelectorInterface = fromAdapter;
            synchronized (dualSelectorInterface) {
                DualSelectorInterface dualSelectorInterface2 = toAdapter;
                synchronized (dualSelectorInterface2) {
                    List lAllItems = fromAdapter.getAllMoveableItems();
                    this.transferItems(fromAdapter, toAdapter, lAllItems);
                }
            }
        }

        public boolean canTransferSelectedSourceItems() {
            if (super.canTransferSelectedSourceItems()) {
                List lItems = this.sourceAdapter.getSelectedItems();
                for (int iItem = 0; iItem < lItems.size(); ++iItem) {
                    TreePath path = (TreePath)lItems.get(iItem);
                    DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                    if (!node.isEnabled()) continue;
                    return true;
                }
            }
            return false;
        }

        private void setHeadingsStatus() {
            List lItems = this.sourceAdapter.getAllItems();
            block0: for (int i = 1; i < lItems.size(); ++i) {
                TreePath path = (TreePath)lItems.get(i);
                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                if (!(node instanceof cHeadingTreeNode)) continue;
                cHeadingTreeNode headingNode = (cHeadingTreeNode)node;
                for (int iChild = 0; iChild < headingNode.getChildCount(); ++iChild) {
                    DisableableTreeNode childNode = (DisableableTreeNode)((Object)headingNode.getChildAt(iChild));
                    if (!childNode.isEnabled()) continue;
                    headingNode.setEnabled(true);
                    continue block0;
                }
                headingNode.setEnabled(false);
            }
        }

        private void selectNextEnabledItem(DualSelectorInterface adapter, int iStartIndex) {
            if (iStartIndex == -1) {
                return;
            }
            List lItems = adapter.getAllItems();
            if (adapter == this.sourceAdapter) {
                DisableableTreeNode node;
                TreePath path;
                int i;
                for (i = ++iStartIndex; i < lItems.size(); ++i) {
                    path = (TreePath)lItems.get(i);
                    node = (DisableableTreeNode)path.getLastPathComponent();
                    if (!node.isEnabled()) continue;
                    adapter.setSelectedIndex(i - 1);
                    return;
                }
                for (i = iStartIndex - 1; i > 0 && i < lItems.size(); --i) {
                    path = (TreePath)lItems.get(i);
                    node = (DisableableTreeNode)path.getLastPathComponent();
                    if (!node.isEnabled()) continue;
                    adapter.setSelectedIndex(i - 1);
                    return;
                }
                adapter.setSelectedIndex(-1);
            } else {
                adapter.setSelectedIndex(Math.min(iStartIndex, lItems.size() - 1));
            }
        }

        public Map<String, List<TreePath>> getSourceColumnMap() {
            if (this.m_hmSources != null) {
                return this.m_hmSources;
            }
            List lSourceItems = this.sourceAdapter.getAllMoveableItems();
            this.m_hmSources = new HashMap<String, List<TreePath>>(lSourceItems.size());
            for (int i = 0; i < lSourceItems.size(); ++i) {
                TreePath path = (TreePath)lSourceItems.get(i);
                DisableableTreeNode node = (DisableableTreeNode)path.getLastPathComponent();
                Object oColumn = node.getColumnObject();
                String sColumnName = null;
                if (oColumn instanceof IColumn) {
                    sColumnName = ((IColumn)oColumn).getName();
                } else if (oColumn instanceof IGeneratedTableColumn) {
                    sColumnName = ((IGeneratedTableColumn)oColumn).getName();
                }
                if (sColumnName == null || sColumnName.length() == 0) continue;
                List<TreePath> lst = this.m_hmSources.get(sColumnName);
                if (lst == null) {
                    lst = new ArrayList<TreePath>();
                }
                lst.add(path);
                this.m_hmSources.put(sColumnName, lst);
            }
            return this.m_hmSources;
        }

        public List<TreePath> getMatchingSourceItems(List<IColumn> lItems) {
            ArrayList<TreePath> lTreePaths = new ArrayList<TreePath>();
            Map<String, List<TreePath>> hmSources = this.getSourceColumnMap();
            for (IColumn column : lItems) {
                if (!hmSources.containsKey(column.getName())) continue;
                for (TreePath path : hmSources.get(column.getName())) {
                    lTreePaths.add(path);
                }
            }
            return lTreePaths;
        }

        public List<IColumn> getUnmatchingSourceItems(List<IColumn> lItems) {
            ArrayList<IColumn> lTreePaths = new ArrayList<IColumn>();
            Map<String, List<TreePath>> hmSources = this.getSourceColumnMap();
            for (IColumn column : lItems) {
                if (hmSources.containsKey(column.getName())) continue;
                lTreePaths.add(column);
            }
            return lTreePaths;
        }
    }

    private class cTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private cTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bFocused) {
            super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bFocused);
            if (node instanceof DisableableTreeNode) {
                this.setIcon(((DisableableTreeNode)node).getIcon());
                this.setToolTipText(((DisableableTreeNode)node).getToolTip());
                if (!(node instanceof cHeadingTreeNode)) {
                    this.setEnabled(((DisableableTreeNode)node).isEnabled());
                }
            }
            return this;
        }
    }

    private class cListCellRenderer
    extends DefaultListCellRenderer {
        private cListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TreeNode node = (TreeNode)((TreePath)value).getLastPathComponent();
            this.setText(node.toString());
            if (node instanceof DisableableTreeNode) {
                this.setIcon(((DisableableTreeNode)((Object)node)).getIcon());
                this.setToolTipText(((DisableableTreeNode)((Object)node)).getToolTip());
            }
            return this;
        }
    }

    private class cTreeSelectionListener
    implements TreeSelectionListener {
        private cTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ChooseColumnsPanel.this.m_tree.scrollPathToVisible(ChooseColumnsPanel.this.m_tree.getSelectionPath());
        }
    }

    private class cHeadingTreeNode
    extends DefaultMutableTreeNode
    implements DisableableTreeNode {
        private String m_sToolTip;
        private Icon m_icon;
        private boolean m_bEnabled;

        public cHeadingTreeNode(String sName, String sToolTip, Icon icon) {
            super(sName);
            this.m_bEnabled = true;
            this.m_sToolTip = sToolTip;
            this.m_icon = icon;
        }

        @Override
        public Icon getIcon() {
            return this.m_icon;
        }

        @Override
        public String getToolTip() {
            return this.m_sToolTip;
        }

        @Override
        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        @Override
        public Object getColumnObject() {
            return this.userObject;
        }

        @Override
        public String getName() {
            return this.toString();
        }
    }

    private class cTempColumnTreeNode
    extends DefaultMutableTreeNode
    implements DisableableTreeNode {
        private boolean m_bEnabled;
        private IGeneratedTableColumn m_column;

        public cTempColumnTreeNode(IGeneratedTableColumn oObject) {
            super(oObject);
            this.m_bEnabled = true;
            this.m_column = oObject;
        }

        public IGeneratedTableColumn getColumnObject() {
            return this.m_column;
        }

        @Override
        public String getName() {
            return this.m_column.getName();
        }

        @Override
        public Icon getIcon() {
            return WsColumnMetadataUtil.getColumnTypeIcon((int)this.m_column.getSASType());
        }

        @Override
        public String getToolTip() {
            return this.m_column.getDescription();
        }

        @Override
        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }
    }

    private class cIColumnTreeNode
    extends DefaultMutableTreeNode
    implements DisableableTreeNode {
        private IColumn m_column;
        private boolean m_bEnabled;

        public cIColumnTreeNode(IColumn column) {
            super(column.getDescription() != null && column.getDescription().length() > 0 ? column.getDescription() + " (" + column.getName() + ")" : column.getName());
            this.m_bEnabled = true;
            this.m_column = column;
        }

        @Override
        public Icon getIcon() {
            return ColumnUIUtilities.getTypeIcon(this.m_column);
        }

        @Override
        public String getToolTip() {
            return bundle.formatString("ChooseColumnsPanel.GetColumnType.txt", (Object)this.m_column.getID());
        }

        @Override
        public boolean isEnabled() {
            return this.m_bEnabled;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            this.m_bEnabled = bEnabled;
        }

        @Override
        public Object getColumnObject() {
            return this.m_column;
        }

        @Override
        public String getName() {
            return this.m_column.getName();
        }
    }

    private static interface DisableableTreeNode {
        public boolean isEnabled();

        public void setEnabled(boolean var1);

        public Icon getIcon();

        public String getToolTip();

        public Object getColumnObject();

        public String getName();
    }
}

