/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractBrowsableTextField;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckpointSetupPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(CheckpointSetupPanel.class);
    private JLabel m_lblDescription;
    private JLabel m_lblCheckpointLibrary;
    private JLabel m_lblAlternateLibrary;
    private cLibraryTextField m_txtCheckpointLibrary;
    private cLibraryTextField m_txtAlternateLibrary;
    private JButton m_btnNewCheckpointLibrary;
    private JButton m_btnEditCheckpointLibrary;
    private JButton m_btnNewAlternateLibrary;
    private JButton m_btnEditAlternateLibrary;
    private WsAbstractAction m_actNewCheckpointLibrary;
    private WsAbstractAction m_actEditCheckpointLibrary;
    private WsAbstractAction m_actNewAlternateLibrary;
    private WsAbstractAction m_actEditAlternateLibrary;
    private IModelListener m_lsnrModel;
    private IJob m_job;

    public CheckpointSetupPanel(IJob job) {
        this.m_job = job;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_lblDescription = WsUIUtilities.createLabelForComponent((JComponent)((Object)this), (String)bundle.getString("CheckpointSetupPanel.DescriptionLabel.txt"));
        this.m_txtCheckpointLibrary = new cLibraryTextField();
        this.m_txtCheckpointLibrary.getBrowseButton().setToolTipText(bundle.getString("CheckpointSetupPanel.cLibraryTextField.Browse.tip"));
        this.m_lblCheckpointLibrary = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)((Object)this.m_txtCheckpointLibrary), (WAdminResource)bundle, (String)"CheckpointSetupPanel.CheckpointLibraryLabel");
        this.m_txtAlternateLibrary = new cLibraryTextField();
        this.m_txtAlternateLibrary.getBrowseButton().setToolTipText(bundle.getString("CheckpointSetupPanel.cLibraryTextField.Browse.tip"));
        this.m_lblAlternateLibrary = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)((Object)this.m_txtAlternateLibrary), (WAdminResource)bundle, (String)"CheckpointSetupPanel.AlternateLibraryLabel");
        this.m_actNewCheckpointLibrary = this.createNewCheckpointLibraryAction();
        this.m_actEditCheckpointLibrary = this.createEditCheckpointLibraryAction();
        this.m_actNewAlternateLibrary = this.createNewAlternateLibraryAction();
        this.m_actEditAlternateLibrary = this.createEditAlternateLibraryAction();
        this.m_btnNewCheckpointLibrary = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewCheckpointLibrary);
        this.m_btnEditCheckpointLibrary = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actEditCheckpointLibrary);
        this.m_btnNewAlternateLibrary = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNewAlternateLibrary);
        this.m_btnEditAlternateLibrary = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actEditAlternateLibrary);
        this.m_lsnrModel = new cModelListener();
        this.m_job.getModel().addModelListener(this.m_lsnrModel);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add(this.m_lblCheckpointLibrary, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_txtCheckpointLibrary), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        this.add(this.m_btnNewCheckpointLibrary, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add(this.m_btnEditCheckpointLibrary, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.add(this.m_lblAlternateLibrary, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_txtAlternateLibrary), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        this.add(this.m_btnNewAlternateLibrary, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add(this.m_btnEditAlternateLibrary, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0), 0, 0));
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        ILibrary library = this.m_job.getCheckpointStateLibrary();
        this.m_txtCheckpointLibrary.setLibrary(library);
        library = this.m_job.getAlternateTemporaryLibrary();
        this.m_txtAlternateLibrary.setLibrary(library);
        this.updateActions();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        this.m_job.setCheckpointStateLibrary(this.m_txtCheckpointLibrary.getLibrary());
        this.m_job.setAlternateTemporaryLibrary(this.m_txtAlternateLibrary.getLibrary());
    }

    public boolean validateData() {
        if (this.m_txtCheckpointLibrary.getLibrary() == null) {
            String sMessage = bundle.getString("CheckpointSetupPanel.Error.NoCheckpointLibrary");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return false;
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.m_job.getModel().removeModelListener(this.m_lsnrModel);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_txtCheckpointLibrary.setEditable(bEditable);
        this.m_txtAlternateLibrary.setEditable(bEditable);
        this.updateActions();
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        boolean bCheckpointSelected = this.m_txtCheckpointLibrary.getLibrary() != null;
        boolean bAlternateSelected = this.m_txtAlternateLibrary.getLibrary() != null;
        this.m_actNewCheckpointLibrary.setEnabled(bEditable);
        this.m_actNewAlternateLibrary.setEnabled(bEditable);
        this.m_actEditCheckpointLibrary.setEnabled(bEditable && bCheckpointSelected);
        this.m_actEditAlternateLibrary.setEnabled(bEditable && bAlternateSelected);
    }

    protected WsAbstractAction createNewCheckpointLibraryAction() {
        return new cNewCheckpointLibraryAction();
    }

    protected WsAbstractAction createEditCheckpointLibraryAction() {
        return new cEditCheckpointLibraryAction();
    }

    protected WsAbstractAction createNewAlternateLibraryAction() {
        return new cNewAlternateLibraryAction();
    }

    protected WsAbstractAction createEditAlternateLibraryAction() {
        return new cEditAlternateLibraryAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILibrary getLibraryModel(String sID, boolean bReload) {
        IModel mdl = this.m_job.getModel();
        ILibrary oLibrary = (ILibrary)mdl.getObject(sID);
        if (oLibrary != null && !bReload) {
            return oLibrary;
        }
        boolean bUndo = mdl.isUndoSupported();
        mdl.setUndoSupported(false);
        try {
            OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), "CheckpointSetupPanel.loadLibrary");
            try {
                if (oLibrary == null) {
                    SASLibrary mdoLibrary = (SASLibrary)omr.acquireOMRObject(sID, "SASLibrary");
                    oLibrary = (ILibrary)omr.acquireObjectUsingTemplate((Root)mdoLibrary);
                } else if (bReload) {
                    omr.populateFor((IOMRPersistable)oLibrary);
                    oLibrary.loadFromOMR(omr);
                }
            }
            finally {
                omr.dispose();
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            mdl.setUndoSupported(bUndo);
        }
        return oLibrary;
    }

    private class cLibraryTextField
    extends WsAbstractBrowsableTextField {
        private ILibrary m_library;

        private cLibraryTextField() {
        }

        public ILibrary getLibrary() {
            return this.m_library;
        }

        public void setLibrary(ILibrary library) {
            this.m_library = library;
            String sText = library != null ? library.getName() : "";
            this.setText(sText);
            CheckpointSetupPanel.this.updateActions();
        }

        public void setEnabled(boolean bEnabled) {
            this.m_txt.setEnabled(false);
            this.m_btn.setEnabled(bEnabled && this.isEditable());
        }

        public boolean isEnabled() {
            return this.m_btn.isEnabled();
        }

        public void setEditable(boolean bEditable) {
            this.m_txt.setEditable(false);
            this.m_btn.setEnabled(bEditable && this.isEnabled());
        }

        public boolean isEditable() {
            return this.m_btn.isEnabled();
        }

        protected Border createTextFieldBorder() {
            if (WsUIUtilities.isXPThemeActive()) {
                return new EmptyBorder(1, 5, 1, 0);
            }
            return new EmptyBorder(1, 1, 1, 0);
        }

        protected void showDialog() {
            ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 2);
            pnl.setSelectedObject((SimpleObject)this.m_library);
            pnl.setSelectionOptional(true);
            String sTitle = bundle.getString("CheckpointSetupPanel.cLibraryTextField.LibrarySelector.title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject library = pnl.getSelectedObject();
                ILibrary oLibrary = library != null ? CheckpointSetupPanel.this.getLibraryModel(library.getID(), false) : null;
                this.setLibrary(oLibrary);
            }
        }
    }

    private class cModelListener
    implements IModelListener {
        private cModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            if (ev.getModelObject() == CheckpointSetupPanel.this.m_job) {
                CheckpointSetupPanel.this.setListeningForChanges(false);
                try {
                    String sType = ev.getType();
                    if ("IJob:CheckpointStateLibraryChanged".equals(sType)) {
                        ILibrary library = CheckpointSetupPanel.this.m_job.getCheckpointStateLibrary();
                        CheckpointSetupPanel.this.m_txtCheckpointLibrary.setLibrary(library);
                    } else if ("IJob:AlternateTempLibraryChanged".equals(sType)) {
                        ILibrary library = CheckpointSetupPanel.this.m_job.getAlternateTemporaryLibrary();
                        CheckpointSetupPanel.this.m_txtAlternateLibrary.setLibrary(library);
                    }
                }
                finally {
                    CheckpointSetupPanel.this.setListeningForChanges(true);
                }
            }
        }
    }

    private class cNewCheckpointLibraryAction
    extends WsAbstractAction {
        public cNewCheckpointLibraryAction() {
            super(bundle, "CheckpointSetupPanel.cNewCheckpointLibraryAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SimpleObject library;
            SimpleObjectImpl simpleFolder = null;
            IFolder folder = CheckpointSetupPanel.this.m_job.getFolder();
            if (folder != null) {
                simpleFolder = new SimpleObjectImpl(folder.getName(), folder.getID(), folder.getOMRType(), "Folder");
            }
            if ((library = AppDialogFactory.getInstance().showNewLibraryDialog((JFrame)Workspace.getWorkspace(), (SimpleObject)simpleFolder)) != null) {
                ILibrary oLibrary = CheckpointSetupPanel.this.getLibraryModel(library.getID(), false);
                CheckpointSetupPanel.this.m_txtCheckpointLibrary.setLibrary(oLibrary);
            }
        }
    }

    private class cEditCheckpointLibraryAction
    extends WsAbstractAction {
        public cEditCheckpointLibraryAction() {
            super(bundle, "CheckpointSetupPanel.cEditCheckpointLibraryAction", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (CheckpointSetupPanel.this.m_job != null) {
                ILibrary lib = CheckpointSetupPanel.this.m_txtCheckpointLibrary.getLibrary();
                AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)lib);
                boolean bUndo = CheckpointSetupPanel.this.m_job.getModel().isUndoSupported();
                try {
                    CheckpointSetupPanel.this.m_job.getModel().setUndoSupported(false);
                    ILibrary oLibrary = CheckpointSetupPanel.this.getLibraryModel(lib.getID(), true);
                    CheckpointSetupPanel.this.m_txtCheckpointLibrary.setLibrary(oLibrary);
                }
                finally {
                    CheckpointSetupPanel.this.m_job.getModel().setUndoSupported(bUndo);
                }
            }
        }
    }

    private class cNewAlternateLibraryAction
    extends WsAbstractAction {
        public cNewAlternateLibraryAction() {
            super(bundle, "CheckpointSetupPanel.cNewAlternateLibraryAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SimpleObject library;
            SimpleObjectImpl simpleFolder = null;
            IFolder folder = CheckpointSetupPanel.this.m_job.getFolder();
            if (folder != null) {
                simpleFolder = new SimpleObjectImpl(folder.getName(), folder.getID(), folder.getOMRType(), "Folder");
            }
            if ((library = AppDialogFactory.getInstance().showNewLibraryDialog((JFrame)Workspace.getWorkspace(), (SimpleObject)simpleFolder)) != null) {
                ILibrary oLibrary = CheckpointSetupPanel.this.getLibraryModel(library.getID(), false);
                CheckpointSetupPanel.this.m_txtAlternateLibrary.setLibrary(oLibrary);
            }
        }
    }

    private class cEditAlternateLibraryAction
    extends WsAbstractAction {
        public cEditAlternateLibraryAction() {
            super(bundle, "CheckpointSetupPanel.cEditAlternateLibraryAction", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (CheckpointSetupPanel.this.m_job != null) {
                ILibrary lib = CheckpointSetupPanel.this.m_txtAlternateLibrary.getLibrary();
                AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)lib);
                boolean bUndo = CheckpointSetupPanel.this.m_job.getModel().isUndoSupported();
                try {
                    CheckpointSetupPanel.this.m_job.getModel().setUndoSupported(false);
                    ILibrary oLibrary = CheckpointSetupPanel.this.getLibraryModel(lib.getID(), true);
                    CheckpointSetupPanel.this.m_txtAlternateLibrary.setLibrary(oLibrary);
                }
                finally {
                    CheckpointSetupPanel.this.m_job.getModel().setUndoSupported(bUndo);
                }
            }
        }
    }
}

