/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class AssociatedForeignKeysTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(AssociatedForeignKeysTableModel.class);
    private static final int VISIBLE_COLUMNS = 2;
    private static final int HIDDEN_COLUMNS = 1;
    public static final int TABLENAME_COLUMN = 0;
    public static final int KEYNAME_COLUMN = 1;
    private static final int KEYOBJECT_COLUMN = 2;
    private static final int TABLENAME_WIDTH = 175;
    private static final int KEYNAME_WIDTH = 175;
    private IKey m_key;
    private IModelListener m_lsnrModel;

    public AssociatedForeignKeysTableModel(IKey key) {
        this.m_key = key;
        this.m_lsnrModel = this.createModelListener();
        this.m_key.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_key.getModel().removeModelListener(this.m_lsnrModel);
    }

    public IModelListener createModelListener() {
        return new ModelListener();
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("AssociatedForeignKeysTableModel.TableName.txt"), 175);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("AssociatedForeignKeysTableModel.KeyName.txt"), 175);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsObjectTableColumn();
        this.m_aColumns[2].setEditable(false);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        this.m_key.getModel().removeModelListener(this.m_lsnrModel);
        IForeignKey[] aKeys = this.m_key.loadForeignKeysFromOMR();
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            IForeignKey fKey = aKeys[iKey];
            ArrayList<String> lValues = new ArrayList<String>();
            lValues.add(fKey.getTable().getName());
            lValues.add(fKey.getName());
            lValues.add((String)fKey);
            this.m_lData.add(lValues);
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
        this.m_key.getModel().addModelListener(this.m_lsnrModel);
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return super.getValueAt(rowIndex, columnIndex);
    }

    private void addForeignKey(IForeignKey foreignKey) {
        ArrayList<String> lValues = new ArrayList<String>();
        lValues.add(foreignKey.getTable().getName());
        lValues.add(foreignKey.getName());
        lValues.add((String)foreignKey);
        this.insertRow(this.getRowCount() - 1, lValues);
    }

    private void removeForeignKey(IForeignKey foreignKey) {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            IForeignKey keyInTable = (IForeignKey)this.getValueAt(rowIndex, 2);
            if (keyInTable != foreignKey) continue;
            this.deleteRow(rowIndex);
            break;
        }
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "PhysicalTable:ForeignKeyAdded") {
                IForeignKey foreignKey = (IForeignKey)ev.getData();
                IKey partnerKey = foreignKey.getPartnerKey();
                if (partnerKey != AssociatedForeignKeysTableModel.this.m_key) {
                    return;
                }
                AssociatedForeignKeysTableModel.this.addForeignKey(foreignKey);
            } else if (sType == "PhysicalTable:ForeignKeyRemoved") {
                IForeignKey foreignKey = (IForeignKey)ev.getData();
                IKey partnerKey = foreignKey.getPartnerKey();
                if (partnerKey != AssociatedForeignKeysTableModel.this.m_key) {
                    return;
                }
                AssociatedForeignKeysTableModel.this.removeForeignKey(foreignKey);
            }
        }
    }
}

