/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.model.IndexTreeModel2;
import com.sas.wadmin.model.IndexTreeNode;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.wadmin.visuals.IndexTree;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultClipboardOwner;
import com.sas.workspace.WsDragSourceAdapter;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;

public class WATableIndexPanel
extends WAPanel {
    protected JPanel m_pnlColumns;
    protected JLabel m_lblColumns;
    protected JScrollPane m_scrColumns;
    protected WsTable m_tblColumns;
    protected JButton m_btnAdd;
    protected JPanel m_pnlIndexes;
    protected JLabel m_lblIndexes;
    protected JScrollPane m_scrIndexes;
    protected IndexTree m_treeIndexes;
    protected JPanel m_pnlButtons;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JPanel m_pnlOptions;
    protected JCheckBox m_ckbUnique;
    protected JCheckBox m_ckbNoMiss;
    protected JCheckBox m_ckbClustered;
    protected JCheckBox m_ckbPrimary;
    protected PhysicalTable m_oTable;
    protected IndexTreeModel2 m_mdlIndexes;
    protected ColumnsTableModel2 m_mdlColumns;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actRename;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actAdd;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected WsAbstractAction m_actCut;
    protected WsAbstractAction m_actCopy;
    protected WsAbstractAction m_actPaste;
    protected WsAbstractAction m_actUnique;
    protected WsAbstractAction m_actNoMiss;
    protected WsAbstractAction m_actClustered;
    protected WsAbstractAction m_actPrimary;
    protected boolean m_bHoldActionUpdates;
    protected boolean m_bColumnsTableHasFocus;
    protected boolean m_bDBMSIsExcel;
    private static WAdminResource bundle = WAdminResource.getBundle(WATableIndexPanel.class);

    public WATableIndexPanel(PhysicalTable oTable, ColumnsTableModel2 mdlColumns) {
        this.m_oTable = oTable;
        this.m_mdlColumns = mdlColumns;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("indexes_tab");
    }

    protected void initialize() {
        this.createActions();
        this.createColumnsPanel();
        this.createAddButton();
        this.createIndexesPanel();
        this.createButtonsPanel();
        this.createOptionsPanel();
    }

    protected void createColumnsPanel() {
        this.createColumnsTable();
        this.m_lblColumns = new JLabel(bundle.getString("WATableIndexPanel.ColumnsLabel.txt"));
        this.m_lblColumns.setDisplayedMnemonic(bundle.getString("WATableIndexPanel.ColumnsLabel.mnem").charAt(0));
        this.m_lblColumns.setLabelFor((Component)this.m_tblColumns);
        this.m_pnlColumns = new JPanel(new BorderLayout(0, 5));
        this.m_pnlColumns.add((Component)this.m_lblColumns, "North");
        this.m_pnlColumns.add((Component)this.m_scrColumns, "Center");
    }

    protected void createColumnsTable() {
        this.m_mdlColumns.setMetadataTable((DataTable)this.m_oTable);
        this.m_tblColumns = new WsTable((WsAbstractTableModel)this.m_mdlColumns);
        this.m_tblColumns.setToolTipText(bundle.getString("WATableIndexPanel.ColumnsTable.ToolTip.txt"));
        this.m_tblColumns.setEditable(false);
        this.m_tblColumns.setMouseBlockSelectionEnabled(false);
        this.m_tblColumns.setMultipleSelectionDragEnabled(true);
        this.m_tblColumns.getSelectionModel().addListSelectionListener(this.createColumnsTableSelectionListener());
        this.m_tblColumns.setTablePopupMenuRequestListener(this.createColumnsTablePopupMenuRequestListener());
        this.m_tblColumns.addFocusListener(this.createColumnsTableFocusListener());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.m_tblColumns, 1, this.createColumnsTableDragGestureListener());
        this.m_tblColumns.getActionMap().put(this.m_actCopy, (Action)this.m_actCopy);
        this.m_tblColumns.getInputMap().put(KeyStroke.getKeyStroke(67, 2), this.m_actCopy);
        this.m_tblColumns.hideColumn(7);
        this.m_tblColumns.hideColumn(6);
        this.m_tblColumns.hideColumn(4);
        this.m_tblColumns.hideColumn(5);
        this.m_tblColumns.hideColumn(8);
        this.m_tblColumns.removeColumn(9);
        this.m_tblColumns.removeColumn(10);
        ColumnsTableNameCellRenderer rdrName = new ColumnsTableNameCellRenderer();
        TableColumn colName = this.m_tblColumns.getColumnModel().getColumn(0);
        colName.setCellRenderer((TableCellRenderer)((Object)rdrName));
        this.m_tblColumns.restoreSettings("TableIndexesPanel");
        this.m_scrColumns = new JScrollPane((Component)this.m_tblColumns);
        this.m_scrColumns.setMinimumSize(new Dimension(170, 250));
        this.m_scrColumns.setPreferredSize(new Dimension(250, 250));
    }

    protected void createAddButton() {
        this.m_btnAdd = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actAdd);
    }

    protected void createIndexesPanel() {
        this.createIndexesTree();
        this.m_lblIndexes = new JLabel(bundle.getString("WATableIndexPanel.IndexesLabel.txt"));
        this.m_lblIndexes.setDisplayedMnemonic(bundle.getString("WATableIndexPanel.IndexesLabel.mnem").charAt(0));
        this.m_lblIndexes.setLabelFor(this.m_treeIndexes);
        this.m_pnlIndexes = new JPanel(new BorderLayout(0, 5));
        this.m_pnlIndexes.add((Component)this.m_lblIndexes, "North");
        this.m_pnlIndexes.add((Component)this.m_scrIndexes, "Center");
    }

    protected void createIndexesTree() {
        this.m_mdlIndexes = new IndexTreeModel2();
        this.m_mdlIndexes.setMetadataTable(this.m_oTable);
        this.m_mdlIndexes.setColumnsTableModel(this.m_mdlColumns);
        this.m_treeIndexes = new IndexTree(this.m_mdlIndexes, this.m_mdlColumns);
        this.m_treeIndexes.setMetadataTable(this.m_oTable);
        this.m_treeIndexes.setUndoManager((UndoManager)this.waum);
        this.m_mdlIndexes.addTreeModelListener(this.createIndexesTreeModelListener());
        this.m_treeIndexes.addTreeSelectionListener(this.createIndexesTreeSelectionListener());
        this.m_treeIndexes.setPopupMenuRequestListener(this.createIndexesTreePopupMenuRequestListener());
        ActionMap mapActions = this.m_treeIndexes.getActionMap();
        mapActions.put(this.m_actDelete, (Action)this.m_actDelete);
        mapActions.put(this.m_actCut, (Action)this.m_actCut);
        mapActions.put(this.m_actCopy, (Action)this.m_actCopy);
        mapActions.put(this.m_actPaste, (Action)this.m_actPaste);
        InputMap mapKeys = this.m_treeIndexes.getInputMap();
        mapKeys.put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        mapKeys.put(KeyStroke.getKeyStroke(88, 2), this.m_actCut);
        mapKeys.put(KeyStroke.getKeyStroke(67, 2), this.m_actCopy);
        mapKeys.put(KeyStroke.getKeyStroke(86, 2), this.m_actPaste);
        this.m_scrIndexes = new JScrollPane(this.m_treeIndexes);
        this.m_scrIndexes.setMinimumSize(new Dimension(230, 200));
        this.m_scrIndexes.setPreferredSize(new Dimension(250, 200));
    }

    protected void createButtonsPanel() {
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout(0, 2));
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout(0, 4));
        pnlLeft.add(this.m_btnMoveUp);
        pnlLeft.add(this.m_btnMoveDown);
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlLeft, "West");
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    protected void createOptionsPanel() {
        this.m_ckbUnique = new JCheckBox((Action)this.m_actUnique);
        this.m_ckbNoMiss = new JCheckBox((Action)this.m_actNoMiss);
        this.m_ckbClustered = new JCheckBox((Action)this.m_actClustered);
        this.m_ckbPrimary = new JCheckBox((Action)this.m_actPrimary);
        this.m_ckbClustered.setVisible(false);
        this.m_ckbPrimary.setVisible(false);
        this.m_pnlOptions = new JPanel(new GridBagLayout());
        String sTitle = " " + bundle.getString("WATableIndexPanel.OptionsTitle.txt") + " ";
        this.m_pnlOptions.setBorder(BorderFactory.createTitledBorder(sTitle));
        this.m_pnlOptions.add((Component)this.m_ckbUnique, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbNoMiss, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbClustered, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbPrimary, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    protected void layoutWidgets() {
        int cxMax;
        Dimension dimIndexes = this.m_pnlIndexes.getMinimumSize();
        Dimension dimButtons = this.m_pnlButtons.getMinimumSize();
        dimIndexes.width = cxMax = Math.max(dimIndexes.width, dimButtons.width);
        dimButtons.width = cxMax;
        this.m_pnlIndexes.setMinimumSize(dimIndexes);
        this.m_pnlButtons.setMinimumSize(dimButtons);
        dimIndexes = this.m_pnlIndexes.getPreferredSize();
        dimButtons = this.m_pnlButtons.getPreferredSize();
        dimIndexes.width = cxMax = Math.max(dimIndexes.width, dimButtons.width);
        dimButtons.width = cxMax;
        this.m_pnlIndexes.setPreferredSize(dimIndexes);
        this.m_pnlButtons.setPreferredSize(dimButtons);
        this.setLayout(new GridBagLayout());
        this.add(this.m_pnlColumns, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_pnlIndexes, new GridBagConstraints(2, 1, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_pnlButtons, new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_pnlOptions, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return this.m_treeIndexes.validateData();
    }

    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated) {
            this.m_mdlColumns.setStorePopulated(bStorePopulated);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_mdlColumns.populateStore();
        this.m_mdlIndexes.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlColumns.moveDataToModel();
        this.m_mdlIndexes.moveDataToModel();
        if (this.m_mdlColumns.getRowCount() > 0) {
            this.m_tblColumns.selectCell(0, 0);
        }
        this.m_treeIndexes.expandPath(new TreePath(this.m_mdlIndexes.getRoot()));
        boolean bSybase = false;
        boolean bSAS = false;
        boolean bTeradata = false;
        this.m_bDBMSIsExcel = false;
        String sDBMSType = null;
        try {
            sDBMSType = TransformUtil.getDBMSProductName((PhysicalTable)this.m_oTable);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (sDBMSType != null) {
            if (sDBMSType.equalsIgnoreCase("Sybase")) {
                bSybase = true;
            } else if (sDBMSType.startsWith("SAS")) {
                bSAS = true;
            } else if (sDBMSType.indexOf("EXCEL") > -1) {
                this.m_bDBMSIsExcel = true;
            } else if (sDBMSType.indexOf("TERADATA") > -1) {
                bTeradata = true;
            }
        }
        this.m_ckbClustered.setVisible(bSybase);
        this.m_ckbNoMiss.setVisible(bSAS);
        this.m_ckbPrimary.setVisible(bTeradata);
        if (!this.m_bDBMSIsExcel) {
            this.setEditable(this.isEditable());
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_mdlIndexes.moveDataToStore();
        this.setDataChanged(false);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actRename.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actCut.setActive(bActive);
        this.m_actCopy.setActive(bActive);
        this.m_actPaste.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_treeIndexes.setEditable(bEditable && !this.m_bDBMSIsExcel);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tblColumns.saveSettings("TableIndexesPanel");
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_treeIndexes.setUndoManager((UndoManager)mgrUndo);
    }

    protected Transferable createTransferableFromSelectedTableColumns() {
        int[] aRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        int nRows = aRows.length;
        if (nRows == 0) {
            return null;
        }
        DNDObject xferColumns = new DNDObject();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int iModelRow = this.m_tblColumns.convertRowIndexToModel(aRows[iRow]);
            xferColumns.add(this.m_mdlColumns.getValueAt(iModelRow, 14));
        }
        return xferColumns;
    }

    public void copySelectedTableColumns() {
        Transferable xfer = this.createTransferableFromSelectedTableColumns();
        if (xfer == null) {
            return;
        }
        this.getToolkit().getSystemClipboard().setContents(xfer, this.createClipboardOwner());
    }

    private boolean checkClipboard() {
        Transferable xfer = this.getToolkit().getSystemClipboard().getContents((Object)this);
        return xfer != null && xfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor);
    }

    protected DragGestureListener createColumnsTableDragGestureListener() {
        return new cColumnsTableDragGestureListener();
    }

    protected DragSourceListener createColumnsTableDragSourceListener() {
        return new WsDragSourceAdapter();
    }

    protected WsPopupMenuRequestListener createColumnsTablePopupMenuRequestListener() {
        return new cColumnsTablePopupMenuRequestListener();
    }

    protected ListSelectionListener createColumnsTableSelectionListener() {
        return new cColumnsTableSelectionListener();
    }

    protected FocusListener createColumnsTableFocusListener() {
        return new cColumnsTableFocusListener();
    }

    protected WsPopupMenuRequestListener createIndexesTreePopupMenuRequestListener() {
        return new cIndexesTreePopupMenuRequestListener();
    }

    protected TreeSelectionListener createIndexesTreeSelectionListener() {
        return new cIndexesTreeSelectionListener();
    }

    protected TreeModelListener createIndexesTreeModelListener() {
        return new cIndexesTreeModelListener();
    }

    protected ClipboardOwner createClipboardOwner() {
        return new WsDefaultClipboardOwner();
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actRename = this.createRenameAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actAdd = this.createAddAction();
        this.m_actMoveUp = this.createMoveUpAction();
        this.m_actMoveDown = this.createMoveDownAction();
        this.m_actCut = this.createCutAction();
        this.m_actCopy = this.createCopyAction();
        this.m_actPaste = this.createPasteAction();
        this.m_actUnique = this.createUniqueAction();
        this.m_actNoMiss = this.createNoMissAction();
        this.m_actClustered = this.createClusteredAction();
        this.m_actPrimary = this.createPrimaryAction();
    }

    protected void setHoldActionUpdates(boolean bHoldActionUpdates) {
        this.m_bHoldActionUpdates = bHoldActionUpdates;
        if (!this.m_bHoldActionUpdates) {
            this.updateActions();
        }
    }

    protected void updateActions() {
        if (this.m_bHoldActionUpdates) {
            return;
        }
        boolean bEditable = this.isEditable() && !this.m_bDBMSIsExcel;
        boolean bIndexes = false;
        int nSelectedNodes = this.m_treeIndexes.getSelectionCount();
        boolean bTreeColumns = false;
        boolean bTableColumns = false;
        boolean bFirst = false;
        boolean bLast = false;
        boolean bCopy = false;
        boolean bUnique = false;
        boolean bNoMiss = false;
        boolean bClustered = false;
        boolean bPrimary = false;
        if (this.m_treeIndexes.isIndexSelected()) {
            bIndexes = true;
            if (nSelectedNodes == 1) {
                bUnique = (Boolean)this.m_treeIndexes.getSelectedIndexProperty("Unique");
                bNoMiss = (Boolean)this.m_treeIndexes.getSelectedIndexProperty("NoMiss");
                bClustered = (Boolean)this.m_treeIndexes.getSelectedIndexProperty("Clustered");
                bPrimary = (Boolean)this.m_treeIndexes.getSelectedIndexProperty("Primary");
            }
        } else {
            TreePath[] aPaths = this.m_treeIndexes.getSelectionPaths();
            if (aPaths != null) {
                bTreeColumns = true;
                int nPaths = aPaths.length;
                for (int iPath = 0; iPath < nPaths; ++iPath) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)aPaths[iPath].getLastPathComponent();
                    if (node.getPreviousSibling() == null) {
                        bFirst = true;
                    }
                    if (node.getNextSibling() != null) continue;
                    bLast = true;
                }
            }
        }
        bTableColumns = this.m_tblColumns.getSelectedRowsFromSelectedCells().length != 0;
        bCopy = this.m_bColumnsTableHasFocus ? bTableColumns : bTreeColumns;
        this.m_actNew.setEnabled(bEditable);
        this.m_actRename.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actDelete.setEnabled(bEditable && nSelectedNodes != 0);
        this.m_actAdd.setEnabled(bEditable && nSelectedNodes == 1 && bTableColumns);
        this.m_actMoveUp.setEnabled(bEditable && bTreeColumns && !bFirst);
        this.m_actMoveDown.setEnabled(bEditable && bTreeColumns && !bLast);
        this.m_actCut.setEnabled(bEditable && bTreeColumns);
        this.m_actCopy.setEnabled(bEditable && bCopy);
        this.m_actPaste.setEnabled(bEditable && nSelectedNodes == 1 && this.checkClipboard());
        this.m_actUnique.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actNoMiss.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actClustered.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actPrimary.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_ckbUnique.setSelected(bUnique);
        this.m_ckbNoMiss.setSelected(bNoMiss);
        this.m_ckbClustered.setSelected(bClustered);
        this.m_ckbPrimary.setSelected(bPrimary);
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createRenameAction() {
        return new cRenameAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createAddAction() {
        return new cAddAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new cMoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new cMoveDownAction();
    }

    protected WsAbstractAction createCutAction() {
        return new cCutAction();
    }

    protected WsAbstractAction createCopyAction() {
        return new cCopyAction();
    }

    protected WsAbstractAction createPasteAction() {
        return new cPasteAction();
    }

    protected WsAbstractAction createUniqueAction() {
        return new cUniqueAction();
    }

    protected WsAbstractAction createPrimaryAction() {
        return new cPrimaryAction();
    }

    protected WsAbstractAction createNoMissAction() {
        return new cNoMissAction();
    }

    protected WsAbstractAction createClusteredAction() {
        return new cClusteredAction();
    }

    protected class cColumnsTableDragGestureListener
    implements DragGestureListener {
        protected cColumnsTableDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            if (!WATableIndexPanel.this.isEditable()) {
                return;
            }
            InputEvent ie = e.getTriggerEvent();
            if (ie.isControlDown() || ie.isShiftDown() || ie.isAltDown()) {
                return;
            }
            Transferable xfer = WATableIndexPanel.this.createTransferableFromSelectedTableColumns();
            if (xfer == null) {
                return;
            }
            e.getDragSource().startDrag(e, null, xfer, WATableIndexPanel.this.createColumnsTableDragSourceListener());
        }
    }

    public class cColumnsTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)WATableIndexPanel.this.m_actCopy));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cColumnsTableSelectionListener
    implements ListSelectionListener {
        protected cColumnsTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WATableIndexPanel.this.updateActions();
        }
    }

    protected class cColumnsTableFocusListener
    implements FocusListener {
        protected cColumnsTableFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            WATableIndexPanel.this.m_bColumnsTableHasFocus = true;
            WATableIndexPanel.this.updateActions();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                WATableIndexPanel.this.m_bColumnsTableHasFocus = false;
                WATableIndexPanel.this.updateActions();
            }
        }
    }

    protected class cIndexesTreePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cIndexesTreePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add((Action)WATableIndexPanel.this.m_actNew);
            mnuPopup.add((Action)WATableIndexPanel.this.m_actRename);
            mnuPopup.add((Action)WATableIndexPanel.this.m_actDelete);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)WATableIndexPanel.this.m_actAdd);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)WATableIndexPanel.this.m_actMoveUp);
            mnuPopup.add((Action)WATableIndexPanel.this.m_actMoveDown);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)WATableIndexPanel.this.m_actCut);
            mnuPopup.add((Action)WATableIndexPanel.this.m_actCopy);
            mnuPopup.add((Action)WATableIndexPanel.this.m_actPaste);
            mnuPopup.show(WATableIndexPanel.this.m_treeIndexes, e.getX(), e.getY());
        }
    }

    class cIndexesTreeSelectionListener
    implements TreeSelectionListener {
        cIndexesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!WATableIndexPanel.this.m_treeIndexes.isDragInProgress()) {
                WATableIndexPanel.this.updateActions();
            }
        }
    }

    class cIndexesTreeModelListener
    implements TreeModelListener {
        cIndexesTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (WATableIndexPanel.this.isListeningForChanges()) {
                WATableIndexPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (WATableIndexPanel.this.isListeningForChanges()) {
                WATableIndexPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (WATableIndexPanel.this.isListeningForChanges()) {
                WATableIndexPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "WATableIndexPanel.New", true);
            this.setMenuSupportId("new");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            WATableIndexPanel.this.m_treeIndexes.addNewIndex();
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cRenameAction
    extends WsAbstractAction {
        public cRenameAction() {
            super(bundle, "WATableIndexPanel.Rename");
            this.setMenuSupportId("rename");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.m_treeIndexes.renameSelectedIndex();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "WATableIndexPanel.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            WATableIndexPanel.this.m_treeIndexes.deleteSelectedNodes();
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cAddAction
    extends WsAbstractAction {
        public cAddAction() {
            super(bundle, "WATableIndexPanel.Add", true);
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            int[] aRows = WATableIndexPanel.this.m_tblColumns.getSelectedRowsFromSelectedCells();
            ArrayList<Object> lColumns = new ArrayList<Object>(aRows.length);
            int nRows = aRows.length;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                lColumns.add(WATableIndexPanel.this.m_mdlColumns.getValueAt(WATableIndexPanel.this.m_tblColumns.convertRowIndexToModel(aRows[iRow]), 14));
            }
            WATableIndexPanel.this.m_treeIndexes.addColumns(lColumns);
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(bundle, "WATableIndexPanel.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            WATableIndexPanel.this.m_treeIndexes.moveSelectedColumnsUp();
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(bundle, "WATableIndexPanel.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            WATableIndexPanel.this.m_treeIndexes.moveSelectedColumnsDown();
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cCutAction
    extends WsAbstractAction {
        public cCutAction() {
            super(bundle, "WATableIndexPanel.Cut", true);
            this.setMenuSupportId("cut");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            WATableIndexPanel.this.m_treeIndexes.cut();
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        public cCopyAction() {
            super(bundle, "WATableIndexPanel.Copy", true);
            this.setMenuSupportId("copy");
        }

        public void actionPerformed(ActionEvent e) {
            if (WATableIndexPanel.this.m_bColumnsTableHasFocus) {
                WATableIndexPanel.this.copySelectedTableColumns();
            } else {
                WATableIndexPanel.this.m_treeIndexes.copy();
            }
            WATableIndexPanel.this.updateActions();
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        public cPasteAction() {
            super(bundle, "WATableIndexPanel.Paste", true);
            this.setMenuSupportId("paste");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.setHoldActionUpdates(true);
            WATableIndexPanel.this.m_treeIndexes.paste();
            WATableIndexPanel.this.setHoldActionUpdates(false);
        }
    }

    protected class cUniqueAction
    extends WsAbstractAction {
        public cUniqueAction() {
            super(bundle, "WATableIndexPanel.Unique");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.m_treeIndexes.setSelectedIndexProperty("Unique", new Boolean(WATableIndexPanel.this.m_ckbUnique.isSelected()));
            WATableIndexPanel.this.setDataChanged(true);
        }
    }

    protected class cPrimaryAction
    extends WsAbstractAction {
        public cPrimaryAction() {
            super(bundle, "WATableIndexPanel.Primary");
        }

        public void actionPerformed(ActionEvent e) {
            if (WATableIndexPanel.this.m_ckbPrimary.isSelected()) {
                IndexTreeNode nodeRoot = (IndexTreeNode)WATableIndexPanel.this.m_mdlIndexes.getRoot();
                int nIndexes = nodeRoot.getChildCount();
                for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
                    IndexTreeNode nodeIndex = (IndexTreeNode)nodeRoot.getChildAt(iIndex);
                    if (!((Boolean)nodeIndex.getProperty("Primary")).booleanValue()) continue;
                    MessageUtil.displayMessage((String)bundle.formatString("WATableIndexPanel.TooManyPrimaryIndexes.txt", (Object)nodeIndex.getName()), (int)0);
                    WATableIndexPanel.this.m_ckbPrimary.setSelected(false);
                    return;
                }
            }
            WATableIndexPanel.this.m_treeIndexes.setSelectedIndexProperty("Primary", new Boolean(WATableIndexPanel.this.m_ckbPrimary.isSelected()));
            WATableIndexPanel.this.setDataChanged(true);
        }
    }

    protected class cNoMissAction
    extends WsAbstractAction {
        public cNoMissAction() {
            super(bundle, "WATableIndexPanel.NoMiss");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.m_treeIndexes.setSelectedIndexProperty("NoMiss", new Boolean(WATableIndexPanel.this.m_ckbNoMiss.isSelected()));
            WATableIndexPanel.this.setDataChanged(true);
        }
    }

    protected class cClusteredAction
    extends WsAbstractAction {
        public cClusteredAction() {
            super(bundle, "WATableIndexPanel.Clustered");
        }

        public void actionPerformed(ActionEvent e) {
            WATableIndexPanel.this.m_treeIndexes.setSelectedIndexProperty("Clustered", new Boolean(WATableIndexPanel.this.m_ckbClustered.isSelected()));
            WATableIndexPanel.this.setDataChanged(true);
        }
    }
}

