/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.visuals.WADocumentPane;
import com.sas.wadmin.visuals.WANotesPane;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.rmi.RemoteException;

public class WANotesPropertyTab
extends WAPropertyTab {
    protected Root m_oMetadata;
    protected WsAbstractAction m_actDelete;
    protected WANotesPane m_pnlNotes;
    protected WADocumentPane m_pnlDocuments;

    public WANotesPropertyTab(CMetadata oMetadata) {
        this.m_oMetadata = (Root)oMetadata;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("notestab");
    }

    public boolean validateData() {
        if (!this.m_pnlNotes.validateData()) {
            return false;
        }
        return this.m_pnlDocuments.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            boolean bl = this.m_pnlNotes.doDataExchange(bSaveToModel) && this.m_pnlDocuments.doDataExchange(bSaveToModel);
            return bl;
        }
        finally {
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlNotes.saveSettingsAndCleanUp();
        this.m_pnlDocuments.saveSettingsAndCleanUp();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.m_actDelete == null) {
            this.m_actDelete = this.m_pnlNotes.getDeleteAction();
        }
        this.m_actDelete.setActive(bActive);
        this.m_pnlNotes.updateWorkspaceUIComponents(bActive);
        this.m_pnlDocuments.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlNotes.setEditable(bEditable);
        this.m_pnlDocuments.setEditable(bEditable);
    }

    protected void initialize() {
        this.m_pnlNotes = new WANotesPane(this.m_oMetadata);
        this.m_pnlDocuments = new WADocumentPane(this.m_oMetadata);
        this.m_pnlNotes.setWAUndoManager(this.getWAUndoManager());
        this.m_pnlDocuments.setWAUndoManager(this.getWAUndoManager());
        this.listenForDataChangesTo(this.m_pnlNotes);
        this.listenForDataChangesTo(this.m_pnlDocuments);
        this.m_pnlNotes.addNotesFocusListener(new NFListener());
        this.m_pnlDocuments.addDocFocusListener(new DFListener());
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_pnlNotes.setPreferredSize(new Dimension(550, 200));
        this.m_pnlDocuments.setPreferredSize(new Dimension(550, 200));
        this.add((Component)((Object)this.m_pnlNotes), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlDocuments), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    class NFListener
    extends FocusAdapter {
        NFListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            WsAbstractAction actDelete = WANotesPropertyTab.this.m_pnlNotes.getDeleteAction();
            if (actDelete != WANotesPropertyTab.this.m_actDelete) {
                if (WANotesPropertyTab.this.m_actDelete != null) {
                    WANotesPropertyTab.this.m_actDelete.setActive(false);
                }
                WANotesPropertyTab.this.m_actDelete = actDelete;
                WANotesPropertyTab.this.m_actDelete.setActive(true);
            }
        }
    }

    class DFListener
    extends FocusAdapter {
        DFListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            WsAbstractAction actDelete = WANotesPropertyTab.this.m_pnlDocuments.getDeleteAction();
            if (actDelete != WANotesPropertyTab.this.m_actDelete) {
                if (WANotesPropertyTab.this.m_actDelete != null) {
                    WANotesPropertyTab.this.m_actDelete.setActive(false);
                }
                WANotesPropertyTab.this.m_actDelete = actDelete;
                WANotesPropertyTab.this.m_actDelete.setActive(true);
            }
        }
    }
}

