/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class WADocumentSelectionDialog
extends WAStandardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(WADocumentSelectionDialog.class);
    protected cDocumentSelectionPanel m_pnlDocs;
    protected Vector m_vAddedDocs;
    protected String m_strIdsToRemove;

    public WADocumentSelectionDialog(CMetadata metadata, String ids) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("WADocumentSelectionDialog.Title.txt"), true);
        this.m_strIdsToRemove = ids;
        this.m_pnlDocs = new cDocumentSelectionPanel(metadata);
        this.setMainPanel(this.m_pnlDocs);
        this.m_vAddedDocs = new Vector();
        this.setHelpProduct("shared");
        this.setHelpTopic("sel_doc");
    }

    public Vector getSelections() {
        return this.m_vAddedDocs;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
    }

    public boolean onCancel() {
        return super.onCancel();
    }

    class cDocumentSelectionPanel
    extends WAPanel {
        private WAdminResource selBundle = WAdminResource.getBundle(cDocumentSelectionPanel.class);
        protected WATable m_table;
        protected CMetadata m_metadata;
        protected DocumentSelectionModel m_tableModel;
        protected JScrollPane m_tableScrollPane;
        final int SCROLL_PANE_WIDTH = 265;
        final int SCROLL_PANE_HEIGHT = 315;
        protected JLabel tempLabel;

        public cDocumentSelectionPanel(CMetadata metadata) {
            this.m_metadata = metadata;
            this.initialize();
            this.layoutWidgets();
        }

        public void initialize() {
            try {
                this.m_tableModel = new DocumentSelectionModel(this.m_metadata);
                this.m_table = new WATable((WATableModel)this.m_tableModel);
                this.m_table.setEditable(false);
                this.m_table.setAutoResizeMode(1);
                Border border = BorderFactory.createBevelBorder(1);
                this.m_tableScrollPane = new JScrollPane();
                this.m_tableScrollPane.getViewport().setView((Component)this.m_table);
                this.m_tableScrollPane.setVerticalScrollBarPolicy(20);
                this.m_tableScrollPane.setHorizontalScrollBarPolicy(30);
                this.m_tableScrollPane.setBorder(border);
                this.m_tableScrollPane.setPreferredSize(new Dimension(315, 315));
                this.m_tableScrollPane.setToolTipText(this.selBundle.getString("WADocumentSelectionDialog.TableToolTip.txt"));
                this.m_table.setToolTipText(this.selBundle.getString("WADocumentSelectionDialog.TableToolTip.txt"));
                this.m_table.setShowGrid(false);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "", 0);
            }
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_tableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(false);
            this.m_table.setEditable(false);
        }

        public boolean doDataExchange(boolean bsaveToModel) throws MdException, RemoteException {
            if (!bsaveToModel) {
                this.m_tableModel.setupModel();
                this.m_table.enableSorting(true);
                this.m_table.sort(0, true);
            }
            return true;
        }

        public boolean validateData() {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < this.m_table.getSelectedRowCount(); ++i) {
                Document o_addedDoc = (Document)this.m_tableModel.getValueAt(selectedRows[i], 1);
                WADocumentSelectionDialog.this.m_vAddedDocs.add(o_addedDoc);
            }
            return true;
        }

        public boolean hasDataChanged() {
            return false;
        }
    }

    public class DocumentSelectionModel
    extends WATableModel {
        protected CMetadata m_metadata = null;
        protected ArrayList m_cellChoices = new ArrayList();
        protected boolean[] isColumnEditable = new boolean[]{false, true};
        private boolean modelPopulated = false;
        private WAdminResource modelBundle = WAdminResource.getBundle(DocumentSelectionModel.class);
        public static final int COLUMN_COL = 0;
        public static final int TOTAL_COLS = 1;
        protected CMetadata m_Object;

        public DocumentSelectionModel(CMetadata inObject) throws MdException, RemoteException {
            this.m_metadata = inObject;
            this.columnNames.add(this.modelBundle.getString("DocumentSelectionModel.Column.txt"));
        }

        public void setupModel() {
            List<Document> valDocs = new Vector();
            try {
                if (!this.modelPopulated) {
                    if (this.m_metadata != null) {
                        String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                        String reposID2 = null;
                        if (Workspace.getWorkspace().getCheckinRepository() != null) {
                            reposID2 = Workspace.getWorkspace().getCheckinRepository().getFQID();
                        }
                        if (reposID2 != null) {
                            valDocs = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_metadata.getObjectStore(), reposID2, "Document", 264, "");
                        }
                        if (reposID2 != null && reposID != reposID2) {
                            List valDocs2 = new Vector();
                            valDocs2 = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_metadata.getObjectStore(), reposID, "Document", 392, "");
                            for (int x = 0; x < valDocs2.size(); ++x) {
                                Document projectDoc = (Document)valDocs2.get(x);
                                if (projectDoc.getChangeState().length() != 0) continue;
                                valDocs.add(projectDoc);
                            }
                        }
                    }
                    this.modelPopulated = true;
                }
                for (int n = valDocs.size(); n > 0; --n) {
                    Document tempDoc = (Document)valDocs.get(n - 1);
                    if (WADocumentSelectionDialog.this.m_strIdsToRemove.indexOf(tempDoc.getFQID()) <= -1) continue;
                    valDocs.remove(tempDoc);
                }
                for (int i = 0; i < valDocs.size(); ++i) {
                    Document doc = (Document)valDocs.get(i);
                    String s_noteName = doc.getName();
                    this.insertRow(s_noteName, doc);
                }
                if (this.data.size() > 0) {
                    this.fireTableRowsInserted(0, this.data.size() - 1);
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }

        public int getColumnCount() {
            return 1;
        }

        public boolean insertRow(String s_docName, Document o_document) {
            ++this.instanceCount;
            ArrayList<String> m = new ArrayList<String>();
            m.add(s_docName);
            m.add((String)o_document);
            this.data.add(m);
            return true;
        }
    }
}

