/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.WorkTable;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class ViewDataWorkTablesPanel
extends WAPanel {
    private JList m_list;
    private JScrollPane m_listPane;
    private Vector m_tableList;
    private Vector m_tableNameList;

    public ViewDataWorkTablesPanel(List lWorkTables) {
        this.m_tableList = (Vector)lWorkTables;
        this.setHelpTopic("work_table_select_win");
        this.initialize();
        this.layoutWidgets();
    }

    public Object getSelectedItem() {
        int iIndex = this.m_list.getSelectedIndex();
        return this.m_tableList.get(iIndex);
    }

    public boolean validateData() {
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    protected void initialize() {
        this.m_list = new JList();
        if (this.m_tableList != null) {
            this.m_tableNameList = new Vector();
        }
        for (int table = 0; table < this.m_tableList.size(); ++table) {
            try {
                String sTableName = ((WorkTable)this.m_tableList.get(table)).getSASTableName();
                this.m_tableNameList.add(table, sTableName);
                continue;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        this.m_list.setListData(this.m_tableNameList);
        this.m_list.setSelectionMode(0);
        this.m_listPane = new JScrollPane(this.m_list, 22, 30);
        this.m_listPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_listPane.setMinimumSize(new Dimension(50, 50));
        if (this.m_tableList != null) {
            this.m_list.setSelectedIndex(0);
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_listPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

