/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.job.transforms.AppendTransformModel;
import com.sas.etl.models.job.transforms.DataTransferTransformModel;
import com.sas.etl.models.job.transforms.ExtractTransformModel;
import com.sas.etl.models.job.transforms.FileReaderTransformModel;
import com.sas.etl.models.job.transforms.FileWriterTransformModel;
import com.sas.etl.models.job.transforms.LibraryContentsTransformModel;
import com.sas.etl.models.job.transforms.OracleBulkTableLoaderTransformModel;
import com.sas.etl.models.job.transforms.ReturnCodeCheckerTransformModel;
import com.sas.etl.models.job.transforms.SPDSTableLoaderTransformModel;
import com.sas.etl.models.job.transforms.SortTransformModel;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.job.transforms.TeradataTableLoaderTransformModel;
import com.sas.etl.models.job.transforms.UserWrittenTransformModel;
import com.sas.etl.models.job.transforms.XMLWriterTransformModel;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTransformModel;
import com.sas.etl.models.job.transforms.cas.CASTransferTransformModel;
import com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel;
import com.sas.etl.models.job.transforms.comparetables.impl.CompareTablesTransformModel;
import com.sas.etl.models.job.transforms.conditional.impl.ConditionalEndTransformModel;
import com.sas.etl.models.job.transforms.conditional.impl.ConditionalStartTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataloader.DataLoaderDirectiveTransformModel;
import com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel;
import com.sas.etl.models.job.transforms.facttable.FactTableTransformModel;
import com.sas.etl.models.job.transforms.fork.impl.ForkEndTransformModel;
import com.sas.etl.models.job.transforms.fork.impl.ForkTransformModel;
import com.sas.etl.models.job.transforms.hpa.LASRLoaderTransformModel;
import com.sas.etl.models.job.transforms.hpa.LASRUnloaderTransformModel;
import com.sas.etl.models.job.transforms.hpa.SASHadoopDataLoaderTransformModel;
import com.sas.etl.models.job.transforms.hpa.SASHadoopDataUnloaderTransformModel;
import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.job.transforms.loop.impl.LoopEndTransformModel;
import com.sas.etl.models.job.transforms.loop.impl.LoopTransformModel;
import com.sas.etl.models.job.transforms.miningresults.impl.MiningResultsTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.IBMWSQReaderTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.IBMWSQWriterTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.MSMQReaderTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.MSMQWriterTransformModel;
import com.sas.etl.models.job.transforms.rank.RankTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.KEDTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.SCDType1TransformModel;
import com.sas.etl.models.job.transforms.scd.impl.SCDType2TransformModel;
import com.sas.etl.models.job.transforms.splitter.SplitterTransformModel;
import com.sas.etl.models.job.transforms.sql.impl.SQLJoinTransformModel;
import com.sas.etl.models.job.transforms.sql.impl.SQLSetOperatorsTransformModel;
import com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenanceTransformModel;
import com.sas.etl.models.job.transforms.waitforcompletion.WaitForCompletionTransformModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.visuals.util.XMLCommandEvent;
import com.sas.wadmin.jobeditor.diagram.adapters.TransformationVisualsFactoryPluginInterface;
import com.sas.wadmin.model.tree.TransformationsTreeModel;
import com.sas.wadmin.pfd.ProcessDetailEventListener;
import com.sas.wadmin.pfd.ProcessEventListener;
import com.sas.wadmin.plugins.TransformHiddenInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.ProcessTreeModel;
import com.sas.wadmin.visuals.TransformationType;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class TransformManager {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformManager.class);
    private static TransformManager s_instance;
    protected TransformationsTreeModel m_transformationsTreeModel;
    HashMap m_transforms = new HashMap(10);

    public static TransformManager createInstance() {
        s_instance = new TransformManager();
        return s_instance;
    }

    public static TransformManager getInstance() {
        if (s_instance == null) {
            return TransformManager.createInstance();
        }
        return s_instance;
    }

    private TransformManager() {
        this.m_transformationsTreeModel = new TransformationsTreeModel(Workspace.getWorkspace().getUserContext());
        String sAccess = bundle.getString("TransformManager.Category.Access.txt");
        String sArchived = bundle.getString("TransformManager.Category.Archived.txt");
        String sControl = bundle.getString("TransformManager.Category.Control.txt");
        String sData = bundle.getString("TransformManager.Category.Data.txt");
        String sAnalysis = bundle.getString("TransformManager.Category.Analysis.txt");
        String sSQL = bundle.getString("TransformManager.Category.SQL.txt");
        String sHPA = bundle.getString("TransformManager.Category.HPA.txt");
        String sHadoop = bundle.getString("TransformManager.Category.Hadoop.txt");
        Workspace.getDefaultLogger().debug((Object)"Creating shipped transformations...");
        this.addTransformation(new TransformationTypeImpl("FileReader", sAccess, FileReaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("FileWriter", sAccess, FileWriterTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("LibraryContents", sAccess, LibraryContentsTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("MicrosoftQueueReader", sArchived, MSMQReaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("MicrosoftQueueWriter", sArchived, MSMQWriterTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SPDServerTableLoader", sAccess, SPDSTableLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("TableLoader", sAccess, TableLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("WebsphereQueueReader", sArchived, IBMWSQReaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("WebsphereQueueWriter", sArchived, IBMWSQWriterTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("XMLWriter", sAccess, XMLWriterTransformModel.getTransformTypeID()));
        TransformationTypeImpl castransfer = new TransformationTypeImpl("CASTransfer", sAccess, CASTransferTransformModel.getTransformTypeID());
        castransfer.m_bHidden = true;
        this.addTransformation(castransfer);
        this.addTransformation(new TransformationTypeImpl("CASLoader", sAccess, CASLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("TableMaintenance", sAccess, TableMaintenanceTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("FactTableLookup", sArchived, FactTableTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Loop", sControl, LoopTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("LoopEnd", sControl, LoopEndTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Fork", sControl, ForkTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("ForkEnd", sControl, ForkEndTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("WaitForCompletion", sControl, WaitForCompletionTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("ReturnCodeCheck", sControl, ReturnCodeCheckerTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("ConditionalStart", sControl, ConditionalStartTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("ConditionalEnd", sControl, ConditionalEndTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Append", sData, AppendTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("DataTransfer", sData, DataTransferTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("DataValidation", sData, DataValidationTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("KeyEffectiveDate", sData, KEDTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Lookup", sData, LookupTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("MiningResults", sData, MiningResultsTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Rank", sData, RankTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Sort", sData, SortTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Splitter", sData, SplitterTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SCDType2Loader", sData, SCDType2TransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("UserWrittenCode", sData, UserWrittenTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("TeradataTableLoader", sAccess, TeradataTableLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("HPF", sAnalysis, HPFTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("OracleBulkTableLoader", sAccess, OracleBulkTableLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("CompareTables", sData, CompareTablesTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SCDType1", sData, SCDType1TransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("Extract", sSQL, ExtractTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SQLJoin", sSQL, SQLJoinTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SetOperator", sSQL, SQLSetOperatorsTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("BusinessRules", sData, BusinessRuleTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("EDMFlow", sData, EDMFlowTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("DataLoaderDirective", sHadoop, DataLoaderDirectiveTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("LASRLoader", sHPA, LASRLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("LASRUnloader", sHPA, LASRUnloaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SASHadoopLoader", sHPA, SASHadoopDataLoaderTransformModel.getTransformTypeID()));
        this.addTransformation(new TransformationTypeImpl("SASHadoopUnloader", sHPA, SASHadoopDataUnloaderTransformModel.getTransformTypeID()));
        Workspace.getDefaultLogger().debug((Object)"Loading plugin transformation...");
        List plugins = Workspace.getWorkspace().getPluginLoader().getPlugins(TransformInterface.class);
        for (int i = 0; i < plugins.size(); ++i) {
            this.addTransformation(new TransformationTypeImpl((TransformInterface)plugins.get(i)));
        }
        List lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(TransformationVisualsFactoryPluginInterface.class);
        for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
            TransformationVisualsFactoryPluginInterface plugin = (TransformationVisualsFactoryPluginInterface)lPlugins.get(iPlugin);
            TransformationType[] aTypes = plugin.getTransformationTypes();
            if (aTypes == null) continue;
            for (int iType = 0; iType < aTypes.length; ++iType) {
                this.addTransformation(new TransformationTypeImpl(aTypes[iType]));
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Loading Generated Transformations...");
        this.loadGeneratedTransformations();
        Workspace.getWorkspace().clearStatusText();
    }

    private void addTransformation(TransformInterface transformation) {
        Workspace.getDefaultLogger().debug((Object)(transformation.getTransformClass() + "=" + transformation.getName() + " in " + transformation.getCategory()));
        this.m_transforms.put(transformation.getTransformClass(), transformation);
        if (!(transformation instanceof TransformationTypeImpl) || !((TransformationTypeImpl)transformation).isHidden()) {
            this.m_transformationsTreeModel.addTransformation(transformation);
        }
    }

    public void removeTransformation(TransformInterface transformation) {
        this.m_transforms.remove(transformation.getTransformClass());
        this.m_transformationsTreeModel.removeTransformation(transformation);
    }

    public TransformInterface getTransform(String transformRole) {
        return (TransformInterface)this.m_transforms.get(transformRole);
    }

    public TransformationType getTransformationType(String sTransformationTypeID) {
        return (TransformationType)this.m_transforms.get(sTransformationTypeID);
    }

    public ArrayList getProcessEventListenerTransforms() {
        ArrayList<ProcessEventListener> list = new ArrayList<ProcessEventListener>();
        for (Object object : this.m_transforms.values()) {
            if (!(object instanceof ProcessEventListener)) continue;
            ProcessEventListener processEventListener = (ProcessEventListener)object;
            list.add(processEventListener);
        }
        return list;
    }

    public ArrayList getProcessDetailEventListenerTransforms() {
        ArrayList<ProcessDetailEventListener> list = new ArrayList<ProcessDetailEventListener>();
        for (Object object : this.m_transforms.values()) {
            if (!(object instanceof ProcessDetailEventListener)) continue;
            ProcessDetailEventListener processDetailEventListener = (ProcessDetailEventListener)object;
            list.add(processDetailEventListener);
        }
        return list;
    }

    public ProcessTreeModel getProcessTreeModel() {
        return null;
    }

    public TransformationsTreeModel getTransformationsTreeModel() {
        return this.m_transformationsTreeModel;
    }

    public void objectsCreated(List lObjects) {
        try {
            ArrayList<String> lTransformsToCreate = new ArrayList<String>();
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                Root mdoObject = (Root)lObjects.get(iObject);
                if (!GeneratedTransformationUtilities.isGeneratedTransformation((Root)mdoObject)) continue;
                lTransformsToCreate.add(mdoObject.getFQID());
            }
            if (!lTransformsToCreate.isEmpty()) {
                this.updateTransformations(lTransformsToCreate);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void objectsModified(List lObjects) {
        try {
            ArrayList<String> lTransformsToUpdate = new ArrayList<String>();
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                Root mdoGenTrans;
                Root mdoObject = (Root)lObjects.get(iObject);
                if (mdoObject == null) {
                    return;
                }
                if (mdoObject.getCMetadataType().equals("Prototype")) {
                    lTransformsToUpdate.add(mdoObject.getFQID());
                    continue;
                }
                if (!GeneratedTransformationUtilities.isTreePathExtension((Root)mdoObject) || (mdoGenTrans = ((Extension)mdoObject).getOwningObject()) == null || !mdoGenTrans.getCMetadataType().equals("Prototype")) continue;
                lTransformsToUpdate.add(mdoGenTrans.getFQID());
            }
            if (!lTransformsToUpdate.isEmpty()) {
                this.updateTransformations(lTransformsToUpdate);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransformations(List lTransformationFQIDs) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "TransformManager:CreateTransformsRunnable");
            try {
                for (int iFQID = 0; iFQID < lTransformationFQIDs.size(); ++iFQID) {
                    String sFQID = (String)lTransformationFQIDs.get(iFQID);
                    Prototype mdoTransform = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Prototype", sFQID);
                    GeneratedTransformationUtilities.populateGeneratedTransformation((Prototype)mdoTransform);
                    if (!GeneratedTransformationUtilities.isGeneratedTransformation((Root)mdoTransform)) continue;
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.updateTransformation(mdoTransform);
                        continue;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new cUpdateTransformationRunnable(mdoTransform));
                        continue;
                    }
                    catch (InterruptedException e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void updateTransformation(Prototype mdoTransformation) throws MdException, RemoteException {
        try {
            String strGetXML = MacroPluginUtilities.getGetXML(mdoTransformation);
            if (strGetXML == null) {
                return;
            }
            String strGUID = MacroPluginUtilities.getGuid(mdoTransformation);
            if (strGUID == null) {
                return;
            }
            TransformInterface transformation = this.getTransform(strGUID);
            if (transformation != null) {
                this.removeTransformation(transformation);
            }
            MacroPlugin macro = new MacroPlugin((CMetadata)mdoTransformation, strGetXML, GeneratedTransformationUtilities.getProcessTreePath((Root)mdoTransformation));
            this.addTransformation(macro);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)"Error importing a plugin moving on");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGeneratedTransformations() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "TransformManager:LoadGeneratedTransformation");
            try {
                List lPrototypes = GeneratedTransformationUtilities.loadGeneratedTransformations((CMetadata)Workspace.getWorkspace().getDefaultRepository(), (MdObjectStore)store);
                for (int i = 0; i < lPrototypes.size(); ++i) {
                    this.updateTransformation((Prototype)lPrototypes.get(i));
                }
            }
            catch (MdException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static void updateTransformNameAndDescription(Prototype mdoTransformation) throws MdException, RemoteException {
        AssociationList properties = mdoTransformation.getProperties();
        String strGetXML = null;
        TextStore storedText = null;
        for (int k = 0; k < properties.size(); ++k) {
            Property property = (Property)properties.elementAt(k);
            if (!property.getPropertyName().equalsIgnoreCase("GetXML")) continue;
            storedText = (TextStore)property.getStoredConfiguration();
            strGetXML = storedText.getStoredText();
            if (strGetXML.length() != 0 && strGetXML.indexOf("PropertyName=\"Class\"") != -1) break;
            return;
        }
        int index = strGetXML.indexOf("<TransformationStep");
        int index2 = strGetXML.indexOf("Name=", index);
        int index4 = strGetXML.indexOf("\" Desc=", index2);
        String subString1 = strGetXML.substring(0, index2 += 6);
        String subString2 = strGetXML.substring(index4);
        StringBuffer newXMLBuffer = new StringBuffer();
        newXMLBuffer.append(subString1);
        newXMLBuffer.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(mdoTransformation.getName()));
        newXMLBuffer.append(subString2);
        String newXML2 = newXMLBuffer.toString();
        index = newXML2.indexOf("<TransformationStep");
        index2 = newXML2.indexOf("Desc=\"", index);
        index4 = newXML2.indexOf("\" IsActive=", index2);
        subString1 = newXML2.substring(0, index2 += 6);
        subString2 = newXML2.substring(index4);
        StringBuffer newXML2Buffer = new StringBuffer();
        newXML2Buffer.append(subString1);
        newXML2Buffer.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(mdoTransformation.getDesc()));
        newXML2Buffer.append(subString2);
        storedText.setStoredText(newXML2Buffer.toString());
    }

    public static boolean exportSourcetoFile(String fileName, String value) {
        return TransformManager.exportSourcetoFile(fileName, value, "UTF-8");
    }

    public static boolean exportSourcetoFile(String fileName, String value, String encoding) {
        try {
            FileOutputStream file = new FileOutputStream(fileName);
            OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(file) : new OutputStreamWriter((OutputStream)file, encoding);
            writer.write(value, 0, value.length());
            writer.close();
            file.close();
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)bundle.formatString("TransformExporterDialog.fileerror.txt", (Object)ex.getMessage()), (int)0);
            Workspace.getDefaultLogger().warn((Object)"", (Throwable)ex);
            return false;
        }
        return true;
    }

    private static class TransformationTypeImpl
    implements TransformInterface,
    TransformationType {
        private String m_sName;
        private String m_sDescription;
        private String m_sID;
        private String m_sCategory;
        private Icon m_icon16;
        private Icon m_icon24;
        private URL m_url16;
        private URL m_url24;
        private boolean m_bHidden = false;

        public TransformationTypeImpl(String sResourceName, String sCategoryName, String sID) {
            this.m_sID = sID;
            this.m_sCategory = sCategoryName;
            this.m_sName = bundle.getString("TransformManager.Transformation." + sResourceName + ".txt");
            this.m_sDescription = bundle.getString("TransformManager.Transformation." + sResourceName + ".tip");
            this.m_icon16 = bundle.getIcon("TransformManager.Transformation." + sResourceName + ".16.image");
            this.m_icon24 = bundle.getIcon("TransformManager.Transformation." + sResourceName + ".24.image");
            this.m_url16 = bundle.getIconURL("TransformManager.Transformation." + sResourceName + ".16.image");
            this.m_url24 = bundle.getIconURL("TransformManager.Transformation." + sResourceName + ".24.image");
        }

        public TransformationTypeImpl(TransformInterface xfm) {
            this.m_sName = xfm.getName();
            this.m_sDescription = xfm.getToolTip();
            this.m_sID = xfm.getTransformClass();
            this.m_sCategory = xfm.getCategory();
            this.m_icon16 = xfm.getIcon();
            this.m_bHidden = xfm instanceof TransformHiddenInterface;
        }

        public TransformationTypeImpl(TransformationType type) {
            this.m_sName = type.getName();
            this.m_sDescription = type.getDescription();
            this.m_sID = type.getTypeID();
            this.m_sCategory = type.getCategory();
            this.m_icon16 = type.getIcon(16);
            this.m_icon24 = type.getIcon(24);
            this.m_url16 = type.getIconURL(16);
            this.m_url24 = type.getIconURL(24);
        }

        @Override
        public String getName() {
            return this.m_sName;
        }

        @Override
        public String getDescription() {
            return this.m_sDescription;
        }

        @Override
        public String getToolTip() {
            return this.m_sDescription;
        }

        @Override
        public String getTypeID() {
            return this.m_sID;
        }

        @Override
        public String getTransformClass() {
            return this.m_sID;
        }

        @Override
        public String getCategory() {
            return this.m_sCategory;
        }

        public Icon getIcon() {
            return this.m_icon16;
        }

        @Override
        public Icon getIcon(int eSize) {
            if (eSize == 16) {
                return this.m_icon16;
            }
            if (eSize == 24) {
                return this.m_icon24;
            }
            throw new IllegalArgumentException("Size must be SIZE_16 or SIZE_24");
        }

        @Override
        public URL getIconURL(int eSize) {
            if (eSize == 16) {
                return this.m_url16;
            }
            if (eSize == 24) {
                return this.m_url24;
            }
            throw new IllegalArgumentException("Size must be SIZE_16 or SIZE_24");
        }

        public boolean isHidden() {
            return this.m_bHidden;
        }

        @Override
        public JInternalFrame displayProperties(CMetadata metadataObject) {
            return null;
        }

        @Override
        public String getCopyXML() {
            return null;
        }

        @Override
        public String getRemoveXML() {
            return null;
        }

        @Override
        public ArrayList getValidDropTargets() {
            return null;
        }

        @Override
        public String getXML() {
            return null;
        }

        @Override
        public String getXMLPopupMenu() {
            return null;
        }

        @Override
        public boolean isRunnable(CMetadata step) {
            return false;
        }

        @Override
        public boolean onAfterDrop(MdObjectStore store) {
            return false;
        }

        @Override
        public boolean onBeforeDrop(MdObjectStore store) {
            return false;
        }

        @Override
        public void processCommand(XMLCommandEvent e) {
        }

        public void dispose() {
        }

        public void initPlugin() {
        }
    }

    private class cUpdateTransformationRunnable
    implements Runnable {
        private Prototype m_mdoTransformation;

        public cUpdateTransformationRunnable(Prototype mdoTransformation) {
            this.m_mdoTransformation = mdoTransformation;
        }

        @Override
        public void run() {
            try {
                TransformManager.this.updateTransformation(this.m_mdoTransformation);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

