/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.IndexCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.UniqueKey;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.visuals.ColumnsTableNameCellRenderer;
import com.sas.wadmin.visuals.ComboButton;
import com.sas.wadmin.visuals.KeyColumnMappingsPanel;
import com.sas.wadmin.visuals.NewForeignKeysWizard;
import com.sas.wadmin.visuals.WAdminTree_TableKeys;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsDragSourceAdapter;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TableKeysPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(TableKeysPanel.class);
    protected DataTable table;
    protected MdObjectStore store;
    protected WAPanel rightPanel;
    protected WAdminTree_TableKeys keyTree;
    protected WorkspaceTreeModel treeModel;
    protected JScrollPane treePane;
    protected WAPanel leftPanel;
    protected JSplitPane splitPane;
    protected ComboButton newButton;
    protected JButton deleteButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JButton leftButton;
    protected JButton rightButton;
    protected WsAbstractAction newAction;
    protected WsAbstractAction newPrimaryKeyAction;
    protected WsAbstractAction newForeignKeyAction;
    protected WsAbstractAction newUniqueKeyAction;
    protected WsAbstractAction deleteAction;
    protected WsAbstractAction moveRightAction;
    protected WsAbstractAction moveLeftAction;
    protected WsAbstractAction moveUpAction;
    protected WsAbstractAction moveDownAction;
    protected JScrollPane colsTablePane;
    protected WAPanel colsPanel;
    protected JPanel horizontalButtonPanel;
    protected JPanel verticalButtonPanel;
    protected WsTable colsTable;
    protected ColumnsTableModel2 colsModel;
    protected int mask;
    protected WorkspaceFile wadef;
    protected UniqueKey primaryKey = null;
    protected Vector foreignKeyList;
    protected Vector foreignKeyPanelList;
    protected MyTreeSelectionListener treeSelectionListener = new MyTreeSelectionListener();
    protected MyTreeChangesListener treeModelChangeListener = new MyTreeChangesListener();
    protected WorkspaceMenuSupport wms;
    protected int uniqueKeyCount;
    protected JLabel lblColumns;
    protected JLabel lblTree;

    public TableKeysPanel(CMetadata otable, ColumnsTableModel2 model) {
        try {
            this.table = (DataTable)otable;
            this.store = (MdObjectStore)this.table.getObjectStore();
            this.colsModel = model;
            this.colsModel.setMetadataTable(this.table);
            this.wadef = Workspace.getWorkspace().getAppDefaultsFile();
            this.initialize();
            this.layoutWidgets();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void initialize() {
        this.createActions();
        this.createKeysTree();
        this.createColumnsTable();
        this.createButtonPanels();
        this.leftPanel = new WAPanel();
        this.rightPanel = new WAPanel();
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent((Component)this.leftPanel);
        this.splitPane.setRightComponent((Component)this.rightPanel);
        this.splitPane.setResizeWeight(0.25);
        this.splitPane.setDividerLocation(275);
        this.foreignKeyList = new Vector();
        this.foreignKeyPanelList = new Vector();
    }

    protected void createKeysTree() {
        this.keyTree = new WAdminTree_TableKeys((CMetadata)this.table);
        this.lblTree = new JLabel(bundle.getString("TableKeysPanel.TreeLabel.txt"));
        this.lblTree.setDisplayedMnemonic(bundle.getString("TableKeysPanel.TreeLabel.mnem").charAt(0));
        this.lblTree.setLabelFor((Component)((Object)this.keyTree));
        this.keyTree.addForeignKeyEventListener(this.createForeignKeyEventListener());
        this.treePane = new JScrollPane((Component)((Object)this.keyTree));
        this.keyTree.setPanel(this);
        this.treeModel = (WorkspaceTreeModel)this.keyTree.getModel();
        this.treeModel.addTreeModelListener((TreeModelListener)this.treeModelChangeListener);
        this.keyTree.addTreeSelectionListener(this.treeSelectionListener);
        this.keyTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.deleteAction);
        this.keyTree.getActionMap().put(this.deleteAction, (Action)this.deleteAction);
    }

    protected void createColumnsTable() {
        this.colsTable = new WsTable((WsAbstractTableModel)this.colsModel);
        this.colsTable.setEditable(false);
        this.colsTable.setMouseBlockSelectionEnabled(false);
        this.colsTable.setMultipleSelectionDragEnabled(true);
        this.lblColumns = new JLabel(bundle.getString("TableKeysPanel.ColumnsLabel.txt"));
        this.lblColumns.setDisplayedMnemonic(bundle.getString("TableKeysPanel.ColumnsLabel.mnem").charAt(0));
        this.lblColumns.setLabelFor((Component)this.colsTable);
        ColumnsTableNameCellRenderer rdrName = new ColumnsTableNameCellRenderer();
        rdrName.showKeyIcon(false);
        rdrName.showNotesIcon(false);
        rdrName.showExtAttrsIcon(false);
        TableColumn colName = this.colsTable.getColumnModel().getColumn(0);
        colName.setCellRenderer((TableCellRenderer)((Object)rdrName));
        this.colsTable.restoreSettings("TableKeysPanel");
        this.colsTable.setEditable(false);
        this.colsTable.hideColumn(3);
        this.colsTable.hideColumn(4);
        this.colsTable.hideColumn(5);
        this.colsTable.hideColumn(6);
        this.colsTable.hideColumn(7);
        this.colsTable.hideColumn(8);
        this.colsTable.removeColumn(9);
        this.colsTable.removeColumn(10);
        this.colsTable.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.colsTable, 1, this.createColumnsTableDragGestureListener());
        this.colsTablePane = new JScrollPane((Component)this.colsTable);
        this.colsTablePane.setBorder(BorderFactory.createEtchedBorder());
        this.colsPanel = new WAPanel();
    }

    protected void createButtonPanels() {
        ArrayList<WsAbstractAction> alNewOptions = new ArrayList<WsAbstractAction>(3);
        alNewOptions.add(this.newForeignKeyAction);
        alNewOptions.add(this.newPrimaryKeyAction);
        alNewOptions.add(this.newUniqueKeyAction);
        this.newButton = new ComboButton((Action)this.newAction, alNewOptions);
        this.deleteButton = this.createTextButton(this.deleteAction);
        this.upButton = this.createToolButton(this.moveUpAction);
        this.downButton = this.createToolButton(this.moveDownAction);
        this.rightButton = this.createToolButton(this.moveRightAction);
        this.leftButton = this.createToolButton(this.moveLeftAction);
        JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout());
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout());
        this.verticalButtonPanel = new JPanel((LayoutManager)new WsButtonsLayout(1, 0));
        pnlLeft.add(this.upButton);
        pnlLeft.add(this.downButton);
        pnlRight.add(this.newButton);
        pnlRight.add(this.deleteButton);
        this.verticalButtonPanel.add(this.rightButton);
        this.verticalButtonPanel.add(this.leftButton);
        this.horizontalButtonPanel = new JPanel(new GridBagLayout());
        this.horizontalButtonPanel.add((Component)pnlLeft, new GridBagConstraints(0, 0, 1, 0, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.horizontalButtonPanel.add((Component)pnlRight, new GridBagConstraints(1, 0, 1, 0, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    protected JButton createTextButton(WsAbstractAction act) {
        JButton btn = new JButton((Action)act);
        btn.setIcon(null);
        return btn;
    }

    protected JButton createToolButton(WsAbstractAction act) {
        JButton btn = new JButton((Action)act);
        btn.setText(null);
        Insets ins = btn.getMargin();
        ins.left = ins.top;
        ins.right = ins.bottom;
        btn.setMargin(ins);
        return btn;
    }

    protected void createActions() {
        this.newAction = this.createNewAction();
        this.newPrimaryKeyAction = this.createNewPrimaryKeyAction();
        this.newForeignKeyAction = this.createNewForeignKeyAction();
        this.newUniqueKeyAction = this.createNewUniqueKeyAction();
        this.deleteAction = this.createDeleteAction();
        this.moveRightAction = this.createMoveRightAction();
        this.moveLeftAction = this.createMoveLeftAction();
        this.moveUpAction = this.createMoveUpAction();
        this.moveDownAction = this.createMoveDownAction();
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.colsModel.populateStore();
        Vector<String> complex = new Vector<String>();
        String template = "<Templates><UniqueKey><KeyedColumns/><ForeignKeys/></UniqueKey><ForeignKey><Table/><KeyedColumns/><KeyAssociations/></ForeignKey></Templates>";
        complex.add("UniqueKeys");
        complex.add("ForeignKeys");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.store, "PhysicalTable", this.table.getFQID(), null, complex, template, 16396);
        AssociationList uniqueKeys = null;
        uniqueKeys = this.table.getUniqueKeys();
        this.uniqueKeyCount = uniqueKeys.size();
        if (!uniqueKeys.isEmpty()) {
            for (int i = 0; i < uniqueKeys.size(); ++i) {
                UniqueKey tableKey = (UniqueKey)uniqueKeys.get(i);
                complex.clear();
                template = "<Templates><ForeignKey><Table/><PartnerUniqueKey/><KeyedColumns/><KeyAssociations/></ForeignKey></Templates>";
                complex.add("ForeignKeys");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.store, "UniqueKey", tableKey.getFQID(), null, complex, template, 16396);
                if (tableKey.getIsPrimary() != 1) continue;
                --this.uniqueKeyCount;
                this.primaryKey = tableKey;
                this.updateActions();
            }
        }
        this.keyTree.initialize();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.colsModel.moveDataToModel();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        WsTreeNode node;
        WsTreeNode currNode;
        block15: {
            String message;
            block17: {
                boolean bSASTable;
                Index index;
                AssociationList keyColumns;
                block16: {
                    if (!this.hasDataChanged()) {
                        return;
                    }
                    currNode = this.keyTree.getSelectedNode();
                    for (int i = 0; i < this.foreignKeyPanelList.size(); ++i) {
                        KeyColumnMappingsPanel panel = (KeyColumnMappingsPanel)((Object)this.foreignKeyPanelList.get(i));
                        panel.moveDataToStore();
                        this.leftPanel.remove((Component)((Object)panel));
                    }
                    this.foreignKeyPanelList.clear();
                    this.foreignKeyList.clear();
                    if (!this.primaryKeyExists()) break block15;
                    keyColumns = this.primaryKey.getKeyedColumns();
                    keyColumns.removeAllElements();
                    keyColumns.flushAll();
                    WsTreeNode pkNode = this.keyTree.getPrimaryKeyNode();
                    this.primaryKey.setName(pkNode.getName());
                    WsTreeNode parent = (WsTreeNode)pkNode.getFirstChild();
                    Enumeration colNodes = parent.children();
                    while (colNodes.hasMoreElements()) {
                        WsDataTreeNode node2 = (WsDataTreeNode)colNodes.nextElement();
                        keyColumns.addElement((Object)node2.getMetadata());
                    }
                    AssociationList indexes = ((PhysicalTable)this.table).getIndexes();
                    int indSize = indexes.size();
                    boolean indexFound = false;
                    index = this.keyTree.getIndexUsedInPrimaryKey();
                    message = null;
                    if (index != null) break block16;
                    for (int i = 0; i < indSize; ++i) {
                        index = (Index)indexes.get(i);
                        IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
                        if (indexCG.getPrimaryKeyUsingIndex() == null) continue;
                        if (index.getIsUnique() == 0) {
                            message = bundle.formatString("TableKeysPanel.IndexModifiedUniqueValues.txt", (Object)index.getName(), (Object)this.primaryKey.getName());
                            index.setIsUnique(1);
                        }
                        this.keyTree.setIndexUsedInPrimaryKey(index);
                        indexFound = true;
                        break;
                    }
                    if (indexFound) break block17;
                    index = this.createIndex((List)keyColumns, (List)indexes);
                    message = bundle.formatString("TableKeysPanel.IndexCreated.txt", (Object)index.getName(), (Object)this.primaryKey.getName());
                    break block17;
                }
                IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
                if (index.getIsUnique() == 0 || indexCG.getPrimaryKeyUsingIndex() == null) {
                    message = bundle.formatString("TableKeysPanel.IndexModified.txt", (Object)index.getName(), (Object)this.primaryKey.getName());
                }
                index.setIsUnique(1);
                index.getColumns().removeAllElements();
                index.getColumns().flushAll();
                index.getColumns().addAll(new ArrayList(keyColumns));
                String sDBMSType = TransformUtil.getDBMSProductName((PhysicalTable)((PhysicalTable)this.table));
                boolean bl = bSASTable = sDBMSType != null && sDBMSType.startsWith("SAS");
                if (bSASTable && keyColumns.size() == 1) {
                    index.setName(((Column)keyColumns.get(0)).getSASColumnName());
                } else if (bSASTable && keyColumns.size() > 1) {
                    for (int i = 0; i < keyColumns.size(); ++i) {
                        Column oColumn = (Column)keyColumns.get(i);
                        if (!oColumn.getSASColumnName().equals(index.getName())) continue;
                        index.setName(index.getName() + "_Primary");
                        break;
                    }
                }
            }
            if (message != null) {
                MessageUtil.displayMessage(message, (int)1);
            }
        }
        if ((node = this.keyTree.getUniqueKeyFolderNode()) != null) {
            Enumeration uKeys = node.children();
            WsDataTreeNode uKeyNode = null;
            while (uKeys.hasMoreElements()) {
                uKeyNode = (WsDataTreeNode)uKeys.nextElement();
                UniqueKey uk = (UniqueKey)uKeyNode.getMetadata();
                uk.setName(uKeyNode.getName());
                AssociationList ukColumns = uk.getKeyedColumns();
                WsTreeNode colFolder = (WsTreeNode)uKeyNode.getFirstChild();
                Enumeration ukColNodes = colFolder.children();
                WsDataTreeNode colNode = null;
                ukColumns.removeAllElements();
                ukColumns.flushAll();
                while (ukColNodes.hasMoreElements()) {
                    colNode = (WsDataTreeNode)ukColNodes.nextElement();
                    ukColumns.addElement((Object)colNode.getMetadata());
                }
            }
        }
        this.keyTree.setSelectionRow(0);
        if (currNode != null) {
            this.setTreeSelection(currNode);
        }
        this.setDataChanged(false);
    }

    private Index createIndex(List keyColumns, List tableIndexList) throws MdException, RemoteException {
        boolean bSASTable;
        String indexName = "pk_index";
        String sDBMSType = TransformUtil.getDBMSProductName((PhysicalTable)((PhysicalTable)this.table));
        boolean bl = bSASTable = sDBMSType != null && sDBMSType.startsWith("SAS");
        if (bSASTable && keyColumns.size() == 1) {
            indexName = ((Column)keyColumns.get(0)).getSASColumnName();
        }
        Index index = (Index)Workspace.getMdFactory().createComplexMetadataObject(this.store, null, indexName, "Index", this.table.getRepositoryID());
        index.setIsUnique(1);
        index.getColumns().addAll(new ArrayList(keyColumns));
        index.setDesc(bundle.formatString("Common.DefaultPrimaryIndex.Descr.txt", (Object)((PhysicalTable)this.table).getSASTableName()));
        index.setIndexName(indexName);
        tableIndexList.add(index);
        this.keyTree.setIndexUsedInPrimaryKey(index);
        return index;
    }

    public boolean validateData() {
        AssociationList uniqueKeys = null;
        try {
            int i;
            uniqueKeys = this.table.getUniqueKeys();
            if (uniqueKeys.size() < 1) {
                return true;
            }
            UniqueKey uKey = null;
            for (i = 0; i < uniqueKeys.size(); ++i) {
                uKey = (UniqueKey)uniqueKeys.get(i);
                if (uKey.getKeyedColumns().size() >= 1) continue;
                MessageUtil.displayMessage((String)bundle.formatString("TableKeysPanel.ErrorNoColumns.txt", (Object)uKey.getName()), (int)0);
                this.keyTree.setSelectionMetadataObject((CMetadata)uKey);
                return false;
            }
            for (i = 0; i < this.foreignKeyPanelList.size(); ++i) {
                KeyColumnMappingsPanel panel = (KeyColumnMappingsPanel)((Object)this.foreignKeyPanelList.get(i));
                boolean isValid = panel.validateData();
                if (isValid) continue;
                this.keyTree.setSelectionMetadataObject((CMetadata)panel.getForeignKey());
                return false;
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.colsTable.saveSettings("TableKeysPanel");
        this.keyTree.removeTreeSelectionListener(this.treeSelectionListener);
        this.treeModel.removeTreeModelListener((TreeModelListener)this.treeModelChangeListener);
        this.keyTree.saveSettingsAndCleanUp();
        for (int i = 0; i < this.foreignKeyPanelList.size(); ++i) {
            KeyColumnMappingsPanel panel = (KeyColumnMappingsPanel)((Object)this.foreignKeyPanelList.get(i));
            panel.saveSettingsAndCleanUp();
        }
        this.table = null;
        this.primaryKey = null;
        this.store = null;
    }

    protected WsAbstractAction createNewAction() {
        return new NewAction();
    }

    protected WsAbstractAction createNewPrimaryKeyAction() {
        return new NewPrimaryKeyAction();
    }

    protected WsAbstractAction createNewForeignKeyAction() {
        return new NewForeignKeyAction();
    }

    protected WsAbstractAction createNewUniqueKeyAction() {
        return new NewUniqueKeyAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new DeleteAction();
    }

    protected WsAbstractAction createMoveRightAction() {
        return new MoveRightAction();
    }

    protected WsAbstractAction createMoveLeftAction() {
        return new MoveLeftAction();
    }

    protected WsAbstractAction createMoveUpAction() {
        return new MoveUpAction();
    }

    protected WsAbstractAction createMoveDownAction() {
        return new MoveDownAction();
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new TableSelectionListener();
    }

    protected KeyColumnMappingsPanel.KeyColumnEventListener createKeyColumnEventListener() {
        return new KeyColumnEventListener();
    }

    protected WAdminTree_TableKeys.ForeignKeyEventListener createForeignKeyEventListener() {
        return new ForeignKeyListener();
    }

    protected void showForeignKeyPanel() {
        ForeignKey key;
        KeyColumnMappingsPanel panel;
        this.colsPanel.setVisible(false);
        if (this.foreignKeyPanelList.size() > 0) {
            for (int i = 0; i < this.foreignKeyPanelList.size(); ++i) {
                panel = (KeyColumnMappingsPanel)((Object)this.foreignKeyPanelList.get(i));
                panel.setVisible(false);
            }
        }
        if ((key = this.keyTree.getForeignKey()) == null) {
            return;
        }
        UniqueKey partnerKey = null;
        try {
            partnerKey = key.getPartnerUniqueKey();
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        boolean isFlip = false;
        if (this.keyTree.isTableForeignKey) {
            isFlip = true;
        }
        int index = 0;
        boolean isOldKey = false;
        int size = this.foreignKeyList.size();
        for (int i = 0; i < size; ++i) {
            ForeignKey oldKey = (ForeignKey)this.foreignKeyList.get(i);
            if (oldKey != key) continue;
            index = i;
            isOldKey = true;
            break;
        }
        if (isOldKey) {
            panel = (KeyColumnMappingsPanel)((Object)this.foreignKeyPanelList.get(index));
            panel.setVisible(true);
            return;
        }
        this.foreignKeyList.addElement(key);
        panel = new KeyColumnMappingsPanel(partnerKey, key, this.store, isFlip);
        panel.setEditable(this.isEditable());
        this.leftPanel.add((Component)((Object)panel), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        try {
            panel.doDataExchange(false);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.listenForDataChangesTo(panel);
        panel.addKeyColumnEventListener(this.createKeyColumnEventListener());
        this.leftPanel.repaint();
        this.leftPanel.revalidate();
        this.foreignKeyPanelList.addElement(panel);
    }

    public void doNewPrimaryKey() {
        this.primaryKey = this.createUniqueKey(true);
        this.keyTree.refresh();
        TreePath keyPath = new TreePath(this.treeModel.getPathToRoot((TreeNode)this.keyTree.getPrimaryKeyNode()));
        this.keyTree.setSelectionPath(keyPath);
        this.updateActions();
        this.setDataChanged(true);
    }

    public void doNewUniqueKey() {
        this.createUniqueKey(false);
        this.keyTree.refresh();
        WsTreeNode node = this.keyTree.getUniqueKeyFolderNode();
        if (node != null) {
            this.keyTree.expandPath(new TreePath(this.treeModel.getPathToRoot((TreeNode)node)));
            WsTreeNode newNode = (WsTreeNode)node.getLastChild();
            TreePath path = new TreePath(this.treeModel.getPathToRoot((TreeNode)newNode));
            this.keyTree.expandPath(path);
            this.keyTree.setSelectionPath(path);
        }
        this.updateActions();
        this.setDataChanged(true);
    }

    protected UniqueKey createUniqueKey(boolean isPrimary) {
        List columns = this.getSelectedTableColumns();
        UniqueKey uKey = null;
        try {
            String reposID = this.table.getRepositoryID();
            String tblName = ((PhysicalTable)this.table).getSASTableName();
            uKey = (UniqueKey)Workspace.getMdFactory().createComplexMetadataObject(this.store, null, tblName + "." + bundle.getString("Common.DefaultUniqueKey.txt"), "UniqueKey", reposID);
            uKey.setDesc(bundle.formatString("Common.DefalutUniqueKey.Descr.txt", (Object)tblName));
            uKey.setIsPrimary(0);
            uKey.getKeyedColumns().addAll((Collection)columns);
            uKey.setTable(this.table);
            if (isPrimary) {
                uKey.setName(tblName + "." + bundle.getString("Common.DefaultPrimaryKey.txt"));
                uKey.setIsPrimary(1);
                uKey.setDesc(bundle.formatString("Common.DefaultPrimaryKey.Descr.txt", (Object)tblName));
            } else {
                ++this.uniqueKeyCount;
                uKey.setName(uKey.getName() + Integer.toString(this.uniqueKeyCount));
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Creating");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return uKey;
    }

    public List getSelectedTableColumns() {
        Vector<Column> columns = new Vector<Column>();
        int[] aSelectedRows = this.colsTable.getSelectedRowsFromSelectedCells();
        int nSelectedRows = aSelectedRows.length;
        if (nSelectedRows > 0) {
            if (nSelectedRows == 1) {
                int rowSelected = aSelectedRows[0];
                int modelRow = this.colsTable.convertRowIndexToModel(rowSelected);
                Column col = (Column)this.colsModel.getValueAt(modelRow, 14);
                columns.add(col);
            } else {
                for (int i = 0; i < nSelectedRows; ++i) {
                    int modelRow = this.colsTable.convertRowIndexToModel(aSelectedRows[i]);
                    Column col = (Column)this.colsModel.getValueAt(modelRow, 14);
                    columns.add(col);
                }
            }
        }
        return columns;
    }

    public void setTreeSelection(WsTreeNode node) {
        this.leftPanel.requestFocus();
        TreePath path = new TreePath(this.treeModel.getPathToRoot((TreeNode)node));
        this.keyTree.expandPath(path);
        this.keyTree.setSelectionPath(path);
    }

    public void doNewForeignKey() {
        Workspace work = Workspace.getWorkspace();
        try {
            MdObjectStore childStore = Workspace.getMdFactory().createObjectStore((MdStore)this.store);
            CMetadata tabObject = Workspace.getMdFactory().createComplexMetadataObject(childStore, (MdStore)this.store, (CMetadata)this.table);
            NewForeignKeysWizard wizard = new NewForeignKeysWizard((JFrame)work, tabObject, childStore);
            wizard.show();
            if (wizard.getReturnValue() == 3 || wizard.getReturnValue() == 1) {
                this.keyTree.refresh();
                List newForeignKeys = wizard.getForeignKeys();
                this.keyTree.setSelectionMetadataObject((CMetadata)newForeignKeys.get(0));
                this.setDataChanged(true);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void doDelete() {
        WsTreeNode node = this.keyTree.getSelectedNode();
        int type = this.keyTree.getNodeType();
        CMetadata objUK = null;
        boolean setSelection = false;
        if (type == 4 || type == 5) {
            WsTreeNode parent = (WsTreeNode)node.getParent();
            objUK = parent.getMetadata();
            setSelection = true;
        }
        this.keyTree.onDelete();
        if (this.keyTree.getPrimaryKeyNode() == null) {
            this.primaryKey = null;
            this.updateActions();
        }
        if (setSelection && objUK != null) {
            this.keyTree.setSelectionMetadataObject(objUK);
        }
        this.setDataChanged(true);
    }

    public void layoutWidgets() {
        this.rightPanel.setLayout((LayoutManager)new GridBagLayout());
        this.rightPanel.add((Component)this.lblTree, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.treePane, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.colsPanel.setLayout((LayoutManager)new GridBagLayout());
        this.colsPanel.add((Component)this.lblColumns, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.colsPanel.add((Component)this.colsTablePane, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.colsPanel.add((Component)this.verticalButtonPanel, (Object)new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 3, new Insets(0, 5, 0, 5), 0, 0));
        this.leftPanel.setLayout((LayoutManager)new GridBagLayout());
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.leftPanel.add((Component)this.colsPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.horizontalButtonPanel, new GridBagConstraints(0, 1, 0, 0, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.newPrimaryKeyAction.setActive(bActive);
        this.newForeignKeyAction.setActive(bActive);
        this.newUniqueKeyAction.setActive(bActive);
        this.newAction.setActive(bActive);
        this.moveRightAction.setActive(bActive);
        this.moveLeftAction.setActive(bActive);
        this.moveUpAction.setActive(bActive);
        this.moveDownAction.setActive(bActive);
        this.keyTree.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.newButton.setEnabled(bEditable);
        this.keyTree.setEditable(bEditable);
        this.colsTable.setDragEnabled(bEditable);
        for (int i = 0; i < this.foreignKeyPanelList.size(); ++i) {
            KeyColumnMappingsPanel panel = (KeyColumnMappingsPanel)((Object)this.foreignKeyPanelList.get(i));
            panel.setEditable(bEditable);
        }
        this.updateActions();
    }

    protected void updateActions() {
        int[] aSelectedRows = this.colsTable.getSelectedRowsFromSelectedCells();
        WsTreeNode node = this.keyTree.getSelectedNode();
        boolean bEditable = this.isEditable();
        boolean bNotRoot = this.keyTree.getSelectedNode() != this.keyTree.nodeRoot;
        boolean bNodeSelected = this.keyTree.getSelectedNode() != null;
        boolean bUniqueColumnSelected = this.keyTree.isSelectedNodeUniqueKeyColumn();
        boolean bTableSelected = aSelectedRows.length > 0;
        boolean bNotFirst = bUniqueColumnSelected;
        boolean bNotLast = bUniqueColumnSelected;
        if (bUniqueColumnSelected) {
            if (this.keyTree.isFirstChild(node)) {
                bNotFirst = false;
            }
            if (this.keyTree.isLastChild(node)) {
                bNotLast = false;
            }
        }
        this.newAction.setEnabled(bEditable);
        this.deleteAction.setEnabled(bEditable && bNotRoot && bNodeSelected);
        this.newPrimaryKeyAction.setEnabled(bEditable && !this.primaryKeyExists());
        this.newForeignKeyAction.setEnabled(bEditable);
        this.newUniqueKeyAction.setEnabled(bEditable);
        this.moveUpAction.setEnabled(bEditable && bNotFirst);
        this.moveDownAction.setEnabled(bEditable && bNotLast);
        this.moveRightAction.setEnabled(bEditable && bTableSelected && this.keyTree.isValidNodeForAUniqueKeyColumnInsert());
        this.moveLeftAction.setEnabled(bEditable && bUniqueColumnSelected);
    }

    protected DragGestureListener createColumnsTableDragGestureListener() {
        return new cColumnsTableDragGestureListener();
    }

    protected DragSourceListener createColumnsTableDragSourceListener() {
        return new WsDragSourceAdapter();
    }

    protected Transferable createTransferableFromSelectedTableColumns() {
        int[] aRows = this.colsTable.getSelectedRowsFromSelectedCells();
        int nRows = aRows.length;
        if (nRows == 0) {
            return null;
        }
        DNDObject xferColumns = new DNDObject();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int iModelRow = this.colsTable.convertRowIndexToModel(aRows[iRow]);
            xferColumns.add(this.colsModel.getValueAt(iModelRow, 14));
        }
        return xferColumns;
    }

    public boolean primaryKeyExists() {
        return this.primaryKey != null;
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TableKeysPanel.this.colsPanel.setVisible(true);
            if (TableKeysPanel.this.keyTree.isSelectedNodeForeignKey()) {
                TableKeysPanel.this.showForeignKeyPanel();
            }
            TableKeysPanel.this.updateActions();
        }
    }

    protected class MyTreeChangesListener
    implements TreeModelListener {
        protected MyTreeChangesListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent tme) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent tme) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent tme) {
            if (TableKeysPanel.this.keyTree.getPrimaryKeyNode() == null) {
                TableKeysPanel.this.primaryKey = null;
            }
            TableKeysPanel.this.updateActions();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent tme) {
        }
    }

    protected class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "TableKeysPanel.New", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.doNewForeignKey();
        }
    }

    protected class NewPrimaryKeyAction
    extends WsAbstractAction {
        public NewPrimaryKeyAction() {
            super(bundle, "TableKeysPanel.PrimaryKey", false, false);
            this.setMenuSupportId("newprimarykey");
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.doNewPrimaryKey();
        }
    }

    protected class NewForeignKeyAction
    extends WsAbstractAction {
        public NewForeignKeyAction() {
            super(bundle, "TableKeysPanel.ForeignKey", false, false);
            this.putValue("Default", new Boolean(true));
            this.setMenuSupportId("newforeignkey");
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.doNewForeignKey();
        }
    }

    protected class NewUniqueKeyAction
    extends WsAbstractAction {
        public NewUniqueKeyAction() {
            super(bundle, "TableKeysPanel.UniqueKey", false, false);
            this.setMenuSupportId("newuniquekey");
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.doNewUniqueKey();
        }
    }

    protected class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "TableKeysPanel.Delete", true);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.doDelete();
        }
    }

    protected class MoveRightAction
    extends WsAbstractAction {
        public MoveRightAction() {
            super(bundle, "TableKeysPanel.MoveRight", true);
        }

        public void actionPerformed(ActionEvent e) {
            List columns = TableKeysPanel.this.getSelectedTableColumns();
            TableKeysPanel.this.keyTree.insertUKColumns(columns);
            TableKeysPanel.this.colsTable.getSelectionModel().clearSelection();
            TableKeysPanel.this.setDataChanged(true);
        }
    }

    protected class MoveLeftAction
    extends WsAbstractAction {
        public MoveLeftAction() {
            super(bundle, "TableKeysPanel.MoveLeft", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.keyTree.removeUKColumns();
            TableKeysPanel.this.setDataChanged(true);
        }
    }

    protected class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "TableKeysPanel.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.keyTree.onMoveUp();
            TableKeysPanel.this.setDataChanged(true);
        }
    }

    protected class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "TableKeysPanel.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            TableKeysPanel.this.keyTree.onMoveDown();
            TableKeysPanel.this.setDataChanged(true);
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            TableKeysPanel.this.updateActions();
        }
    }

    protected class KeyColumnEventListener
    implements KeyColumnMappingsPanel.KeyColumnEventListener {
        protected KeyColumnEventListener() {
        }

        @Override
        public void keyColumnAdded(KeyColumnMappingsPanel.KeyColumnEvent e) {
            WsTreeNode node = TableKeysPanel.this.keyTree.getSelectedNode();
            KeyColumnMappingsPanel panel = (KeyColumnMappingsPanel)((Object)e.getSource());
            try {
                boolean isValid = panel.validateData();
                if (isValid) {
                    panel.moveDataToStore();
                    TableKeysPanel.this.keyTree.refresh();
                    TableKeysPanel.this.setTreeSelection(node);
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Creating");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void keyColumnRemoved(KeyColumnMappingsPanel.KeyColumnEvent e) {
            WsTreeNode node = TableKeysPanel.this.keyTree.getSelectedNode();
            if (node instanceof WsDataTreeNode && ((WsDataTreeNode)node).getMetadata() instanceof Column) {
                node = (WsTreeNode)node.getParent();
            }
            KeyColumnMappingsPanel panel = (KeyColumnMappingsPanel)((Object)e.getSource());
            try {
                boolean isValid = panel.validateData();
                if (isValid) {
                    panel.moveDataToStore();
                    TableKeysPanel.this.keyTree.setSelectionMetadataObject((CMetadata)panel.getDeletedForeignKeyColumn());
                    TableKeysPanel.this.keyTree.onDelete();
                    TableKeysPanel.this.setTreeSelection(node);
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Creating");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        @Override
        public void keyColumnImported(KeyColumnMappingsPanel.KeyColumnEvent e) {
            try {
                TableKeysPanel.this.colsModel.moveDataToModel();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Creating");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    protected class ForeignKeyListener
    implements WAdminTree_TableKeys.ForeignKeyEventListener {
        protected ForeignKeyListener() {
        }

        @Override
        public void foreignKeyRemoved(WAdminTree_TableKeys.ForeignKeyEvent e) {
            for (int i = 0; i < TableKeysPanel.this.foreignKeyPanelList.size(); ++i) {
                TableKeysPanel.this.leftPanel.remove((Component)TableKeysPanel.this.foreignKeyPanelList.get(i));
            }
            TableKeysPanel.this.foreignKeyList.removeAllElements();
            TableKeysPanel.this.foreignKeyPanelList.removeAllElements();
        }
    }

    protected class cColumnsTableDragGestureListener
    implements DragGestureListener {
        protected cColumnsTableDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            if (!TableKeysPanel.this.isEditable()) {
                return;
            }
            InputEvent ie = e.getTriggerEvent();
            if (ie.isControlDown() || ie.isShiftDown() || ie.isAltDown()) {
                return;
            }
            Transferable xfer = TableKeysPanel.this.createTransferableFromSelectedTableColumns();
            if (xfer == null) {
                return;
            }
            e.getDragSource().startDrag(e, null, xfer, TableKeysPanel.this.createColumnsTableDragSourceListener());
        }
    }
}

