/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.visuals.DBMSLibraryConnectWizardTab;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SalesforceImporter
extends SASImporter
implements MultipleNodeInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(SalesforceImporter.class);
    private ArrayList m_NameList;
    private ArrayList m_ToolTipList;
    private ArrayList m_DescriptionsList;
    private ArrayList m_ImageIconList;

    @Override
    public void initPlugin() {
        this.m_LIBRARY_TAB = "SalesforceImportertab1";
        this.m_TABLES_TAB = "SalesforceImportertab2";
        String[][] standardTransitionList = new String[][]{{this.m_LIBRARY_TAB, "NEXT", this.m_TABLES_TAB}, {this.m_TABLES_TAB, "NEXT", "SASImportertab4"}};
        this.m_transitionList = standardTransitionList;
        this.m_name = bundle.getString("SalesforceImporter.pluginname.txt");
        this.m_icon = bundle.getImageIcon("DBMSImporter.SALESFORCE.image");
        this.m_tooltip = bundle.getString("SalesforceImporter.ToolTip.txt");
        this.buildNameList();
        this.buildTooltipList();
        this.buildIconList();
        this.buildDescriptionList();
    }

    public void buildDescriptionList() {
        this.m_DescriptionsList = new ArrayList();
        this.m_DescriptionsList.add(bundle.getString("SalesforceImporter.description.Salesforce.notrans"));
    }

    public void buildIconList() {
        this.m_ImageIconList = new ArrayList();
        this.m_ImageIconList.add(bundle.getImageIcon("DBMSImporter.SALESFORCE.image"));
    }

    public void buildNameList() {
        this.m_NameList = new ArrayList();
        String folderName = bundle.getString("SalesforceImporter.FolderName.DatabaseSources.txt") + ".";
        this.m_NameList.add(folderName + bundle.getString("SalesforceImporter.Name.Salesforce.txt"));
    }

    public void buildTooltipList() {
        this.m_ToolTipList = new ArrayList();
        this.m_ToolTipList.add(bundle.getString("SalesforceImporter.ToolTip.Salesforce.txt"));
    }

    @Override
    protected void createLibraryTab() {
        ImageIcon image = bundle.getImageIcon("SourceDesigner.ConnectInfo.image");
        this.m_libraryTab = new DBMSLibraryConnectWizardTab("SASIOSLF", bundle.getString("SalesforceConnectWizardTab.Description.txt"));
        this.m_libraryTab.setHelpTopic("salesforce_win");
        this.m_libraryTab.setEngineType("SASIOSLF");
        this.m_wizardDialog.addTab(bundle.getString("SalesforceConnectWizardTab.Title.txt"), this.m_LIBRARY_TAB, (WAPropertyTab)this.m_libraryTab, "wa_source_connectInfo.gif", (Icon)image, false);
    }

    @Override
    public String getDescription() {
        return bundle.getString("SalesforceImporter.description.txt");
    }

    @Override
    public String getCategory() {
        return bundle.getString("SalesforceImporter.FolderName.DatabaseSources.txt");
    }

    public ArrayList getDescriptions() {
        return this.m_DescriptionsList;
    }

    public ArrayList getIcons() {
        return this.m_ImageIconList;
    }

    public ArrayList getNames() {
        return this.m_NameList;
    }

    public ArrayList getToolTips() {
        return this.m_ToolTipList;
    }

    @Override
    public boolean isEngineSupported(String engineName) {
        return engineName.equalsIgnoreCase("SASIOSLF");
    }

    public void updateEngineName(WAWizardDialog wizardDialog) {
        String nodeName = (String)wizardDialog.getWizardData("SELECTEDNODE");
        if (nodeName.equalsIgnoreCase(bundle.getString("SalesforceImporter.Name.Salesforce.txt"))) {
            this.m_strEngine = bundle.getString("SalesforceImporter.description.Salesforce.notrans");
        }
        wizardDialog.addWizardData("ENGINETYPE", (Object)this.m_strEngine);
    }
}

