/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.wadmin.model.tree.TempLogicalObjectNode;
import com.sas.wadmin.visuals.SASLibnameDialog;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.VersionUtil;
import com.sas.workspace.tree.WsNodeFactory;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SASLibraryTreeNode
extends TempLogicalObjectNode {
    private static WAdminResource bundle = WAdminResource.getBundle(SASLibraryTreeNode.class);
    protected WsAbstractAction m_actDisplayLibname = this.createDisplayLibnameAction();
    protected SASLibrary m_SASLibrary;
    protected CMetadata m_oObject;

    public SASLibraryTreeNode(CMetadata oSASLibrary) {
        super(oSASLibrary);
        this.m_oObject = oSASLibrary;
    }

    public WsTreeNode createChild(CMetadata oMetadata) {
        WsDataTreeNode ptTreeNode = WorkspaceTree.createDataTreeNode((CMetadata)oMetadata, (String)"com.sas.wadmin.visuals.", (String)"TreeNode");
        ptTreeNode.setAllowsChildren(false);
        return ptTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidParentFor(CMetadata oMetadata) {
        try {
            if (!oMetadata.getCMetadataType().equals("PhysicalTable")) {
                return false;
            }
            if (!oMetadata.getRepositoryID().equals(this.getFQID().substring(0, 8))) {
                return false;
            }
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                CMetadata oDetail = factory.createComplexMetadataObject(store, oMetadata);
                String template = "<Templates><SASLibrary><DeployedComponents/></SASLibrary><DatabaseSchema><UsedByPackages/></DatabaseSchema></Templates>";
                Vector<String> complex = new Vector<String>();
                complex.add("TablePackage");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oDetail, null, complex, template, 12);
                AssociationList tablePackages = ((PhysicalTable)oDetail).getTablePackages();
                SASLibrary tablelib = LibraryUtil.findLibraryForTable((AssociationList)tablePackages);
                if (tablelib == null) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.getFQID().equals(tablelib.getFQID())) return false;
                boolean bl = true;
                return bl;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return false;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren() {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                AssociationList alTables;
                SASLibrary oDetail = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oMetadata.getName(), this.m_oMetadata.getCMetadataType(), this.m_oMetadata.getId());
                String mytemplate = "<Templates><DatabaseSchema><Tables/></DatabaseSchema></Templates>";
                Vector<String> mycomplex = new Vector<String>();
                mycomplex.add("UsingPackages");
                mycomplex.add("Tables");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oDetail, null, mycomplex, mytemplate, 268);
                if (oDetail.getIsDBMSLibname() == 1) {
                    AssociationList alPackages = oDetail.getUsingPackages();
                    if (alPackages.size() > 0) {
                        CMetadata oObject = (CMetadata)alPackages.get(0);
                        if (!oObject.getCMetadataType().equals("DatabaseSchema")) {
                            return;
                        }
                        alTables = ((DatabaseSchema)oObject).getTables();
                    } else {
                        alTables = null;
                    }
                } else {
                    alTables = oDetail.getTables();
                }
                if (alTables != null) {
                    WsNodeFactory factoryNodes = this.getTreeModel().getNodeFactory();
                    for (int i = 0; i < alTables.size(); ++i) {
                        Root oComplexTable = (Root)alTables.get(i);
                        if (!oComplexTable.getCMetadataType().equals("PhysicalTable") || !oComplexTable.getRepositoryID().equals(oDetail.getRepositoryID())) continue;
                        WsTreeNode node = factoryNodes.createObjectNode(oComplexTable, (WsTreeNode)this);
                        this.getTreeModel().addChild(node, (WsTreeNode)this);
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public JPopupMenu getPopupMenu(WAdminResource rBundle) {
        JPopupMenu menuPopup = super.getPopupMenu(rBundle);
        menuPopup.add(new JMenuItem((Action)this.m_actDisplayLibname));
        return menuPopup;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actDisplayLibname.setActive(bActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayLibname() {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        try {
            MdObjectStore store = factory.createObjectStore();
            CMetadata oDetail = Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oMetadata.getName(), this.m_oMetadata.getCMetadataType(), this.m_oMetadata.getId());
            try {
                String sOptions = "<TEMPLATES><PhysicalTable><Columns/><TablePackage/></PhysicalTable><SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary></TEMPLATES>";
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oDetail, null, null, sOptions, 24972);
                if (((SASLibrary)oDetail).getIsPreassigned() == 1) {
                    String preMessage = bundle.formatString("SASLibraryTreeNode.Preassigned.fmt", (Object)oDetail.getName());
                    String preTitle = bundle.getString("SASLibraryTreeNode.Preassigned.Title.txt");
                    MessageUtil.displayMessage((String)preMessage, (String)preTitle, (int)1);
                    return;
                }
                SASLibnameDialog sasLD = new SASLibnameDialog((SASLibrary)oDetail);
                sasLD.show();
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected WsAbstractAction createDisplayLibnameAction() {
        return new cDisplayLibnameAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WsOMAView onProperties() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            try {
                CMetadata oDetail = Workspace.getMdFactory().createComplexMetadataObject(store, this.m_oMetadata);
                String template = "<Templates><SASLibrary><UsingPrototype/></SASLibrary></Templates>";
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oDetail, null, null, template, 12);
                if (!PrototypeUtil.isPrototypeCompatible((Root)((Root)oDetail), (Component)Workspace.getWorkspace())) {
                    VersionUtil.displayPropertiesMessage((Window)Workspace.getWorkspace(), (String)bundle.getString("apptitle"));
                    WsOMAView wsOMAView = null;
                    return wsOMAView;
                }
                WsOMAView wsOMAView = super.onProperties();
                return wsOMAView;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return null;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    protected class cDisplayLibnameAction
    extends WsAbstractAction {
        public cDisplayLibnameAction() {
            super(bundle, "SASLibraryTreeNode.DisplayLibname");
            this.setMenuSupportId("displaylibname");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            SASLibraryTreeNode.this.onDisplayLibname();
        }
    }
}

