/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SASLibraryServerDialog
extends WAStandardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(SASLibraryServerDialog.class);

    public SASLibraryServerDialog(PhysicalTable metadata) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("SASLibraryServerDialog.Title.txt"), true);
        cSASLibraryServerPanel pnlSASLibrary = new cSASLibraryServerPanel(metadata);
        pnlSASLibrary.setPreferredSize(new Dimension(500, 200));
        this.setMainPanel(pnlSASLibrary);
        this.setEditable(false);
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("prep_display_library_server");
    }

    class cSASLibraryServerPanel
    extends WAPanel {
        protected PhysicalTable m_metadata;
        protected WATextArea m_serverName;
        protected JScrollPane m_serverScroll;
        protected WATextArea m_libraryName;
        protected WATextArea m_schemaName;
        protected AssociationList m_servers;
        protected String m_sLibname;
        protected SASLibrary m_lib;
        protected DatabaseSchema m_dbSchema;
        protected boolean m_isDBMSLibname = true;

        public cSASLibraryServerPanel(PhysicalTable metadata) {
            this.m_metadata = metadata;
            this.initialize();
            this.layoutWidgets();
        }

        public void initialize() {
            this.m_libraryName = new WATextArea();
            this.m_libraryName.setBehavior(1);
            this.m_libraryName.setAutoSelect(false);
            this.m_libraryName.setBorder((Border)new TitledBorder(new BevelBorder(1), bundle.getString("SASLibraryServerDialog.Library.Label.txt")));
            this.m_serverName = new WATextArea();
            this.m_serverName.setLineWrap(true);
            this.m_serverName.setWrapStyleWord(true);
            this.m_serverName.setBehavior(2);
            this.m_serverName.setAutoSelect(false);
            this.m_serverScroll = new JScrollPane((Component)this.m_serverName);
            this.m_serverScroll.setBorder(new TitledBorder(new BevelBorder(1), bundle.getString("SASLibraryServerDialog.AppServer.Label.txt")));
            this.m_schemaName = new WATextArea();
            this.m_schemaName.setBehavior(1);
            this.m_schemaName.setAutoSelect(false);
            this.m_schemaName.setBorder((Border)new TitledBorder(new BevelBorder(1), bundle.getString("SASLibraryServerDialog.Schema.Label.txt")));
            this.m_schemaName.setVisible(false);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_libraryName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add(this.m_serverScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this.m_schemaName, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        public void moveDataToView() throws RemoteException {
            if (this.m_lib != null) {
                this.m_libraryName.setText(this.m_lib.getName());
                if (this.m_lib.getIsDBMSLibname() == 1) {
                    this.m_schemaName.setVisible(true);
                }
            } else {
                this.m_libraryName.setText(bundle.getString("SASLibraryServerDialog.NoLibraryMessage.txt"));
            }
            if (this.m_dbSchema != null) {
                this.m_schemaName.setText(this.m_dbSchema.getName());
            } else {
                this.m_schemaName.setText(bundle.getString("SASLibraryServerDialog.NoSchemaMessage.txt"));
            }
            if (this.m_servers != null) {
                for (int i = 0; i < this.m_servers.size(); ++i) {
                    if (i > 0) {
                        this.m_serverName.append("\n");
                    }
                    DeployedComponent server = (DeployedComponent)this.m_servers.get(i);
                    this.m_serverName.append(server.getName());
                }
                if (this.m_servers.size() == 0) {
                    this.m_serverName.append(bundle.getString("SASLibraryServerDialog.NoServerMessage.txt"));
                }
            }
            this.m_serverName.setCaretPosition(0);
        }

        public void populateStore() throws MdException, RemoteException {
            this.m_lib = null;
            String template = "<Templates><SASLibrary><DeployedComponents/></SASLibrary><DatabaseSchema><UsedByPackages/></DatabaseSchema></Templates>";
            Vector<String> complex = new Vector<String>();
            complex.add("TablePackage");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_metadata, null, complex, template, 24588);
            AssociationList tablePackages = this.m_metadata.getTablePackages();
            this.m_lib = LibraryUtil.findLibraryForTable((AssociationList)tablePackages);
            if (this.m_lib != null && this.m_lib.getIsDBMSLibname() == 1) {
                for (int i = 0; i < tablePackages.size(); ++i) {
                    RelationalSchema tablePackage = (RelationalSchema)tablePackages.get(i);
                    if (!(tablePackage instanceof DatabaseSchema)) continue;
                    this.m_dbSchema = (DatabaseSchema)tablePackage;
                }
            }
            if (this.m_lib != null) {
                this.m_servers = this.m_lib.getDeployedComponents();
            }
        }

        public boolean validateData() {
            return true;
        }
    }
}

