/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Report;
import com.sas.metadata.remote.Text;
import com.sas.wadmin.visuals.SourceCodePanel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;

public class ReportPanel
extends WAPanel {
    protected JLabel m_lblReportType;
    protected WATextField m_tfReportType;
    protected SourceCodePanel m_pnlLocation;
    protected boolean m_bEditable = true;
    protected Report m_metadata;
    private static WAdminResource bundle = WAdminResource.getBundle(ReportPanel.class);

    public ReportPanel(Report inReport) {
        this();
        this.m_metadata = inReport;
    }

    public ReportPanel() {
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_lblReportType = new JLabel(bundle.getString("ReportPanel.lblReportType.txt"));
        this.m_lblReportType.setDisplayedMnemonic(bundle.getString("ReportPanel.lblReportType.mnem").charAt(0));
        this.m_lblReportType.setLabelFor((Component)this.m_tfReportType);
        this.m_tfReportType = new WATextField();
        this.m_tfReportType.getDocument().addUndoableEditListener(new DocUndoableEditListener());
        this.listenForDataChangesTo((JTextComponent)this.m_tfReportType);
        this.m_tfReportType.setToolTipText(bundle.getString("ReportPanel.tfReportType.ToolTip.txt"));
        this.m_pnlLocation = new SourceCodePanel();
    }

    protected void layoutWidgets() {
        WAPanel pnlBorder = new WAPanel();
        pnlBorder.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("ReportPanel.LocationBorder.txt")));
        pnlBorder.setLayout((LayoutManager)new GridBagLayout());
        pnlBorder.add((Component)((Object)this.m_pnlLocation), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblReportType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 5), 0, 0));
        this.add((Component)this.m_tfReportType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 10, 0), 0, 0));
        this.add((Component)pnlBorder, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return this.m_pnlLocation.validateData();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        try {
            if (saveToModel) {
                this.m_pnlLocation.doDataExchange(true);
                AssociationList alReportLocations = this.m_metadata.getReportLocations();
                alReportLocations.flushAll();
                Text mdText = this.m_pnlLocation.getTextObject();
                if (mdText != null) {
                    alReportLocations.add((Object)mdText);
                }
                alReportLocations.setState(16);
                this.m_metadata.setReportType(this.m_tfReportType.getText());
            } else {
                this.m_tfReportType.setText(this.m_metadata.getReportType());
                AssociationList al = this.m_metadata.getReportLocations();
                if (al.size() > 0) {
                    this.m_pnlLocation.setMetadataObject((CMetadata)((Text)al.get(0)));
                }
                this.m_pnlLocation.doDataExchange(false);
            }
            return true;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return false;
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tfReportType.setEditable(bEditable);
        this.m_pnlLocation.setEditable(bEditable);
        this.m_bEditable = bEditable;
    }

    public void setMetadataObject(Report inReport) {
        this.m_metadata = inReport;
    }

    public String getReportType() {
        return this.m_tfReportType.getText();
    }

    public String getReportObjectType() {
        return this.m_pnlLocation.getSourceType();
    }

    public String getReportObjectInfo() {
        boolean FileSourceType = true;
        int SASSourceType = 2;
        int MetaSourceType = 3;
        String strInfo = bundle.getString("ReportPanel.LocationInfo.txt") + "\n     ";
        int iSourceType = this.m_pnlLocation.getSourceTypeEnum();
        if (iSourceType == 1) {
            strInfo = strInfo + bundle.getString("RemoteFilePanel.lblPath.txt") + "  " + this.m_pnlLocation.getPath();
        } else if (iSourceType == 2) {
            strInfo = strInfo + bundle.getString("SourceCodePanel.lblHost.txt") + "  " + this.m_pnlLocation.getSASHostLoc() + "\n     " + bundle.getString("SourceCodePanel.lblLibrary.txt") + "  " + this.m_pnlLocation.getLibrary() + "\n     " + bundle.getString("SourceCodePanel.lblCatalog.txt") + "  " + this.m_pnlLocation.getCatalog() + "\n     " + bundle.getString("SourceCodePanel.lblCatEntry.txt") + "  " + this.m_pnlLocation.getCatEntry();
        } else if (iSourceType == 3) {
            strInfo = strInfo + bundle.getString("SourceCodePanel.lblName.txt") + "  " + this.m_pnlLocation.getMetaName() + "\n     " + bundle.getString("SourceCodePanel.lblDesc.txt") + "  " + this.m_pnlLocation.getMetaDesc();
        }
        return strInfo;
    }

    class DocUndoableEditListener
    implements UndoableEditListener {
        DocUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            ReportPanel.this.getWAUndoManager().addEdit(e.getEdit());
        }
    }
}

