/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.omg.CORBA.StringHolder;

public class RemoteFilePanel
extends WAPanel {
    protected JLabel m_lblHost;
    protected WAComboBox m_cmbHost;
    protected JButton m_btnDefine;
    protected JLabel m_lblPath;
    protected WATextField m_tfPath;
    protected JButton m_btnBrowse;
    protected File m_mdFile;
    protected MdObjectStore m_mdStore;
    protected HashMap m_hmServerContexts;
    protected boolean m_bAppServerDefined;
    protected boolean m_bCreateMDFileObject = false;
    protected boolean m_bPnlEditable = true;
    protected boolean m_bPnlEnabled = true;
    protected RemoteFilePanel m_pnlThis;
    protected LinkedHashMap fileTypes;
    private static WAdminResource bundle = WAdminResource.getBundle(RemoteFilePanel.class);
    private boolean m_bCheckRemoteFileLineLength = false;

    public RemoteFilePanel() {
        this.initialize();
        this.layoutWidgets();
        this.m_pnlThis = this;
    }

    public RemoteFilePanel(MdObjectStore mdStore) {
        this();
        this.m_mdStore = mdStore;
    }

    public RemoteFilePanel(File mdFile) {
        this();
        this.m_mdFile = mdFile;
    }

    protected void initialize() {
        this.m_lblHost = new JLabel();
        this.m_cmbHost = new WAComboBox();
        this.m_btnDefine = new JButton();
        this.m_lblPath = new JLabel();
        this.m_tfPath = new WATextField();
        this.m_btnBrowse = new JButton();
        this.m_lblHost.setText(bundle.getString("RemoteFilePanel.lblHost.txt"));
        this.m_btnDefine.setText(bundle.getString("RemoteFilePanel.btnDefine.txt"));
        this.m_lblPath.setText(bundle.getString("RemoteFilePanel.lblPath.txt"));
        this.m_btnBrowse.setText(bundle.getString("RemoteFilePanel.btnBrowse.txt"));
        this.m_lblHost.setDisplayedMnemonic(bundle.getString("RemoteFilePanel.lblHost.mnem").charAt(0));
        this.m_btnDefine.setMnemonic(bundle.getString("RemoteFilePanel.btnDefine.mnem").charAt(0));
        this.m_lblPath.setDisplayedMnemonic(bundle.getString("RemoteFilePanel.lblPath.mnem").charAt(0));
        this.m_btnBrowse.setMnemonic(bundle.getString("RemoteFilePanel.btnBrowse.mnem").charAt(0));
        this.m_cmbHost.setToolTipText(bundle.getString("RemoteFilePanel.cmbHost.ToolTip.txt"));
        this.m_btnDefine.setToolTipText(bundle.getString("RemoteFilePanel.btnDefine.ToolTip.txt"));
        this.m_tfPath.setToolTipText(bundle.getString("RemoteFilePanel.tfPath.ToolTip.txt"));
        this.m_btnBrowse.setToolTipText(bundle.getString("RemoteFilePanel.btnBrowse.ToolTip.txt"));
        this.m_lblHost.setLabelFor((Component)this.m_cmbHost);
        this.m_lblPath.setLabelFor((Component)this.m_tfPath);
        this.m_tfPath.setMaxCharacters(256);
        this.listenForDataChangesTo((JComboBox)this.m_cmbHost);
        this.listenForDataChangesTo((JTextComponent)this.m_tfPath);
        this.m_btnDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppServer appServer = new AppServer();
                AppServerDialog dlgAppServer = new AppServerDialog((Frame)Workspace.getWorkspace(), appServer, bundle.getString("RemoteFilePanel.AppServer.Info.txt"));
                dlgAppServer.show();
                if (dlgAppServer.getReturnValue() == 1) {
                    RemoteFilePanel.this.populateHosts();
                    try {
                        RemoteFilePanel.this.m_cmbHost.setSelectedItem((Object)appServer.getServerContext().getName());
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                }
            }
        });
        this.m_btnBrowse.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteFilePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ServerContext mdSC = (ServerContext)RemoteFilePanel.this.m_hmServerContexts.get(RemoteFilePanel.this.m_cmbHost.getSelectedItem());
                WsAppServer appServer = WsAppServer.createAppServer((ServerContext)mdSC);
                try {
                    appServer.open();
                    if (!appServer.isFileBrowseEnabled()) {
                        return;
                    }
                    IWorkspace iworkspace = appServer.getWorkspace();
                    RemoteFilePanel.this.setCursor(Cursor.getDefaultCursor());
                    if (RemoteFilePanel.this.fileTypes == null) {
                        RemoteFilePanel.this.fileTypes = new LinkedHashMap();
                        RemoteFilePanel.this.fileTypes.put(bundle.getString("RemoteFilePanel.SASFileTypes.txt"), bundle.getString("RemoteFilePanel.SASFileExtension.notrans"));
                        RemoteFilePanel.this.fileTypes.put(bundle.getString("RemoteFilePanel.AllFileTypes.txt"), "*");
                    }
                    IFileServiceSelectorPanel pnlSelector = new IFileServiceSelectorPanel("", iworkspace, (Map)RemoteFilePanel.this.fileTypes, false);
                    ArrayList alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)WorkspaceUtil.getParentFrame((Component)((Object)RemoteFilePanel.this.m_pnlThis)), (String)bundle.getString("RemoteFilePanel.RemoteFileSelector.Title.txt"), (boolean)true, (int)0, (String)"", (IWorkspace)iworkspace, (boolean)true, (boolean)false, (IFileServiceSelectorPanel)pnlSelector);
                    if (alFileList != null && alFileList.size() > 0) {
                        RemoteFilePanel.this.m_tfPath.setText((String)alFileList.get(0));
                    }
                }
                catch (WsAppServerFailException ex) {
                    MessageUtil.displayMessage((String)bundle.formatString("RemoteFilePanel.AppServer.Error.txt", (Object)ex.getLocalizedMessage()), (int)0);
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                }
                finally {
                    RemoteFilePanel.this.setCursor(Cursor.getDefaultCursor());
                    appServer.dispose();
                }
            }
        });
        this.m_btnDefine.setEnabled(false);
    }

    public void setCheckRemoteFileLineLength(boolean value) {
        this.m_bCheckRemoteFileLineLength = value;
    }

    public boolean getCheckRemoteFileLineLength() {
        return this.m_bCheckRemoteFileLineLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFileLineLengths() {
        boolean valid = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        ServerContext mdSC = (ServerContext)this.m_hmServerContexts.get(this.m_cmbHost.getSelectedItem());
        WsAppServer appServer = WsAppServer.createAppServer((ServerContext)mdSC);
        ITextStream ts = null;
        try {
            appServer.open();
            IWorkspace iWorkspace = appServer.getWorkspace();
            iWorkspace = appServer.getWorkspace();
            IFileService rio = iWorkspace.FileService();
            IFileref fr = rio.AssignFileref("TempFileRef", "DISK", this.m_tfPath.getText(), "", new StringHolder("test"));
            ts = fr.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, Short.MAX_VALUE);
            LongSeqHolder lg = new LongSeqHolder();
            StringSeqHolder st = new StringSeqHolder();
            boolean loop = true;
            block11: while (loop) {
                ts.ReadLines(10000, lg, st);
                if (st.value.length < 10000) {
                    loop = false;
                }
                for (int i = 0; i < st.value.length; ++i) {
                    if (st.value[i].length() <= 255) continue;
                    SASCodeGeneration.displayLineLengthMessage((String)st.value[i], (int)(i + 1), (String)this.m_tfPath.getText());
                    valid = false;
                    continue block11;
                }
            }
        }
        catch (Exception ex) {
            MessageUtil.displayMessage((String)bundle.formatString("RemoteFilePanel.AppServer.Error.txt", (Object)ex.getLocalizedMessage()), (int)0);
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            valid = false;
        }
        finally {
            try {
                if (ts != null) {
                    ts.Close();
                }
            }
            catch (GenericError genericError) {}
            appServer.dispose();
        }
        this.setCursor(Cursor.getDefaultCursor());
        return valid;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.m_lblPath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_tfPath, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new WAPanel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        String strErrMsg = null;
        if (!this.m_bAppServerDefined) {
            this.m_cmbHost.requestFocus();
            strErrMsg = bundle.getString("RemoteFilePanel.NoAppServer.Error.txt");
        } else if (this.m_tfPath.getText().trim().length() == 0) {
            this.m_tfPath.requestFocus();
            strErrMsg = bundle.getString("RemoteFilePanel.tfPath.Error.txt");
        } else {
            if (this.m_bCheckRemoteFileLineLength) {
                return this.checkFileLineLengths();
            }
            return true;
        }
        if (strErrMsg != null) {
            MessageUtil.displayMessage((String)strErrMsg, (int)0);
        }
        return false;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            if (this.m_mdStore != null && this.m_bCreateMDFileObject) {
                if (this.m_mdFile == null) {
                    String strReposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                    strReposID = strReposID.substring(strReposID.indexOf(".") + 1);
                    this.m_mdFile = (File)Workspace.getMdFactory().createComplexMetadataObject(this.m_mdStore, null, "File", "File", strReposID, null);
                }
                this.m_mdFile.setFileName(this.getPath());
                this.m_mdFile.setIsARelativeName(0);
                AssociationList alDepComps = this.m_mdFile.getDeployedComponents();
                alDepComps.flushAll();
                alDepComps.add(this.m_hmServerContexts.get(this.m_cmbHost.getSelectedItem()));
                alDepComps.setState(16);
            }
        } else {
            if (this.m_mdStore == null) {
                this.m_mdStore = this.m_mdFile != null ? (MdObjectStore)this.m_mdFile.getObjectStore() : Workspace.getMdFactory().createObjectStore();
            }
            this.populateHosts();
            if (this.m_mdFile != null) {
                DeployedComponent dc;
                AssociationList alDepComps = this.m_mdFile.getDeployedComponents();
                if (alDepComps.size() > 0 && this.m_cmbHost.getIndexOf((Object)(dc = (DeployedComponent)alDepComps.get(0)).getName()) >= 0) {
                    this.m_cmbHost.setSelectedItem((Object)dc.getName());
                }
                this.m_tfPath.setText(this.m_mdFile.getFileName());
            }
        }
        this.setDataChanged(false);
        this.getWAUndoManager().discardAllEdits();
        return true;
    }

    protected void populateHosts() {
        this.m_cmbHost.removeAllItems();
        try {
            boolean bGoToServer = this.m_mdStore.getIsGoToServerForMetadata();
            this.m_mdStore.setIsGotToServerForMetadata(true);
            List vecServerContexts = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_mdStore, Workspace.getWorkspace().getDefaultRepository().getFQID(), "ServerContext", 8460, "");
            this.m_mdStore.setIsGotToServerForMetadata(bGoToServer);
            this.m_hmServerContexts = new HashMap();
            if (vecServerContexts.size() > 0) {
                String strDefaultSCID = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default");
                int iSize = vecServerContexts.size();
                for (int i = 0; i < iSize; ++i) {
                    ServerContext mdSC = (ServerContext)vecServerContexts.get(i);
                    String strSCName = mdSC.getName();
                    this.m_cmbHost.addItem((Object)strSCName);
                    this.m_hmServerContexts.put(strSCName, mdSC);
                    if (strDefaultSCID == null || mdSC.getFQID().compareTo(strDefaultSCID) != 0) continue;
                    this.m_cmbHost.setSelectedItem((Object)strSCName);
                }
            } else {
                throw new Exception();
            }
            this.m_bAppServerDefined = true;
            this.m_cmbHost.setEnabled(true);
            this.m_tfPath.setEnabled(true);
            this.m_btnBrowse.setEnabled(true);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.m_cmbHost.addItem((Object)bundle.getString("RemoteFilePanel.cmbHost.NoAppServer.txt"));
            this.m_bAppServerDefined = false;
            this.m_cmbHost.setEnabled(false);
            this.m_tfPath.setEnabled(false);
            this.m_btnBrowse.setEnabled(false);
        }
    }

    public void setInfoForDefine(String sKey) {
        this.m_btnDefine.setText(bundle.getString(sKey + ".txt"));
        this.m_btnDefine.setMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        this.m_btnDefine.setToolTipText(bundle.getString(sKey + ".ToolTip.txt"));
    }

    public void setInfoForHost(String sKey) {
        this.m_lblHost.setText(bundle.getString(sKey + ".txt"));
        this.m_lblHost.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
    }

    public void setInfoForPath(String sKey) {
        this.m_lblPath.setText(bundle.getString(sKey + ".txt"));
        this.m_lblPath.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
    }

    public void setInfoForBrowse(String sKey) {
        this.m_btnBrowse.setText(bundle.getString(sKey + ".txt"));
        this.m_btnBrowse.setMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        this.m_btnBrowse.setToolTipText(bundle.getString(sKey + ".ToolTip.txt"));
    }

    public void refreshHosts() {
        String strSelectedItem = (String)this.m_cmbHost.getSelectedItem();
        this.populateHosts();
        this.m_cmbHost.setSelectedItem((Object)strSelectedItem);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_bPnlEditable = bEditable;
        this.m_cmbHost.setEnabled(bEditable && this.m_bPnlEnabled && this.m_bAppServerDefined);
        this.m_tfPath.setEditable(bEditable);
        this.m_btnBrowse.setEnabled(bEditable && this.m_bPnlEnabled && this.m_bAppServerDefined);
    }

    public void setEnabled(boolean bEnabled) {
        this.m_bPnlEnabled = bEnabled;
        this.m_lblHost.setEnabled(bEnabled && this.m_bAppServerDefined);
        this.m_cmbHost.setEnabled(bEnabled && this.m_bAppServerDefined && this.m_bPnlEditable);
        this.m_lblPath.setEnabled(bEnabled && this.m_bAppServerDefined);
        this.m_tfPath.setEnabled(bEnabled && this.m_bAppServerDefined);
        this.m_tfPath.setEditable(bEnabled && this.m_bAppServerDefined);
        this.m_btnBrowse.setEnabled(bEnabled && this.m_bAppServerDefined && this.m_bPnlEditable);
    }

    public void setMetadataObject(File mdFile) {
        this.m_mdFile = mdFile;
        try {
            this.m_mdStore = (MdObjectStore)this.m_mdFile.getObjectStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setMetadataStore(MdObjectStore mdStore) {
        this.m_mdStore = mdStore;
    }

    public void setCreateMDFileObject(boolean bCreateMDFileObject) {
        this.m_bCreateMDFileObject = bCreateMDFileObject;
    }

    public ServerContext getServerContext() {
        return (ServerContext)this.m_hmServerContexts.get(this.m_cmbHost.getSelectedItem());
    }

    public String getPath() {
        return this.m_tfPath.getText().trim();
    }

    public File getFileObject() {
        return this.m_mdFile;
    }

    public void setFileTypes(LinkedHashMap types) {
        this.fileTypes = types;
    }
}

