/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.other.IServer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.wadmin.visuals.SASParallelMaximumConcurrentProcessesPanel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class ParallelOptionsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ParallelOptionsPanel.class);
    private JCheckBox m_ckbExecuteParallel;
    private JLabel m_lblLogOutputLocation;
    private WATextField m_txtLogOutputLocation;
    private JButton m_butLogOutputLocation;
    private JLabel m_lblApplication;
    private WAComboBox m_cmbApplication;
    private JLabel m_lblWorkload;
    private WAComboBox m_cmbWorkload;
    private JCheckBox m_ckbWaitfor;
    private SASParallelMaximumConcurrentProcessesPanel m_pnlMaxCurrentProcs;
    private JLabel m_lblAdditionalOptions;
    private WATextField m_txtAdditionalOptions;
    private JLabel m_lblSignonRetries;
    private WAIntTextField m_txtSignonRetries;
    private JLabel m_lblGridSuppJobOptions;
    private WATextField m_txtGridSuppJobOptions;
    private JCheckBox m_ckbUnknownStatusError;
    public static final int DEFAULT_SIGNON_RETRIES = 3;
    public static final boolean EXECUTE_PARALLEL_DEFAULT = false;
    public static final boolean SIGNOFF_DEFAULT = true;
    public static final boolean WAITFOR_DEFAULT = true;
    public static final boolean UNKNOWN_STATUS_ERROR_DEFAULT = false;
    public static final String NONE = bundle.getString("Common.None.txt");
    public static final String SELECT = bundle.getString("Common.Select.txt");
    private IServer m_server;
    private boolean m_bShowOnlySubmitToGridOptions = false;
    private WsAbstractAction m_lstnComponent;
    private PropertyChangeListener m_lstnPanel;
    public static String EXECUTE_PARALLEL_CHANGED = "ExecuteParallelChanged";
    public static String APPLICATION_CHANGED = "ApplicationChanged";
    public static String WORKLOAD_CHANGED = "WorkloadChanged";
    public static String WAIT_FOR_CHANGED = "WaitForCompletionChanged";
    public static String UNKNOWN_STATUS_IS_ERROR_CHANGED = "UnknownStatusIsErrorChanged";

    public ParallelOptionsPanel(IServer server, String helpTopic) {
        this(server, helpTopic, false);
    }

    public ParallelOptionsPanel(String helpTopic) {
        this(null, helpTopic);
    }

    public ParallelOptionsPanel(String helpTopic, boolean showOnlySubmitToGridOptions) {
        this(null, helpTopic, showOnlySubmitToGridOptions);
    }

    public ParallelOptionsPanel(IServer server, String helpTopic, boolean showOnlySubmitToGridOptions) {
        this.m_bShowOnlySubmitToGridOptions = showOnlySubmitToGridOptions;
        this.m_server = server;
        this.setHelpTopic(helpTopic);
        this.createListeners();
        this.initialize();
    }

    protected void createListeners() {
        this.m_lstnComponent = new cExecuteParallelAction();
        this.m_lstnPanel = new PanelPropertyListener();
    }

    protected void initialize() {
        this.m_ckbExecuteParallel = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ParallelOptionsPanel.ExecuteParallel");
        this.m_ckbExecuteParallel.addActionListener((ActionListener)this.m_lstnComponent);
        this.listenForDataChangesTo(this.m_ckbExecuteParallel);
        this.m_txtLogOutputLocation = new WATextField();
        this.m_lblLogOutputLocation = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtLogOutputLocation, (WAdminResource)bundle, (String)"ParallelOptionsPanel.LogOutputLocation");
        this.m_butLogOutputLocation = WsUIUtilities.createTextButton((WsAbstractAction)new cBrowseAction());
        this.listenForDataChangesTo((JTextComponent)this.m_txtLogOutputLocation);
        this.m_cmbApplication = new WAComboBox();
        this.m_cmbApplication.setSorted(false);
        this.m_cmbApplication.setEditable(false);
        this.m_lblApplication = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbApplication, (WAdminResource)bundle, (String)"ParallelOptionsPanel.Application");
        this.m_cmbApplication.addActionListener((ActionListener)this.m_lstnComponent);
        this.listenForDataChangesTo((JComboBox)this.m_cmbApplication);
        this.m_cmbWorkload = new WAComboBox();
        this.m_cmbWorkload.setSorted(true);
        this.m_cmbWorkload.setEditable(false);
        this.m_lblWorkload = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbWorkload, (WAdminResource)bundle, (String)"ParallelOptionsPanel.Workload");
        this.m_cmbWorkload.addActionListener((ActionListener)this.m_lstnComponent);
        this.listenForDataChangesTo((JComboBox)this.m_cmbWorkload);
        this.m_ckbWaitfor = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ParallelOptionsPanel.Waitfor");
        this.m_ckbWaitfor.addActionListener((ActionListener)this.m_lstnComponent);
        this.listenForDataChangesTo(this.m_ckbWaitfor);
        this.m_txtAdditionalOptions = new WATextField();
        this.m_lblAdditionalOptions = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtAdditionalOptions, (WAdminResource)bundle, (String)"ParallelOptionsPanel.AdditionalSignonOptions");
        this.listenForDataChangesTo((JTextComponent)this.m_txtAdditionalOptions);
        this.m_txtSignonRetries = new WAIntTextField(false);
        this.m_lblSignonRetries = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtSignonRetries, (WAdminResource)bundle, (String)"ParallelOptionsPanel.SignonRetries");
        this.m_txtSignonRetries.setColumns(10);
        this.m_txtSignonRetries.setMinimumSize(this.m_txtSignonRetries.getPreferredSize());
        this.listenForDataChangesTo((JTextComponent)this.m_txtSignonRetries);
        this.m_txtGridSuppJobOptions = new WATextField();
        this.m_lblGridSuppJobOptions = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtGridSuppJobOptions, (WAdminResource)bundle, (String)"ParallelOptionsPanel.GridSuppJobOptions");
        this.listenForDataChangesTo((JTextComponent)this.m_txtGridSuppJobOptions);
        this.m_ckbUnknownStatusError = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ParallelOptionsPanel.UnknownStatusError");
        this.m_ckbUnknownStatusError.addActionListener((ActionListener)this.m_lstnComponent);
        this.listenForDataChangesTo(this.m_ckbUnknownStatusError);
        this.m_pnlMaxCurrentProcs = new SASParallelMaximumConcurrentProcessesPanel(bundle.getString("ParallelOptionsPanel.MaximumProcs.Title.txt"));
        this.m_pnlMaxCurrentProcs.addPropertyChangeListener(this.m_lstnPanel);
        this.listenForDataChangesTo(this.m_pnlMaxCurrentProcs);
        this.setLayout(new GridBagLayout());
        if (!this.m_bShowOnlySubmitToGridOptions) {
            this.add(this.m_ckbExecuteParallel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add(this.m_lblLogOutputLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_txtLogOutputLocation, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.add(this.m_butLogOutputLocation, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        }
        this.add(this.m_lblApplication, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbApplication, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblWorkload, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbWorkload, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        if (!this.m_bShowOnlySubmitToGridOptions) {
            this.add(this.m_ckbWaitfor, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)((Object)this.m_pnlMaxCurrentProcs), new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.add(this.m_lblAdditionalOptions, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtAdditionalOptions, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_lblSignonRetries, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtSignonRetries, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        if (!this.m_bShowOnlySubmitToGridOptions) {
            this.add(this.m_lblGridSuppJobOptions, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)this.m_txtGridSuppJobOptions, new GridBagConstraints(1, 8, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        }
        if (!this.m_bShowOnlySubmitToGridOptions) {
            this.add(this.m_ckbUnknownStatusError, new GridBagConstraints(0, 9, 3, 1, 0.0, 1.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
    }

    private IServer getDefaultServer(IModel model) throws MdException, RemoteException {
        IServer server = null;
        String defaultServerId = WsAppServer.getDefaultAppServerFQID();
        ServerContextInterface logicalServer = WsAppServer.findAppServer((String)defaultServerId);
        if (logicalServer != null) {
            server = ModelUIUtilities.getServerForAppServer(model, defaultServerId);
        }
        return server;
    }

    public void setServer(IServer server) {
        if (this.m_server == server) {
            return;
        }
        this.m_server = server;
        try {
            this.updateGridOptionsSetList(this.m_server);
            this.updateWorkloadList(this.m_server);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGridOptionsSetList(IServer server) throws MdException, RemoteException {
        boolean disposeModel = false;
        BaseModel mdl = null;
        try {
            ArrayList aGAO1;
            if (server == null) {
                disposeModel = true;
                mdl = new BaseModel();
                mdl.setDebugName("grid options set update");
                server = this.getDefaultServer((IModel)mdl);
            }
            ArrayList aGAO = new ArrayList();
            if (server != null && server.getGridServer() != null && (aGAO1 = new ArrayList(server.getGridServer().getGridOptionSets())).size() > 0) {
                Collections.sort(aGAO1);
                aGAO.addAll(aGAO1);
            }
            aGAO.add(0, NONE);
            String gao = (String)this.m_cmbApplication.getSelectedItem();
            if (gao == null) {
                gao = NONE;
            }
            this.m_cmbApplication.removeAllItems();
            for (int i = 0; i < aGAO.size(); ++i) {
                this.m_cmbApplication.addItem(aGAO.get(i));
            }
            this.m_cmbApplication.setSelectedItem((Object)gao);
        }
        finally {
            if (disposeModel && mdl != null) {
                mdl.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWorkloadList(IServer server) throws MdException, RemoteException {
        boolean disposeModel = false;
        BaseModel mdl = null;
        try {
            if (server == null) {
                disposeModel = true;
                mdl = new BaseModel();
                mdl.setDebugName("workload update");
                server = this.getDefaultServer((IModel)mdl);
            }
            ArrayList<String> workloads = new ArrayList<String>();
            if (server != null && server.getGridServer() != null) {
                workloads.addAll(server.getGridServer().getWorkloads());
            }
            workloads.add(0, NONE);
            String workload = (String)this.m_cmbWorkload.getSelectedItem();
            if ("".equals(workload) || !workloads.contains(workload)) {
                workload = NONE;
            }
            this.m_cmbWorkload.removeAllItems();
            for (int i = 0; i < workloads.size(); ++i) {
                this.m_cmbWorkload.addItem(workloads.get(i));
            }
            this.m_cmbWorkload.setSelectedItem((Object)workload);
        }
        finally {
            if (disposeModel && mdl != null) {
                mdl.dispose();
            }
        }
    }

    public void setExecuteParallel(boolean parallel) {
        boolean sel = this.m_ckbExecuteParallel.isSelected();
        if (sel == parallel) {
            return;
        }
        this.m_ckbExecuteParallel.setSelected(parallel);
        this.updateExecuteParallel();
    }

    public void setExecuteParallelAndDisableChange() {
        this.m_ckbExecuteParallel.setSelected(true);
        this.m_ckbExecuteParallel.setEnabled(false);
        this.m_ckbExecuteParallel.setVisible(false);
        this.m_ckbUnknownStatusError.setVisible(false);
        this.add((Component)new WAPanel(), new GridBagConstraints(0, 9, 3, 1, 0.0, 1.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void updateExecuteParallel() {
        this.setEditable(this.isEditable());
        this.firePropertyChange(EXECUTE_PARALLEL_CHANGED, !this.m_ckbExecuteParallel.isSelected(), this.m_ckbExecuteParallel.isSelected());
    }

    public boolean getExecuteParallel() {
        return this.m_ckbExecuteParallel.isSelected();
    }

    public void setLogOutputLocation(String logOutput) {
        this.m_txtLogOutputLocation.setText(logOutput);
    }

    public String getLogOutputLocation() {
        return this.m_txtLogOutputLocation.getText();
    }

    public void setApplication(String newApplication) {
        String application = (String)this.m_cmbApplication.getSelectedItem();
        if (newApplication.equals(application)) {
            return;
        }
        if ("".equals(newApplication)) {
            newApplication = NONE;
        }
        this.m_cmbApplication.setSelectedItem((Object)newApplication);
        this.firePropertyChange(APPLICATION_CHANGED, "", this.m_cmbApplication.getSelectedItem());
    }

    public String getApplication() {
        String application = (String)this.m_cmbApplication.getSelectedItem();
        if (NONE.equals(application)) {
            application = "";
        }
        return application;
    }

    public void setWorkload(String newWorkload) {
        String workload = (String)this.m_cmbWorkload.getSelectedItem();
        if (newWorkload.equals(workload)) {
            return;
        }
        if ("".equals(newWorkload)) {
            newWorkload = NONE;
        }
        this.m_cmbWorkload.setSelectedItem((Object)newWorkload);
        this.firePropertyChange(WORKLOAD_CHANGED, "", this.m_cmbWorkload.getSelectedItem());
    }

    public String getWorkload() {
        String workload = (String)this.m_cmbWorkload.getSelectedItem();
        if (NONE.equals(workload)) {
            workload = "";
        }
        return workload;
    }

    public void setWaitForWhenComplete(boolean wait) {
        boolean oldValue = this.m_ckbWaitfor.isSelected();
        if (oldValue == wait) {
            return;
        }
        this.m_ckbWaitfor.setSelected(wait);
        this.firePropertyChange(WAIT_FOR_CHANGED, !wait, wait);
    }

    public boolean getWaitForWhenComplete() {
        return this.m_ckbWaitfor.isSelected();
    }

    public void setMaximumConcurrentSetting(String max) {
        this.m_pnlMaxCurrentProcs.setMaximumConcurrentSetting(max);
    }

    public String getMaximumConcurrentSetting() {
        return this.m_pnlMaxCurrentProcs.getMaximumConcurrentSetting();
    }

    public void setAdditionalSignonOptions(String add) {
        this.m_txtAdditionalOptions.setText(add);
    }

    public String getAdditionalSignonOptions() {
        return this.m_txtAdditionalOptions.getText();
    }

    public void setSignonRetries(int count) {
        this.m_txtSignonRetries.setValue(count);
    }

    public int getSignonRetries() {
        return this.m_txtSignonRetries.getValue();
    }

    public void setGridSuppJobOptions(String add) {
        this.m_txtGridSuppJobOptions.setText(add);
    }

    public String getGridSuppJobOptions() {
        return this.m_txtGridSuppJobOptions.getText();
    }

    public void setUnknownStatusAsError(boolean error) {
        boolean oldValue = this.m_ckbUnknownStatusError.isSelected();
        if (oldValue == error) {
            return;
        }
        this.m_ckbUnknownStatusError.setSelected(error);
        this.firePropertyChange(UNKNOWN_STATUS_IS_ERROR_CHANGED, !error, error);
    }

    public boolean getUnknownStatusAsError() {
        return this.m_ckbUnknownStatusError.isSelected();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.updateGridOptionsSetList(this.m_server);
        this.updateWorkloadList(this.m_server);
        this.setEditable(this.isEditable());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public boolean validateData() {
        if (!this.m_bShowOnlySubmitToGridOptions) {
            return this.m_pnlMaxCurrentProcs.validateData();
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        boolean parallel = (this.m_bShowOnlySubmitToGridOptions || this.m_ckbExecuteParallel.isSelected()) && editable;
        this.m_ckbExecuteParallel.setEnabled(editable);
        this.m_ckbWaitfor.setEnabled(parallel);
        this.m_txtLogOutputLocation.setEditable(parallel);
        this.m_butLogOutputLocation.setEnabled(parallel);
        this.m_cmbApplication.setEnabled(parallel);
        this.m_cmbWorkload.setEnabled(parallel);
        this.m_txtAdditionalOptions.setEditable(parallel);
        this.m_ckbUnknownStatusError.setEnabled(parallel);
        this.m_txtSignonRetries.setEditable(parallel);
        this.m_txtGridSuppJobOptions.setEditable(parallel);
        this.m_pnlMaxCurrentProcs.setEditable(parallel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseForLogOutputLocation() {
        WsAppServer appServer = null;
        boolean disposeModel = false;
        BaseModel mdl = null;
        IServer server = this.m_server;
        try {
            if (server == null) {
                disposeModel = true;
                mdl = new BaseModel();
                mdl.setDebugName("workload update");
                server = this.getDefaultServer((IModel)mdl);
            }
            appServer = server != null ? WsAppServer.createAppServer((String)server.getID()) : WsAppServer.createDefaultAppServer();
            String path = null;
            if (appServer.getOperatingSystem().equalsIgnoreCase("OS")) {
                MessageUtil.displayMessage((String)bundle.getString("ParallelOptionsPanel.UnableToBrowse.txt"), (int)0);
            } else {
                path = appServer.promptForDirectory(bundle.getString("ParallelOptionsPanel.BrowseLogOutput.Title.txt"), this.m_txtLogOutputLocation.getText(), null);
            }
            if (path != null) {
                this.setLogOutputLocation(path);
            }
        }
        catch (GenericError err) {
            MessageUtil.displayMessage((String)err.getLocalizedMessage());
        }
        catch (WsAppServerFailException exc) {
            MessageUtil.displayMessage((String)exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
            if (disposeModel && mdl != null) {
                mdl.dispose();
            }
        }
    }

    private class cExecuteParallelAction
    extends WsAbstractAction {
        private cExecuteParallelAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == ParallelOptionsPanel.this.m_ckbExecuteParallel) {
                ParallelOptionsPanel.this.updateExecuteParallel();
            } else if (source == ParallelOptionsPanel.this.m_cmbApplication) {
                String application = (String)ParallelOptionsPanel.this.m_cmbApplication.getSelectedItem();
                if (application == null || NONE.equals(application) || SELECT.equals(application)) {
                    application = null;
                }
                ParallelOptionsPanel.this.firePropertyChange(APPLICATION_CHANGED, NONE, application);
            } else if (source == ParallelOptionsPanel.this.m_cmbWorkload) {
                String workload = (String)ParallelOptionsPanel.this.m_cmbWorkload.getSelectedItem();
                if (workload == null || NONE.equals(workload)) {
                    workload = "";
                }
                ParallelOptionsPanel.this.firePropertyChange(WORKLOAD_CHANGED, NONE, workload);
            } else if (source == ParallelOptionsPanel.this.m_ckbWaitfor) {
                ParallelOptionsPanel.this.firePropertyChange(WAIT_FOR_CHANGED, !ParallelOptionsPanel.this.m_ckbWaitfor.isSelected(), ParallelOptionsPanel.this.m_ckbWaitfor.isSelected());
            } else if (source == ParallelOptionsPanel.this.m_ckbUnknownStatusError) {
                ParallelOptionsPanel.this.firePropertyChange(UNKNOWN_STATUS_IS_ERROR_CHANGED, !ParallelOptionsPanel.this.m_ckbUnknownStatusError.isSelected(), ParallelOptionsPanel.this.m_ckbUnknownStatusError.isSelected());
            }
        }
    }

    private class PanelPropertyListener
    implements PropertyChangeListener {
        private PanelPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (SASParallelMaximumConcurrentProcessesPanel.MAX_CONCURRENT_CHANGED.equals(ev.getPropertyName())) {
                ParallelOptionsPanel.this.firePropertyChange(SASParallelMaximumConcurrentProcessesPanel.MAX_CONCURRENT_CHANGED, ev.getOldValue(), ev.getNewValue());
            }
        }
    }

    private class cBrowseAction
    extends WsAbstractAction {
        public cBrowseAction() {
            super(bundle, "ParallelOptionsPanel.BrowseLogOutputLocation");
        }

        public void actionPerformed(ActionEvent event) {
            ParallelOptionsPanel.this.browseForLogOutputLocation();
        }
    }
}

