/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.OSNodeFactory;
import com.sas.wadmin.model.tree.OSNodeFilter;
import com.sas.wadmin.model.tree.ObjectSelectorTreeModel;
import com.sas.wadmin.visuals.CustomTreeUtilities;
import com.sas.wadmin.visuals.MiningTreeUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ObjectsSelectorTreeModel
extends ObjectSelectorTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ObjectsSelectorTreeModel.class);
    private static final int MAX_TREES = 2;
    private String[] m_saInventoryNodeTypes;
    private String[] m_saInventoryNodeTitles;
    private TreeExpansionListener m_lsnrExpansion = new ExpansionListener();
    private TreeSelectionListener m_lsnrSelection = new SelectionListener();

    public ObjectsSelectorTreeModel(MdObjectStore store) {
        super(store);
    }

    public void setRepositoriesToShow(List lRepositories) {
        this.setRepositories(lRepositories);
    }

    public List getRepositoriesToShow() {
        return this.getRepositories();
    }

    public void addListenersToTree(JTree tree) {
        tree.addTreeExpansionListener(this.m_lsnrExpansion);
        tree.addTreeSelectionListener(this.m_lsnrSelection);
    }

    public void removeListenersFromTree(JTree tree) {
        tree.removeTreeExpansionListener(this.m_lsnrExpansion);
        tree.removeTreeSelectionListener(this.m_lsnrSelection);
    }

    @Override
    public WsDataTreeNode find(Root oData) {
        try {
            return super.find(oData);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public void expandRootNode() {
        WsTreeNode node = (WsTreeNode)this.getRoot();
        node.expand();
    }

    public void expandRepositoryNodes() {
        WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
        if (!nodeRoot.hasExpanded()) {
            this.expandRootNode();
        }
        int childCount = nodeRoot.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            WsTreeNode node = (WsTreeNode)nodeRoot.getChildAt(i);
            node.expand();
        }
    }

    public DefaultMutableTreeNode getInitialNodeToScrollTo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRoot();
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        return node;
    }

    public WsDataTreeNode find(Root oData, boolean bPopulate) throws MdException, RemoteException {
        return this.find(oData);
    }

    protected WsDataTreeNode find(WsTreeNode node, String sFQID) {
        if (node instanceof WsDataTreeNode && node.getFQID().equals(sFQID)) {
            return (WsDataTreeNode)node;
        }
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            WsDataTreeNode nodeFound = this.find((WsTreeNode)node.getChildAt(iChild), sFQID);
            if (nodeFound == null) continue;
            return nodeFound;
        }
        return null;
    }

    public WsDataTreeNode populateTo(Root oData) throws MdException, RemoteException {
        return this.find(oData);
    }

    protected MiningResult getParentMiningResult(RelationalTable oTable) throws MdException, RemoteException {
        AssociationList lSources = oTable.getSourceTransformations();
        for (int iSource = 0; iSource < lSources.size(); ++iSource) {
            Root oSource = (Root)lSources.get(iSource);
            if (!oSource.getCMetadataType().equals("MiningResult")) continue;
            return (MiningResult)oSource;
        }
        AssociationList lTargets = oTable.getTargetTransformations();
        for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
            Root oTarget = (Root)lTargets.get(iTarget);
            if (!oTarget.getCMetadataType().equals("MiningResult")) continue;
            return (MiningResult)oTarget;
        }
        return null;
    }

    protected WsDataTreeNode populateAndFind(Root oData) throws MdException, RemoteException {
        WsDataTreeNode node;
        List lPathTrees;
        WsDataTreeNode node2;
        cTreeTreeNode nodeCustom;
        String sType = oData.getCMetadataType();
        String sRepositoryFQID = "A0000001." + oData.getRepositoryID();
        cRepositoryTreeNode nodeRepository = (cRepositoryTreeNode)this.find((WsTreeNode)this.getRoot(), sRepositoryFQID);
        if (nodeRepository == null) {
            return null;
        }
        if (!nodeRepository.hasExpanded()) {
            nodeRepository.addChildren();
            nodeRepository.setHasExpanded(true);
        }
        if ((nodeCustom = nodeRepository.getTreeRootNode(1)) != null && (node2 = this.populatePath(nodeCustom, lPathTrees = CustomTreeUtilities.getPath(oData, nodeCustom.getMetadataTree(), this.getStore()), oData)) != null) {
            return node2;
        }
        cTreeTreeNode nodeMining = nodeRepository.getTreeRootNode(2);
        if (nodeMining != null && (node = this.populatePath(nodeMining, lPathTrees = MiningTreeUtilities.getPath(oData, nodeMining.getMetadataTree(), this.getStore()), oData)) != null) {
            return node;
        }
        if (sType.equals("Tree")) {
            return null;
        }
        cUngroupedTreeNode nodeUngrouped = nodeRepository.getUngroupedNode();
        if (nodeUngrouped != null) {
            return this.populateAndFind(nodeUngrouped, oData);
        }
        cInventoryTreeNode[] aNodeInventory = nodeRepository.getInventoryTreeNodes();
        if (aNodeInventory != null) {
            for (int i = 0; i < aNodeInventory.length; ++i) {
                cInventoryTreeNode oNode = aNodeInventory[i];
                WsDataTreeNode node3 = this.populateAndFind(oNode, oData);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    protected WsDataTreeNode populatePath(cTreeTreeNode nodeRoot, List lPathTrees, Root oData) {
        if (lPathTrees.isEmpty()) {
            return null;
        }
        try {
            Tree oTree = (Tree)lPathTrees.get(0);
            if (!nodeRoot.getMetadataTree().getFQID().equals(oTree.getFQID())) {
                return null;
            }
            cTreeTreeNode nodeTree = nodeRoot;
            for (int iTree = 1; iTree < lPathTrees.size(); ++iTree) {
                oTree = (Tree)lPathTrees.get(iTree);
                if ((nodeTree = (cTreeTreeNode)this.populateAndFind((WsTreeNode)nodeTree, (Root)oTree)) != null) continue;
                return null;
            }
            if (oData.getCMetadataType().equals("Tree")) {
                return nodeTree;
            }
            return this.populateAndFind((WsTreeNode)nodeTree, oData);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    protected WsDataTreeNode populateAndFind(WsTreeNode node, Root oData) {
        if (node == null) {
            return null;
        }
        if (!node.hasExpanded()) {
            node.addChildren();
            node.setHasExpanded(true);
        }
        try {
            return this.find(node, oData.getFQID());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    protected void appendChild(MutableTreeNode nodeChild, MutableTreeNode nodeParent) {
        this.insertNodeInto(nodeChild, nodeParent, nodeParent.getChildCount());
    }

    protected WsTreeNode createNodeForObject(Root oData) {
        try {
            String sType = oData.getCMetadataType();
            if (sType.equals("PhysicalTable")) {
                return new cDataTableTreeNode((DataTable)((PhysicalTable)oData));
            }
            if (sType.equals("ExternalTable")) {
                return new cDataTableTreeNode((DataTable)((ExternalTable)oData));
            }
            if (sType.equals("Column")) {
                return new cColumnTreeNode((Column)oData);
            }
            if (sType.equals("MiningResult")) {
                return new cMiningResultTreeNode((MiningResult)oData);
            }
            if (sType.equals("RelationalTable")) {
                return new cDataTableTreeNode((DataTable)((RelationalTable)oData));
            }
            return new WsDataTreeNode((CMetadata)oData);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    protected class ExpansionListener
    implements TreeExpansionListener {
        protected ExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode node = (WsTreeNode)e.getPath().getLastPathComponent();
            node.expand();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }

    protected class SelectionListener
    implements TreeSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!((OSNodeFilter)ObjectsSelectorTreeModel.this.getNodeFilter()).isTypeShown("Column")) {
                return;
            }
            OSNodeFactory factory = (OSNodeFactory)ObjectsSelectorTreeModel.this.getNodeFactory();
            TreePath[] aPaths = e.getPaths();
            if (aPaths != null) {
                for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                    WsDataTreeNode node;
                    String sType;
                    Object obj = aPaths[iPath].getLastPathComponent();
                    if (!(obj instanceof WsDataTreeNode) || !factory.isTypeExpandable(sType = (node = (WsDataTreeNode)obj).getType()) || !sType.equals("PhysicalTable") && !sType.equals("RelationalTable") && !sType.equals("ExternalTable")) continue;
                    node.expand();
                    if (node.getChildCount() != 0) continue;
                    node.setAllowsChildren(false);
                }
            }
        }
    }

    protected class cRepositoryTreeNode
    extends cTreeTreeNode {
        private cTreeTreeNode[] m_aRootNodes;
        private int[] m_aTreeIds;
        private int m_nTrees;
        private cUngroupedTreeNode m_nodeUngrouped;
        private cInventoryTreeNode[] m_aNodeInventoryTrees;

        public cRepositoryTreeNode(CMetadata oData) {
            super(oData);
        }

        @Override
        public Icon getIcon(boolean bExpanded) {
            return WAdminResource.getTypeIcon((CMetadata)this.m_oMetadata);
        }

        @Override
        public void addChildren() {
            try {
                this.m_nTrees = 0;
                this.m_aTreeIds = new int[2];
                this.m_aRootNodes = new cTreeTreeNode[2];
                Tree[] aRoots = new Tree[2];
                if ((ObjectsSelectorTreeModel.this.getTreesToShow() & 1) != 0) {
                    this.m_aTreeIds[this.m_nTrees] = 1;
                    aRoots[this.m_nTrees] = CustomTreeUtilities.getRoot(this.m_oMetadata.getFQID(), ObjectsSelectorTreeModel.this.getStore());
                    this.m_nodeUngrouped = new cUngroupedTreeNode(this.m_oMetadata, aRoots[this.m_nTrees]);
                    if (aRoots[this.m_nTrees] != null) {
                        ++this.m_nTrees;
                    }
                }
                if ((ObjectsSelectorTreeModel.this.getTreesToShow() & 2) != 0) {
                    this.m_aTreeIds[this.m_nTrees] = 2;
                    aRoots[this.m_nTrees] = MiningTreeUtilities.getRoot(this.m_oMetadata.getFQID(), ObjectsSelectorTreeModel.this.getStore());
                    if (aRoots[this.m_nTrees] != null) {
                        ++this.m_nTrees;
                    }
                }
                if (this.m_nTrees > 1) {
                    for (int iTree = 0; iTree < this.m_nTrees; ++iTree) {
                        cTreeTreeNode node = new cTreeTreeNode(aRoots[iTree]);
                        if (this.m_aTreeIds[iTree] == 1) {
                            node.hackName(bundle.getString("ObjectsSelectorTreeModel.Custom.txt"));
                        }
                        ObjectsSelectorTreeModel.this.addChild((WsTreeNode)node, (WsTreeNode)this);
                        this.m_aRootNodes[iTree] = node;
                    }
                } else if (this.m_nTrees == 1) {
                    this.setMetadataTree(aRoots[0]);
                    super.addChildren();
                    this.m_aRootNodes[0] = this;
                }
                if (this.m_nodeUngrouped != null) {
                    cTreeTreeNode nodeCustom = this.getTreeRootNode(1);
                    if (nodeCustom != null) {
                        ObjectsSelectorTreeModel.this.addChild(this.m_nodeUngrouped, (WsTreeNode)nodeCustom);
                    } else {
                        ObjectsSelectorTreeModel.this.addChild(this.m_nodeUngrouped, (WsTreeNode)this);
                    }
                }
                if (ObjectsSelectorTreeModel.this.m_saInventoryNodeTitles != null) {
                    this.m_aNodeInventoryTrees = new cInventoryTreeNode[ObjectsSelectorTreeModel.this.m_saInventoryNodeTitles.length];
                }
                if (ObjectsSelectorTreeModel.this.m_saInventoryNodeTypes != null && ObjectsSelectorTreeModel.this.m_saInventoryNodeTypes.length > 0) {
                    for (int i = 0; i < ObjectsSelectorTreeModel.this.m_saInventoryNodeTypes.length; ++i) {
                        cInventoryTreeNode inventoryNode;
                        this.m_aNodeInventoryTrees[i] = inventoryNode = new cInventoryTreeNode(this.getMetadata(), ObjectsSelectorTreeModel.this.m_saInventoryNodeTitles[i], ObjectsSelectorTreeModel.this.m_saInventoryNodeTypes[i]);
                        ObjectsSelectorTreeModel.this.addChild(inventoryNode, (WsTreeNode)this);
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }

        public cTreeTreeNode getTreeRootNode(int fTree) {
            for (int iTree = 0; iTree < this.m_nTrees; ++iTree) {
                if (this.m_aTreeIds[iTree] != fTree) continue;
                return this.m_aRootNodes[iTree];
            }
            return null;
        }

        public cUngroupedTreeNode getUngroupedNode() {
            return this.m_nodeUngrouped;
        }

        public cInventoryTreeNode[] getInventoryTreeNodes() {
            return this.m_aNodeInventoryTrees;
        }
    }

    protected class cTreeTreeNode
    extends WsDataTreeNode {
        private Tree m_oTree;

        public cTreeTreeNode(CMetadata oData) {
            super(oData);
        }

        public cTreeTreeNode(Tree oTree) {
            super((CMetadata)oTree);
            this.m_oTree = oTree;
        }

        protected void hackName(String sName) {
            this.m_sName = sName;
        }

        public void setMetadataTree(Tree oTree) {
            this.m_oTree = oTree;
        }

        public Tree getMetadataTree() {
            return this.m_oTree;
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
        }

        public void addChildren() {
            try {
                if (this.m_oTree == null) {
                    return;
                }
                AssociationList lSubTrees = this.m_oTree.getSubTrees();
                for (int iSubTree = 0; iSubTree < lSubTrees.size(); ++iSubTree) {
                    Tree oTree = (Tree)lSubTrees.get(iSubTree);
                    cTreeTreeNode nodeTree = new cTreeTreeNode(oTree);
                    ObjectsSelectorTreeModel.this.addChild((WsTreeNode)nodeTree, (WsTreeNode)this);
                }
                AssociationList lMembers = this.m_oTree.getMembers();
                for (int iMember = 0; iMember < lMembers.size(); ++iMember) {
                    Root oData = (Root)lMembers.get(iMember);
                    if (!ObjectsSelectorTreeModel.this.getNodeFilter().accept(oData, (WsTreeNode)this)) continue;
                    ObjectsSelectorTreeModel.this.addChild(ObjectsSelectorTreeModel.this.createNodeForObject(oData), (WsTreeNode)this);
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }
    }

    protected class cUngroupedTreeNode
    extends WsTreeNode {
        private CMetadata m_oRepository;
        private Tree m_oRoot;

        public cUngroupedTreeNode(CMetadata oRepository, Tree oRoot) {
            super(bundle.getString("ObjectsSelectorTreeModel.Ungrouped.txt"));
            this.m_oRepository = oRepository;
            this.m_oRoot = oRoot;
        }

        public void addChildren() {
            try {
                AssociationList lGroups;
                Group oGroup = null;
                if (this.m_oRoot != null && !(lGroups = this.m_oRoot.getGroups()).isEmpty()) {
                    oGroup = (Group)lGroups.get(0);
                }
                String sRepositoryFQID = this.m_oRepository.getFQID();
                String[] saTypesToShow = ((OSNodeFilter)ObjectsSelectorTreeModel.this.getNodeFilter()).getTypesToShow();
                for (int iType = 0; iType < saTypesToShow.length; ++iType) {
                    if (saTypesToShow[iType].equals("Column") || saTypesToShow[iType].equals("MiningResult") || saTypesToShow[iType].equals("RelationalTable")) continue;
                    int fFlags = 264;
                    List lObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)ObjectsSelectorTreeModel.this.getStore(), sRepositoryFQID, saTypesToShow[iType], fFlags, null);
                    if (lObjects.size() <= 0) continue;
                    if (oGroup != null) {
                        StringBuffer sbSelect = new StringBuffer(100);
                        sbSelect.append("<XMLSELECT Search=\"");
                        sbSelect.append("*[Trees/*[Groups/*[@Id='" + oGroup.getFQID() + "']]]");
                        sbSelect.append("\"/>");
                        List lRemoveObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)ObjectsSelectorTreeModel.this.getStore(), sRepositoryFQID, saTypesToShow[iType], 128, sbSelect.toString());
                        lObjects.removeAll(lRemoveObjects);
                    }
                    for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                        ObjectsSelectorTreeModel.this.addChild(ObjectsSelectorTreeModel.this.createNodeForObject((Root)lObjects.get(iObject)), this);
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }
    }

    protected class cInventoryTreeNode
    extends WsTreeNode {
        private CMetadata m_oRepository;
        private String m_type;

        public cInventoryTreeNode(CMetadata oRepository, String sTitle, String sType) {
            super(sTitle);
            this.m_oRepository = oRepository;
            this.m_type = sType;
        }

        public void addChildren() {
            try {
                String sRepositoryFQID = this.m_oRepository.getFQID();
                int fFlags = 264;
                List lObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)ObjectsSelectorTreeModel.this.getStore(), sRepositoryFQID, this.m_type, fFlags, null);
                if (!lObjects.isEmpty()) {
                    for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                        ObjectsSelectorTreeModel.this.addChild(ObjectsSelectorTreeModel.this.createNodeForObject((Root)lObjects.get(iObject)), this);
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }
    }

    protected class cDataTableTreeNode
    extends WsDataTreeNode {
        private DataTable m_oTable;

        public cDataTableTreeNode(DataTable oTable) {
            super((CMetadata)oTable);
            this.m_oTable = oTable;
            this.setAllowsChildren(((OSNodeFilter)ObjectsSelectorTreeModel.this.getNodeFilter()).isTypeShown("Column"));
        }

        public void addChildren() {
            try {
                AssociationList lColumns = this.m_oTable.getColumns();
                for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
                    Column oColumn = (Column)lColumns.get(iColumn);
                    if (!ObjectsSelectorTreeModel.this.getNodeFilter().accept((Root)oColumn, (WsTreeNode)this)) continue;
                    WsTreeNode nodeTree = ObjectsSelectorTreeModel.this.createNodeForObject((Root)oColumn);
                    if (ObjectsSelectorTreeModel.this.isSortColumns()) {
                        ObjectsSelectorTreeModel.this.addChild(nodeTree, (WsTreeNode)this);
                        continue;
                    }
                    ObjectsSelectorTreeModel.this.appendChild((MutableTreeNode)nodeTree, (MutableTreeNode)((Object)this));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }

        public void removeChildren() {
            while (this.getChildCount() > 0) {
                ObjectsSelectorTreeModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
            this.setHasExpanded(false);
        }
    }

    protected class cColumnTreeNode
    extends WsDataTreeNode {
        private Column m_oColumn;

        public cColumnTreeNode(Column oColumn) {
            super((CMetadata)oColumn);
            this.m_oColumn = oColumn;
            this.setAllowsChildren(false);
            this.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((Column)this.m_oColumn));
        }
    }

    protected class cMiningResultTreeNode
    extends WsDataTreeNode {
        private MiningResult m_oMiningResult;

        public cMiningResultTreeNode(MiningResult oMiningResult) {
            super((CMetadata)oMiningResult);
            this.m_oMiningResult = oMiningResult;
            this.setAllowsChildren(((OSNodeFilter)ObjectsSelectorTreeModel.this.getNodeFilter()).isTypeShown("RelationalTable"));
        }

        public void addChildren() {
            try {
                AssociationList lTransformationSources = this.m_oMiningResult.getTransformationSources();
                for (int iTransformationSource = 0; iTransformationSource < lTransformationSources.size(); ++iTransformationSource) {
                    RelationalTable oTransformationSource = (RelationalTable)lTransformationSources.get(iTransformationSource);
                    WsTreeNode nodeTree = ObjectsSelectorTreeModel.this.createNodeForObject((Root)oTransformationSource);
                    ObjectsSelectorTreeModel.this.addChild(nodeTree, (WsTreeNode)this);
                }
                AssociationList lTransformationTargets = this.m_oMiningResult.getTransformationTargets();
                for (int iTransformationTarget = 0; iTransformationTarget < lTransformationTargets.size(); ++iTransformationTarget) {
                    RelationalTable oTransformationTarget = (RelationalTable)lTransformationTargets.get(iTransformationTarget);
                    WsTreeNode nodeTree = ObjectsSelectorTreeModel.this.createNodeForObject((Root)oTransformationTarget);
                    ObjectsSelectorTreeModel.this.addChild(nodeTree, (WsTreeNode)this);
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }
    }

    protected class cRootTreeNode
    extends WsTreeNode {
        public cRootTreeNode() {
            super(bundle.getString("ObjectsSelectorTreeModel.Repositories.txt"));
        }

        public void addChildren() {
            List lRepositories = ObjectsSelectorTreeModel.this.getRepositoriesToShow();
            if (lRepositories == null) {
                lRepositories = Workspace.getWorkspace().getSelectedRepositories();
            }
            for (int iRepository = 0; iRepository < lRepositories.size(); ++iRepository) {
                CMetadata oRepository = (CMetadata)lRepositories.get(iRepository);
                cRepositoryTreeNode nodeRepository = new cRepositoryTreeNode(oRepository);
                ObjectsSelectorTreeModel.this.addChild((WsTreeNode)nodeRepository, this);
            }
            this.setHasExpanded(true);
        }
    }
}

