/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractBrowsableTextField;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;

public class ObjectBrowsableTextField
extends WsAbstractBrowsableTextField {
    private static WAdminResource bundle = WAdminResource.getBundle(ObjectBrowsableTextField.class);
    private String m_objectType;
    private boolean m_browseDirectories = false;
    private boolean m_returnObjects = true;
    private MdObjectStore m_mdStore;

    public ObjectBrowsableTextField() {
    }

    public ObjectBrowsableTextField(MdObjectStore mdStore) {
        this.m_mdStore = mdStore;
    }

    public ObjectBrowsableTextField(String objectType) {
        this();
        this.setMetadataType(objectType);
    }

    public ObjectBrowsableTextField(MdObjectStore mdStore, String objectType) {
        this(mdStore);
        this.setMetadataType(objectType);
    }

    public ObjectBrowsableTextField(MdObjectStore mdStore, String objectType, boolean returnObjects) {
        this(mdStore, objectType);
        this.setReturnObjects(returnObjects);
    }

    public ObjectBrowsableTextField(String objectType, boolean returnObjects) {
        this(null, objectType);
        this.setReturnObjects(returnObjects);
    }

    public void setBrowseDirectories(boolean browseDirectories) {
        this.m_browseDirectories = browseDirectories;
    }

    public void setMetadataType(String objectType) {
        this.m_objectType = objectType;
    }

    public void showDialog() {
        if (this.m_objectType.equals("File")) {
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(bundle.getString("ObjectBrowsableTextField.AllFileTypes.txt"), "*");
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer wsAppServer = WsAppServer.createDefaultAppServer();
            String selection = "";
            try {
                selection = this.m_browseDirectories ? wsAppServer.promptForDirectory(bundle.getString("ObjectBrowsableTextField.RemoteFileSelectorDirectory.Title.txt"), this.getText(), fileTypes) : wsAppServer.promptForFilename(bundle.getString("ObjectBrowsableTextField.RemoteFileSelector.Title.txt"), this.getText(), fileTypes);
            }
            catch (WsAppServerFailException exc) {
                this.setCursor(Cursor.getDefaultCursor());
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                return;
            }
            catch (GenericError err) {
                this.setCursor(Cursor.getDefaultCursor());
                MessageUtil.displayMessage((String)err.getLocalizedMessage(), (int)0);
                return;
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (selection != null) {
                this.setText(selection);
            }
        } else {
            try {
                ObjectSelectorPanel pnl;
                boolean disposeStore = false;
                SimpleObject selObject = null;
                PrimaryType mdObject = null;
                if (this.m_mdStore == null) {
                    try {
                        this.m_mdStore = Workspace.getMdFactory().createObjectStore();
                        disposeStore = true;
                        if (this.m_objectType.equals("PhysicalTable")) {
                            mdObject = MacroPluginUtilities.findTable(Workspace.getWorkspace().getDefaultRepository().getFQID(), this.getText().split("\\."), this.m_mdStore);
                        } else if (this.m_objectType.equals("SASLibrary")) {
                            mdObject = MacroPluginUtilities.findLibrary(Workspace.getWorkspace().getDefaultRepository().getFQID(), this.getText(), this.m_mdStore);
                        }
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                } else if (this.getData() != null && this.getData() instanceof PrimaryType) {
                    mdObject = (PrimaryType)this.getData();
                }
                if (mdObject != null) {
                    selObject = ObjectConverter.getInstance().convertToSimpleObject(mdObject);
                }
                UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
                String type = "";
                if (this.m_objectType.equals("PhysicalTable")) {
                    pnl = new ObjectSelectorPanel(userContext, 3);
                    type = bundle.getString("ObjectBrowsableTextField.Types.Table.txt");
                    pnl.setHelpProduct("wdb");
                    pnl.setHelpTopic("select_table_win");
                } else if (this.m_objectType.equals("SASLibrary")) {
                    pnl = new ObjectSelectorPanel(userContext, 2);
                    type = bundle.getString("ObjectBrowsableTextField.Types.Library.txt");
                    pnl.setHelpProduct("wdb");
                    pnl.setHelpTopic("select_library_win");
                } else {
                    return;
                }
                String sSelectDialogTitle = bundle.formatString("ObjectBrowsableTextField.SelectionType.title.txt", (Object)type);
                pnl.setSelectionOptional(true);
                if (selObject != null) {
                    pnl.setSelectedObject(selObject);
                }
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sSelectDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    SimpleObject simpleObj = pnl.getSelectedObject();
                    if (simpleObj != null) {
                        try {
                            Root oRoot = ObjectConverter.getInstance().convertToJOMAObject(this.m_mdStore, simpleObj);
                            String textDisplay = oRoot.toString();
                            if (this.m_returnObjects) {
                                this.setData(oRoot);
                            } else if (oRoot instanceof PhysicalTable) {
                                textDisplay = ObjectBrowsableTextField.getTableTextDisplay((PhysicalTable)oRoot);
                            } else if (oRoot instanceof SASLibrary) {
                                textDisplay = ((SASLibrary)oRoot).getLibref();
                            }
                            this.setText(textDisplay);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                    } else {
                        this.setData("");
                        this.setText("");
                    }
                }
                if (disposeStore) {
                    this.m_mdStore.dispose();
                    this.m_mdStore = null;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public static String getTableTextDisplay(PhysicalTable oTable) throws MdException, RemoteException {
        String tableText = oTable.getSASTableName();
        if (oTable != null) {
            RelationalSchema rSchema = oTable.getTablePackage();
            if (rSchema != null && rSchema instanceof DatabaseSchema) {
                SASLibrary tLibrary;
                tableText = ((DatabaseSchema)rSchema).getSchemaName() + '.' + tableText;
                if (!rSchema.getUsedByPackages(false).isEmpty() && (tLibrary = (SASLibrary)rSchema.getUsedByPackages(false).get(0)) != null) {
                    tableText = tLibrary.getLibref() + '.' + tableText;
                }
            } else if (rSchema != null) {
                tableText = ((SASLibrary)rSchema).getLibref() + '.' + tableText;
            }
        }
        return tableText;
    }

    public void setReturnObjects(boolean returnObjects) {
        this.m_returnObjects = returnObjects;
    }

    public boolean getReturnObjects() {
        return this.m_returnObjects;
    }
}

