/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsEditableListModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;

public class NotesListModelUsingMetadata
extends DefaultListModel
implements WsEditableListModel {
    Root m_oMetadata;
    List m_lObjects;

    public NotesListModelUsingMetadata(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.m_lObjects = new ArrayList();
    }

    public Object getValueAt(int iValue) {
        try {
            return this.getNoteDocumentAtIndex(iValue).getName();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
    }

    public boolean isCellEditable(int iValue) {
        return false;
    }

    public void setValueAt(int iValue, Object value) {
        this.setNoteNameAtIndex(iValue, (String)value);
        this.fireContentsChanged(this, iValue, iValue);
    }

    @Override
    public Object getElementAt(int arg0) {
        try {
            return this.getNoteDocumentAtIndex(arg0).getName();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
    }

    @Override
    public int getSize() {
        return this.getPublicNotesList().size();
    }

    private List getPublicNotesList() {
        ArrayList<Object> notesList = new ArrayList<Object>();
        try {
            AssociationList allDocs = this.m_oMetadata.getDocuments();
            for (int i = 0; i < allDocs.size(); ++i) {
                Document doc = (Document)allDocs.get(i);
                if (!doc.getPublicType().equalsIgnoreCase("Note")) continue;
                notesList.add(doc.getNotes().get(0));
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        return notesList;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            List notes = this.getPublicNotesList();
            for (int i = 0; i < notes.size(); ++i) {
                this.addElement(notes.get(i));
            }
            this.m_lObjects.addAll(notes);
        }
        return true;
    }

    public Root getNoteTextStoreAtIndex(int iIndex) {
        int iCount = 0;
        try {
            AssociationList allDocs = this.m_oMetadata.getDocuments();
            for (int i = 0; i < allDocs.size(); ++i) {
                Document doc = (Document)allDocs.get(i);
                if (!doc.getPublicType().equalsIgnoreCase("Note")) continue;
                if (iIndex == iCount) {
                    return (TextStore)doc.getNotes().get(0);
                }
                ++iCount;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        return null;
    }

    public Root getNoteDocumentAtIndex(int iIndex) {
        int iCount = 0;
        try {
            AssociationList allDocs = this.m_oMetadata.getDocuments();
            for (int i = 0; i < allDocs.size(); ++i) {
                Document doc = (Document)allDocs.get(i);
                if (!doc.getPublicType().equalsIgnoreCase("Note")) continue;
                if (iIndex == iCount) {
                    return doc;
                }
                ++iCount;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        return null;
    }

    private void setNoteNameAtIndex(int iIndex, String sName) {
        int iCount = 0;
        try {
            AssociationList allDocs = this.m_oMetadata.getDocuments();
            for (int i = 0; i < allDocs.size(); ++i) {
                Document doc = (Document)allDocs.get(i);
                if (!doc.getPublicType().equalsIgnoreCase("Note")) continue;
                if (iIndex == iCount) {
                    doc.setName(sName);
                    TextStore note = (TextStore)doc.getNotes().get(0);
                    note.setName(sName);
                    return;
                }
                ++iCount;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }
}

