/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.WANotesPreviewPane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;

public class NewNoteDialog
extends WAPropertyDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(NewNoteDialog.class);
    private SimpleObject m_parentFolder;
    private cMainPanel m_pnlMain;
    private SimpleObject m_note;
    private MdObjectStore m_store;
    private Document m_newDocument = null;

    public NewNoteDialog(Frame frm) {
        this(frm, null);
    }

    public NewNoteDialog(Frame frm, SimpleObject parentFolder) {
        super(frm, true);
        this.m_parentFolder = parentFolder;
        this.setTitle(bundle.getString("NewNoteDialog.Title.txt"));
        this.initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("new_note_wiz");
    }

    protected void initialize() {
        super.initialize();
        this.m_pnlMain = new cMainPanel();
        this.setMainPanel(this.m_pnlMain);
        this.setResizable(true);
    }

    public SimpleObject getNewNote() {
        return this.m_note;
    }

    protected void writeMetadata(boolean bCleanUp) {
        super.writeMetadata(false);
        try {
            this.m_note = new SimpleObjectImpl(this.m_newDocument.getName(), this.m_newDocument.getFQID(), this.m_newDocument.getCMetadataType(), this.m_newDocument.getPublicType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (bCleanUp) {
            this.dispose();
        }
    }

    protected class cMainPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        protected WAGeneralPanel m_generalPanel;
        protected WANotesPreviewPane m_txtText;

        public cMainPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.m_generalPanel = new WAGeneralPanel(null, null, false, false, false, true);
            this.m_generalPanel.setPreferredSize(new Dimension(200, 200));
            this.m_generalPanel.enableNameValidation(true);
            this.m_txtText = new WANotesPreviewPane();
            this.m_txtText.setEditable(true);
            this.m_txtText.setEnabled(true);
            this.m_txtText.getTextPane().setToolTipText(bundle.getString("NewNoteDialog.Note.ToolTip.txt"));
            this.m_txtText.setPreferredSize(new Dimension(400, 200));
            BorderLayout mainPanelLayout = new BorderLayout();
            this.setLayout(mainPanelLayout);
            this.add((Component)this.m_generalPanel, "North");
            mainPanelLayout.setVgap(5);
            this.add(this.m_txtText, "Center");
        }

        public void moveDataToView() {
            try {
                NewNoteDialog.this.m_store = Workspace.getMdFactory().createObjectStore(null, "NewNoteDialog");
                this.m_generalPanel.moveDataToView();
                String newName = WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)bundle.getString("NewNoteDialog.DefaultNoteName.txt"));
                this.m_generalPanel.setNameField(newName);
                Tree mdoFolder = NewNoteDialog.this.m_parentFolder == null ? WsMetadataUtil.getDefaultFolder((MdObjectStore)NewNoteDialog.this.m_store) : (Tree)ObjectConverter.getInstance().convertToJOMAObject(NewNoteDialog.this.m_store, NewNoteDialog.this.m_parentFolder);
                this.m_generalPanel.setOwningTree(mdoFolder);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
        }

        public void moveDataToStore() {
            try {
                NewNoteDialog.this.m_newDocument = this.makeNoteDocument(NewNoteDialog.this.m_store);
                NewNoteDialog.this.setMetadataObject((CMetadata)NewNoteDialog.this.m_newDocument);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public boolean validateData() {
            boolean state = this.m_generalPanel.validateData();
            if (!state) {
                return state;
            }
            Tree tree = this.m_generalPanel.getOwningTree();
            if (tree == null) {
                MessageUtil.displayMessage((String)bundle.getString("NewNoteDialog.MissingFolder.txt"), (int)0);
                return false;
            }
            boolean bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)this.m_generalPanel.getNameComponent().getText(), (Tree)tree, (String)"Note");
            if (!bIsUniqueName) {
                MessageUtil.displayMessage((String)bundle.getString("NewNoteDialog.DuplicateName.Message.txt"), (String)bundle.getString("NewNoteDialog.DuplicateName.Title.txt"), (int)0, (int)-1);
                return false;
            }
            return true;
        }

        public void saveSettingsAndCleanUp() {
            try {
                if (NewNoteDialog.this.m_store != null && !NewNoteDialog.this.m_store.isDisposed()) {
                    NewNoteDialog.this.m_store.dispose();
                }
                NewNoteDialog.this.m_store = null;
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        private Document makeNoteDocument(MdObjectStore store) throws RemoteException, MdException {
            Document document = null;
            String reposID = null;
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                reposID = repos.getFQID().substring(9, 17);
            } else {
                Tree tree = this.m_generalPanel.getOwningTree();
                reposID = tree.getRepositoryID();
            }
            document = (Document)Workspace.getMdFactory().createComplexMetadataObject(store, null, "", "Document", reposID, null);
            document.setPublicType("Note");
            document.setUsageVersion(OMRDocument.CURRENT_VERSION.encode());
            String sName = this.m_generalPanel.getNameComponent().getText();
            document.setName(sName);
            document.setDesc(this.m_generalPanel.getDescriptionComponent().getText());
            document.setURI("Document for public note");
            document.setTextRole("Note");
            Tree owningTree = this.m_generalPanel.getOwningTree();
            document.getTrees().add((Object)owningTree);
            WsMetadataUtil.setDefaultFolder((String)owningTree.getFQID());
            TextStore oText = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(store, null, "", "TextStore", reposID, null);
            oText.setName(sName);
            oText.setTextRole("Note");
            oText.setTextType("html");
            oText.setStoredText(this.m_txtText.getContents());
            AssociationList lNotes = document.getNotes();
            lNotes.add((Object)oText);
            document.setNotes(lNotes);
            return document;
        }
    }
}

