/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;

public class NewJobDialog
extends WAPropertyDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(NewJobDialog.class);
    private WAGeneralPanel m_generalPanel;
    private SimpleObject m_folder;
    private SimpleObject m_job;
    private MdObjectStore m_store;
    private static final String GENERATE_METADATA_MACROS_KEY = "Workspace.EnableMacroVariables";
    private static final String GENERATE_PARALLEL_MACROS_KEY = "Workspace.EnableParallelMacros";
    private static final String GENERATE_STATUS_HANDLING_LAST_KEY = "Workspace.GenerateJobStatusHandlingLast";
    private static final String USE_NLS_DATE_FORMAT_KEY = "Workspace.UseNLSDateFormat";
    private static final String AUTOMATICALLY_MAP = "NewJobDialog.AutomaticallyMap";
    private static final String AUTOMATICALLY_PROPAGATE = "NewJobDialog.AutomaticallyPropagate";
    private static final String AUTOMATIC_PROPAGATION_DIRECTION = "NewJobDialog.AutomaticPropagationDirection";
    private static final String COLLECT_RUNTIME_STATISTICS_KEY = "NewJobDialog.CollectRuntimeStatistics";
    private static final String COLLECT_TABLE_STATISTICS_KEY = "NewJobDialog.CollectTableStatistics";
    private static final String INCLUDE_STATISTICS_IN_STOREDPROCESS_KEY = "NewJobDialog.DoNotIncludeStatisticsInStoredProcess";
    private static final String GENERATEFORMATSINFORMATS_KEY = "NewJobDialog.GenerateFormatsInformats";
    private static final String GENERATECONNECTUSING_KEY = "NewJobDialog.GenerateConnectUsing";
    public static final int BEGINNING_TO_END = 0;
    public static final int END_TO_BEGINNING = 1;

    public static boolean isUserPreferenceToGenerateMetadataMacros() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(GENERATE_METADATA_MACROS_KEY, true);
    }

    public static void setUserPreferenceToGenerateMetadataMacros(boolean bGenerate) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(GENERATE_METADATA_MACROS_KEY, bGenerate);
    }

    public static boolean isUserPreferenceToGenerateParallelMacros() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(GENERATE_PARALLEL_MACROS_KEY, false);
    }

    public static void setUserPreferenceToGenerateParallelMacros(boolean bGenerate) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(GENERATE_PARALLEL_MACROS_KEY, bGenerate);
    }

    public static boolean isUserPreferenceToGenerateStatusHandlingLast() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(GENERATE_STATUS_HANDLING_LAST_KEY, true);
    }

    public static void setUserPreferenceToGenerateStatusHandlingLast(boolean bLast) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(GENERATE_STATUS_HANDLING_LAST_KEY, bLast);
    }

    public static boolean isUserPreferenceToUseNLSDateFormat() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(USE_NLS_DATE_FORMAT_KEY, true);
    }

    public static boolean isUserPreferenceToGenerateWarningsOnMappings() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.GenerateWarningsForMappings", true);
    }

    public static boolean isUserPreferenceToEnableCheckpoints() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.EnableJobCheckpoints", true);
    }

    public static String getAlternateTemporaryLibrary() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("Workspace.AlternateJobLibrary");
    }

    public static String getCheckpointStateLibrary() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("Workspace.DefaultCheckpointStateLibrary");
    }

    public static void setUserPreferenceToUseNLSDateFormat(boolean bUseNLSDateFormat) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(USE_NLS_DATE_FORMAT_KEY, bUseNLSDateFormat);
    }

    public static boolean isUserPreferenceToAutomaticallyMap() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AUTOMATICALLY_MAP, true);
    }

    public static void setUserPreferenceToAutomaticallyMap(boolean bAutomaticallyMap) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(AUTOMATICALLY_MAP, bAutomaticallyMap);
    }

    public static boolean isUserPreferenceToAutomaticallyPropagate() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AUTOMATICALLY_PROPAGATE, true);
    }

    public static void setUserPreferenceToAutomaticallyPropagate(boolean bAutomaticallyPropagate) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(AUTOMATICALLY_PROPAGATE, bAutomaticallyPropagate);
    }

    public static int getUserPreferenceForAutomaticPropagationDirection() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(AUTOMATIC_PROPAGATION_DIRECTION, 0);
    }

    public static void setUserPreferenceForAutomaticPropagationDirection(int eDirection) {
        if (eDirection != 0 && eDirection != 1) {
            throw new IllegalArgumentException("Automatic propagation direction must be BEGINNING_TO_END or END_TO_BEGINNING");
        }
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(AUTOMATIC_PROPAGATION_DIRECTION, eDirection);
    }

    public static void setUserPreferenceToCollectTableStatistics(boolean bCollectTableStatistics) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(COLLECT_TABLE_STATISTICS_KEY, bCollectTableStatistics);
    }

    public static boolean isUserPreferenceToCollectTableStatistics() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(COLLECT_TABLE_STATISTICS_KEY, true);
    }

    public static void setUserPreferenceToCollectRuntimeStatistics(boolean bCollectRuntimeStatistics) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(COLLECT_RUNTIME_STATISTICS_KEY, bCollectRuntimeStatistics);
    }

    public static boolean isUserPreferenceToCollectRuntimeStatistics() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(COLLECT_RUNTIME_STATISTICS_KEY, true);
    }

    public static void setUserPreferenceToIncludeStatisticsInStoredProcess(boolean bIncludeStatisticsInStoredProcess) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(INCLUDE_STATISTICS_IN_STOREDPROCESS_KEY, bIncludeStatisticsInStoredProcess);
    }

    public static boolean isUserPreferenceToIncludeStatisticsInStoredProcess() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(INCLUDE_STATISTICS_IN_STOREDPROCESS_KEY, true);
    }

    public static void setUserPreferenceToGenerateFormatsAndInformats(boolean bGenerateFormatsAndInformats) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(GENERATEFORMATSINFORMATS_KEY, bGenerateFormatsAndInformats);
    }

    public static boolean isUserPreferenceToGenerateFormatsAndInformats() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(GENERATEFORMATSINFORMATS_KEY, true);
    }

    public static void setUserPreferenceToConnectUsing(boolean bGenerateConnectUsing) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(GENERATECONNECTUSING_KEY, bGenerateConnectUsing);
    }

    public static boolean isUserPreferenceToConnectUsing() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(GENERATECONNECTUSING_KEY, false);
    }

    public NewJobDialog(Frame frm) {
        this(frm, null);
    }

    public NewJobDialog(Frame frm, SimpleObject folder) {
        super(frm, true);
        this.m_folder = folder;
        this.setTitle(bundle.getString("NewJobDialog.Title.txt"));
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("job_wizard");
        this.m_generalPanel = new WAGeneralPanel(null, null, false, false, false, true);
        this.m_generalPanel.setPreferredSize(new Dimension(400, 200));
        this.m_generalPanel.enableNameValidation(true);
        this.m_generalPanel.setHelpProduct("wdb");
        this.m_generalPanel.setHelpTopic("job_wizard");
        this.setMainPanel((WAPanel)this.m_generalPanel);
        this.setResizable(true);
    }

    public SimpleObject getNewJob() {
        return this.m_job;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this.m_store = Workspace.getMdFactory().createObjectStore(null, "NewJobDialog");
                this.m_generalPanel.moveDataToView();
                String sName = WsMetadataNameUtil.getUniqueNameForType((String)"Job", (String)bundle.getString("NewJobDialog.DefaultJobName.txt"));
                this.m_generalPanel.setNameField(sName);
                Tree mdoFolder = this.m_folder == null ? WsMetadataUtil.getDefaultFolder((MdObjectStore)this.m_store) : (Tree)ObjectConverter.getInstance().convertToJOMAObject(this.m_store, this.m_folder);
                this.m_generalPanel.setOwningTree(mdoFolder);
                return true;
            }
            return this.createJob();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        return false;
    }

    public boolean validateData() {
        boolean state = this.m_generalPanel.validateData();
        if (!state) {
            return state;
        }
        Tree tree = this.m_generalPanel.getOwningTree();
        if (tree == null) {
            MessageUtil.displayMessage((String)bundle.getString("NewJobDialog.Error.NoFolder.txt"), (int)0);
            return false;
        }
        boolean bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)this.m_generalPanel.getNameComponent().getText(), (Tree)tree, (String)"Job");
        if (!bIsUniqueName) {
            MessageUtil.displayMessage((String)bundle.getString("NewJobDialog.Error.DuplicateName.txt"), (int)0);
            return false;
        }
        return true;
    }

    public void dispose() {
        try {
            if (this.m_store != null) {
                this.m_store.dispose();
                this.m_store = null;
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        super.dispose();
    }

    public boolean hasDataChanged() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createJob() throws RemoteException, MdException {
        String sContainerID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getDefaultRepository().getFQID() : this.m_generalPanel.getOwningTree().getFQID();
        DesignTimeJobModel mdl = DesignTimeJobModel.createModelForNewJob((String)sContainerID);
        try {
            String cpLibrary;
            IJob job = mdl.getJob();
            job.setName(this.m_generalPanel.getNameComponent().getText());
            job.setDescription(this.m_generalPanel.getDescriptionComponent().getText());
            Tree mdoFolder = this.m_generalPanel.getOwningTree();
            IFolder folder = mdl.getObjectFactory().createFolder(mdoFolder.getFQID());
            job.setFolder(folder);
            WsMetadataUtil.setDefaultFolder((String)mdoFolder.getFQID());
            job.setGenerateMetadataMacroVariables(NewJobDialog.isUserPreferenceToGenerateMetadataMacros());
            job.setGenerateParallelMacros(NewJobDialog.isUserPreferenceToGenerateParallelMacros());
            job.setGenerateStatusHandlingLast(NewJobDialog.isUserPreferenceToGenerateStatusHandlingLast());
            job.setUseNLSDateFormat(NewJobDialog.isUserPreferenceToUseNLSDateFormat());
            job.setMapAutomatically(NewJobDialog.isUserPreferenceToAutomaticallyMap());
            job.setPropagateAutomatically(NewJobDialog.isUserPreferenceToAutomaticallyPropagate());
            job.setCollectStatistics(NewJobDialog.isUserPreferenceToCollectRuntimeStatistics());
            job.setCollectTableStatistics(NewJobDialog.isUserPreferenceToCollectTableStatistics());
            job.setAutomaticPropagationDirection(NewJobDialog.getUserPreferenceForAutomaticPropagationDirection());
            job.setGenerateWarningOnMapping(NewJobDialog.isUserPreferenceToGenerateWarningsOnMappings());
            job.setFormatInformatGenerationEnabled(NewJobDialog.isUserPreferenceToGenerateFormatsAndInformats());
            job.setConnectUsingEnabled(NewJobDialog.isUserPreferenceToConnectUsing());
            String altLibrary = NewJobDialog.getAlternateTemporaryLibrary();
            if (altLibrary != null && altLibrary.length() > 0) {
                try {
                    if (WsMetadataUtil.doesObjectExist((String)altLibrary, (String)"SASLibrary")) {
                        ILibrary alternateLibrary = mdl.getObjectFactory().createLibrary(altLibrary);
                        job.setAlternateTemporaryLibrary(alternateLibrary);
                    }
                }
                catch (MdException alternateLibrary) {
                    // empty catch block
                }
            }
            if ((cpLibrary = NewJobDialog.getCheckpointStateLibrary()) != null && cpLibrary.length() > 0) {
                try {
                    if (WsMetadataUtil.doesObjectExist((String)cpLibrary, (String)"SASLibrary")) {
                        ILibrary checkpointLibrary = mdl.getObjectFactory().createLibrary(cpLibrary);
                        job.setCheckpointStateLibrary(checkpointLibrary);
                    }
                }
                catch (MdException checkpointLibrary) {
                    // empty catch block
                }
            }
            job.setDisableCheckpoints(!NewJobDialog.isUserPreferenceToEnableCheckpoints());
            SaveRunnable run = new SaveRunnable((IModel)mdl);
            OpRequestUI op = new OpRequestUI();
            op.setTitle(job.getName());
            op.setMessage(bundle.getString("NewJobDialog.Saving.txt"));
            op.execute((Runnable)run);
            if (run.wasSuccessful()) {
                this.m_job = new SimpleObjectImpl(job.getName(), job.getID(), job.getMetadataType(), job.getPublicType());
            }
            boolean bl = run.wasSuccessful();
            return bl;
        }
        finally {
            mdl.dispose();
        }
    }

    private static class SaveRunnable
    implements Runnable {
        private IModel m_mdlJob;
        private boolean m_bSuccessful;

        private SaveRunnable(IModel mdlJob) {
            this.m_mdlJob = mdlJob;
        }

        @Override
        public void run() {
            this.m_bSuccessful = false;
            try {
                this.m_mdlJob.saveToOMR(Workspace.getMdFactory());
                this.m_bSuccessful = true;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Writing");
            }
        }

        public boolean wasSuccessful() {
            return this.m_bSuccessful;
        }
    }
}

