/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.Folder;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.wadmin.visuals.WANotesPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;

public class NewGroupWizardTab
extends WsDescriptionWizardTab
implements MdStoreListener {
    private static WAdminResource bundle = WAdminResource.getBundle(NewGroupWizardTab.class);
    protected Tree m_groupTree = null;
    protected JButton m_additionalBtn;
    protected WAGeneralPanel m_generalPanel;
    protected int m_groupType = 0;
    public static int GROUPTYPE_GENERIC = 0;
    public static int GROUPTYPE_REPORTS = 1;
    public static int GROUPTYPE_SOURCETABLES = 2;
    public static int GROUPTYPE_DATAMARTS = 3;
    public static int GROUPTYPE_JOBS = 4;
    public static int GROUPTYPE_DOCUMENTS = 5;
    public static int GROUPTYPE_EXTERNALFILES = 6;
    public static int GROUPTYPE_NOTES = 7;
    protected String m_sSoftClass = "com.sas.wadmin.visuals.TheAppWA";
    protected String optionSelected = "";

    public NewGroupWizardTab() {
        super(bundle.getString("NewGroupWizardTab.Description.txt"));
        this._initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("customtree_wizard");
    }

    public NewGroupWizardTab(int type) {
        this();
        this.m_groupType = type;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            store.addMdStoreListener((MdStoreListener)this);
            this.optionSelected = (String)myParent.getWizardData("SELECTEDNODE");
            if (this.m_groupTree == null || !this.optionSelected.equalsIgnoreCase(myParent.getWizardData("PREVIOUSSELECTEDNODE").toString())) {
                CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                this.m_groupTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", repos.getFQID().substring(9, 17));
                CMetadata oRepository = Workspace.getWorkspace().getCheckinRepository();
                Vector<CMetadata> vRepository = new Vector<CMetadata>(1);
                List vRepositories = Workspace.getWorkspace().getSelectedRepositories();
                int nRepositories = vRepositories.size();
                for (int iRepository = 0; iRepository < nRepositories; ++iRepository) {
                    CMetadata oTestRepository = (CMetadata)vRepositories.get(iRepository);
                    String sTestFQID = oTestRepository.getFQID();
                    String sFQID = oRepository.getFQID();
                    if (!sFQID.substring(9, 17).equals(sTestFQID.substring(9, 17))) continue;
                    vRepository.add(oTestRepository);
                    break;
                }
                String newName = bundle.getString("NewGroupWizardTab.DefaultGroupName.txt");
                this.m_groupTree.setName(WsMetadataNameUtil.getUniqueNameForType((String)"Tree", (String)newName));
                this.m_generalPanel.setMetadataObject((Root)this.m_groupTree);
                this.m_generalPanel.doDataExchange(false);
                this.m_groupTree.setPublicType("Folder");
                this.m_groupTree.setUsageVersion(Folder.CURRENT_VERSION.encode());
            }
        } else {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            myParent.fixupID((CMetadata)this.m_groupTree);
            this.m_groupTree.setTreeType("BIP Folder");
            if (myParent.getWizardData("GROUP") == null) {
                this.m_groupTree.getSoftwareComponents().add((Object)CustomTreeModel.getSoftwareComponent(Workspace.getWorkspace().getCheckinRepository().getFQID(), store));
            } else {
                this.m_groupTree.getParentTrees().add(myParent.getWizardData("GROUP"));
            }
            myParent.setMasterObject((CMetadata)this.m_groupTree);
            myParent.addWizardData("TREE", (Object)this.m_groupTree);
        }
        return true;
    }

    public void _initialize() {
        this.setLayout(new GridBagLayout());
        this.m_generalPanel = new WAGeneralPanel(bundle.getString("WAGeneralPropertyTab.Title.txt"), false, false, false);
        this.m_generalPanel.setPreferredSize(new Dimension(200, 100));
        this.add((Component)this.m_generalPanel, new GridBagConstraints(0, 0, 3, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_additionalBtn = new JButton(bundle.getString("TDInfoTab.AdditionalProp.txt"));
        this.m_additionalBtn.setMnemonic(bundle.getString("TDInfoTab.AdditionalProp.mnem").charAt(0));
        this.m_additionalBtn.setToolTipText(bundle.getString("TDInfoTab.AdditionalProp.Tooltip.txt"));
        this.m_additionalBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(NewGroupWizardTab.this.m_groupTree.getObjectStore());
                    WAPropertyDialog buttonDialog = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("TDInfoTab.AdditionalProp.Dialog.Title.txt"), true);
                    NewGroupWizardTab.this.m_generalPanel.doDataExchange(true);
                    Tree tempNewTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, NewGroupWizardTab.this.m_groupTree.getObjectStore(), (CMetadata)NewGroupWizardTab.this.m_groupTree);
                    buttonDialog.setMetadataObject((CMetadata)tempNewTree);
                    buttonDialog.addTab(bundle.getString("Mapping.Tabgroup.General.txt"), (WAPropertyTab)new WAGeneralPropertyTab((CMetadata)tempNewTree));
                    buttonDialog.addTab(bundle.getString("Mapping.Tabgroup.Notes.txt"), (WAPropertyTab)new WANotesPropertyTab((CMetadata)tempNewTree));
                    buttonDialog.addTab(bundle.getString("Mapping.Tabgroup.ExtendedAttributes.txt"), (WAPropertyTab)new WAExtAttrPropertyTab((CMetadata)tempNewTree));
                    buttonDialog.addTab(bundle.getString("WsGenericGeneralPropertyTab.Title.txt"), (WAPropertyTab)new WsGenericGeneralPropertyTab((CMetadata)tempNewTree));
                    buttonDialog.show();
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        });
        this.add(this.m_additionalBtn, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        boolean state = this.m_generalPanel.validateData();
        if (!state) {
            return state;
        }
        try {
            this.m_generalPanel.doDataExchange(true);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    public void onBack() {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent.removeWizardData("PREVIOUSSELECTEDNODE");
    }

    public String createFinishString() {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        StringBuffer sbFinish = new StringBuffer();
        try {
            sbFinish.append(bundle.getString("NewGroupWizardTab.FinishString.Intro.txt"));
            sbFinish.append("\n\n");
            sbFinish.append(bundle.formatString("NewGroupWizardTab.FinishString.Name.fmt.txt", (Object)this.m_groupTree.getName()));
            sbFinish.append("\n");
            sbFinish.append(bundle.formatString("NewGroupWizardTab.FinishString.Desc.fmt.txt", (Object)this.m_groupTree.getDesc()));
            sbFinish.append("\n");
            Tree groupTree = (Tree)myParent.getWizardData("GROUP");
            if (groupTree != null) {
                sbFinish.append(bundle.formatString("NewGroupWizardTab.FinishString.Group.fmt.txt", (Object)groupTree.getName()));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return sbFinish.toString();
    }

    public void MdObjectsModified(MdEvent e, List items) {
        try {
            this.m_generalPanel.doDataExchange(false);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void MdObjectsRemoved(MdEvent e, List items) {
    }

    public void MdObjectsAdded(MdEvent e, List items) {
    }
}

