/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.UniqueKey;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.KeyColumnMappingsPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.WizardFinishTab;
import com.sas.workspace.visuals.objectselector.ISelectorFeedbackFilter;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class NewForeignKeysWizard
extends WAWizardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(NewForeignKeysWizard.class);
    protected String reposID;
    protected WATransitionWizardModel model;
    protected Object[] selectedTables;
    protected MdObjectStore objectStore = null;
    protected DataTable keysTable;
    protected List foreignKeys;

    public NewForeignKeysWizard(JFrame frmOwner, CMetadata table, MdObjectStore store) {
        super((Frame)frmOwner, true);
        this.setHelpProduct("wdb");
        this.setTitle(bundle.getString("NewForeignKeysWizard.Title.txt"));
        this.foreignKeys = new ArrayList();
        this.objectStore = store;
        if (this.objectStore == null) {
            this.objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        } else {
            this.replaceWizardData("OBJECTSTORE", this.objectStore);
        }
        this.keysTable = (DataTable)table;
        try {
            this.reposID = table.getRepositoryID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        this.model = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)this.model);
        String[][] transitionList = new String[][]{{"TableSelectionTab", "NEXT", "MethodSelectionTab"}, {"MethodSelectionTab", "NEXT", "FinishTab"}};
        ImageIcon image = bundle.getImageIcon("NewForeignKeysWizard.SelectTablesTab.image");
        this.addTab(bundle.getString("NewForeignKeysWizard.SelectTables.Title.txt"), "TableSelectionTab", (WAPropertyTab)new cTablesTab(), "gen_select_table.gif", image, false);
        image = bundle.getImageIcon("NewForeignKeysWizard.SelectMethodTab.image");
        this.addTab(bundle.getString("NewForeignKeysWizard.SelectMethod.Title.txt"), "MethodSelectionTab", (WAPropertyTab)new cSelectMethodTab(), "gen_properties.gif", image, false);
        image = bundle.getImageIcon("NewForeignKeysWizard.FinishTab.image");
        this.addTab(bundle.getString("FinishTab.Title.txt"), "FinishTab", (WAPropertyTab)new WizardFinishTab(bundle.getString("NewForeignKeysWizard.FinishTab.Description.txt")), "gen_summary.gif", image, true);
        this.model.addTransitions(transitionList);
    }

    public ForeignKey createForeignKeyObjects(UniqueKey ukey, List ukMatches, List tblMatches) {
        ForeignKey foreignKey = null;
        try {
            String ukTableName = ((PhysicalTable)ukey.getTable()).getSASTableName();
            String tableName = ((PhysicalTable)this.keysTable).getSASTableName();
            foreignKey = (ForeignKey)Workspace.getMdFactory().createComplexMetadataObject(this.objectStore, null, ukTableName + "." + tableName, "ForeignKey", this.reposID);
            foreignKey.setDesc(bundle.formatString("Common.DefaultForeignKey.Descr.txt", (Object)tableName, (Object)ukey.getName(), (Object)ukTableName));
            foreignKey.setPartnerUniqueKey(ukey);
            this.keysTable.getForeignKeys().addElement((Object)foreignKey);
            if (ukMatches.size() > 0) {
                foreignKey.getKeyedColumns().addAll((Collection)tblMatches);
                for (int i = 0; i < tblMatches.size(); ++i) {
                    Column ukColumn = (Column)ukMatches.get(i);
                    Column tblColumn = (Column)tblMatches.get(i);
                    KeyAssociation keyAssoc = (KeyAssociation)Workspace.getMdFactory().createComplexMetadataObject(this.objectStore, null, ukColumn.getSASColumnName() + "." + tblColumn.getSASColumnName(), "KeyAssociation", this.reposID);
                    keyAssoc.setForeignKeyColumn(tblColumn);
                    keyAssoc.setUniqueKeyColumn(ukColumn);
                    keyAssoc.setOwningForeignKey(foreignKey);
                }
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Creating");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.foreignKeys.add(foreignKey);
        return foreignKey;
    }

    public List getForeignKeys() {
        return this.foreignKeys;
    }

    protected class cTablesTab
    extends WsDescriptionWizardTab {
        private WAWizardDialog m_parent;
        private ObjectsSelectorPanel m_objectsSelector;

        public cTablesTab() {
            super(bundle.getString("NewForeignKeysWizard.SelectTables.Description.txt"));
            this.m_parent = null;
            this.setHelpProduct("shared");
            this.setHelpTopic("fkey_select_table");
            this._initialize();
        }

        public void saveSettingsAndCleanUp() {
            this.m_objectsSelector.saveSettingsAndCleanUp();
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            boolean rc = false;
            if (this.m_parent == null) {
                this.m_parent = (WAWizardDialog)this.getTopLevelAncestor();
            }
            if (!bSaveToModel) {
                this.m_objectsSelector.doDataExchange(false);
            }
            return rc;
        }

        public boolean validateData() {
            boolean rc = false;
            rc = this.m_objectsSelector.validateData();
            if (rc) {
                try {
                    this.m_objectsSelector.moveDataToStore();
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            return rc;
        }

        public void onNext() {
            super.onNext();
            try {
                SimpleObject[] aTables = this.m_objectsSelector.getSelectedObjects();
                NewForeignKeysWizard.this.selectedTables = ObjectConverter.getInstance().convertToJOMAObjects(NewForeignKeysWizard.this.objectStore, aTables);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void onBack() {
            super.onBack();
            this.m_parent.removeWizardData("TDNEWTABLECOLUMNS");
            this.m_parent.removeWizardData("TDSOURCETABLES");
        }

        private void _initialize() {
            this.m_objectsSelector = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 3);
            this.m_objectsSelector.setMinSelectionCount(1);
            this.m_objectsSelector.setSourceLabel(bundle.getString("NewForeignKeysWizard.AvailableTables.txt"), bundle.getString("NewForeignKeysWizard.AvailableTables.mnem").charAt(0));
            this.m_objectsSelector.setSelectableObjectsFilter((ISimpleObjectFilter)new cSelectorFilter());
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_objectsSelector, "Center");
        }

        public List getSourceTables(ArrayList columns) {
            ArrayList<DataTable> tables = new ArrayList<DataTable>(10);
            for (int i = 0; i < columns.size(); ++i) {
                try {
                    Column col = (Column)columns.get(i);
                    tables.add(col.getTable());
                    continue;
                }
                catch (MdException col) {
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            return tables;
        }
    }

    protected class cSelectMethodTab
    extends WsDescriptionWizardTab {
        protected WATable selectTable;
        protected MethodTableModel tableModel;
        protected JScrollPane tablePane;
        protected boolean hasAutomatic;
        protected int dynamicNumber;

        public cSelectMethodTab() {
            super(bundle.getString("NewForeignKeysWizard.SelectMethod.Description.txt"));
            this.hasAutomatic = false;
            this.dynamicNumber = 0;
            this.setHelpProduct("shared");
            this.setHelpTopic("fkey_select_method");
            this.initialize();
        }

        public void initialize() {
            this.tableModel = new MethodTableModel();
            this.selectTable = new WATable((WATableModel)this.tableModel);
            this.selectTable.hideColumn(3);
            this.selectTable.hideColumn(4);
            this.tablePane = new JScrollPane((Component)this.selectTable);
            this.tablePane.setPreferredSize(new Dimension(500, 250));
            this.setLayout(new GridBagLayout());
            this.add(this.tablePane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                ArrayList<Object> al = new ArrayList<Object>();
                for (int i = 0; i < NewForeignKeysWizard.this.selectedTables.length; ++i) {
                    al.add(NewForeignKeysWizard.this.selectedTables[i]);
                }
                this.tableModel.setupModel(al);
            } else {
                NewForeignKeysWizard.this.setMasterObject((CMetadata)NewForeignKeysWizard.this.keysTable);
                if (this.hasAutomatic) {
                    ForeignKey foreignKey = null;
                    for (int i = 0; i < this.selectTable.getRowCount(); ++i) {
                        UniqueKey uKey = (UniqueKey)this.tableModel.getValueAt(i, 1);
                        String method = (String)this.tableModel.getValueAt(i, 2);
                        Vector ukMatches = (Vector)this.tableModel.getValueAt(i, 3);
                        Vector tblMatches = (Vector)this.tableModel.getValueAt(i, 4);
                        if (!method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType1.txt")) && !method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType2.txt"))) continue;
                        if (method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType2.txt"))) {
                            ukMatches.clear();
                            tblMatches.clear();
                            foreignKey = NewForeignKeysWizard.this.createForeignKeyObjects(uKey, ukMatches, tblMatches);
                            Column newColumn = null;
                            Column ukColumn = null;
                            KeyAssociation keyAssoc = null;
                            AssociationList ukColumns = uKey.getKeyedColumns();
                            for (int j = 0; j < ukColumns.size(); ++j) {
                                ukColumn = (Column)ukColumns.get(j);
                                newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(NewForeignKeysWizard.this.objectStore, null, ukColumn.getName(), "Column", NewForeignKeysWizard.this.reposID);
                                newColumn.setPublicType("Column");
                                newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                                newColumn.setDesc(ukColumn.getDesc());
                                newColumn.setSASColumnName(ukColumn.getSASColumnName());
                                newColumn.setSASColumnType(ukColumn.getSASColumnType());
                                newColumn.setSASColumnLength(ukColumn.getSASColumnLength());
                                newColumn.setSASInformat(ukColumn.getSASInformat());
                                newColumn.setSASFormat(ukColumn.getSASFormat());
                                NewForeignKeysWizard.this.keysTable.getColumns().addElement((Object)newColumn);
                                foreignKey.getKeyedColumns().addElement((Object)newColumn);
                                keyAssoc = (KeyAssociation)Workspace.getMdFactory().createComplexMetadataObject(NewForeignKeysWizard.this.objectStore, null, ukColumn.getSASColumnName() + "." + newColumn.getSASColumnName(), "KeyAssociation", NewForeignKeysWizard.this.reposID);
                                keyAssoc.setForeignKeyColumn(newColumn);
                                keyAssoc.setUniqueKeyColumn(ukColumn);
                                keyAssoc.setOwningForeignKey(foreignKey);
                            }
                            continue;
                        }
                        foreignKey = NewForeignKeysWizard.this.createForeignKeyObjects(uKey, ukMatches, tblMatches);
                    }
                }
            }
            return true;
        }

        public boolean validateData() {
            int rowCount = this.selectTable.getRowCount();
            int nNoForeignKey = 0;
            for (int i = 0; i < rowCount; ++i) {
                String method = (String)this.tableModel.getValueAt(i, 2);
                if (!method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType4.txt"))) continue;
                ++nNoForeignKey;
            }
            if (rowCount == nNoForeignKey) {
                MessageUtil.displayMessage((String)bundle.getString("NewForeignKeysWizard.ErrorNoCreateForeignKey.txt"), (int)0);
                return false;
            }
            this.hasAutomatic = false;
            boolean hasUserSelectionMethods = false;
            Vector<Integer> rowsContainingSelectMappings = new Vector<Integer>();
            for (int i = 0; i < rowCount; ++i) {
                String method = (String)this.tableModel.getValueAt(i, 2);
                Vector colMatches = (Vector)this.tableModel.getValueAt(i, 4);
                if (method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType1.txt"))) {
                    this.hasAutomatic = true;
                    if (colMatches.size() >= 1) continue;
                    MessageUtil.displayMessage((String)bundle.formatString("NewForeignKeysWizard.ErrorNoColumnMatches.fmt", this.selectTable.getValueAt(i, 0)), (int)0);
                    return false;
                }
                if (method == bundle.getString("NewForeignKeysWizard.MethodType2.txt")) {
                    this.hasAutomatic = true;
                    continue;
                }
                if (method != bundle.getString("NewForeignKeysWizard.MethodType3.txt")) continue;
                hasUserSelectionMethods = true;
                rowsContainingSelectMappings.add(new Integer(i));
            }
            Vector oldTabs = (Vector)NewForeignKeysWizard.this.getWizardData("TRANSITIONTABS");
            if (oldTabs != null) {
                int size = oldTabs.size();
                for (int i = 0; i < size; ++i) {
                    String tabName = (String)oldTabs.get(i);
                    NewForeignKeysWizard.this.model.removeTransition(tabName, "NEXT");
                }
                NewForeignKeysWizard.this.model.removeTransition("MethodSelectionTab", "NEXT");
                NewForeignKeysWizard.this.model.addTransition("MethodSelectionTab", "NEXT", "FinishTab");
            }
            if (hasUserSelectionMethods) {
                this.addTransitionsToModel(rowsContainingSelectMappings);
            }
            return true;
        }

        public void addTransitionsToModel(List rowNumbers) {
            String tabName = "TableSelectionTab";
            Vector<String> transitionTabs = new Vector<String>();
            NewForeignKeysWizard.this.model.removeTransition("MethodSelectionTab", "NEXT");
            NewForeignKeysWizard.this.model.addTransition("MethodSelectionTab", "NEXT", tabName + this.dynamicNumber);
            int size = rowNumbers.size();
            for (int i = 0; i < size; ++i) {
                int rowNumber = (Integer)rowNumbers.get(i);
                UniqueKey ukey = (UniqueKey)this.tableModel.getValueAt(rowNumber, 1);
                Vector ukMatches = (Vector)this.tableModel.getValueAt(rowNumber, 3);
                Vector tblMatches = (Vector)this.tableModel.getValueAt(rowNumber, 4);
                String toTab = tabName + this.dynamicNumber;
                transitionTabs.add(toTab);
                ImageIcon image = bundle.getImageIcon("NewForeignKeysWizard.ColumnLinkTab.image");
                NewForeignKeysWizard.this.addTab(bundle.getString("NewForeignKeysWizard.ColumnsLink.Title.txt"), toTab, (WAPropertyTab)new cColumnsLinkTab(ukey, ukMatches, tblMatches), "gen_column_information.gif", image, false);
                if (i == size - 1) {
                    NewForeignKeysWizard.this.model.addTransition(toTab, "NEXT", "FinishTab");
                    continue;
                }
                ++this.dynamicNumber;
                NewForeignKeysWizard.this.model.addTransition(toTab, "NEXT", tabName + this.dynamicNumber);
            }
            ++this.dynamicNumber;
            NewForeignKeysWizard.this.addWizardData("TRANSITIONTABS", transitionTabs);
        }

        public void saveSettingsAndCleanUp() {
        }

        public String createFinishString() {
            try {
                String temp = bundle.formatString("NewForeignKeysWizard.Finish.fmt", (Object)NewForeignKeysWizard.this.keysTable.getName()) + "\n\n";
                ForeignKey fkey = null;
                for (int i = 0; i < this.selectTable.getRowCount(); ++i) {
                    String method = (String)this.tableModel.getValueAt(i, 2);
                    DataTable table = (DataTable)this.tableModel.getValueAt(i, 0);
                    UniqueKey uKey = (UniqueKey)this.tableModel.getValueAt(i, 1);
                    Vector tblMatches = (Vector)this.tableModel.getValueAt(i, 4);
                    if (method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType1.txt"))) {
                        temp = temp + bundle.getString("Common.DefaultForeignKey.txt") + ": " + table.getName() + "." + NewForeignKeysWizard.this.keysTable.getName() + "\n";
                        temp = temp + bundle.getString("NewForeignKeysWizard.Column.txt") + "\n";
                        for (int j = 0; j < tblMatches.size(); ++j) {
                            temp = temp + "     " + ((Column)tblMatches.get(j)).getName() + "\n";
                        }
                        temp = temp + bundle.formatString("NewForeignKeysWizard.PrimaryKey.fmt", (Object)uKey.getName(), (Object)table.getName()) + "\n\n";
                    }
                    if (!method.equalsIgnoreCase(bundle.getString("NewForeignKeysWizard.MethodType2.txt"))) continue;
                    temp = temp + bundle.getString("Common.DefaultForeignKey.txt") + ": " + table.getName() + "." + NewForeignKeysWizard.this.keysTable.getName() + "\n";
                    temp = temp + bundle.getString("NewForeignKeysWizard.Column.txt") + "\n";
                    AssociationList ukColumns = null;
                    try {
                        ukColumns = uKey.getKeyedColumns();
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    for (int j = 0; j < ukColumns.size(); ++j) {
                        temp = temp + "     " + ((Column)ukColumns.get(j)).getName() + "\n";
                    }
                    temp = temp + bundle.formatString("NewForeignKeysWizard.PrimaryKey.fmt", (Object)uKey.getName(), (Object)table.getName()) + "\n\n";
                }
                List al = NewForeignKeysWizard.this.objectStore.getNewObjects();
                for (int i = 0; i < al.size(); ++i) {
                    Object obj = al.get(i);
                    if (!(obj instanceof ForeignKey)) continue;
                    fkey = (ForeignKey)obj;
                    temp = temp + bundle.getString("Common.DefaultForeignKey.txt") + ": " + fkey.getName() + "\n";
                    temp = temp + bundle.getString("NewForeignKeysWizard.Column.txt") + "\n";
                    AssociationList fkColumns = fkey.getKeyedColumns();
                    for (int j = 0; j < fkColumns.size(); ++j) {
                        temp = temp + "     " + ((Column)fkColumns.get(j)).getName() + "\n";
                    }
                    UniqueKey uk = fkey.getPartnerUniqueKey();
                    temp = temp + bundle.formatString("NewForeignKeysWizard.PrimaryKey.fmt", (Object)uk.getName(), (Object)uk.getTable().getName()) + "\n\n";
                }
                return temp;
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return "";
        }
    }

    private class cSelectorFilter
    implements ISelectorFeedbackFilter {
        ISimpleObjectFilter m_delegateFilter = ObjectSelectorFilterFactory.createObjectFilter((String[])new String[]{"Table"});

        private cSelectorFilter() {
        }

        public boolean accept(SimpleObject simpleObject) {
            if (this.m_delegateFilter.accept(simpleObject)) {
                return !this.isSameTable(simpleObject);
            }
            return false;
        }

        public String getReasonForRejection(SimpleObject simpleObj) {
            if (this.isSameTable(simpleObj)) {
                return bundle.getString("NewForeignKeysWizard.SameTable.txt");
            }
            return null;
        }

        private boolean isSameTable(SimpleObject simpleObj) {
            try {
                String sSelectedName = simpleObj.getName();
                String sCurrName = NewForeignKeysWizard.this.keysTable.getName();
                if (sSelectedName == null) {
                    return sCurrName == null;
                }
                return sSelectedName.equals(sCurrName);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
        }
    }

    protected class MethodTableModel
    extends WATableModel {
        protected String[] methodChoices = null;
        protected Vector ukColumnMatches;
        protected Vector tblColumnMatches;
        public static final int TABLE_COLUMN = 0;
        public static final int UK_COLUMN = 1;
        public static final int METHOD_COLUMN = 2;
        public static final int UK_COL_MATCHES_COLUMN = 3;
        public static final int TBL_COL_MATCHES_COLUMN = 4;
        public static final int TOTAL_COLUMNS = 5;

        protected MethodTableModel() {
            this.columnNames.add(bundle.getString("NewForeignKeysWizard.TableColumn.Title.txt"));
            this.columnNames.add(bundle.getString("Common.DefaultUniqueKey.txt"));
            this.columnNames.add(bundle.getString("NewForeignKeysWizard.MethodColumn.Title.txt"));
            this.columnNames.add("");
            this.columnNames.add("");
            this.methodChoices = new String[4];
            this.methodChoices[0] = bundle.getString("NewForeignKeysWizard.MethodType1.txt");
            this.methodChoices[1] = bundle.getString("NewForeignKeysWizard.MethodType2.txt");
            this.methodChoices[2] = bundle.getString("NewForeignKeysWizard.MethodType3.txt");
            this.methodChoices[3] = bundle.getString("NewForeignKeysWizard.MethodType4.txt");
        }

        protected void setupModel(ArrayList al) {
            if (this.data.size() > 0) {
                int s = this.data.size();
                this.data.clear();
                this.fireTableRowsDeleted(0, s - 1);
            }
            for (int i = 0; i < al.size(); ++i) {
                DataTable table = (DataTable)al.get(i);
                boolean isAutomatic = false;
                try {
                    AssociationList ukList = table.getUniqueKeys();
                    for (int a = 0; a < ukList.size(); ++a) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        this.ukColumnMatches = new Vector();
                        this.tblColumnMatches = new Vector();
                        isAutomatic = false;
                        row.add(table);
                        UniqueKey uk = (UniqueKey)ukList.get(a);
                        row.add(uk);
                        AssociationList colList = uk.getKeyedColumns();
                        for (int j = 0; j < colList.size(); ++j) {
                            Column column = (Column)colList.get(j);
                            String colName = column.getSASColumnName();
                            String colType = column.getSASColumnType();
                            int colLength = column.getSASColumnLength();
                            AssociationList tabColumnList = NewForeignKeysWizard.this.keysTable.getColumns();
                            for (int k = 0; k < tabColumnList.size(); ++k) {
                                Column tblColumn = (Column)tabColumnList.get(k);
                                String tblColName = tblColumn.getSASColumnName();
                                String tblColType = tblColumn.getSASColumnType();
                                int tblColLength = tblColumn.getSASColumnLength();
                                if (!tblColName.equalsIgnoreCase(colName) || !tblColType.equalsIgnoreCase(colType)) continue;
                                if (colType.equalsIgnoreCase("C")) {
                                    if (colLength < tblColLength) continue;
                                    this.tblColumnMatches.addElement(tblColumn);
                                    this.ukColumnMatches.addElement(column);
                                    isAutomatic = true;
                                    continue;
                                }
                                if (colLength != tblColLength) continue;
                                this.tblColumnMatches.addElement(tblColumn);
                                this.ukColumnMatches.addElement(column);
                                isAutomatic = true;
                            }
                        }
                        if (isAutomatic) {
                            row.add(this.methodChoices[0]);
                        } else {
                            row.add(this.methodChoices[1]);
                        }
                        row.add(this.ukColumnMatches);
                        row.add(this.tblColumnMatches);
                        this.data.add(row);
                    }
                    continue;
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 5;
        }

        public String[] getColumnChoices(int col) {
            if (col == 2) {
                return this.methodChoices;
            }
            return new String[0];
        }
    }

    protected class cColumnsLinkTab
    extends WsDescriptionWizardTab {
        protected KeyColumnMappingsPanel panel;
        protected ForeignKey foreignKey;
        protected UniqueKey uniqueKey;

        public cColumnsLinkTab(UniqueKey uk, List ukMatches, List fkMatches) {
            super(bundle.getString("NewForeignKeysWizard.ColumnsLink.Description.txt"));
            this.setHelpProduct("shared");
            this.setHelpTopic("fkey_select_mapping");
            this.foreignKey = NewForeignKeysWizard.this.createForeignKeyObjects(uk, ukMatches, fkMatches);
            this.uniqueKey = uk;
            this.initialize();
        }

        public void initialize() {
            this.panel = new KeyColumnMappingsPanel(this.uniqueKey, this.foreignKey, NewForeignKeysWizard.this.objectStore, true);
            this.setLayout(new GridBagLayout());
            this.add((Component)((Object)this.panel), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            return this.panel.validateData();
        }

        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            if (!bSaveToModel) {
                return this.panel.doDataExchange(bSaveToModel);
            }
            return true;
        }

        public void saveSettingsAndCleanUp() {
            this.foreignKey = null;
            this.uniqueKey = null;
            this.panel.saveSettingsAndCleanUp();
        }

        public void onNext() {
            try {
                this.panel.moveDataToStore();
                this.foreignKey = this.panel.getForeignKey();
                super.onNext();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public void onBack() {
            try {
                NewForeignKeysWizard.this.objectStore.removeObjectFromStore((CMetadata)this.foreignKey, null);
                super.onBack();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

