/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.io.File;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NewDocumentDialog
extends WAPropertyDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(NewDocumentDialog.class);
    private SimpleObject m_parentFolder;
    private cMainPanel m_pnlMain;
    private SimpleObject m_document;
    private Document m_newDocument = null;
    private MdObjectStore m_store;

    public NewDocumentDialog(Frame frm) {
        this(frm, null);
    }

    public NewDocumentDialog(Frame frm, SimpleObject parentFolder) {
        super(frm, true);
        this.m_parentFolder = parentFolder;
        this.setTitle(bundle.getString("NewDocumentDialog.Title.txt"));
        this.initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("new_doc_wiz");
    }

    protected void initialize() {
        super.initialize();
        this.m_pnlMain = new cMainPanel();
        this.setMainPanel(this.m_pnlMain);
        this.setResizable(true);
    }

    public SimpleObject getNewDocument() {
        return this.m_document;
    }

    protected void writeMetadata(boolean bCleanUp) {
        super.writeMetadata(false);
        try {
            this.m_document = new SimpleObjectImpl(this.m_newDocument.getName(), this.m_newDocument.getFQID(), this.m_newDocument.getCMetadataType(), this.m_newDocument.getPublicType());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (bCleanUp) {
            this.dispose();
        }
    }

    protected class cMainPanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        private boolean m_isLocal;
        protected WAGeneralPanel m_generalPanel;
        protected JLabel m_lblFile;
        protected WATextField m_txtFile;
        protected JButton m_btnFile;
        protected JButton m_btnRemoteFile;

        public cMainPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.m_generalPanel = new WAGeneralPanel(null, null, false, false, false, true);
            this.m_generalPanel.enableNameValidation(true);
            this.m_txtFile = new WATextField();
            this.m_txtFile.setBehavior(0);
            this.m_txtFile.setMaxCharacters(256);
            this.m_txtFile.setToolTipText(bundle.getString("NewDocumentDialog.FileLocation.Label.ToolTip.txt"));
            this.m_lblFile = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtFile, (String)bundle.getString("NewDocumentDialog.FileLocation.Label.txt"));
            int fileLabelWidth = this.m_lblFile.getPreferredSize().width;
            int maxWidthOfGeneralPanelLabels = this.m_generalPanel.getMaxWidthOfLabels();
            if (maxWidthOfGeneralPanelLabels > fileLabelWidth) {
                this.m_lblFile.setPreferredSize(new Dimension(maxWidthOfGeneralPanelLabels, this.m_lblFile.getPreferredSize().height));
            } else {
                this.m_generalPanel.setWidthOfLabels(fileLabelWidth);
            }
            this.m_btnFile = WsUIUtilities.createTextButton((WsAbstractAction)new cSelectFileAction());
            this.m_btnRemoteFile = WsUIUtilities.createTextButton((WsAbstractAction)new cSelectRemoteFileAction());
            JPanel docPanel = new JPanel();
            BorderLayout docLayout = new BorderLayout();
            docPanel.setLayout(docLayout);
            docPanel.add((Component)this.m_lblFile, "West");
            docLayout.setHgap(5);
            docPanel.add((Component)this.m_txtFile, "Center");
            JPanel btnsPanel = new JPanel();
            btnsPanel.add(this.m_btnFile);
            btnsPanel.add(this.m_btnRemoteFile);
            JPanel btPanel = new JPanel(new BorderLayout());
            btPanel.add((Component)btnsPanel, "East");
            docPanel.add((Component)btPanel, "South");
            BorderLayout mainPanelLayout = new BorderLayout();
            this.setLayout(mainPanelLayout);
            mainPanelLayout.setVgap(5);
            this.add((Component)this.m_generalPanel, "Center");
            this.add(docPanel, "South");
        }

        public void moveDataToView() {
            try {
                NewDocumentDialog.this.m_store = Workspace.getMdFactory().createObjectStore(null, "NewDocumentDialog");
                this.m_generalPanel.moveDataToView();
                String newName = WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)bundle.getString("NewDocumentDialog.DefaultDocumentName.txt"));
                this.m_generalPanel.setNameField(newName);
                Tree mdoFolder = NewDocumentDialog.this.m_parentFolder == null ? WsMetadataUtil.getDefaultFolder((MdObjectStore)NewDocumentDialog.this.m_store) : (Tree)ObjectConverter.getInstance().convertToJOMAObject(NewDocumentDialog.this.m_store, NewDocumentDialog.this.m_parentFolder);
                this.m_generalPanel.setOwningTree(mdoFolder);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
        }

        public void moveDataToStore() {
            try {
                NewDocumentDialog.this.m_newDocument = this.makeDocument(NewDocumentDialog.this.m_store);
                NewDocumentDialog.this.setMetadataObject((CMetadata)NewDocumentDialog.this.m_newDocument);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public void saveSettingsAndCleanUp() {
            try {
                if (NewDocumentDialog.this.m_store != null && !NewDocumentDialog.this.m_store.isDisposed()) {
                    NewDocumentDialog.this.m_store.dispose();
                }
                NewDocumentDialog.this.m_store = null;
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public boolean validateData() {
            boolean state = this.m_generalPanel.validateData();
            if (!state) {
                return state;
            }
            Tree tree = this.m_generalPanel.getOwningTree();
            if (tree == null) {
                MessageUtil.displayMessage((String)bundle.getString("NewDocumentDialog.MissingFolder.txt"), (int)0);
                return false;
            }
            boolean bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)this.m_generalPanel.getNameComponent().getText(), (Tree)tree, (String)"Document");
            if (!bIsUniqueName) {
                MessageUtil.displayMessage((String)bundle.getString("NewDocumentDialog.DuplicateName.Message.txt"), (String)bundle.getString("NewDocumentDialog.DuplicateName.Title.txt"), (int)0, (int)-1);
                return false;
            }
            String sFilename = this.m_txtFile.getText();
            if (sFilename.length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("NewDocumentDialog.FileLocationError.txt"), (int)0);
                return false;
            }
            return true;
        }

        private String getFilename() {
            String sSelectedFile = null;
            String sDirectory = null;
            FileDialog fileDialog = new FileDialog((Frame)Workspace.getWorkspace());
            if (this.m_txtFile != null && this.m_txtFile.getText().length() > 0) {
                File tempFile = new File(this.m_txtFile.getText());
                sDirectory = tempFile.getParent();
            }
            if (sDirectory != null) {
                fileDialog.setDirectory(sDirectory);
            } else {
                fileDialog.setDirectory(Workspace.getWorkspace().getDefaultPath());
            }
            fileDialog.setTitle(bundle.getString("NewDocumentDialog.SelectFileDialog.Title.txt"));
            fileDialog.setMode(0);
            fileDialog.setVisible(true);
            String sFile = fileDialog.getFile();
            sDirectory = fileDialog.getDirectory();
            if (sFile != null) {
                String sDir = fileDialog.getDirectory();
                sSelectedFile = sDir + sFile;
            }
            return sSelectedFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getRemoteFilename() {
            String sSelectedFile = null;
            try (WsAppServer appserver = WsAppServer.createDefaultAppServer((boolean)true);){
                if (appserver == null) {
                    String string = "";
                    return string;
                }
                if (!appserver.isOpen()) {
                    appserver.open();
                }
                String file = this.m_txtFile.getText();
                sSelectedFile = appserver.promptForFilename(bundle.getString("NewDocumentDialog.SelectFileDialog.Title.txt"), file, null);
            }
            return sSelectedFile;
        }

        private Document makeDocument(MdObjectStore store) throws RemoteException, MdException {
            Document document = null;
            String reposID = null;
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                reposID = repos.getFQID().substring(9, 17);
            } else {
                Tree tree = this.m_generalPanel.getOwningTree();
                reposID = tree.getRepositoryID();
            }
            document = (Document)Workspace.getMdFactory().createComplexMetadataObject(store, null, "", "Document", reposID, null);
            document.setPublicType("Document");
            document.setUsageVersion(OMRDocument.CURRENT_VERSION.encode());
            document.setName(this.m_generalPanel.getNameComponent().getText());
            document.setDesc(this.m_generalPanel.getDescriptionComponent().getText());
            document.setURI(this.m_txtFile.getText());
            if (!this.m_isLocal) {
                document.setURIType("REMOTE");
            }
            Tree owningTree = this.m_generalPanel.getOwningTree();
            document.getTrees().add((Object)owningTree);
            WsMetadataUtil.setDefaultFolder((String)owningTree.getFQID());
            return document;
        }

        protected class cSelectFileAction
        extends WsAbstractAction {
            private static final long serialVersionUID = 1L;

            public cSelectFileAction() {
                super(bundle, "NewDocumentDialog.SelectPath", 0);
            }

            public void actionPerformed(ActionEvent e) {
                String sFileName = cMainPanel.this.getFilename();
                if (sFileName != null && sFileName.length() > 0) {
                    cMainPanel.this.m_isLocal = true;
                    cMainPanel.this.m_txtFile.setText(sFileName);
                }
            }
        }

        protected class cSelectRemoteFileAction
        extends WsAbstractAction {
            private static final long serialVersionUID = 1L;

            public cSelectRemoteFileAction() {
                super(bundle, "NewDocumentDialog.SelectRemotePath", 0);
            }

            public void actionPerformed(ActionEvent e) {
                String sFileName = cMainPanel.this.getRemoteFilename();
                if (sFileName != null && sFileName.length() > 0) {
                    cMainPanel.this.m_isLocal = false;
                    cMainPanel.this.m_txtFile.setText(sFileName);
                }
            }
        }
    }
}

