/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MiningResult;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class MiningModelInfoPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(MiningModelInfoPanel.class);
    JLabel m_name;
    JLabel m_description;
    JLabel m_key;
    JLabel m_function;
    JLabel m_algorithm;
    JLabel m_version;
    JLabel m_developer;
    JLabel m_subject;
    WATextField m_nameField;
    WATextArea m_descTextArea;
    WATextField m_keyField;
    WATextField m_functionField;
    WATextField m_algorithmField;
    WATextField m_versionField;
    WATextField m_developerField;
    WATextField m_subjectField;
    JScrollPane m_descPane;
    MiningResult m_result;
    boolean m_layoutVertical;

    public MiningModelInfoPanel(boolean layoutVertical) {
        this.m_layoutVertical = layoutVertical;
        this.initialize();
        this.layoutWidgets();
        this.setEditable(false);
    }

    protected void initialize() {
        this.m_name = new JLabel(bundle.getString("MiningModelInfoPanel.Name.txt"));
        this.m_description = new JLabel(bundle.getString("MiningModelInfoPanel.Description.txt"));
        this.m_key = new JLabel(bundle.getString("MiningModelInfoPanel.Key.txt"));
        this.m_function = new JLabel(bundle.getString("MiningModelInfoPanel.Function.txt"));
        this.m_algorithm = new JLabel(bundle.getString("MiningModelInfoPanel.Algorithm.txt"));
        this.m_version = new JLabel(bundle.getString("MiningModelInfoPanel.Version.txt"));
        this.m_developer = new JLabel(bundle.getString("MiningModelInfoPanel.Developer.txt"));
        this.m_subject = new JLabel(bundle.getString("MiningModelInfoPanel.Subject.txt"));
        this.m_nameField = new WATextField();
        this.m_descTextArea = new WATextArea();
        this.m_keyField = new WATextField(24);
        this.m_functionField = new WATextField();
        this.m_algorithmField = new WATextField();
        this.m_versionField = new WATextField(16);
        this.m_developerField = new WATextField();
        this.m_subjectField = new WATextField();
        this.m_descPane = new JScrollPane((Component)this.m_descTextArea);
        this.m_descTextArea.setLineWrap(true);
        this.m_descTextArea.setWrapStyleWord(true);
        if (this.m_layoutVertical) {
            this.m_descTextArea.setRows(5);
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_nameField.setEditable(bEditable);
        this.m_keyField.setEditable(bEditable);
        this.m_functionField.setEditable(bEditable);
        this.m_algorithmField.setEditable(bEditable);
        this.m_versionField.setEditable(bEditable);
        this.m_developerField.setEditable(bEditable);
        this.m_subjectField.setEditable(bEditable);
        if (bEditable) {
            this.m_descTextArea.setBehavior(0);
        } else {
            this.m_descTextArea.setBehavior(2);
        }
    }

    public void setMiningResult(MiningResult result) throws MdException, RemoteException {
        this.m_result = result;
        this.updateWidgetValues();
    }

    protected void updateWidgetValues() throws MdException, RemoteException {
        if (this.m_result != null) {
            this.m_nameField.setText(this.m_result.getName());
            this.m_descTextArea.setText(this.m_result.getDesc());
            this.m_functionField.setText(this.m_result.getMiningFunction());
            this.m_algorithmField.setText(this.m_result.getMiningAlgorithm());
            this.m_subjectField.setText(this.m_result.getSubject());
            AssociationList extList = this.m_result.getExtensions();
            for (int x = 0; x < extList.size(); ++x) {
                Extension e = (Extension)extList.get(x);
                if (e.getName().equalsIgnoreCase("Key")) {
                    this.m_keyField.setText(e.getValue());
                }
                if (e.getName().equalsIgnoreCase("Developer")) {
                    this.m_developerField.setText(e.getValue());
                }
                if (!e.getName().equalsIgnoreCase("EMVersion")) continue;
                this.m_versionField.setText(e.getValue());
            }
        } else {
            this.m_nameField.setText("");
            this.m_descTextArea.setText("");
            this.m_keyField.setText("");
            this.m_functionField.setText("");
            this.m_algorithmField.setText("");
            this.m_versionField.setText("");
            this.m_developerField.setText("");
            this.m_subjectField.setText("");
        }
    }

    protected void layoutWidgets() {
        if (this.m_layoutVertical) {
            this._layoutWidgetsVertical();
        } else {
            this._layoutWidgetsHorizontal();
        }
    }

    protected void _layoutWidgetsVertical() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets middleLeftInset = new Insets(5, 0, 0, 5);
        Insets middleRightInset = new Insets(5, 0, 0, 0);
        this.layoutLabelComponentPair(gbl, 0, this.m_name, new Insets(0, 0, 0, 5), (Component)this.m_nameField, new Insets(0, 0, 0, 0));
        this.layoutLabelComponentPair(gbl, 1, this.m_description, middleLeftInset, this.m_descPane, middleRightInset);
        this.layoutLabelComponentPair(gbl, 2, this.m_key, middleLeftInset, (Component)this.m_keyField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 3, this.m_function, middleLeftInset, (Component)this.m_functionField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 4, this.m_algorithm, middleLeftInset, (Component)this.m_algorithmField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 5, this.m_version, middleLeftInset, (Component)this.m_versionField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 6, this.m_developer, middleLeftInset, (Component)this.m_developerField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 7, this.m_subject, middleLeftInset, (Component)this.m_subjectField, middleRightInset);
    }

    protected void layoutLabelComponentPair(GridBagLayout gbl, int yLevel, JLabel label, Insets labelInset, Component component, Insets componentInset) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = yLevel;
        gbc.anchor = 17;
        gbc.insets = labelInset;
        gbl.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = yLevel;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = componentInset;
        gbl.setConstraints(component, gbc);
        this.add(component);
    }

    protected void _layoutWidgetsHorizontal() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets middleLeftInset = new Insets(5, 0, 0, 5);
        Insets middleRightInset = new Insets(5, 0, 0, 0);
        this.layoutLabelComponentPair(gbl, 0, this.m_name, new Insets(0, 0, 0, 5), (Component)this.m_nameField, new Insets(0, 0, 0, 0));
        this.layoutLabelComponentPair(gbl, 1, this.m_description, middleLeftInset, this.m_descPane, middleRightInset);
        this.layoutKeyVersionLine(gbl);
        this.layoutLabelComponentPair(gbl, 3, this.m_function, middleLeftInset, (Component)this.m_functionField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 4, this.m_algorithm, middleLeftInset, (Component)this.m_algorithmField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 5, this.m_developer, middleLeftInset, (Component)this.m_developerField, middleRightInset);
        this.layoutLabelComponentPair(gbl, 6, this.m_subject, middleLeftInset, (Component)this.m_subjectField, middleRightInset);
    }

    protected void layoutKeyVersionLine(GridBagLayout gbl) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbl.setConstraints(this.m_key, gbc);
        this.add(this.m_key);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbl.setConstraints((Component)this.m_keyField, gbc);
        this.add((Component)this.m_keyField);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbl.setConstraints(this.m_version, gbc);
        this.add(this.m_version);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbl.setConstraints((Component)this.m_versionField, gbc);
        this.add((Component)this.m_versionField);
    }
}

