/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.visuals.MacroOptionsDefineTemplatesPanel;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class MacroOptionsTemplatesPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(MacroOptionsTemplatesPanel.class);
    public static final int MAX_DIGITS_FOR_INTEGER = 10;
    public static final int MAX_LENGTH_FOR_TABLE_NAMES = 13;
    protected static final String TEMPLATE_TYPE_INPUT = "Input";
    protected static final String TEMPLATE_TYPE_OUTPUT = "Output";
    protected static final boolean DEFAULT_SUPPORT_INPUTS = false;
    protected static final boolean DEFAULT_SUPPORT_OUTPUTS = false;
    private WAPanel m_pnlInputs;
    private JCheckBox m_ckbMultipleInputs;
    private WsAbstractAction m_actDefineInputs;
    private JButton m_btnDefineInputs;
    private WAIntTextField m_txtMinInputs;
    private WAIntTextField m_txtMaxInputs;
    private JLabel m_lblMinInputs;
    private JLabel m_lblMaxInputs;
    private WAPanel m_pnlOutputs;
    private JCheckBox m_ckbMultipleOutputs;
    private WsAbstractAction m_actDefineOutputs;
    private JButton m_btnDefineOutputs;
    private WAIntTextField m_txtMinOutputs;
    private WAIntTextField m_txtMaxOutputs;
    private JLabel m_lblMinOutputs;
    private JLabel m_lblMaxOutputs;
    private JCheckBox m_ckbDeleteOutputs;
    private JCheckBox m_ckbGenerateTransformMappings;
    private Prototype m_oMetadata;
    private List m_listOfInputMacroNames = null;
    private List m_listOfInputMacroPrompts = null;
    private List m_listOfOutputMacroNames = null;
    private List m_listOfOutputMacroPrompts = null;
    private List m_listOfInputAssociations = null;
    private List m_listOfOutputAssociations = null;
    private MdObjectStore m_childStore = null;

    public MacroOptionsTemplatesPanel(Prototype oMetadata) {
        this.m_oMetadata = oMetadata;
        this.initialize();
    }

    protected void initialize() {
        this.m_pnlInputs = new WAPanel();
        this.m_pnlInputs.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("MacroOptionsTransformPropertiesTab.InputsPanel.title")));
        this.m_ckbMultipleInputs = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.InputsPanel.MultipleInputs");
        this.m_ckbMultipleInputs.setSelected(true);
        this.listenForDataChangesTo(this.m_ckbMultipleInputs);
        this.m_actDefineInputs = new cDefineTemplatesAction(bundle, "MacroOptionsTransformPropertiesTab.InputsPanel.DefineInputs", TEMPLATE_TYPE_INPUT);
        this.m_btnDefineInputs = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDefineInputs);
        this.m_txtMinInputs = new WAIntTextField();
        this.m_txtMinInputs.setText("1");
        this.m_txtMinInputs.setMaxCharacters(10);
        this.m_lblMinInputs = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtMinInputs, (WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.InputsPanel.MinimumInputs");
        this.listenForDataChangesTo((JTextComponent)this.m_txtMinInputs);
        this.m_txtMaxInputs = new WAIntTextField();
        this.m_txtMaxInputs.setText("1");
        this.m_txtMaxInputs.setMaxCharacters(10);
        this.m_lblMaxInputs = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtMaxInputs, (WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.InputsPanel.MaximumInputs");
        this.listenForDataChangesTo((JTextComponent)this.m_txtMaxInputs);
        this.m_pnlOutputs = new WAPanel();
        this.m_pnlOutputs.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("MacroOptionsTransformPropertiesTab.OutputsPanel.title")));
        this.m_ckbMultipleOutputs = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.OutputsPanel.MultipleOutputs");
        this.m_ckbMultipleOutputs.setSelected(true);
        this.listenForDataChangesTo(this.m_ckbMultipleOutputs);
        this.m_ckbDeleteOutputs = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.OutputsPanel.DeleteOutputs");
        this.m_ckbDeleteOutputs.setSelected(true);
        this.listenForDataChangesTo(this.m_ckbDeleteOutputs);
        this.m_actDefineOutputs = new cDefineTemplatesAction(bundle, "MacroOptionsTransformPropertiesTab.OutputsPanel.DefineOutputs", TEMPLATE_TYPE_OUTPUT);
        this.m_btnDefineOutputs = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDefineOutputs);
        this.m_txtMinOutputs = new WAIntTextField();
        this.m_txtMinOutputs.setText("1");
        this.m_txtMinOutputs.setMaxCharacters(10);
        this.m_lblMinOutputs = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtMinOutputs, (WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.OutputsPanel.MinimumOutputs");
        this.listenForDataChangesTo((JTextComponent)this.m_txtMinOutputs);
        this.m_txtMaxOutputs = new WAIntTextField();
        this.m_txtMaxOutputs.setText("1");
        this.m_txtMaxOutputs.setMaxCharacters(10);
        this.m_lblMaxOutputs = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtMaxOutputs, (WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.OutputsPanel.MaximumOutputs");
        this.listenForDataChangesTo((JTextComponent)this.m_txtMaxOutputs);
        this.m_ckbMultipleInputs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroOptionsTemplatesPanel.this.setInputsEnabled();
            }
        });
        this.m_ckbMultipleOutputs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroOptionsTemplatesPanel.this.setOutputsEnabled();
            }
        });
        this.m_ckbGenerateTransformMappings = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"MacroOptionsTransformPropertiesTab.OutputsPanel.GenerateTransformMappings", (int)5);
        this.listenForDataChangesTo(this.m_ckbGenerateTransformMappings);
        this.setPreferredSize(new Dimension(550, 300));
        this.m_pnlInputs.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlInputs.add((Component)this.m_ckbMultipleInputs, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.m_pnlInputs.add((Component)this.m_btnDefineInputs, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_pnlInputs.add((Component)this.m_lblMinInputs, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlInputs.add((Component)this.m_txtMinInputs, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlInputs.add((Component)this.m_lblMaxInputs, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 5), 0, 0));
        this.m_pnlInputs.add((Component)this.m_txtMaxInputs, (Object)new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlOutputs.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlOutputs.add((Component)this.m_ckbMultipleOutputs, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_btnDefineOutputs, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_lblMinOutputs, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_txtMinOutputs, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_lblMaxOutputs, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 5, 5), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_txtMaxOutputs, (Object)new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_ckbDeleteOutputs, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_pnlOutputs.add((Component)this.m_ckbGenerateTransformMappings, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlInputs, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_pnlOutputs, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.m_listOfInputAssociations = new ArrayList();
        this.m_listOfInputMacroNames = new ArrayList();
        this.m_listOfInputMacroPrompts = new ArrayList();
        this.m_listOfOutputAssociations = new ArrayList();
        this.m_listOfOutputMacroNames = new ArrayList();
        this.m_listOfOutputMacroPrompts = new ArrayList();
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        AssociationProperty assocProperty;
        int i;
        int max;
        int min;
        AssociationProperty property;
        this.setListeningForChanges(false);
        if (this.m_childStore != null) {
            this.m_childStore.dispose();
        }
        this.m_childStore = Workspace.getMdFactory().createObjectStore(this.m_oMetadata.getObjectStore(), "MacroOptionsTemplatesPanelParsingStore");
        MacroPluginUtilities.getAllAssociationProperties(this.m_childStore, this.m_oMetadata, this.m_listOfInputAssociations, this.m_listOfOutputAssociations);
        if (this.m_listOfInputAssociations.size() > 0) {
            property = (AssociationProperty)this.m_listOfInputAssociations.get(0);
            min = property.getMinimum();
            max = property.getMaximum();
            this.m_ckbMultipleInputs.setSelected(min != -1);
            this.m_txtMinInputs.setValue(min);
            if (max == 0) {
                this.m_txtMaxInputs.setText("");
            } else {
                this.m_txtMaxInputs.setValue(max);
            }
            if (this.m_listOfInputMacroNames.isEmpty()) {
                for (i = 0; i < this.m_listOfInputAssociations.size(); ++i) {
                    assocProperty = (AssociationProperty)this.m_listOfInputAssociations.get(i);
                    if (MacroPluginUtilities.isTemplateDefault(assocProperty)) continue;
                    this.m_listOfInputMacroNames.add(MacroPluginUtilities.getMacroNameFromProperty(assocProperty));
                    this.m_listOfInputMacroPrompts.add(assocProperty.getName());
                }
            }
        } else {
            this.m_ckbMultipleInputs.setSelected(false);
        }
        this.setInputsEnabled();
        if (this.m_listOfOutputAssociations.size() > 0) {
            property = (AssociationProperty)this.m_listOfOutputAssociations.get(0);
            min = property.getMinimum();
            max = property.getMaximum();
            this.m_ckbMultipleOutputs.setSelected(min != -1);
            this.m_txtMinOutputs.setValue(min);
            if (max == 0) {
                this.m_txtMaxOutputs.setText("");
            } else {
                this.m_txtMaxOutputs.setValue(max);
            }
            if (this.m_listOfOutputMacroNames.isEmpty()) {
                for (i = 0; i < this.m_listOfOutputAssociations.size(); ++i) {
                    assocProperty = (AssociationProperty)this.m_listOfOutputAssociations.get(i);
                    if (MacroPluginUtilities.isTemplateDefault(assocProperty)) continue;
                    this.m_listOfOutputMacroNames.add(MacroPluginUtilities.getMacroNameFromProperty(assocProperty));
                    this.m_listOfOutputMacroPrompts.add(assocProperty.getName());
                }
            }
        } else {
            this.m_ckbMultipleOutputs.setSelected(false);
        }
        this.setOutputsEnabled();
        boolean deleteOutputs = true;
        PromptGroupInterface transformPrompts = PromptsPersistUtil.getPromptGroupFromOMRObject((Root)this.m_oMetadata, (SessionContextInterface)UtilPlatformServices.getSessionContext());
        if (transformPrompts != null) {
            deleteOutputs = transformPrompts.getPromptDefinition("ADMIN.DONTDELETEOUTPUTS", false) == null;
        }
        this.m_ckbDeleteOutputs.setSelected(deleteOutputs);
        this.m_ckbGenerateTransformMappings.setSelected(this.findMappingProperty(this.m_oMetadata) != null);
        this.setListeningForChanges(true);
    }

    private Property findMappingProperty(Prototype mdObject) throws RemoteException, MdException {
        AssociationList props = mdObject.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            Property prop = (Property)props.get(i);
            if (!"ADMIN.GENERATE_MAPPING_MACROS".equals(prop.getPropertyName())) continue;
            return prop;
        }
        return null;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        PromptGroupInterface transformPrompts = PromptsPersistUtil.getPromptGroupFromOMRObject((Root)this.m_oMetadata, (SessionContextInterface)UtilPlatformServices.getSessionContext());
        if (transformPrompts == null) {
            transformPrompts = PromptUtils.createPromptGroup();
        }
        PromptDefinitionInterface dontDeleteOutputsPrompt = transformPrompts.getPromptDefinition("ADMIN.DONTDELETEOUTPUTS", false);
        if (this.m_ckbDeleteOutputs.isSelected()) {
            if (dontDeleteOutputsPrompt != null) {
                transformPrompts.removePromptDefinition(dontDeleteOutputsPrompt);
            }
        } else if (dontDeleteOutputsPrompt == null) {
            transformPrompts.addPromptDefinition((PromptDefinitionInterface)MacroOptionsTemplatesPanel.createDontDeleteOutputsPrompt());
        }
        Property prop = this.findMappingProperty(this.m_oMetadata);
        if (this.m_ckbGenerateTransformMappings.isSelected()) {
            if (prop == null) {
                prop = this.createMappingsProperty(this.m_oMetadata);
                this.m_oMetadata.getProperties().add((Object)prop);
            }
        } else if (prop != null) {
            ((MdObjectStore)this.m_oMetadata.getObjectStore()).removeObjectFromStore((CMetadata)prop, "");
            this.m_oMetadata.getProperties().remove((Object)prop);
        }
        PromptUtils.savePromptGroupToMetadataObject((UserContextInterface)Workspace.getWorkspace().getUserContext(), (String)this.m_oMetadata.getRepositoryID(), (PromptGroupInterface)transformPrompts, (Root)this.m_oMetadata);
        this.setDataChanged(false);
    }

    public Property createMappingsProperty(Prototype oMetadata) throws RemoteException, MdException {
        Property prop = (Property)this.m_oMetadata.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore(), "GenerateMappingMacros", "Property", this.m_oMetadata.getRepositoryID());
        prop.setPropertyName("ADMIN.GENERATE_MAPPING_MACROS");
        prop.setPropertyRole("ADMIN.GENERATE_MAPPING_MACROS");
        return prop;
    }

    public static TextDefinition createDontDeleteOutputsPrompt() {
        TextDefinition td = new TextDefinition("ADMIN.DONTDELETEOUTPUTS");
        td.setHidden(true);
        return td;
    }

    public boolean validateData() {
        int numberMacros;
        int maxTextLength;
        if (this.m_ckbMultipleInputs.isSelected()) {
            if (this.m_txtMinInputs.getText().length() > 0) {
                try {
                    this.m_txtMinInputs.getValue2();
                }
                catch (WAIntTextField.IllegalIntegerException exc) {
                    MessageUtil.displayMessage((String)bundle.formatString("MacroOptionsEditPanel.IntegerException.Error.msg.txt", (Object)this.m_txtMinInputs.getText()), (String)bundle.getString("MacroOptionsEditPanel.IntegerException.Error.title.txt"), (int)0);
                    this.m_txtMinInputs.requestFocus();
                    return false;
                }
            }
            if (this.m_txtMaxInputs.getText().length() > 0) {
                try {
                    this.m_txtMaxInputs.getValue2();
                }
                catch (WAIntTextField.IllegalIntegerException exc) {
                    MessageUtil.displayMessage((String)bundle.formatString("MacroOptionsEditPanel.IntegerException.Error.msg.txt", (Object)this.m_txtMaxInputs.getText()), (String)bundle.getString("MacroOptionsEditPanel.IntegerException.Error.title.txt"), (int)0);
                    this.m_txtMaxInputs.requestFocus();
                    return false;
                }
            }
            maxTextLength = this.m_txtMaxInputs.getText().length();
            if (this.getMinInputs() == -1 && this.getMaxInputs() != -1) {
                MessageUtil.displayMessage((String)bundle.getString("MacroOptionsTemplatesPanel.InputUnlimited.txt"), (String)bundle.getString("MacroOptionsTemplatesPanel.InputUnlimited.title"), (int)0);
                this.m_txtMaxInputs.requestFocus();
                return false;
            }
            if (maxTextLength > 0 && this.getMaxInputs() < this.getMinInputs()) {
                MessageUtil.displayMessage((String)bundle.getString("MacroOptionsTemplatesPanel.MaxBelowMin.txt"), (String)bundle.getString("MacroOptionsTemplatesPanel.MaxBelowMin.title"), (int)0);
                this.m_txtMaxInputs.requestFocus();
                return false;
            }
            numberMacros = 0;
            if (this.getListOfMacroNames(true) != null) {
                numberMacros = this.getListOfMacroNames(true).size();
            }
            if (maxTextLength > 0 && numberMacros > 0 && this.getMaxInputs() < numberMacros) {
                MessageUtil.displayMessage((String)bundle.getString("MacroOptionsTemplatesPanel.TooManyDefined.txt"), (String)bundle.getString("MacroOptionsTemplatesPanel.TooManyDefined.title"), (int)0);
                return false;
            }
        }
        if (this.m_ckbMultipleOutputs.isSelected()) {
            if (this.m_txtMinOutputs.getText().length() > 0) {
                try {
                    this.m_txtMinOutputs.getValue2();
                }
                catch (WAIntTextField.IllegalIntegerException exc) {
                    MessageUtil.displayMessage((String)bundle.formatString("MacroOptionsEditPanel.IntegerException.Error.msg.txt", (Object)this.m_txtMinOutputs.getText()), (String)bundle.getString("MacroOptionsEditPanel.IntegerException.Error.title.txt"), (int)0);
                    this.m_txtMinOutputs.requestFocus();
                    return false;
                }
            }
            if (this.m_txtMaxOutputs.getText().length() > 0) {
                try {
                    this.m_txtMaxOutputs.getValue2();
                }
                catch (WAIntTextField.IllegalIntegerException exc) {
                    MessageUtil.displayMessage((String)bundle.formatString("MacroOptionsEditPanel.IntegerException.Error.msg.txt", (Object)this.m_txtMaxOutputs.getText()), (String)bundle.getString("MacroOptionsEditPanel.IntegerException.Error.title.txt"), (int)0);
                    this.m_txtMaxOutputs.requestFocus();
                    return false;
                }
            }
            maxTextLength = this.m_txtMaxOutputs.getText().length();
            if (this.getMinOutputs() == -1 && this.getMaxOutputs() != -1) {
                MessageUtil.displayMessage((String)bundle.getString("MacroOptionsTemplatesPanel.OutputUnlimited.txt"), (String)bundle.getString("MacroOptionsTemplatesPanel.OutputUnlimited.title"), (int)0);
                this.m_txtMaxOutputs.requestFocus();
                return false;
            }
            if (maxTextLength > 0 && this.getMaxOutputs() < this.getMinOutputs()) {
                MessageUtil.displayMessage((String)bundle.getString("MacroOptionsTemplatesPanel.MaxBelowMin.txt"), (String)bundle.getString("MacroOptionsTemplatesPanel.MaxBelowMin.title"), (int)0);
                this.m_txtMaxOutputs.requestFocus();
                return false;
            }
            numberMacros = 0;
            if (this.getListOfMacroNames(false) != null) {
                numberMacros = this.getListOfMacroNames(false).size();
            }
            if (maxTextLength > 0 && numberMacros > 0 && this.getMaxOutputs() < numberMacros) {
                MessageUtil.displayMessage((String)bundle.getString("MacroOptionsTemplatesPanel.TooManyDefined.txt"), (String)bundle.getString("MacroOptionsTemplatesPanel.TooManyDefined.title"), (int)0);
                return false;
            }
            if (this.m_ckbGenerateTransformMappings.isSelected()) {
                List outputNames = this.getListOfMacroNames(false);
                for (int i = 0; i < outputNames.size(); ++i) {
                    String name = (String)outputNames.get(i);
                    if (name.length() <= 13) continue;
                    MessageUtil.displayMessage((String)bundle.formatString("MacroOptionsTemplatesPanel.OutputMacroNameTooLong.txt", (Object)name), (int)0);
                    return false;
                }
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.setInputsEnabled();
        this.setOutputsEnabled();
        this.m_ckbMultipleInputs.setEnabled(bEditable);
        this.m_ckbMultipleOutputs.setEnabled(bEditable);
    }

    public void setMetadataObject(Prototype oMetadata) {
        this.m_oMetadata = oMetadata;
    }

    public int getMinInputs() {
        if (this.m_ckbMultipleInputs.isSelected()) {
            return this.m_txtMinInputs.getValue();
        }
        return 0;
    }

    public int getMaxInputs() {
        if (this.m_ckbMultipleInputs.isSelected()) {
            return this.m_txtMaxInputs.getValue();
        }
        return 0;
    }

    public int getMinOutputs() {
        if (this.m_ckbMultipleOutputs.isSelected()) {
            return this.m_txtMinOutputs.getValue();
        }
        return 0;
    }

    public int getMaxOutputs() {
        if (this.m_ckbMultipleOutputs.isSelected()) {
            return this.m_txtMaxOutputs.getValue();
        }
        return 0;
    }

    public boolean getOutputsSelected() {
        return this.m_ckbMultipleOutputs.isSelected();
    }

    public boolean getGenerateDeleteCode() {
        return this.m_ckbDeleteOutputs.isSelected();
    }

    protected void setInputsEnabled() {
        boolean editable = this.m_ckbMultipleInputs.isSelected() && this.isEditable();
        this.m_lblMinInputs.setEnabled(editable);
        this.m_lblMaxInputs.setEnabled(editable);
        this.m_txtMinInputs.setEditable(editable);
        this.m_txtMaxInputs.setEditable(editable);
        this.m_actDefineInputs.setEnabled(this.m_ckbMultipleInputs.isSelected());
    }

    protected void setOutputsEnabled() {
        boolean editable = this.m_ckbMultipleOutputs.isSelected() && this.isEditable();
        this.m_lblMinOutputs.setEnabled(editable);
        this.m_lblMaxOutputs.setEnabled(editable);
        this.m_txtMinOutputs.setEditable(editable);
        this.m_txtMaxOutputs.setEditable(editable);
        this.m_ckbDeleteOutputs.setEnabled(editable);
        this.m_actDefineOutputs.setEnabled(this.m_ckbMultipleOutputs.isSelected());
        this.m_ckbGenerateTransformMappings.setEnabled(editable);
    }

    public List getListOfMacroNames(boolean bIsInputTemplate) {
        List macroNames = null;
        if (bIsInputTemplate) {
            if (this.m_ckbMultipleInputs.isSelected()) {
                macroNames = this.m_listOfInputMacroNames;
            }
        } else if (this.m_ckbMultipleOutputs.isSelected()) {
            macroNames = this.m_listOfOutputMacroNames;
        }
        return macroNames;
    }

    public List getListOfMacroPrompts(boolean bIsInputTemplate) {
        List macroPrompts = null;
        if (bIsInputTemplate) {
            if (this.m_ckbMultipleInputs.isSelected()) {
                macroPrompts = this.m_listOfInputMacroPrompts;
            }
        } else if (this.m_ckbMultipleOutputs.isSelected()) {
            macroPrompts = this.m_listOfOutputMacroPrompts;
        }
        return macroPrompts;
    }

    protected class cDefineTemplatesAction
    extends WsAbstractAction {
        protected boolean m_bIsInputTemplate;

        public cDefineTemplatesAction(WAdminResource res, String key, String templateType) {
            super(res, key);
            if (templateType.equals(MacroOptionsTemplatesPanel.TEMPLATE_TYPE_INPUT)) {
                this.m_bIsInputTemplate = true;
            } else if (templateType.equals(MacroOptionsTemplatesPanel.TEMPLATE_TYPE_OUTPUT)) {
                this.m_bIsInputTemplate = false;
            } else {
                Workspace.getDefaultLogger().debug((Object)"illegal template type; defaulting to input");
                this.m_bIsInputTemplate = true;
            }
        }

        public void actionPerformed(ActionEvent e) {
            String dialogTitle = this.m_bIsInputTemplate ? bundle.getString("MacroOptionsTransformPropertiesTab.DefineTemplateDialog.Input.title") : bundle.getString("MacroOptionsTransformPropertiesTab.DefineTemplateDialog.Output.title");
            try {
                MdObjectStore childStore = Workspace.getMdFactory().createObjectStore(MacroOptionsTemplatesPanel.this.m_oMetadata.getObjectStore(), "MacroOptionsDefineTemplatesPanelParsingStore");
                MacroOptionsDefineTemplatesPanel panel = new MacroOptionsDefineTemplatesPanel(childStore, this.m_bIsInputTemplate, MacroOptionsTemplatesPanel.this.m_oMetadata);
                if (this.m_bIsInputTemplate) {
                    if (MacroOptionsTemplatesPanel.this.m_listOfInputMacroNames != null && MacroOptionsTemplatesPanel.this.m_listOfInputMacroNames.size() > 0) {
                        panel.setMacroNamesList((ArrayList)MacroOptionsTemplatesPanel.this.m_listOfInputMacroNames);
                        panel.setMacroPromptsList((ArrayList)MacroOptionsTemplatesPanel.this.m_listOfInputMacroPrompts);
                    }
                } else if (MacroOptionsTemplatesPanel.this.m_listOfOutputMacroNames != null && MacroOptionsTemplatesPanel.this.m_listOfOutputMacroNames.size() > 0) {
                    panel.setMacroNamesList((ArrayList)MacroOptionsTemplatesPanel.this.m_listOfOutputMacroNames);
                    panel.setMacroPromptsList((ArrayList)MacroOptionsTemplatesPanel.this.m_listOfOutputMacroPrompts);
                }
                WAStandardDialog d = new WAStandardDialog((Frame)Workspace.getWorkspace(), dialogTitle, true, (WAPanel)panel);
                d.setResizable(true);
                d.setEditable(MacroOptionsTemplatesPanel.this.isEditable());
                d.show();
                if (d.getReturnValue() == 1) {
                    MacroOptionsTemplatesPanel.this.setDataChanged(true);
                    int templatesSize = panel.getMacroNamesList().size();
                    if (this.m_bIsInputTemplate) {
                        MacroOptionsTemplatesPanel.this.m_listOfInputMacroNames = panel.getMacroNamesList();
                        MacroOptionsTemplatesPanel.this.m_listOfInputMacroPrompts = panel.getMacroPromptsList();
                        if (MacroOptionsTemplatesPanel.this.m_txtMaxInputs.getValue() <= templatesSize) {
                            MacroOptionsTemplatesPanel.this.m_txtMaxInputs.setValue(templatesSize);
                        }
                    } else {
                        MacroOptionsTemplatesPanel.this.m_listOfOutputMacroNames = panel.getMacroNamesList();
                        MacroOptionsTemplatesPanel.this.m_listOfOutputMacroPrompts = panel.getMacroPromptsList();
                        if (MacroOptionsTemplatesPanel.this.m_txtMaxOutputs.getValue() <= templatesSize) {
                            MacroOptionsTemplatesPanel.this.m_txtMaxOutputs.setValue(templatesSize);
                        }
                    }
                }
                childStore.dispose();
                d.dispose();
            }
            catch (RemoteException exc) {
                Workspace.handleRemoteException((RemoteException)exc);
            }
        }
    }
}

