/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.jobeditor.JobEditorView;
import com.sas.wadmin.model.tree.TempLogicalObjectNode;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.OperationUIAdapter;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.WAPFDEditorOMAView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsCheckToIgnoreDialog;
import com.sas.workspace.WsJobSubmissionManager;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.visuals.SubmitType;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class JobTreeNode
extends TempLogicalObjectNode {
    private static WAdminResource bundle = WAdminResource.getBundle(JobTreeNode.class);
    private static final Icon ICON_NORMAL = WAdminResource.getTypeIcon((String)"Job", (boolean)true);
    private static final Icon ICON_PARAMSDEPLOYED = bundle.getIcon("JobTreeNode.ParameterDeployedJob.image");
    private static final Icon ICON_DEPLOYED = bundle.getIcon("JobTreeNode.DeployedJob.image");
    private static final Icon ICON_PARAMS = bundle.getIcon("JobTreeNode.ParameterJob.image");
    protected WsAbstractAction m_actSubmitJob = this.createSubmitJobAction();
    protected WsAbstractAction m_actViewJob = this.createViewJobAction();
    protected WsAbstractAction m_actViewSource = this.createViewSourceAction();
    private WsAbstractAction m_actOpen = new OpenAction();

    public JobTreeNode(CMetadata oJob) {
        super(oJob);
        this.updateIcon();
    }

    public JPopupMenu getPopupMenu(WAdminResource bdl) {
        this.m_actSubmitJob.setEnabled(!this.isJobRunning());
        JPopupMenu menuPopup = super.getPopupMenu(bdl);
        menuPopup.add((Action)this.m_actOpen);
        menuPopup.add((Action)this.m_actViewJob);
        menuPopup.add((Action)this.m_actViewSource);
        menuPopup.addSeparator();
        menuPopup.add((Action)this.m_actSubmitJob);
        return menuPopup;
    }

    public boolean isJobRunning() {
        String sStatus = WsJobSubmissionManager.getInstance().getWsServerRequestStatus(this.getFQID());
        return WsServerRequest.JOBRUNNING.equals(sStatus);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actSubmitJob.setActive(bActive);
        this.m_actViewJob.setActive(bActive);
        SubmitType.getInstance().setActive(bActive);
        this.m_actViewSource.setActive(bActive);
    }

    public void doDefaultAction() {
        this.open();
    }

    public void delete() {
        OperationUIAdapter opUI = new OperationUIAdapter((WsMessageDisplayer)Workspace.getWorkspace().getStatusBar());
        this.delete(opUI);
    }

    public void onSubmitJob() {
        WsEditorOMAView view = this.showProcessView();
        if (view != null) {
            view.getEditorTab().submitCode();
        }
    }

    private void open() {
        WsViewFactory.showNewView((String)this.getFQID(), (String)this.getType(), (String)this.getName(), JobEditorView.class);
    }

    public void onViewJob() {
        this.showProcessView();
    }

    public void onViewSource() {
        WsEditorOMAView view = this.showProcessView();
        if (view != null) {
            view.showEditorTab();
        }
    }

    protected WsEditorOMAView showProcessView() {
        Job oJob = JobTreeNode.createJobObject(this.m_oMetadata, "ProcessView");
        try {
            if (!Workspace.isJobReadableByApplicationVersion((Job)oJob)) {
                return null;
            }
            if (!MacroPluginUtilities.isJobUpToDate(this.m_oMetadata) && !MacroPluginUtilities.promptToUpdateTransformsInJob(this.m_oMetadata)) {
                return null;
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        WsEditorOMAView view = (WsEditorOMAView)WsViewFactory.findExistingView((CMetadata)oJob, (String)WAPFDEditorOMAView.class.getName());
        if (view != null) {
            try {
                oJob.getObjectStore().dispose();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            WsViewFactory.showExistingView((WsOMAView)view);
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            return view;
        }
        view = new WAPFDEditorOMAView(oJob);
        WASplittablePropertyFrame frame = new WASplittablePropertyFrame((CMetadata)oJob, "");
        WsViewFactory.attachViewToFrame((CMetadata)oJob, (WorkspaceOMAView)view, (WAPropertyFrame)frame);
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        try {
            List archivedSteps = MacroPluginUtilities.getArchivedTransforms(oJob);
            if (!archivedSteps.isEmpty()) {
                this.showCheckToIgnoreDialog(false, bundle.getString("JobTreeNode.TransformsArchived.Title.txt"), bundle.getString("JobTreeNode.TransformsArchived.txt"), "Workspace.ArchivedTransformWarningDialog.show", archivedSteps);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return view;
    }

    public WsOMAView onProperties() {
        WsOMAView newView = this.getPropertyView(this.m_oMetadata, this.m_sViewPrefix, this.m_sViewPostfix, this.getClass().getClassLoader());
        if (newView == null) {
            return super.onProperties();
        }
        return newView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WsOMAView getPropertyView(CMetadata oMetadata, String viewPrefix, String viewPostfix, ClassLoader classLoader) {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                CMetadata oDetail = factory.createComplexMetadataObject(store, null, oMetadata.getName(), oMetadata.getCMetadataType(), oMetadata.getId(), null);
                WsEditorOMAView view = (WsEditorOMAView)WsViewFactory.findExistingView((CMetadata)oDetail, (String)WAPFDEditorOMAView.class.getName());
                if (view == null) return null;
                oDetail = view.getMetadata();
                MdObjectStore store2 = factory.createObjectStore(oDetail.getObjectStore());
                CMetadata oDetail2 = factory.createComplexMetadataObject(store2, null, oMetadata.getName(), oMetadata.getCMetadataType(), oMetadata.getId(), null);
                WsOMAView wsOMAView = WsViewFactory.showPropertyView((CMetadata)oDetail2, (String)viewPrefix, (String)viewPostfix, (ClassLoader)classLoader);
                return wsOMAView;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public static WsEditorOMAView showProcessView(CMetadata object) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        Job oJob = JobTreeNode.createJobObject(object, "ProcessView");
        WsEditorOMAView view = (WsEditorOMAView)WsViewFactory.findExistingView((CMetadata)oJob, (String)WAPFDEditorOMAView.class.getName());
        if (view != null) {
            try {
                oJob.getObjectStore().dispose();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            WsViewFactory.showExistingView((WsOMAView)view);
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            return view;
        }
        view = new WAPFDEditorOMAView(oJob);
        WsViewFactory.attachViewToFrame((CMetadata)oJob, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oJob, ""));
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        return view;
    }

    public static WsEditorOMAView showNewProcessView(CMetadata object) {
        Job oJob = JobTreeNode.createJobObject(object, "ProcessView");
        WAPFDEditorOMAView view = new WAPFDEditorOMAView(oJob);
        WsViewFactory.attachViewToFrame((CMetadata)oJob, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oJob, ""));
        return view;
    }

    public static WsEditorOMAView showNewProcessView(CMetadata object, String storeName) {
        Job oJob = JobTreeNode.createJobObject(object, storeName);
        WAPFDEditorOMAView view = new WAPFDEditorOMAView(oJob);
        WsViewFactory.attachViewToFrame((CMetadata)oJob, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oJob, ""));
        return view;
    }

    public static WsEditorOMAView showNewProcessView(CMetadata object, ArrayList outputTables) {
        Job oJob = JobTreeNode.createJobObject(object, "ProcessView");
        WAPFDEditorOMAView view = new WAPFDEditorOMAView(oJob, outputTables);
        WsViewFactory.attachViewToFrame((CMetadata)oJob, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oJob, ""));
        return view;
    }

    private static Job createJobObject(CMetadata oMetadata, String storeName) {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore(null, storeName);
            store.setIsObjectCopiedFromParentOnCreation(false);
            return (Job)factory.createComplexMetadataObject(store, oMetadata);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private void updateIcon() {
        this.setIcon(this.getDecoratedIcon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getDecoratedIcon() {
        Icon icon = ICON_NORMAL;
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                boolean bDeployed;
                Job job = (Job)Workspace.getMdFactory().createComplexMetadataObject(store, this.m_oMetadata);
                String template = "<Templates><Job><JFJobs/><SourceTransformations/><TransformationSources/></Job><ClassifierMap TransformRole=\"\"></ClassifierMap></Templates>";
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)job, null, null, template, 8452);
                boolean bl = bDeployed = !job.getJFJobs().isEmpty();
                if (!bDeployed) {
                    AssociationList lSources = job.getTransformationSources();
                    for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                        if (!(lSources.get(iSource) instanceof ClassifierMap)) continue;
                        bDeployed = true;
                        break;
                    }
                }
                ParametersModel parmModel = new ParametersModel((Root)job);
                boolean bParameters = parmModel.isParameterizedObject();
                if (bDeployed && bParameters) {
                    icon = ICON_PARAMSDEPLOYED;
                } else if (bDeployed) {
                    icon = ICON_DEPLOYED;
                } else if (bParameters) {
                    icon = ICON_PARAMS;
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return icon;
    }

    @Override
    public void updateMetadata(CMetadata oMetadata) {
        this.updateIcon();
        super.updateMetadata(oMetadata);
    }

    protected boolean isProjectObject(CMetadata iObject) {
        try {
            String sReposID = "A0000001." + iObject.getId().substring(0, 8);
            IOMI iOMI = Workspace.getWorkspace().getCMRHandle();
            String sReposType = WsRepositoryUtil.getRepositoryType((IOMI)iOMI, (String)sReposID);
            return sReposType.equals("PROJECT");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isCubeJob() {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                Job oData = (Job)factory.createComplexMetadataObject(store, this.m_oMetadata);
                Vector inSimpleAttr = new Vector();
                Vector<String> inXMLComplex = new Vector<String>();
                String temp = "";
                inXMLComplex.add("JobActivities");
                temp = "<Templates><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep><ClassifierMap><ClassifierTargets/></ClassifierMap></Templates>";
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oData, inSimpleAttr, inXMLComplex, temp, 28);
                AssociationList jobActivities = oData.getJobActivities(false);
                if (jobActivities.size() <= 0) return false;
                TransformationActivity transActivities = (TransformationActivity)jobActivities.get(0);
                AssociationList iSteps = transActivities.getSteps(false);
                if (iSteps.size() <= 0) return false;
                TransformationStep step = (TransformationStep)iSteps.get(0);
                AssociationList iTrans = step.getTransformations(false);
                if (iTrans.size() <= 0) return false;
                Transformation iCMaps = (Transformation)iTrans.get(0);
                if (!(iCMaps instanceof ClassifierMap)) return false;
                AssociationList ctargets = ((ClassifierMap)iCMaps).getClassifierTargets(false);
                if (ctargets.size() <= 0) return false;
                CMetadata object = (CMetadata)ctargets.get(0);
                if (!object.getCMetadataType().equals("Cube")) return false;
                boolean bl = true;
                return bl;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                return false;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isAnyJobInJob(String sMessageKey) {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                Job oData = (Job)factory.createComplexMetadataObject(store, this.m_oMetadata);
                Vector inSimpleAttr = new Vector();
                Vector<String> inXMLComplex = new Vector<String>();
                String temp = "";
                inXMLComplex.add("Steps");
                temp = "<Templates></Templates>";
                factory.getOMIUtil().getMetadataAllDepths((CMetadata)oData, inSimpleAttr, inXMLComplex, temp, 28);
                if (!oData.getSteps().isEmpty()) {
                    String message = null;
                    message = oData.getName().length() == 0 ? bundle.getString("Common.JobUseInJobNoDelete.Text") : bundle.formatString(sMessageKey, (Object)oData.getName());
                    MessageUtil.displayMessage((String)message, (int)2);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                return false;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    public boolean isReallyDeleteable() {
        if (this.isCubeJob()) {
            try {
                int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("JobTreeNode.CubeDeleteWarning.fmt", (Object)this.m_oMetadata.getName()), (int)2, (int)0);
                return eAnswer == 0;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return this.isAnyJobInJob("Common.JobUseInJobNoDelete.Text.fmt");
    }

    public boolean isReallyCMDeleteable() {
        if (this.isCubeJob()) {
            try {
                String sChangeState = ((Root)this.m_oMetadata).getChangeState();
                if (sChangeState.equals("")) {
                    int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("JobTreeNode.CubeDeleteWarning.fmt", (Object)this.m_oMetadata.getName()), (int)2, (int)0);
                    return eAnswer == 0;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
        }
        return true;
    }

    public boolean isReallyDestroyable() {
        if (this.isCubeJob()) {
            try {
                MessageUtil.displayMessage((String)bundle.formatString("JobTreeNode.CMDestroyWarning.fmt", (Object)this.m_oMetadata.getName()), (int)2, (int)-1);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return true;
    }

    protected WsAbstractAction createSubmitJobAction() {
        return new cSubmitJobAction();
    }

    protected WsAbstractAction createViewJobAction() {
        return new cViewJobAction();
    }

    protected WsAbstractAction createViewSourceAction() {
        return new cViewSourceAction();
    }

    public void showCheckToIgnoreDialog(boolean bIgnoreSetting, String sTitle, String sMessageText, String sKey, List steps) {
        WorkspaceFile AppDefs;
        if (!bIgnoreSetting && !(AppDefs = Workspace.getWorkspace().getAppDefaultsFile()).getPropertyBoolean(sKey, true)) {
            return;
        }
        cArchivedTransformDialog s_dlgCheckBoxMessage = new cArchivedTransformDialog(null, sTitle, sMessageText, sKey, steps);
        s_dlgCheckBoxMessage.doShow(bIgnoreSetting);
    }

    private class OpenAction
    extends WsAbstractAction {
        public OpenAction() {
            this.setText("Open new Job Editor");
            this.setMnemonic('o');
        }

        public void actionPerformed(ActionEvent ev) {
            JobTreeNode.this.open();
        }
    }

    protected class cSubmitJobAction
    extends WsAbstractAction {
        public cSubmitJobAction() {
            super(bundle, "Tree.PopupMenu.SubmitJob", true);
            this.setMenuSupportId("submit");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            JobTreeNode.this.onSubmitJob();
        }
    }

    protected class cViewJobAction
    extends WsAbstractAction {
        public cViewJobAction() {
            super(bundle, "Tree.PopupMenu.ViewJob");
            this.setMenuSupportId("viewjob");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            JobTreeNode.this.onViewJob();
        }
    }

    protected class cViewSourceAction
    extends WsAbstractAction {
        public cViewSourceAction() {
            super(bundle, "Tree.PopupMenu.ViewSource");
            this.setMenuSupportId("viewjobsource");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            JobTreeNode.this.onViewSource();
        }
    }

    private class cArchivedTransformDialog
    extends WsCheckToIgnoreDialog {
        private List m_steps;

        public cArchivedTransformDialog(Frame frmOwner, String sTitle, String sMessageText, String sKey, List steps) {
            super(frmOwner, sTitle, sMessageText, sKey);
            this.m_steps = steps;
        }

        protected void initialize() {
            super.initialize();
            ((cPanel)this.getMainPanel()).setArchivedSteps(this.m_steps);
        }

        protected WAPanel createMainPanel() {
            return new cPanel();
        }

        protected class cPanel
        extends WsCheckToIgnoreDialog.cMainPanel {
            private WsTable m_table;
            private cArchivedTableModel m_model;
            private JScrollPane scroller;

            protected cPanel() {
                super((WsCheckToIgnoreDialog)cArchivedTransformDialog.this);
            }

            protected void initialize() {
                super.initialize();
                this.m_model = new cArchivedTableModel();
                this.m_table = new WsTable((WsAbstractTableModel)this.m_model);
                this.m_table.setColumnHeaderVisible(true);
                this.m_table.setColumnHeaderPopupMenuEnabled(false);
                this.m_table.setColumnsReorderable(false);
                this.m_table.setRowHeaderVisible(false);
                this.setPreferredSize(new Dimension(500, 300));
                this.m_table.restoreSettings("JobTreeNode.ArchiveTransformTable");
            }

            protected void layoutWidgets() {
                this.scroller = new JScrollPane((Component)this.m_table);
                this.scroller.setVerticalScrollBarPolicy(20);
                this.setLayout(new GridBagLayout());
                this.add((Component)this.m_fullText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.scroller, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.m_ckbDisable, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            }

            public void setArchivedSteps(List steps) {
                this.m_model.setArchivedSteps(steps);
                this.m_model.moveDataToModel();
            }

            public void saveSettingsAndCleanUp() {
                this.m_table.saveSettings("JobTreeNode.ArchiveTransformTable");
                super.saveSettingsAndCleanUp();
            }

            private class cArchivedTableModel
            extends WsAbstractTableModel {
                public cArchivedTableModel() {
                    this.createColumnDefinitions();
                }

                public void setArchivedSteps(List steps) {
                    cArchivedTransformDialog.this.m_steps = steps;
                }

                public void createColumnDefinitions() {
                    this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
                    WsStringTableColumn oldTStep_Col = new WsStringTableColumn(0, bundle.getString("cArchivedTableModel.StepInJob.txt"), 110);
                    oldTStep_Col.setEditable(false);
                    this.m_aColumns[0] = oldTStep_Col;
                    WsStringTableColumn newTransform_Col = new WsStringTableColumn(1, bundle.getString("cArchivedTableModel.NewTransformName.txt"), 110);
                    newTransform_Col.setEditable(false);
                    this.m_aColumns[1] = newTransform_Col;
                    WsStringTableColumn newTransformLocation_Col = new WsStringTableColumn(2, bundle.getString("cArchivedTableModel.NewTransformLocation.txt"), 240);
                    newTransformLocation_Col.setEditable(false);
                    this.m_aColumns[2] = newTransformLocation_Col;
                }

                public int getColumnCount() {
                    return 3;
                }

                public int getHiddenColumnCount() {
                    return 0;
                }

                public void moveDataToStore() {
                }

                public void moveDataToModel() {
                    int nRows = this.m_lData.size();
                    if (nRows > 0) {
                        this.m_lData.clear();
                        this.fireTableRowsDeleted(0, nRows - 1);
                    }
                    nRows = 0;
                    for (int iKey = 0; iKey < cArchivedTransformDialog.this.m_steps.size(); ++iKey) {
                        try {
                            TransformInterface replacement = MacroPluginUtilities.getReplacingTransformInterface((TransformationStep)cArchivedTransformDialog.this.m_steps.get(iKey));
                            ArrayList alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                            alRow.add(cArchivedTransformDialog.this.m_steps.get(iKey));
                            alRow.add(replacement.getName());
                            alRow.add(replacement.getCategory());
                            this.m_lData.add(alRow);
                            ++nRows;
                            continue;
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            continue;
                        }
                        catch (RemoteException re) {
                            Workspace.handleRemoteException((RemoteException)re);
                        }
                    }
                    if (nRows > 0) {
                        this.fireTableRowsInserted(0, nRows - 1);
                    }
                    this.m_nRowInstances = nRows;
                }

                public void populateStore() {
                }
            }
        }
    }

    private class SetIconRunnable
    implements Runnable {
        private Icon m_icon;

        public SetIconRunnable(Icon icon) {
            this.m_icon = icon;
        }

        @Override
        public void run() {
            JobTreeNode.this.setIcon(this.m_icon);
        }
    }
}

