/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.wadmin.visuals.DocumentsPaneUsingMetadata;
import com.sas.wadmin.visuals.NotesPaneUsingMetadata;
import com.sas.wadmin.visuals.common.PrivateNotePane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class JOMANotesTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(JOMANotesTab.class);
    private Root m_oMetadata;
    private WsAbstractAction m_actDelete;
    private PrivateNotePane m_pnlPrivateNote;
    private NotesPaneUsingMetadata m_pnlNotes;
    private DocumentsPaneUsingMetadata m_pnlDocuments;
    private static String PRIVATE_NOTES_ROLE = "Note";

    public JOMANotesTab(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.setName(bundle.getString("NotesTab.Title.txt"));
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("notestab");
    }

    public boolean validateData() {
        if (!this.m_pnlPrivateNote.validateData()) {
            return false;
        }
        if (!this.m_pnlNotes.validateData()) {
            return false;
        }
        return this.m_pnlDocuments.validateData();
    }

    public void moveDataToView() {
        try {
            TextStore oNote = this.getPrivateNote();
            if (oNote != null) {
                this.m_pnlPrivateNote.setContents(oNote.getStoredText());
            }
            this.m_pnlPrivateNote.doDataExchange(false);
            this.m_pnlNotes.doDataExchange(false);
            this.m_pnlDocuments.doDataExchange(false);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    private TextStore getPrivateNote() {
        try {
            if (this.m_oMetadata.getNotes().size() > 0) {
                AssociationList lNotes = this.m_oMetadata.getNotes();
                for (int t = 0; t < lNotes.size(); ++t) {
                    TextStore oOurPossiblePrivateNote = (TextStore)lNotes.get(t);
                    if (!oOurPossiblePrivateNote.getTextRole().equalsIgnoreCase(PRIVATE_NOTES_ROLE)) continue;
                    return oOurPossiblePrivateNote;
                }
            }
            return null;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        return null;
    }

    public void moveDataToStore() {
        try {
            this.m_oMetadata.setName(this.m_oMetadata.getName());
            String sNote = this.m_pnlPrivateNote.getContents();
            TextStore note = this.getPrivateNote();
            if (sNote == null || sNote.trim().length() == 0) {
                if (note != null) {
                    ((MdObjectStore)this.m_oMetadata.getObjectStore()).removeObjectFromStore((CMetadata)note, null);
                }
            } else if (note == null) {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                TextStore oDoc = (TextStore)factory.createComplexMetadataObject((MdObjectStore)this.m_oMetadata.getObjectStore(), "PrivateNote", "TextStore", this.m_oMetadata.getRepositoryID());
                oDoc.setStoredText(sNote);
                oDoc.setTextRole(PRIVATE_NOTES_ROLE);
                this.m_oMetadata.getNotes().add((Object)oDoc);
            } else {
                note.setStoredText(sNote);
            }
            this.m_pnlPrivateNote.doDataExchange(true);
            this.m_pnlNotes.doDataExchange(true);
            this.m_pnlDocuments.doDataExchange(true);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlPrivateNote.saveSettingsAndCleanUp();
        this.m_pnlNotes.saveSettingsAndCleanUp();
        this.m_pnlDocuments.saveSettingsAndCleanUp();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.m_actDelete == null) {
            this.m_actDelete = this.m_pnlNotes.getDeleteAction();
        }
        this.m_actDelete.setActive(bActive);
        this.m_pnlPrivateNote.updateWorkspaceUIComponents(bActive);
        this.m_pnlNotes.updateWorkspaceUIComponents(bActive);
        this.m_pnlDocuments.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlPrivateNote.setEditable(bEditable);
        this.m_pnlNotes.setEditable(bEditable);
        this.m_pnlDocuments.setEditable(bEditable);
    }

    protected void initialize() {
        this.m_pnlPrivateNote = new PrivateNotePane();
        this.m_pnlNotes = new NotesPaneUsingMetadata(this.m_oMetadata);
        this.m_pnlDocuments = new DocumentsPaneUsingMetadata(this.m_oMetadata);
        this.listenForDataChangesTo(this.m_pnlPrivateNote);
        this.listenForDataChangesTo(this.m_pnlNotes);
        this.listenForDataChangesTo(this.m_pnlDocuments);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_pnlNotes.setPreferredSize(new Dimension(550, 200));
        this.m_pnlDocuments.setPreferredSize(new Dimension(550, 200));
        this.add((Component)((Object)this.m_pnlPrivateNote), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlNotes), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlDocuments), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

