/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.wadmin.visuals.DBMSLibraryConnectWizardTab;
import com.sas.wadmin.visuals.DefineTablesWizardTab;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.plugins.MultipleNodeInterface;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JDBCImporter
extends SASImporter
implements MultipleNodeInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(JDBCImporter.class);
    private ArrayList m_NameList;
    private ArrayList m_ToolTipList;
    private ArrayList m_DescriptionsList;
    private ArrayList m_ImageIconList;

    @Override
    public void initPlugin() {
        super.initPlugin();
        this.m_LIBRARY_TAB = "SASImportertab1";
        this.m_TABLES_TAB = "SASImportertab2";
        String[][] standardTransitionList = new String[][]{{this.m_LIBRARY_TAB, "NEXT", this.m_TABLES_TAB}, {this.m_TABLES_TAB, "NEXT", "SASImportertab4"}};
        this.m_transitionList = standardTransitionList;
        this.m_name = bundle.getString("JDBCImporter.pluginname.txt");
        this.m_tooltip = bundle.getString("JDBCImporter.ToolTip.txt");
    }

    @Override
    public boolean initializeWizard(WAWizardDialog wizardDialog, WATransitionWizardModel wizardModel) {
        this.m_wizardDialog = wizardDialog;
        this.m_wizardModel = wizardModel;
        this.createLibraryTab();
        this.createTablesTab();
        this.createFinishTab();
        this.m_wizardModel.addTransitions(this.getTransitions());
        this.setTransitionsAdded(true);
        return true;
    }

    @Override
    public String getCategory() {
        return bundle.getString("JDBCImporter.FolderName.DatabaseSources.txt");
    }

    @Override
    public void setTabProperty(int tabConstant, String propertyName, Object propertyValue) {
        switch (tabConstant) {
            case 1: {
                this.m_libraryTab.setTabProperty(propertyName, propertyValue);
                break;
            }
            case 2: {
                this.m_tablesTab.setTabProperty(propertyName, propertyValue);
                break;
            }
            case 4: {
                this.m_finishTab.setTabProperty(propertyName, propertyValue);
            }
        }
    }

    public ArrayList getDescriptions() {
        return null;
    }

    public ArrayList getIcons() {
        return null;
    }

    public ArrayList getToolTips() {
        return null;
    }

    public ArrayList getNames() {
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public boolean isEngineSupported(String engineName) {
        if (engineName == null) {
            return false;
        }
        return engineName.equalsIgnoreCase("sasiojdb");
    }

    public void updateEngineName(WAWizardDialog wizardDialog) {
        String nodeName = (String)wizardDialog.getWizardData("SELECTEDNODE");
        if (nodeName.equalsIgnoreCase(bundle.getString("JDBCImporter.Name.JDBC.txt"))) {
            this.m_strEngine = bundle.getString("JDBCImporter.description.JDBC.notrans");
        }
        wizardDialog.addWizardData("ENGINETYPE", (Object)this.m_strEngine);
    }

    @Override
    protected void createLibraryTab() {
        ImageIcon image = bundle.getImageIcon("SourceDesigner.ConnectInfo.image");
        this.m_libraryTab = new DBMSLibraryConnectWizardTab("SASIOJDBC", bundle.getString("JDBCConnectWizardTab.Description.txt"));
        this.m_libraryTab.setEngineType("SASIOJDB");
        this.m_wizardDialog.addTab(bundle.getString("JDBCConnectWizardTab.Title.txt"), this.m_LIBRARY_TAB, (WAPropertyTab)this.m_libraryTab, "wa_source_connectInfo.gif", (Icon)image, false);
    }

    @Override
    protected void createTablesTab() {
        ImageIcon image = bundle.getImageIcon("SourceDesigner.SelectTable.image");
        this.m_tablesTab = new DefineTablesWizardTab();
        this.m_tablesTab.setEngine("SASIOJDB");
        this.m_wizardDialog.addTab(bundle.getString("DefineTablesWizardTab.Title.txt"), this.m_TABLES_TAB, (WAPropertyTab)this.m_tablesTab, "gen_select_table.gif", (Icon)image, false);
    }
}

