/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.IndexCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.UniqueKey;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.model.IndexTreeModel2;
import com.sas.wadmin.model.IndexTreeNode;
import com.sas.wadmin.visuals.IndexTreeCellRenderer;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDefaultClipboardOwner;
import com.sas.workspace.WsDragSourceAdapter;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class IndexTree
extends JTree {
    private static WAdminResource bundle = WAdminResource.getBundle(IndexTree.class);
    public static final String UNIQUE = "Unique";
    public static final String NOMISS = "NoMiss";
    public static final String CLUSTERED = "Clustered";
    public static final String PRIMARY = "Primary";
    protected PhysicalTable m_oTable;
    protected ColumnsTableModel2 m_mdlTable;
    protected IndexTreeModel2 m_mdlIndexes;
    protected UndoManager m_mgrUndo;
    protected WsPopupMenuRequestListener m_lsnrPopupMenuRequest;
    protected boolean m_bDragInProgress;
    protected boolean m_bNonDefaultDND;
    protected IndexTreeNode[] m_aDragNodes;

    public IndexTree(IndexTreeModel2 mdlIndexes, ColumnsTableModel2 mdlTable) {
        super(mdlIndexes);
        this.setUI(this.createUI());
        new DropTarget(this, 3, this.createDropTargetListener(), true);
        this.createDragGestureRecognizer();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.setAutoscrolls(true);
        this.setScrollsOnExpand(true);
        this.setSelectionModel(this.createSelectionModel());
        DefaultTreeCellRenderer rdr = this.createTreeCellRenderer();
        DefaultTreeCellEditor edt = this.createTreeCellEditor(rdr);
        this.setCellRenderer(rdr);
        this.setCellEditor(edt);
        this.m_mdlIndexes = mdlIndexes;
        this.m_mdlTable = mdlTable;
    }

    public boolean isDragInProgress() {
        return this.m_bDragInProgress;
    }

    public void setMetadataTable(PhysicalTable oTable) {
        this.m_oTable = oTable;
    }

    public PhysicalTable getMetadataTable() {
        return this.m_oTable;
    }

    public void setUndoManager(UndoManager mgrUndo) {
        this.m_mgrUndo = mgrUndo;
    }

    public UndoManager getUndoManager() {
        return this.m_mgrUndo;
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getPopupMenuRequestListener() {
        return this.m_lsnrPopupMenuRequest;
    }

    protected void firePopupMenuRequested(MouseEvent e) {
        if (this.m_lsnrPopupMenuRequest != null) {
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    public void addNewIndex() {
        if (!this.stopNodeEditing()) {
            return;
        }
        IndexTreeNode nodeIndex = this.m_mdlIndexes.createIndexNode();
        CompoundEdit ce = new CompoundEdit();
        ce.addEdit(this.createClearSelectionUndoable(false, true));
        ce.addEdit(this.undoableInsertNode(nodeIndex, this.getRoot(), this.m_mdlIndexes.getChildCount(this.m_mdlIndexes.getRoot())));
        ce.addEdit(this.createClearSelectionUndoable(true, false));
        ce.end();
        this.m_mgrUndo.addEdit(ce);
        TreePath pathIndex = new TreePath(nodeIndex.getPath());
        this.setSelectionPath(pathIndex);
        this.scrollPathToVisible(pathIndex);
        this.startEditingAtPath(pathIndex);
    }

    public void renameSelectedIndex() {
        IndexTreeNode nodeIndex = (IndexTreeNode)this.getLastSelectedPathComponent();
        TreePath pathIndex = new TreePath(nodeIndex.getPath());
        this.startEditingAtPath(pathIndex);
    }

    public boolean isIndexSelected() {
        IndexTreeNode nodeIndex = (IndexTreeNode)this.getLastSelectedPathComponent();
        return nodeIndex != null && nodeIndex.isIndex();
    }

    public void setSelectedIndexProperty(String sProperty, Object oNewValue) {
        IndexTreeNode nodeIndex = (IndexTreeNode)this.getLastSelectedPathComponent();
        Object oOldValue = nodeIndex.getProperty(sProperty);
        nodeIndex.setProperty(sProperty, oNewValue);
        this.m_mgrUndo.addEdit(this.createPropertyChangeUndoable(nodeIndex, sProperty, oOldValue, oNewValue));
    }

    public Object getSelectedIndexProperty(String sProperty) {
        IndexTreeNode nodeIndex = (IndexTreeNode)this.getLastSelectedPathComponent();
        return nodeIndex.getProperty(sProperty);
    }

    public void cut() {
        this.copy();
        this.deleteSelectedNodes();
    }

    public void copy() {
        DNDObject clipColumns = new DNDObject();
        TreePath[] aPaths = this.getSelectionPaths();
        int nPaths = aPaths.length;
        for (int iPath = 0; iPath < nPaths; ++iPath) {
            IndexTreeNode nodeColumn = (IndexTreeNode)aPaths[iPath].getLastPathComponent();
            clipColumns.add((Object)nodeColumn.getColumn());
        }
        this.getToolkit().getSystemClipboard().setContents((Transferable)clipColumns, (ClipboardOwner)new WsDefaultClipboardOwner());
    }

    public void paste() {
        List lColumns = this.getListFromTransferable(this.getToolkit().getSystemClipboard().getContents(this));
        if (lColumns == null) {
            return;
        }
        IndexTreeNode nodeSelected = (IndexTreeNode)this.getLastSelectedPathComponent();
        IndexTreeNode nodeIndex = this.getIndexNodeForNode(nodeSelected);
        if (this.validateColumns(lColumns, nodeIndex, true)) {
            int iInsertIndex = this.getInsertIndex(nodeIndex, nodeSelected);
            CompoundEdit ce = new CompoundEdit();
            ce.addEdit(this.createClearSelectionUndoable(false, true));
            ce.addEdit(this.undoableInsertColumns(lColumns, nodeIndex, iInsertIndex));
            ce.addEdit(this.createClearSelectionUndoable(true, false));
            ce.end();
            this.m_mgrUndo.addEdit(ce);
        }
    }

    public void deleteSelectedNodes() {
        UndoableEdit del;
        IndexTreeNode node;
        CompoundEdit ce = new CompoundEdit();
        TreePath[] aPaths = this.getSelectionPaths();
        int nPaths = aPaths.length;
        for (int iPath = 0; iPath < nPaths - 1; ++iPath) {
            node = (IndexTreeNode)aPaths[iPath].getLastPathComponent();
            UndoableEdit del2 = this.undoableRemoveNode(node);
            if (del2 == null) continue;
            ce.addEdit(del2);
        }
        node = (IndexTreeNode)aPaths[nPaths - 1].getLastPathComponent();
        IndexTreeNode nodeToSelect = (IndexTreeNode)node.getNextSibling();
        if (nodeToSelect == null) {
            nodeToSelect = (IndexTreeNode)node.getPreviousSibling();
        }
        if (nodeToSelect == null && !node.isIndex()) {
            nodeToSelect = (IndexTreeNode)node.getParent();
        }
        if ((del = this.undoableRemoveNode(node)) != null) {
            ce.addEdit(del);
            if (nodeToSelect == null) {
                this.clearSelection();
            } else {
                this.setSelectionPath(new TreePath(nodeToSelect.getPath()));
            }
            ce.addEdit(this.createClearSelectionUndoable(true, false));
        }
        ce.end();
        if (del != null) {
            this.m_mgrUndo.addEdit(ce);
        } else {
            ce.end();
        }
    }

    public void moveSelectedColumnsUp() {
        boolean editValid = false;
        CompoundEdit ce = new CompoundEdit();
        ce.addEdit(this.createClearSelectionUndoable(false, true));
        TreePath[] aPaths = this.getSelectionPaths();
        int[] aRows = this.getSelectionRows();
        Arrays.sort(aRows);
        int nRows = aRows.length;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            IndexTreeNode nodeColumn = (IndexTreeNode)this.getPathForRow(aRows[iRow]).getLastPathComponent();
            IndexTreeNode nodeIndex = (IndexTreeNode)nodeColumn.getParent();
            int iColumn = nodeIndex.getIndex(nodeColumn);
            UndoableEdit del = this.undoableRemoveNode(nodeColumn);
            if (del == null) continue;
            editValid = true;
            ce.addEdit(del);
            ce.addEdit(this.undoableInsertNode(nodeColumn, nodeIndex, iColumn - 1));
        }
        if (editValid) {
            ce.addEdit(this.createClearSelectionUndoable(true, false));
        }
        ce.end();
        if (editValid) {
            this.m_mgrUndo.addEdit(ce);
            this.setSelectionPaths(aPaths);
        }
    }

    public void moveSelectedColumnsDown() {
        boolean editValid = false;
        CompoundEdit ce = new CompoundEdit();
        ce.addEdit(this.createClearSelectionUndoable(false, true));
        TreePath[] aPaths = this.getSelectionPaths();
        int[] aRows = this.getSelectionRows();
        Arrays.sort(aRows);
        int nRows = aRows.length;
        for (int iRow = nRows - 1; iRow >= 0; --iRow) {
            IndexTreeNode nodeColumn = (IndexTreeNode)this.getPathForRow(aRows[iRow]).getLastPathComponent();
            IndexTreeNode nodeIndex = (IndexTreeNode)nodeColumn.getParent();
            int iColumn = nodeIndex.getIndex(nodeColumn);
            System.out.println(nodeColumn.getName());
            UndoableEdit del = this.undoableRemoveNode(nodeColumn);
            if (del == null) continue;
            editValid = true;
            ce.addEdit(del);
            ce.addEdit(this.undoableInsertNode(nodeColumn, nodeIndex, iColumn + 1));
        }
        if (editValid) {
            ce.addEdit(this.createClearSelectionUndoable(true, false));
        }
        ce.end();
        if (editValid) {
            this.m_mgrUndo.addEdit(ce);
            this.setSelectionPaths(aPaths);
        }
    }

    public void addColumns(List lColumns) {
        IndexTreeNode nodeSelected = (IndexTreeNode)this.getLastSelectedPathComponent();
        IndexTreeNode nodeIndex = this.getIndexNodeForNode(nodeSelected);
        if (nodeIndex.getIndex() != null) {
            try {
                IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)nodeIndex.getIndex());
                UniqueKey key = indexCG.getPrimaryKeyUsingIndex();
                if (key != null) {
                    MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)nodeIndex.getIndex().getName(), (Object)key.getName()), (int)0);
                    return;
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.validateColumns(lColumns, nodeIndex, false)) {
            int iInsertIndex = this.getInsertIndex(nodeIndex, nodeSelected);
            CompoundEdit ce = new CompoundEdit();
            ce.addEdit(this.createClearSelectionUndoable(false, true));
            ce.addEdit(this.undoableInsertColumns(lColumns, nodeIndex, iInsertIndex));
            ce.addEdit(this.createClearSelectionUndoable(true, false));
            ce.end();
            this.m_mgrUndo.addEdit(ce);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateData() {
        if (!this.stopNodeEditing()) {
            return false;
        }
        boolean bSASTable = false;
        boolean bTeradataTable = false;
        try {
            AssociationList lLibs;
            RelationalSchema rsTblPackage;
            AssociationList lTblPackages = this.m_oTable.getTablePackages();
            if (lTblPackages != null && lTblPackages.size() > 0 && !(bSASTable = (rsTblPackage = (RelationalSchema)lTblPackages.get(0)) instanceof SASLibrary) && (lLibs = rsTblPackage.getUsedByPackages()) != null && lLibs.size() > 0) {
                SASLibrary sasLib = (SASLibrary)lLibs.get(0);
                bSASTable = sasLib.getEngine().equalsIgnoreCase("SASSPDS");
                bTeradataTable = sasLib.getEngine().indexOf("TERADATA") > -1;
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        ArrayList<Column> lSimpleColumns = new ArrayList<Column>();
        IndexTreeNode nodeRoot = this.getRoot();
        int iPrimarys = 0;
        int nIndexes = nodeRoot.getChildCount();
        int iIndex = 0;
        while (iIndex < nIndexes) {
            String sMessage;
            int nColumns;
            IndexTreeNode nodeIndex = (IndexTreeNode)nodeRoot.getChildAt(iIndex);
            if (nodeIndex.getIndex() != null) {
                try {
                    IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)nodeIndex.getIndex());
                    UniqueKey key = indexCG.getPrimaryKeyUsingIndex();
                    if (key != null && !((Boolean)nodeIndex.getProperty(UNIQUE)).booleanValue()) {
                        int answer = MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexUniqueError.txt", (Object)nodeIndex.getIndex().getName(), (Object)key.getName()), (int)1, (int)0);
                        if (answer == 0) {
                            nodeIndex.setProperty(UNIQUE, new Boolean(true));
                            return true;
                        }
                        return false;
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            if ((nColumns = nodeIndex.getChildCount()) == 0) {
                this.setSelectionPath(new TreePath(nodeIndex.getPath()));
                String sMessage2 = bundle.formatString("IndexTree.EmptyIndexError.fmt", (Object)nodeIndex.getName());
                MessageUtil.displayMessage((String)sMessage2, (int)0);
                return false;
            }
            if (nColumns == 1) {
                String sColumn;
                String sIndex;
                IndexTreeNode nodeColumn = (IndexTreeNode)nodeIndex.getChildAt(0);
                Column oColumn = nodeColumn.getColumn();
                if (lSimpleColumns.contains(oColumn)) {
                    this.setSelectionPath(new TreePath(nodeColumn.getPath()));
                    String sMessage3 = bundle.formatString("IndexTree.ColumnInMultipleSimpleIndexes.fmt", (Object)nodeColumn.getName());
                    MessageUtil.displayMessage((String)sMessage3, (int)0);
                    return false;
                }
                lSimpleColumns.add(oColumn);
                if (bSASTable && !(sIndex = nodeIndex.getName()).equals(sColumn = nodeColumn.getName())) {
                    this.setSelectionPath(new TreePath(nodeIndex.getPath()));
                    if (!this.m_mdlIndexes.isIndexNameUnique(sColumn, null)) {
                        sMessage = bundle.formatString("IndexTree.SimpleIndexError.fmt", (Object)sIndex, (Object)sColumn);
                        MessageUtil.displayMessage((String)sMessage, (int)0);
                        return false;
                    }
                    sMessage = bundle.formatString("IndexTree.SimpleIndexError.fmt", (Object)sIndex, (Object)sColumn);
                    int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)2, (int)0);
                    if (eAnswer != 0) {
                        return false;
                    }
                    nodeIndex.setName(sColumn);
                    this.m_mdlIndexes.nodeChanged(nodeIndex);
                }
            } else if (bSASTable) {
                try {
                    String sIndex = nodeIndex.getName();
                    for (int i = 0; i < nColumns; ++i) {
                        IndexTreeNode nodeColumn = (IndexTreeNode)nodeIndex.getChildAt(i);
                        Column oColumn = nodeColumn.getColumn();
                        if (!sIndex.equalsIgnoreCase(oColumn.getSASColumnName())) continue;
                        sMessage = bundle.formatString("IndexTree.InvalidCompositeIndexName.txt", (Object)sIndex);
                        MessageUtil.displayMessage((String)sMessage, (int)0);
                        return false;
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            if (nodeIndex != null && ((Boolean)nodeIndex.getProperty(PRIMARY)).booleanValue()) {
                ++iPrimarys;
            }
            ++iIndex;
        }
        return true;
    }

    protected IndexTreeNode getRoot() {
        return (IndexTreeNode)this.m_mdlIndexes.getRoot();
    }

    protected boolean stopNodeEditing() {
        this.stopEditing();
        return !this.isEditing();
    }

    protected UndoableEdit undoableInsertColumns(List lColumns, IndexTreeNode nodeIndex, int iInsertBefore) {
        this.clearSelection();
        CompoundEdit ce = new CompoundEdit();
        ce.addEdit(this.createClearSelectionUndoable(false, true));
        int nColumns = lColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            Column oColumn = (Column)lColumns.get(iColumn);
            IndexTreeNode nodeColumn = this.m_mdlIndexes.createColumnNode(oColumn);
            ce.addEdit(this.undoableInsertNode(nodeColumn, nodeIndex, iInsertBefore + iColumn));
            this.addSelectionPath(new TreePath(nodeColumn.getPath()));
        }
        ce.end();
        return ce;
    }

    protected UndoableEdit undoableInsertNode(IndexTreeNode nodeChild, IndexTreeNode nodeParent, int iInsert) {
        this.insertNodeImpl(nodeChild, nodeParent, iInsert);
        return this.createInsertNodeUndoable(nodeChild, nodeParent, iInsert);
    }

    protected UndoableEdit undoableRemoveNodes(IndexTreeNode[] aNodes) {
        CompoundEdit ce = new CompoundEdit();
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            ce.addEdit(this.undoableRemoveNode(aNodes[iNode]));
        }
        ce.end();
        return ce;
    }

    protected UndoableEdit undoableRemoveNode(IndexTreeNode node) {
        boolean canDeleteNode = false;
        try {
            Index index = null;
            index = node.isIndex() ? node.getIndex() : this.getIndexNodeForNode(node).getIndex();
            IndexCG indexCG = null;
            UniqueKey key = null;
            if (index != null) {
                indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
                key = indexCG.getPrimaryKeyUsingIndex();
            }
            if (indexCG == null || key == null) {
                canDeleteNode = true;
            } else {
                MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)index.getName(), (Object)key.getName()), (int)0);
            }
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (canDeleteNode) {
            UndoableEdit undo = this.createRemoveNodeUndoable(node);
            this.removeNodeImpl(node);
            return undo;
        }
        return null;
    }

    protected void insertNodeImpl(IndexTreeNode nodeChild, IndexTreeNode nodeParent, int iInsert) {
        this.cancelEditing();
        this.m_mdlIndexes.insertNodeInto(nodeChild, nodeParent, iInsert);
    }

    protected void removeNodeImpl(IndexTreeNode node) {
        this.cancelEditing();
        this.m_mdlIndexes.removeNodeFromParent(node);
    }

    protected List getListFromTransferable(Transferable t) {
        if (t.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
            try {
                return (List)t.getTransferData(DNDObject.dndObjectDataFlavor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected IndexTreeNode getIndexNodeForNode(IndexTreeNode node) {
        if (node.isIndex()) {
            return node;
        }
        return (IndexTreeNode)node.getParent();
    }

    protected int getInsertIndex(IndexTreeNode nodeIndex, IndexTreeNode nodeInsertBefore) {
        if (nodeIndex == nodeInsertBefore) {
            return 0;
        }
        return nodeIndex.getIndex(nodeInsertBefore);
    }

    protected boolean validateColumns(List lColumns, IndexTreeNode nodeIndex, boolean bExternal) {
        try {
            String sTableFQID = this.m_oTable.getFQID();
            int nSourceColumns = lColumns.size();
            for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
                String sColumnTableFQID;
                Object obj = lColumns.get(iSourceColumn);
                if (bExternal && !(obj instanceof Column)) {
                    String sMessage = bundle.getString("IndexTree.InvalidTypeError.txt");
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
                Column oColumn = (Column)obj;
                if (bExternal && !sTableFQID.equals(sColumnTableFQID = oColumn.getTable().getFQID())) {
                    String sMessage = bundle.getString("IndexTree.InvalidTableError.txt");
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
                String sColumnFQID = oColumn.getFQID();
                int nIndexColumns = nodeIndex.getChildCount();
                for (int iIndexColumn = 0; iIndexColumn < nIndexColumns; ++iIndexColumn) {
                    IndexTreeNode nodeColumn = (IndexTreeNode)nodeIndex.getChildAt(iIndexColumn);
                    if (!sColumnFQID.equals(nodeColumn.getColumn().getFQID())) continue;
                    String sMessage = bundle.formatString("IndexTree.DuplicateColumnError.fmt", (Object)nodeColumn.getColumn().getSASColumnName());
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        return true;
    }

    protected DragGestureRecognizer createDragGestureRecognizer() {
        return new cDragGestureRecognizer(new DragSource(), this, 3, this.createDragGestureListener());
    }

    protected DragGestureListener createDragGestureListener() {
        return new cDragGestureListener();
    }

    protected DragSourceListener createDragSourceListener() {
        return new cDragSourceListener();
    }

    protected DropTargetListener createDropTargetListener() {
        return new cDropTargetListener();
    }

    protected TreeUI createUI() {
        return new cIndexTreeUI();
    }

    protected TreeSelectionModel createSelectionModel() {
        return new cSelectionModel();
    }

    protected DefaultTreeCellRenderer createTreeCellRenderer() {
        return new IndexTreeCellRenderer();
    }

    protected DefaultTreeCellEditor createTreeCellEditor(DefaultTreeCellRenderer rdr) {
        WATextField txt = new WATextField();
        txt.setMaxCharacters(60);
        txt.setBorder(UIManager.getBorder("Tree.editorBorder"));
        cCellEditor edt = new cCellEditor((JTextField)txt);
        return new DefaultTreeCellEditor(this, rdr, edt);
    }

    protected DefaultCellEditor createCellEditor(JTextField txt) {
        return new cCellEditor(txt);
    }

    protected cNonDefaultDNDMenu createNonDefaultDNDMenu(List lColumns, IndexTreeNode[] aRemoveNodes) {
        return new cNonDefaultDNDMenu(lColumns, aRemoveNodes);
    }

    protected UndoableEdit createInsertNodeUndoable(IndexTreeNode nodeChild, IndexTreeNode nodeParent, int iInsert) {
        return new cInsertNodeUndoable(nodeChild, nodeParent, iInsert);
    }

    protected UndoableEdit createRemoveNodeUndoable(IndexTreeNode node) {
        return new cRemoveNodeUndoable(node);
    }

    protected UndoableEdit createPropertyChangeUndoable(IndexTreeNode nodeIndex, String sProperty, Object oOldValue, Object oNewValue) {
        return new cPropertyChangeUndoable(nodeIndex, sProperty, oOldValue, oNewValue);
    }

    protected UndoableEdit createNameChangeUndoable(IndexTreeNode nodeIndex, String sOldName, String sNewName) {
        return new cNameChangeUndoable(nodeIndex, sOldName, sNewName);
    }

    protected UndoableEdit createClearSelectionUndoable(boolean bUndo, boolean bRedo) {
        return new cClearSelectionUndoable(bUndo, bRedo);
    }

    protected class cDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        static final int dragThreshold = 5;
        protected static final int ButtonMask = 20;
        protected static final int KeysMask = 3;

        protected cDragGestureRecognizer(DragSource src, Component cmp, int fActions, DragGestureListener lsnrDragGesture) {
            super(src, cmp, fActions, lsnrDragGesture);
        }

        protected int mapDragOperationFromModifiers(MouseEvent e) {
            int fAllModifiers = e.getModifiers();
            if ((fAllModifiers & 0xFFFFFFE8) != 0) {
                return 0;
            }
            int fButtons = fAllModifiers & 0x14;
            if (fButtons == 16 || fButtons == 4) {
                int fKeys = fAllModifiers & 3;
                if (fKeys == 0) {
                    return 2;
                }
                if (fKeys == 3) {
                    return 0x40000000;
                }
                if (fKeys == 2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.events.isEmpty()) {
                int opDrag = this.mapDragOperationFromModifiers(e);
                if (opDrag == 0) {
                    return;
                }
                MouseEvent evtTrigger = (MouseEvent)this.events.get(0);
                Point ptTrigger = evtTrigger.getPoint();
                Point ptCurrent = e.getPoint();
                int dx = Math.abs(ptTrigger.x - ptCurrent.x);
                int dy = Math.abs(ptTrigger.y - ptCurrent.y);
                if (dx > 5 || dy > 5) {
                    this.fireDragGestureRecognized(opDrag, ptTrigger);
                } else {
                    this.appendEvent(e);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.events.clear();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.events.clear();
            if (this.mapDragOperationFromModifiers(e) != 0) {
                this.appendEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.events.clear();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.events.isEmpty()) {
                int dragAction = this.mapDragOperationFromModifiers(e);
                if (dragAction != 0) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(dragAction, ((MouseEvent)this.getTriggerEvent()).getPoint());
                } else {
                    this.events.clear();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class cDragGestureListener
    implements DragGestureListener {
        protected cDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            TreePath[] aPaths;
            if (!IndexTree.this.isEditable()) {
                return;
            }
            InputEvent ie = e.getTriggerEvent();
            if (ie.isControlDown() || ie.isShiftDown()) {
                return;
            }
            if (ie instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)ie;
                Point pt = me.getPoint();
                if (IndexTree.this.getPathForLocation(pt.x, pt.y) == null) {
                    return;
                }
            }
            if ((aPaths = IndexTree.this.getSelectionPaths()) == null) {
                return;
            }
            IndexTreeNode nodeSelected = (IndexTreeNode)aPaths[0].getLastPathComponent();
            if (nodeSelected.isRoot() || nodeSelected.isIndex()) {
                return;
            }
            IndexTree.this.m_bNonDefaultDND = (ie.getModifiers() & 4) == 4;
            IndexTree.this.m_aDragNodes = new IndexTreeNode[aPaths.length];
            DNDObject dragColumns = new DNDObject();
            int nPaths = aPaths.length;
            for (int iPath = 0; iPath < nPaths; ++iPath) {
                IndexTreeNode nodeColumn;
                IndexTree.this.m_aDragNodes[iPath] = nodeColumn = (IndexTreeNode)aPaths[iPath].getLastPathComponent();
                dragColumns.add((Object)nodeColumn.getColumn());
            }
            e.getDragSource().startDrag(e, null, (Transferable)dragColumns, IndexTree.this.createDragSourceListener());
        }
    }

    protected class cDragSourceListener
    extends WsDragSourceAdapter {
        protected cDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            IndexTree.this.m_bNonDefaultDND = false;
            IndexTree.this.m_aDragNodes = null;
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            IndexTree.this.clearSelection();
            e.acceptDrag(0);
            IndexTree.this.m_bDragInProgress = true;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            IndexTree.this.m_bDragInProgress = false;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            WsUIUtilities.autoscrollForDragEvent((DropTargetDragEvent)e);
            IndexTreeNode node = this.getDropTargetNode(e.getLocation());
            if (node == null) {
                e.rejectDrag();
            } else if (IndexTree.this.m_aDragNodes == null) {
                e.acceptDrag(1);
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            List lColumns;
            IndexTree.this.m_bDragInProgress = false;
            Point ptDrop = e.getLocation();
            IndexTreeNode node = this.getDropTargetNode(ptDrop);
            if (node != null && (lColumns = IndexTree.this.getListFromTransferable(e.getTransferable())) != null) {
                boolean bSame;
                boolean bMove;
                boolean bExternal;
                IndexTreeNode nodeIndex = IndexTree.this.getIndexNodeForNode(node);
                int iInsertIndex = IndexTree.this.getInsertIndex(nodeIndex, node);
                if (IndexTree.this.m_bNonDefaultDND) {
                    IndexTree.this.m_bNonDefaultDND = false;
                    boolean bSameIndex = IndexTree.this.m_aDragNodes[0].getParent() == nodeIndex;
                    cNonDefaultDNDMenu mnu = IndexTree.this.createNonDefaultDNDMenu(lColumns, IndexTree.this.m_aDragNodes);
                    mnu.setCopyEnabled(!bSameIndex);
                    mnu.show(IndexTree.this, ptDrop.x, ptDrop.y);
                    e.acceptDrop(e.getDropAction());
                    IndexTree.this.m_aDragNodes = null;
                    return;
                }
                boolean bl = bExternal = IndexTree.this.m_aDragNodes == null;
                if (!bExternal) {
                    bMove = (e.getDropAction() & 2) != 0;
                    bSame = IndexTree.this.m_aDragNodes[0].getParent() == nodeIndex;
                } else {
                    bMove = false;
                    bSame = false;
                }
                if (!(!bExternal && bMove && bSame || IndexTree.this.validateColumns(lColumns, nodeIndex, bExternal))) {
                    e.rejectDrop();
                    return;
                }
                e.acceptDrop(bMove ? 2 : 1);
                CompoundEdit ce = new CompoundEdit();
                ce.addEdit(IndexTree.this.createClearSelectionUndoable(false, true));
                ce.addEdit(IndexTree.this.undoableInsertColumns(lColumns, nodeIndex, iInsertIndex));
                if (bMove) {
                    ce.addEdit(IndexTree.this.undoableRemoveNodes(IndexTree.this.m_aDragNodes));
                }
                ce.addEdit(IndexTree.this.createClearSelectionUndoable(true, false));
                ce.end();
                IndexTree.this.m_mgrUndo.addEdit(ce);
                IndexTree.this.m_aDragNodes = null;
                return;
            }
            e.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        protected IndexTreeNode getDropTargetNode(Point pt) {
            IndexTreeNode node;
            TreePath path = IndexTree.this.getPathForLocation(pt.x, pt.y);
            if (path != null && !(node = (IndexTreeNode)path.getLastPathComponent()).isRoot()) {
                IndexTree.this.setSelectionPath(path);
                return node;
            }
            IndexTree.this.clearSelection();
            return null;
        }
    }

    protected class cIndexTreeUI
    extends BasicTreeUI {
        protected cIndexTreeUI() {
        }

        @Override
        protected MouseListener createMouseListener() {
            return new cMouseHandler();
        }

        public class cMouseHandler
        extends BasicTreeUI.MouseHandler {
            public cMouseHandler() {
                super(cIndexTreeUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!cIndexTreeUI.this.tree.isEnabled()) {
                    return;
                }
                if (cIndexTreeUI.this.tree.isEditing() && !cIndexTreeUI.this.tree.stopEditing()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    this.triggerPopup(e);
                    return;
                }
                if (cIndexTreeUI.this.tree.getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                    cIndexTreeUI.this.tree.requestFocus();
                } else {
                    super.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!cIndexTreeUI.this.tree.isEnabled()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    this.triggerPopup(e);
                    return;
                }
                if (cIndexTreeUI.this.tree.getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                    MouseEvent ePressed = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), false, e.getButton());
                    super.mousePressed(ePressed);
                }
                super.mouseReleased(e);
            }

            protected boolean isPointOnSelectedPath(Point pt) {
                TreePath path = IndexTree.this.getPathForLocation(pt.x, pt.y);
                return path != null && cIndexTreeUI.this.tree.isPathSelected(path);
            }

            protected void triggerPopup(MouseEvent e) {
                TreePath path = IndexTree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && !cIndexTreeUI.this.tree.isPathSelected(path)) {
                    cIndexTreeUI.this.tree.setSelectionPath(path);
                }
                IndexTree.this.firePopupMenuRequested(e);
            }
        }
    }

    protected class cSelectionModel
    extends DefaultTreeSelectionModel {
        protected cSelectionModel() {
        }

        @Override
        public void addSelectionPaths(TreePath[] aPaths) {
            TreeNode node = (IndexTreeNode)IndexTree.this.getLastSelectedPathComponent();
            if (node == null) {
                node = (TreeNode)aPaths[0].getLastPathComponent();
            }
            if (!this.isSelectionValid(aPaths, node.getParent())) {
                this.setSelectionToFirstPath(aPaths);
            } else {
                super.addSelectionPaths(aPaths);
            }
        }

        @Override
        public void setSelectionPaths(TreePath[] aPaths) {
            if (!this.isSelectionValid(aPaths, ((TreeNode)aPaths[0].getLastPathComponent()).getParent())) {
                this.setSelectionToFirstPath(aPaths);
            } else {
                super.setSelectionPaths(aPaths);
            }
        }

        protected boolean isSelectionValid(TreePath[] aPaths, TreeNode nodeParent) {
            int nPaths = aPaths.length;
            for (int iPath = 0; iPath < nPaths; ++iPath) {
                IndexTreeNode nodeTest = (IndexTreeNode)aPaths[iPath].getLastPathComponent();
                if (nodeTest.getParent() == nodeParent) continue;
                return false;
            }
            return true;
        }

        protected void setSelectionToFirstPath(TreePath[] aPaths) {
            TreePath[] aNewPaths = new TreePath[]{aPaths[0]};
            super.setSelectionPaths(aNewPaths);
        }
    }

    protected class cCellEditor
    extends DefaultCellEditor {
        public cCellEditor(JTextField txt) {
            super(txt);
            this.setClickCountToStart(1);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (IndexTree.this.isIndexSelected() && IndexTree.this.getSelectionCount() == 1) {
                return super.isCellEditable(e);
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            String sName = (String)this.getCellEditorValue();
            if (sName.trim().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("IndexTree.NoNameError.txt"), (int)0);
                return false;
            }
            IndexTreeNode nodeSelectedIndex = (IndexTreeNode)IndexTree.this.getLastSelectedPathComponent();
            if (!IndexTree.this.m_mdlIndexes.isIndexNameUnique(sName, nodeSelectedIndex)) {
                MessageUtil.displayMessage((String)bundle.getString("IndexTree.DuplicateNameError.txt"), (int)0);
                return false;
            }
            if (!sName.equals(nodeSelectedIndex.getName())) {
                IndexTree.this.m_mgrUndo.addEdit(IndexTree.this.createNameChangeUndoable(nodeSelectedIndex, nodeSelectedIndex.getName(), sName));
            }
            return super.stopCellEditing();
        }
    }

    protected class cNonDefaultDNDMenu
    extends JPopupMenu {
        WsAbstractAction m_actMove;
        WsAbstractAction m_actCopy;
        WsAbstractAction m_actCancel;
        List m_lColumns;
        IndexTreeNode[] m_aRemoveNodes;

        public cNonDefaultDNDMenu(List lColumns, IndexTreeNode[] aRemoveNodes) {
            this.m_lColumns = lColumns;
            this.m_aRemoveNodes = aRemoveNodes;
            this.m_actMove = this.createMoveAction();
            this.m_actCopy = this.createCopyAction();
            this.m_actCancel = this.createCancelAction();
            this.add((Action)this.m_actMove);
            this.add((Action)this.m_actCopy);
            this.addSeparator();
            this.add((Action)this.m_actCancel);
        }

        public void setCopyEnabled(boolean bEnabled) {
            this.m_actCopy.setEnabled(bEnabled);
        }

        public void setMoveEnabled(boolean bEnabled) {
            this.m_actMove.setEnabled(bEnabled);
        }

        protected WsAbstractAction createCopyAction() {
            return new cCopyAction();
        }

        protected WsAbstractAction createMoveAction() {
            return new cMoveAction();
        }

        protected WsAbstractAction createCancelAction() {
            return new cCancelAction();
        }

        protected class cCopyAction
        extends WsAbstractAction {
            public cCopyAction() {
                super(bundle, "IndexTree.Copy", false, false);
            }

            public void actionPerformed(ActionEvent e) {
                IndexTreeNode nodeDrop = (IndexTreeNode)IndexTree.this.getSelectionPath().getLastPathComponent();
                IndexTreeNode nodeIndex = IndexTree.this.getIndexNodeForNode(nodeDrop);
                int iInsertIndex = IndexTree.this.getInsertIndex(nodeIndex, nodeDrop);
                if (!IndexTree.this.validateColumns(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex, false)) {
                    return;
                }
                CompoundEdit ce = new CompoundEdit();
                ce.addEdit(IndexTree.this.createClearSelectionUndoable(false, true));
                ce.addEdit(IndexTree.this.undoableInsertColumns(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex, iInsertIndex));
                ce.addEdit(IndexTree.this.createClearSelectionUndoable(true, false));
                ce.end();
                IndexTree.this.m_mgrUndo.addEdit(ce);
            }
        }

        protected class cMoveAction
        extends WsAbstractAction {
            public cMoveAction() {
                super(bundle, "IndexTree.Move", false, false);
            }

            public void actionPerformed(ActionEvent e) {
                IndexTreeNode nodeDrop = (IndexTreeNode)IndexTree.this.getSelectionPath().getLastPathComponent();
                IndexTreeNode nodeIndex = IndexTree.this.getIndexNodeForNode(nodeDrop);
                int iInsertIndex = IndexTree.this.getInsertIndex(nodeIndex, nodeDrop);
                if (cNonDefaultDNDMenu.this.m_aRemoveNodes[0].getParent() != nodeIndex && !IndexTree.this.validateColumns(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex, false)) {
                    return;
                }
                CompoundEdit ce = new CompoundEdit();
                ce.addEdit(IndexTree.this.createClearSelectionUndoable(false, true));
                ce.addEdit(IndexTree.this.undoableInsertColumns(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex, iInsertIndex));
                ce.addEdit(IndexTree.this.undoableRemoveNodes(cNonDefaultDNDMenu.this.m_aRemoveNodes));
                ce.addEdit(IndexTree.this.createClearSelectionUndoable(true, false));
                ce.end();
                IndexTree.this.m_mgrUndo.addEdit(ce);
                IndexTree.this.m_mgrUndo.addEdit(ce);
            }
        }

        protected class cCancelAction
        extends WsAbstractAction {
            public cCancelAction() {
                super(bundle, "IndexTree.Cancel", false, false);
            }

            public void actionPerformed(ActionEvent e) {
            }
        }
    }

    protected class cInsertNodeUndoable
    extends AbstractUndoableEdit {
        protected IndexTreeNode m_nodeParent;
        protected IndexTreeNode m_nodeChild;
        protected int m_iInsert;

        public cInsertNodeUndoable(IndexTreeNode nodeChild, IndexTreeNode nodeParent, int iInsert) {
            this.m_nodeParent = nodeParent;
            this.m_nodeChild = nodeChild;
            this.m_iInsert = iInsert;
        }

        @Override
        public void undo() {
            super.undo();
            IndexTree.this.removeNodeImpl(this.m_nodeChild);
        }

        @Override
        public void redo() {
            super.redo();
            IndexTree.this.insertNodeImpl(this.m_nodeChild, this.m_nodeParent, this.m_iInsert);
            IndexTree.this.addSelectionPath(new TreePath(this.m_nodeChild.getPath()));
        }
    }

    class cRemoveNodeUndoable
    extends AbstractUndoableEdit {
        protected IndexTreeNode m_nodeParent;
        protected IndexTreeNode m_nodeChild;
        protected int m_iInsert;

        public cRemoveNodeUndoable(IndexTreeNode node) {
            this.m_nodeChild = node;
            this.m_nodeParent = (IndexTreeNode)node.getParent();
            this.m_iInsert = this.m_nodeParent.getIndex(node);
        }

        @Override
        public void undo() {
            super.undo();
            IndexTree.this.insertNodeImpl(this.m_nodeChild, this.m_nodeParent, this.m_iInsert);
            IndexTree.this.addSelectionPath(new TreePath(this.m_nodeChild.getPath()));
        }

        @Override
        public void redo() {
            super.redo();
            IndexTree.this.removeNodeImpl(this.m_nodeChild);
        }
    }

    protected class cPropertyChangeUndoable
    extends AbstractUndoableEdit {
        protected IndexTreeNode m_nodeIndex;
        protected String m_sProperty;
        protected Object m_oOldValue;
        protected Object m_oNewValue;

        public cPropertyChangeUndoable(IndexTreeNode nodeIndex, String sProperty, Object oOldValue, Object oNewValue) {
            this.m_nodeIndex = nodeIndex;
            this.m_sProperty = sProperty;
            this.m_oOldValue = oOldValue;
            this.m_oNewValue = oNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            this.m_nodeIndex.setProperty(this.m_sProperty, this.m_oOldValue);
            IndexTree.this.clearSelection();
            IndexTree.this.setSelectionPath(new TreePath(this.m_nodeIndex.getPath()));
        }

        @Override
        public void redo() {
            super.redo();
            this.m_nodeIndex.setProperty(this.m_sProperty, this.m_oNewValue);
            IndexTree.this.clearSelection();
            IndexTree.this.setSelectionPath(new TreePath(this.m_nodeIndex.getPath()));
        }
    }

    protected class cNameChangeUndoable
    extends AbstractUndoableEdit {
        protected IndexTreeNode m_nodeIndex;
        protected String m_sOldName;
        protected String m_sNewName;

        public cNameChangeUndoable(IndexTreeNode nodeIndex, String sOldName, String sNewName) {
            this.m_nodeIndex = nodeIndex;
            this.m_sOldName = sOldName;
            this.m_sNewName = sNewName;
        }

        @Override
        public void undo() {
            super.undo();
            this.m_nodeIndex.setName(this.m_sOldName);
            IndexTree.this.clearSelection();
            IndexTree.this.setSelectionPath(new TreePath(this.m_nodeIndex.getPath()));
        }

        @Override
        public void redo() {
            super.redo();
            this.m_nodeIndex.setName(this.m_sNewName);
            IndexTree.this.clearSelection();
            IndexTree.this.setSelectionPath(new TreePath(this.m_nodeIndex.getPath()));
        }
    }

    protected class cClearSelectionUndoable
    extends AbstractUndoableEdit {
        boolean m_bClearOnUndo;
        boolean m_bClearOnRedo;

        public cClearSelectionUndoable() {
            this(true, false);
        }

        public cClearSelectionUndoable(boolean bClearOnUndo, boolean bClearOnRedo) {
            this.m_bClearOnUndo = bClearOnUndo;
            this.m_bClearOnRedo = bClearOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bClearOnUndo) {
                IndexTree.this.clearSelection();
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bClearOnRedo) {
                IndexTree.this.clearSelection();
            }
        }
    }
}

