/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.Feature;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImpactAnalysisUtilities {
    private static final String INVALID = "Invalid";
    private static final String ACTION = "Action";
    private static final String ACTIONS = "Actions";
    private static final String LOOKUP = "Lookup";
    private static final String TRUE = "TRUE";
    public static final int JOB_INDEX = 0;
    public static final int TRANSFORMATIONSTEP_INDEX = 1;
    public static final int COLUMN_INDEX = 2;
    private static WAdminResource bundle = WAdminResource.getBundle(ImpactAnalysisUtilities.class);
    protected static final Icon g_iconIMap = bundle.getImageIcon("ImpactAnalysisUtilities.IMap.image");
    protected static final Icon g_iconEGProject = bundle.getImageIcon("ImpactAnalysisUtilities.Project.image");
    protected static final Icon g_iconMessageQueue = bundle.getImageIcon("RootQueueView.Frame.image");
    protected static final Icon g_iconNonIMap = bundle.getImageIcon("ImpactAnalysisUtilities.NonIMap.image");

    private ImpactAnalysisUtilities() {
    }

    public static List getInvalidValuesValidation(Column oColumn) throws MdException, RemoteException {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (ImpactAnalysisUtilities.isPhysicalTableColumn(oColumn)) {
            return columnList;
        }
        ImpactAnalysisUtilities.populateStore(oColumn);
        AssociationList targetFMList = oColumn.getTargetFeatureMaps();
        for (int iFM = 0; iFM < targetFMList.size(); ++iFM) {
            Column lookupColumn;
            Event invalidEvent;
            PropertySet ps;
            Property actionProperty;
            FeatureMap fm = (FeatureMap)targetFMList.get(iFM);
            if (!fm.getTransformRole().equalsIgnoreCase(INVALID) || (actionProperty = ImpactAnalysisUtilities.getActionProperty(fm)) == null || (ps = ImpactAnalysisUtilities.getAssociatedPropertySet(actionProperty, TRUE)) == null || (invalidEvent = ImpactAnalysisUtilities.getEvent(ps, INVALID)) == null || (lookupColumn = ImpactAnalysisUtilities.getLookupColumn(invalidEvent)) == null) continue;
            columnList.add(lookupColumn);
        }
        return columnList;
    }

    public static List getTransforms(CMetadata oPrototype, String strGUID) throws MdException, RemoteException {
        ArrayList<Root> steps = new ArrayList<Root>();
        String sOptions = "<Templates><Property Name=\"\" DefaultValue=\"\"></Property></Templates><XMLSelect Search=\"@DefaultValue='" + strGUID + "'\"/>";
        List m_metaQuery = new Vector();
        String sRepositoryFQID = "A0000001." + oPrototype.getRepositoryID();
        m_metaQuery = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(oPrototype.getObjectStore(), sRepositoryFQID, "Property", 24972, sOptions);
        for (int i = 0; i < m_metaQuery.size(); ++i) {
            Property property = (Property)m_metaQuery.get(i);
            Root obj = property.getAssociatedObject();
            if (!(obj instanceof TransformationStep)) continue;
            steps.add(property.getAssociatedObject());
        }
        return steps;
    }

    public static Job getJobForTransform(TransformationStep step) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)step.getActivities().get(0);
        return (Job)activity.getJobs().get(0);
    }

    public static List getWhereColumnUsedAsLookup(Column oColumn) throws MdException, RemoteException {
        ArrayList rows = new ArrayList();
        ImpactAnalysisUtilities.populateStore(oColumn);
        AssociationList lookupFMList = oColumn.getSourceFeatureMaps();
        for (int iFM = 0; iFM < lookupFMList.size(); ++iFM) {
            FeatureMap fm = (FeatureMap)lookupFMList.get(iFM);
            if (!fm.getTransformRole().equalsIgnoreCase(LOOKUP)) continue;
            AssociationList lookupEventList = fm.getTransformationSources();
            for (int iEvent = 0; iEvent < lookupEventList.size(); ++iEvent) {
                Event lookupEvent;
                CMetadata object = (CMetadata)lookupEventList.get(iEvent);
                if (!object.getCMetadataType().equals("Event") || (lookupEvent = (Event)lookupEventList.get(iEvent)).getTriggeringTransforms().isEmpty()) continue;
                ClassifierMap cm = (ClassifierMap)lookupEvent.getTriggeringTransforms().get(0);
                AssociationList tsList = cm.getSteps();
                ArrayList<Object> rowValues = new ArrayList<Object>();
                if (tsList.isEmpty()) continue;
                TransformationStep ts = (TransformationStep)tsList.get(0);
                Job job = ImpactAnalysisUtilities.getJobFor(ts);
                rowValues.add(job);
                rowValues.add(ts);
                PropertySet actionPS = ImpactAnalysisUtilities.getPropertySet(lookupEvent, TRUE);
                Property actionProp = ImpactAnalysisUtilities.getProperty(actionPS);
                FeatureMap invalidFM = ImpactAnalysisUtilities.getFeatureMap(actionProp, INVALID);
                if (invalidFM == null) continue;
                Column validatedColumn = ImpactAnalysisUtilities.getTargetColumn(invalidFM);
                if (validatedColumn != null) {
                    rowValues.add(validatedColumn);
                }
                if (job == null || ts == null || validatedColumn == null) continue;
                rows.add(rowValues);
            }
        }
        return rows;
    }

    private static boolean isPhysicalTableColumn(Column oColumn) throws MdException, RemoteException {
        return oColumn.getTable().getCMetadataType().equals("PhysicalTable");
    }

    private static void populateStore(Column oColumn) throws MdException, RemoteException {
        ArrayList<String> lAssociations = new ArrayList<String>();
        StringBuffer sbTemplate = new StringBuffer(100);
        sbTemplate.append("<Templates>");
        lAssociations.add("TargetFeatureMaps");
        lAssociations.add("SourceFeatureMaps ");
        sbTemplate.append("<Column><Table/></Column>");
        sbTemplate.append("<FeatureMap><TransformationTargets/><TransformationSources/><FeatureSources/><FeatureTargets/></FeatureMap>");
        sbTemplate.append("<Property><AssociatedPropertySet/><TargetTransformations/></Property>");
        sbTemplate.append("<PropertySet><OwningObject/><SetProperties/></PropertySet>");
        sbTemplate.append("<Event><SourceTransformations/><TriggeringTransforms/><PropertySets/></Event>");
        sbTemplate.append("<ClassifierMap><Steps/></ClassifierMap>");
        sbTemplate.append("<TransformationStep><Activities/></TransformationStep>");
        sbTemplate.append("<TransformationActivity><Jobs/></TransformationActivity>");
        sbTemplate.append("</Templates>");
        int fFlags = 8460;
        if (ImpactAnalysisUtilities.getUseDependentReposFlag()) {
            fFlags |= 0x4000;
        }
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oColumn, null, lAssociations, sbTemplate.toString(), fFlags);
    }

    private static Property getActionProperty(FeatureMap oFM) throws MdException, RemoteException {
        AssociationList l_tranTargets = oFM.getTransformationTargets();
        for (int iTT = 0; iTT < l_tranTargets.size(); ++iTT) {
            Property prop = (Property)l_tranTargets.get(iTT);
            if (!prop.getName().equalsIgnoreCase(ACTION)) continue;
            return prop;
        }
        return null;
    }

    private static PropertySet getAssociatedPropertySet(Property oProperty, String role) throws MdException, RemoteException {
        AssociationList psList = oProperty.getAssociatedPropertySets();
        for (int i = 0; i < psList.size(); ++i) {
            PropertySet ps = (PropertySet)psList.get(i);
            if (!ps.getName().equalsIgnoreCase(ACTIONS) || !ps.getSetRole().equalsIgnoreCase(role)) continue;
            return ps;
        }
        return null;
    }

    private static Event getEvent(PropertySet oPropertySet, String condition) throws MdException, RemoteException {
        Event event = (Event)oPropertySet.getOwningObject();
        if (event.getCondition().equalsIgnoreCase(condition)) {
            return event;
        }
        return null;
    }

    private static Column getLookupColumn(Event oEvent) throws MdException, RemoteException {
        AssociationList transList = oEvent.getSourceTransformations();
        if (transList.isEmpty()) {
            return null;
        }
        FeatureMap fm = null;
        for (int i = 0; i < transList.size(); ++i) {
            CMetadata trans = (CMetadata)transList.get(i);
            if (trans == null || !(trans instanceof FeatureMap) || !((FeatureMap)trans).getTransformRole().equalsIgnoreCase(LOOKUP)) continue;
            fm = (FeatureMap)trans;
            break;
        }
        if (fm == null) {
            return null;
        }
        AssociationList colList = fm.getFeatureSources();
        if (colList.size() <= 0) {
            return null;
        }
        return (Column)colList.get(0);
    }

    private static Job getJobFor(TransformationStep oTS) throws MdException, RemoteException {
        TransformationActivity ta;
        AssociationList jobList;
        AssociationList taList = oTS.getActivities();
        if (!taList.isEmpty() && !(jobList = (ta = (TransformationActivity)taList.get(0)).getJobs()).isEmpty()) {
            return (Job)jobList.get(0);
        }
        return null;
    }

    private static Property getProperty(PropertySet oPS) throws MdException, RemoteException {
        if (oPS == null) {
            return null;
        }
        AssociationList propList = oPS.getSetProperties();
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getName().equalsIgnoreCase(ACTION)) continue;
            return prop;
        }
        return null;
    }

    private static PropertySet getPropertySet(Event oEvent, String role) throws MdException, RemoteException {
        if (oEvent == null) {
            return null;
        }
        AssociationList psList = oEvent.getPropertySets();
        for (int i = 0; i < psList.size(); ++i) {
            PropertySet ps = (PropertySet)psList.get(i);
            if (!ps.getName().equalsIgnoreCase(ACTIONS) || !ps.getSetRole().equalsIgnoreCase(role)) continue;
            return ps;
        }
        return null;
    }

    private static FeatureMap getFeatureMap(Property oProperty, String role) throws MdException, RemoteException {
        if (oProperty == null) {
            return null;
        }
        AssociationList fmList = oProperty.getTargetTransformations();
        for (int i = 0; i < fmList.size(); ++i) {
            FeatureMap fm;
            CMetadata cm = (CMetadata)fmList.get(i);
            if (!(cm instanceof FeatureMap) || !(fm = (FeatureMap)cm).getTransformRole().equalsIgnoreCase(role)) continue;
            return fm;
        }
        return null;
    }

    private static Column getTargetColumn(FeatureMap oFM) throws MdException, RemoteException {
        AssociationList colList = oFM.getFeatureTargets();
        if (colList.size() == 1) {
            return (Column)colList.get(0);
        }
        return null;
    }

    public static Icon getCubeTypeIcon(String type) {
        if (type.equalsIgnoreCase("InformationMap")) {
            return g_iconIMap;
        }
        if (type.equalsIgnoreCase("Project")) {
            return g_iconEGProject;
        }
        if (type.equalsIgnoreCase("SASMessageQueue")) {
            return g_iconMessageQueue;
        }
        return g_iconNonIMap;
    }

    public static List getCubesForFeature(Feature oFeature) throws MdException, RemoteException {
        Dimension oDim;
        Level oLevel;
        AssociationList lCubes = new ArrayList();
        if (oFeature instanceof Measure) {
            lCubes = ((Measure)oFeature).getCubes();
        } else if (oFeature instanceof Level) {
            Dimension oDim2 = ((Level)oFeature).getOwningDimension();
            if (oDim2 != null) {
                lCubes = oDim2.getCubes();
            }
        } else if (oFeature instanceof OLAPProperty && (oLevel = ((OLAPProperty)oFeature).getAssociatedLevel()) != null && (oDim = oLevel.getOwningDimension()) != null) {
            lCubes = oDim.getCubes();
        }
        return lCubes;
    }

    protected static boolean getUseDependentReposFlag() {
        return true;
    }

    public static ImageIcon getIconForBILineage(CMetadata metadataObject) throws MdException, RemoteException {
        String sType = metadataObject.getDesc();
        if (metadataObject instanceof Feature) {
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.DataItem.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.DataItem.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Section.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Section.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Filter.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Filter.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Num_Column.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Num_Column.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Char_Column.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Char_Column.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Hierarchy.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Hierarchy.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Measure.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Measure.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.Join.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Join.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Feature.Description.StoredProcess.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.StoredProcess.image");
            }
        } else if (metadataObject instanceof Group) {
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Group.Description.InfoMap.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.InfoMap.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Group.Description.Report.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Report.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Group.Description.Table.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Table.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Group.Description.Cube.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.Cube.image");
            }
            if (sType.equalsIgnoreCase(bundle.getString("ImpactAnalysisUtilities.Group.Description.StoredProcess.txt.notrans"))) {
                return bundle.getImageIcon("ImpactAnalysisUtilities.BILineage.StoredProcess.image");
            }
        }
        return null;
    }
}

