/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.model.tree.TempLogicalObjectNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DocumentTreeNode
extends TempLogicalObjectNode {
    private static WAdminResource bundle = WAdminResource.getBundle(DocumentTreeNode.class);
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private WsAbstractAction m_actViewData = this.createViewDataAction();

    public DocumentTreeNode(CMetadata oMetadata) {
        super(oMetadata);
    }

    public JPopupMenu getPopupMenu(WAdminResource bundleLocal) {
        JPopupMenu menuPopup = super.getPopupMenu(bundleLocal);
        menuPopup.add(new JMenuItem((Action)this.m_actViewData));
        return menuPopup;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actViewData.setActive(bActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onViewData() {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                Document mdoDocument = (Document)factory.createComplexMetadataObject(store, this.getMetadata());
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoDocument, null, null, "", 264);
                DocumentTreeNode.displayURL(mdoDocument.getURI());
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected WsAbstractAction createViewDataAction() {
        return new cViewDataAction();
    }

    public static void displayURL(String url) {
        boolean windows = DocumentTreeNode.isWindowsPlatform();
        String runTimeCommandFmt = null;
        runTimeCommandFmt = windows ? "rundll32 url.dll,FileProtocolHandler {0}" : "netscape -remote openURL({0})";
        MessageFormat fmt = new MessageFormat(runTimeCommandFmt);
        String runTimeCommand = fmt.format(new Object[]{url});
        try {
            Runtime.getRuntime().exec(runTimeCommand);
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getMessage(), (String)bundle.getString("Tree.ViewDocument.FileError.title.txt"), (int)0, (int)-1);
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    private class cViewDataAction
    extends WsAbstractAction {
        public cViewDataAction() {
            super(bundle, "Tree.PopupMenu.ViewData");
            this.setMenuSupportId("viewdata");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            DocumentTreeNode.this.onViewData();
        }
    }
}

