/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.visuals.util.XMLCommandEvent;
import com.sas.wadmin.efi2.ImportCobolCopyBookPanel;
import com.sas.wadmin.pfd.PFDOptionsTab;
import com.sas.wadmin.viewdata2.ViewDataGlobalOptionsTab;
import com.sas.wadmin.visuals.CodeConditionConfigPanel;
import com.sas.wadmin.visuals.EditorOptionsPropertyTab;
import com.sas.wadmin.visuals.GeneralOptionsPropertyTab;
import com.sas.wadmin.visuals.ImpactAnalysisOptionsPropertyTab;
import com.sas.wadmin.visuals.JobStatusView;
import com.sas.wadmin.visuals.MacroPluginWizard;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.wadmin.visuals.SASCodeGenerationOptionsPropertyTab;
import com.sas.wadmin.visuals.ServerOptionsPropertyTab;
import com.sas.wadmin.visuals.WAdminTreeObject;
import com.sas.workspace.CustomDesktop;
import com.sas.workspace.MenuCommandListener;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WorkspaceTreeObject;
import com.sas.workspace.WsTipOfDayDialog;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.visuals.WsAboutBox;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.rmi.RemoteException;
import javax.swing.JInternalFrame;
import javax.swing.undo.CannotUndoException;

public class DefaultCommandListener
extends MenuCommandListener {
    private static final String FILE_CLOSEALL_CMD = "_closeall_";
    private static final String FILE_NEWOBJECT_CMD = "_newobject_";
    private static final String FILE_NEWWORKSPACE_CMD = "_newworkspace_";
    private static final String FILE_OPENWORKSPACE_CMD = "_openworkspace_";
    private static final String FILE_EXIT_CMD = "_exit_";
    private static final String EDIT_UNDO_CMD = "_undo_";
    private static final String EDIT_REDO_CMD = "_redo_";
    private static final String EDIT_CLEARMESSAGE_CMD = "_clearmessage_";
    private static final String VIEW_MESSAGEWINDOW_CMD = "_messagewindow_";
    private static final String VIEW_QUICKPROPERTIES_CMD = "_quickproperties_";
    private static final String VIEW_WAREHOUSETREE_CMD = "_warehousetree_";
    private static final String VIEW_PROJECTSTREE_CMD = "_projectstree_";
    private static final String VIEW_INVENTORYTREE_CMD = "_inventorytree_";
    private static final String VIEW_PROCESSLIBRARYTREE_CMD = "_processlibrarytree_";
    private static final String VIEW_COMPARISONRESULTSTREE_CMD = "_comparisonresultstree_";
    private static final String VIEW_REFRESHALL_CMD = "_refreshall_";
    private static final String TOOLS_EDITOR_CMD = "_editor_";
    private static final String TOOLS_SOURCEDESIGNER_CMD = "_sourcedesigner_";
    private static final String TOOLS_METADATAIMPORTER_CMD = "_metadataimport_";
    private static final String TOOLS_METADATAEXPORTER_CMD = "_metadataexport_";
    private static final String TOOLS_COBOLCOPYBOOKIMPORT_CMD = "_cobolcopybookimport_";
    private static final String TOOLS_CONFIGURESTATUS_CMD = "_configurestatus_";
    private static final String TOOLS_JOBSTATUSMANAGER_CMD = "_jobstatusmanager_";
    private static final String TOOLS_OPTIONS_CMD = "_options_";
    private static final String TOOLS_TRANSFORMG_CMD = "_transformg_";
    private static final String TOOLS_SHORTCUTS_SOURCEDESIGNER_CMD = "_sourcedesigner_";
    private static final String TOOLS_SHORTCUTS_PROCESSDESIGNER_CMD = "_processdesigner_";
    private static final String TOOLS_SHORTCUTS_TARGETDESIGNER_CMD = "_targetdesigner_";
    private static final String TOOLS_SHORTCUTS_CONFIGURE_CMD = "_configure_";
    private static final String WINDOW_CASCADE_CMD = "_cascade_";
    private static final String WINDOW_TILEH_CMD = "_tileh_";
    private static final String WINDOW_TILEV_CMD = "_tilev_";
    private static final String WINDOW_CLOSEALL_CMD = "_closeall_";
    private static final String HELP_CONTENTS_CMD = "_help_";
    private static final String HELP_CLEAR_CACHE = "_clearcache_";
    private static final String HELP_VIEW_ROADMAPS = "_viewroadmaps_";
    private static final String HELP_DUMP_STORES = "_dumpstores_";
    private static final String HELP_ABOUT_CMD = "_about_";
    private static final String HELP_SHOW_TIP_OF_DAY_CMD = "_showtipofday_";
    public static final int SHORTCUTS_SOURCEDESIGNER_CODE = 0;
    public static final int SHORTCUTS_METADATAIMPORTER_CODE = 1;
    public static final int SHORTCUTS_METADATAEXPORTER_CODE = 2;
    public static final int SHORTCUTS_PROCESSDESIGNER_CODE = 3;
    public static final int SHORTCUTS_TARGETDESIGNER_CODE = 4;
    public static final int SHORTCUTS_CONFIGURE_CODE = 5;
    private Workspace m_workspace = null;
    private static WAdminResource bundle = WAdminResource.getBundle(DefaultCommandListener.class);

    public DefaultCommandListener(Workspace workspace) {
        this.m_workspace = workspace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(XMLCommandEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("_closeall_")) {
            try {
                this.m_workspace.getDesktopWindowHandle().closeAll();
                return;
            }
            catch (PropertyVetoException ex) {
                return;
            }
        }
        if (cmd.equals(FILE_NEWOBJECT_CMD)) {
            NewObjectWizard dlg = new NewObjectWizard((Frame)this.m_workspace, bundle.getString("NewObjectWizard.tab1Title.txt"));
            dlg.show();
            dlg.handleGlobals();
            return;
        }
        if (cmd.equals(FILE_NEWWORKSPACE_CMD)) {
            if (this.m_workspace.getCMRHandle() != null) {
                int iChoice = MessageUtil.displayMessage((String)bundle.getString("AppSupport.CloseWorkspaceConfirm.txt"), (String)bundle.getString("AppSupport.CloseWorkspaceConfirmTitle.txt"), (int)3, (int)0);
                if (iChoice != 0) return;
                try {
                    this.m_workspace.shutdownDesktop2();
                }
                catch (PropertyVetoException ex) {
                    return;
                }
            }
            this.m_workspace.setTreeObject((WorkspaceTreeObject)new WAdminTreeObject());
            this.m_workspace.getConnected(false, true);
            return;
        }
        if (cmd.equals(FILE_OPENWORKSPACE_CMD)) {
            if (this.m_workspace.getCMRHandle() != null) {
                int iChoice = MessageUtil.displayMessage((String)bundle.getString("AppSupport.CloseWorkspaceConfirm.txt"), (String)bundle.getString("AppSupport.CloseWorkspaceConfirmTitle.txt"), (int)3, (int)0);
                if (iChoice != 0) return;
                try {
                    this.m_workspace.shutdownDesktop2();
                }
                catch (PropertyVetoException ex) {
                    return;
                }
            }
            this.m_workspace.setTreeObject((WorkspaceTreeObject)new WAdminTreeObject());
            this.m_workspace.getConnected(false, false);
            return;
        }
        if (cmd.equals(FILE_EXIT_CMD)) {
            this.m_workspace.dispatchEvent((AWTEvent)new WindowEvent((Window)this.m_workspace, 201));
            return;
        } else if (cmd.equals(EDIT_UNDO_CMD)) {
            CustomDesktop desktop = this.m_workspace.getDesktopWindowHandle();
            if (desktop == null) {
                return;
            }
            JInternalFrame frame = desktop.getSelectedFrame();
            if (!(frame instanceof WAStandardInternalFrame)) return;
            WAUndoManager waum = ((WAStandardInternalFrame)frame).getWAUndoManager();
            if (waum == null) {
                return;
            }
            if (!waum.canUndo()) return;
            try {
                waum.undo();
                return;
            }
            catch (CannotUndoException cannotUndoException) {}
            return;
        } else if (cmd.equals(EDIT_REDO_CMD)) {
            CustomDesktop desktop = this.m_workspace.getDesktopWindowHandle();
            if (desktop == null) {
                return;
            }
            JInternalFrame frame = desktop.getSelectedFrame();
            if (!(frame instanceof WAStandardInternalFrame)) return;
            WAUndoManager waum = ((WAStandardInternalFrame)frame).getWAUndoManager();
            if (waum == null) {
                return;
            }
            if (!waum.canRedo()) return;
            try {
                waum.redo();
                return;
            }
            catch (CannotUndoException cannotUndoException) {}
            return;
        } else if (cmd.equals(TOOLS_EDITOR_CMD)) {
            WsViewFactory.attachViewToFrame(null, (WorkspaceOMAView)new WsEditorOMAView(), (WAPropertyFrame)new WASplittablePropertyFrame());
            return;
        } else if (cmd.equals(TOOLS_TRANSFORMG_CMD)) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            MacroPluginWizard wizard = new MacroPluginWizard((Frame)Workspace.getWorkspace());
            wizard.show();
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            return;
        } else if (cmd.equals("_sourcedesigner_")) {
            this.m_workspace.getShortcutBar().onItemSelected(0);
            return;
        } else if (cmd.equals(TOOLS_METADATAIMPORTER_CMD)) {
            this.m_workspace.getShortcutBar().onItemSelected(1);
            return;
        } else if (cmd.equals(TOOLS_METADATAEXPORTER_CMD)) {
            this.m_workspace.getShortcutBar().onItemSelected(2);
            return;
        } else if (cmd.equals(TOOLS_CONFIGURESTATUS_CMD)) {
            DefaultCommandListener.launchConfigureStatusDialog();
            return;
        } else if (cmd.equals(TOOLS_JOBSTATUSMANAGER_CMD)) {
            DefaultCommandListener.launchJobStatusManagerFrame();
            return;
        } else if (cmd.equals(TOOLS_OPTIONS_CMD)) {
            DefaultCommandListener.launchOptionsDialog();
            return;
        } else if (cmd.equals(TOOLS_SHORTCUTS_CONFIGURE_CMD)) {
            this.m_workspace.getShortcutBar().onItemSelected(5);
            return;
        } else if (cmd.equals("_sourcedesigner_")) {
            this.m_workspace.getShortcutBar().onItemSelected(0);
            return;
        } else if (cmd.equals(TOOLS_SHORTCUTS_PROCESSDESIGNER_CMD)) {
            this.m_workspace.getShortcutBar().onItemSelected(3);
            return;
        } else if (cmd.equals(TOOLS_SHORTCUTS_TARGETDESIGNER_CMD)) {
            this.m_workspace.getShortcutBar().onItemSelected(4);
            return;
        } else if (cmd.equals(TOOLS_COBOLCOPYBOOKIMPORT_CMD)) {
            DefaultCommandListener.launchCobolCopyBookImportDialog();
            return;
        } else if (cmd.equals(WINDOW_CASCADE_CMD)) {
            CustomDesktop deskTop = this.m_workspace.getDesktopWindowHandle();
            if (deskTop == null) return;
            deskTop.cascade();
            return;
        } else if (cmd.equals(WINDOW_TILEH_CMD)) {
            CustomDesktop deskTop = this.m_workspace.getDesktopWindowHandle();
            if (deskTop == null) return;
            deskTop.tileHorizontal();
            return;
        } else if (cmd.equals(WINDOW_TILEV_CMD)) {
            CustomDesktop deskTop = this.m_workspace.getDesktopWindowHandle();
            if (deskTop == null) return;
            deskTop.tileVertical();
            return;
        } else if (cmd.equals("_closeall_")) {
            try {
                CustomDesktop deskTop = this.m_workspace.getDesktopWindowHandle();
                if (deskTop == null) return;
                deskTop.closeAll();
                return;
            }
            catch (PropertyVetoException ex) {
                return;
            }
        } else if (cmd.equals(HELP_CONTENTS_CMD)) {
            this.m_workspace.showHelp(null, "4.910");
            return;
        } else if (cmd.equals(HELP_SHOW_TIP_OF_DAY_CMD)) {
            WsTipOfDayDialog.showTipOfDayDialog((boolean)true);
            return;
        } else if (cmd.equals(HELP_CLEAR_CACHE)) {
            try {
                this.m_workspace.getMdObjectFactory().getDetailObjectMap().clear();
                this.m_workspace.getMdObjectFactory().dumpDetailHashMap();
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return;
        } else {
            if (cmd.equals(HELP_VIEW_ROADMAPS)) return;
            if (cmd.equals(HELP_DUMP_STORES)) {
                try {
                    this.m_workspace.getMdObjectFactory().dumpDetailHashMap();
                    return;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                return;
            } else {
                if (!cmd.equals(HELP_ABOUT_CMD)) return;
                WsAboutBox aboutbox = new WsAboutBox(bundle.getImageIcon("DataBuilder.AboutBox.image"), bundle.getString("DataBuilder.AboutBox.title.txt"), bundle, bundle.getString("DataBuilder.AboutBox.JarName.notrans"));
                aboutbox.show();
            }
        }
    }

    public static void launchConfigureStatusDialog() {
        Group mdGroup = CodeConditionConfigPanel.getMetadataObject();
        if (mdGroup != null) {
            Workspace ws = Workspace.getWorkspace();
            ws.setCursor(Cursor.getPredefinedCursor(3));
            WAPropertyDialog dlgConfigureStatus = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("CodeConditionConfigPanel.DialogTitle.txt"), true);
            CodeConditionConfigPanel pnlCodeConditions = new CodeConditionConfigPanel(mdGroup);
            dlgConfigureStatus.setMainPanel((WAPanel)pnlCodeConditions);
            dlgConfigureStatus.setMetadataObject((CMetadata)mdGroup);
            ws.setCursor(Cursor.getPredefinedCursor(0));
            dlgConfigureStatus.show();
        } else {
            MessageUtil.displayMessage((String)bundle.getString("CodeConditionConfigPanel.Error.txt"), (int)0);
        }
    }

    public static void launchJobStatusManagerFrame() {
        Workspace ws = Workspace.getWorkspace();
        ws.setCursor(Cursor.getPredefinedCursor(3));
        WsViewFactory.showView(JobStatusView.class);
        ws.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void launchOptionsDialog() {
        Workspace ws = Workspace.getWorkspace();
        ws.setCursor(Cursor.getPredefinedCursor(3));
        WAPropertyDialog dlg = new WAPropertyDialog((Frame)ws, bundle.getString("DefaultCommandListener.OptionsDialog.Title.txt"), true);
        GeneralOptionsPropertyTab genTab = new GeneralOptionsPropertyTab();
        PFDOptionsTab PFDOpTab = new PFDOptionsTab();
        EditorOptionsPropertyTab EdOpTab = new EditorOptionsPropertyTab((Dialog)dlg);
        ServerOptionsPropertyTab apsTab = new ServerOptionsPropertyTab();
        ViewDataGlobalOptionsTab vdataTab = new ViewDataGlobalOptionsTab();
        SASCodeGenerationOptionsPropertyTab codeTab = new SASCodeGenerationOptionsPropertyTab();
        ImpactAnalysisOptionsPropertyTab IATab = new ImpactAnalysisOptionsPropertyTab();
        dlg.addTab(bundle.getString("Common.General.txt"), (WAPropertyTab)genTab);
        dlg.addTab(bundle.getString("PFDOptionsTab.Title.txt"), (WAPropertyTab)PFDOpTab);
        dlg.addTab(bundle.getString("EditorOptionsPropertyTab.Title.txt"), (WAPropertyTab)EdOpTab);
        dlg.addTab(bundle.getString("AppServerOptionsTab.Title.txt"), (WAPropertyTab)apsTab);
        try {
            ClassLoader pluginLoader = Workspace.getWorkspace().getPluginLoader().getClassLoader("com.sas.wadmin.transforms.dataquality.match.DQMatch");
            Class<?> dqTabClass = pluginLoader.loadClass("com.sas.wadmin.transforms.dataquality.match.visuals.DQOptionsTab");
            WAPropertyTab dqTab = (WAPropertyTab)dqTabClass.newInstance();
            dlg.addTab(bundle.getString("DQOptionsTab.Title.txt"), dqTab);
        }
        catch (ClassNotFoundException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (InstantiationException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        dlg.addTab(bundle.getString("ViewDataOptionsTab.Title.txt"), (WAPropertyTab)vdataTab);
        dlg.addTab(bundle.getString("SASCodeGenerationOptionsTab.Title.txt"), (WAPropertyTab)codeTab);
        dlg.addTab(bundle.getString("ImpactAnalysisOptionsTab.Title.txt"), (WAPropertyTab)IATab);
        ws.setCursor(Cursor.getPredefinedCursor(0));
        dlg.show();
    }

    public static void launchCobolCopyBookImportDialog() {
        Workspace ws = Workspace.getWorkspace();
        ws.setCursor(Cursor.getPredefinedCursor(3));
        ImportCobolCopyBookPanel cobolPanel = new ImportCobolCopyBookPanel();
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("DefaultCommandListener.ImportCobolCopybook.title.txt"), true);
        dialog.setMainPanel((WAPanel)cobolPanel);
        dialog.setResizable(true);
        ws.setCursor(Cursor.getPredefinedCursor(0));
        dialog.show();
    }
}

