/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.DataValidationMetadataHandler;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.DataValidationCustomAssignTableModel;
import com.sas.wadmin.visuals.DataValidationCustomTableModel;
import com.sas.wadmin.visuals.DataValidationEditPanel;
import com.sas.wadmin.visuals.DataValidationTableModel;
import com.sas.wadmin.visuals.DataValidationTableViewer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsExpressionTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DataValidationCustomEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationCustomEditPanel.class);
    protected JLabel m_lblName;
    protected WATextField m_txtName;
    protected JLabel m_lblCondition;
    protected WsExpressionTextField m_expCondition;
    protected JPanel m_pnlTrue;
    protected DataValidationTableViewer m_tblTrue;
    protected DataValidationCustomAssignTableModel m_tblTrueModel;
    protected JCheckBox m_chkTrueException;
    protected JLabel m_lblTrueAction;
    protected WAComboBox m_cmbTrueAction;
    protected JPanel m_pnlFalse;
    protected DataValidationTableViewer m_tblFalse;
    protected DataValidationCustomAssignTableModel m_tblFalseModel;
    protected JCheckBox m_chkFalseException;
    protected JLabel m_lblFalseAction;
    protected WAComboBox m_cmbFalseAction;
    protected List m_rowValues;
    protected DataValidationCustomTableModel m_tableModel;
    protected DataValidationMetadataHandler m_handler;
    protected ClassifierMap m_classifierMap;
    protected List m_actionList;
    static final String HELP_ID = "custom_validation_win";

    public DataValidationCustomEditPanel(ClassifierMap classifierMap, DataValidationTableModel tableModel, List rowValues) {
        this.m_classifierMap = classifierMap;
        this.m_tableModel = (DataValidationCustomTableModel)tableModel;
        this.m_handler = this.m_tableModel.getHandler();
        this.m_rowValues = rowValues;
        this.initialize();
        this.setHelpTopic(HELP_ID);
    }

    protected void initialize() {
        super.initialize();
        this.m_txtName = new WATextField();
        this.m_txtName.setToolTipText(bundle.getString("DataValidationEditPanel.Name.tooltip.txt"));
        this.m_txtName.setMaxCharacters(60);
        this.m_lblName = new JLabel(bundle.getString("DataValidationEditPanel.Name.label.txt"));
        this.m_lblName.setLabelFor((Component)this.m_txtName);
        this.m_lblName.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Name.mnem").charAt(0));
        this.m_expCondition = new WsExpressionTextField(this.m_handler.getTargetTable(), "");
        this.m_expCondition.setToolTipText(bundle.getString("DataValidationEditPanel.Condition.tooltip.txt"));
        this.m_lblCondition = new JLabel(bundle.getString("DataValidationEditPanel.Condition.label.txt"));
        this.m_lblCondition.setLabelFor((Component)this.m_expCondition);
        this.m_lblCondition.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Condition.mnem").charAt(0));
        this.m_pnlTrue = new JPanel();
        TitledBorder borderTrue = BorderFactory.createTitledBorder(bundle.getString("DataValidationEditPanel.TrueBox.label.txt"));
        this.m_pnlTrue.setBorder(borderTrue);
        this.m_tblTrue = new DataValidationTableViewer();
        List trueList = (List)this.m_rowValues.get(this.m_handler.getAssignIndex()[1]);
        this.m_tblTrueModel = new DataValidationCustomAssignTableModel("TRUE", trueList);
        this.m_tblTrueModel.setHandler(this.m_tableModel.getHandler());
        this.m_tblTrue.setupViewer("TRUE", this.m_tblTrueModel, this.waum);
        Dimension dim = this.m_tblTrue.getPreferredSize();
        dim.setSize(dim.getHeight(), 150.0);
        this.m_tblTrue.setPreferredSize(dim);
        this.m_chkTrueException = new JCheckBox(bundle.getString("DataValidationEditPanel.Exception.label.txt"));
        this.m_chkTrueException.setToolTipText(bundle.getString("DataValidationEditPanel.Exception.tooltip.txt"));
        this.m_chkTrueException.setMnemonic(bundle.getString("DataValidationEditPanel.Exception.mnem").charAt(0));
        this.m_cmbTrueAction = new WAComboBox();
        this.m_cmbTrueAction.setToolTipText(bundle.getString("DataValidationEditPanel.Custom.Action.tooltip.txt"));
        this.m_lblTrueAction = new JLabel(bundle.getString("DataValidationEditPanel.Custom.Action.label.txt"));
        this.m_lblTrueAction.setLabelFor((Component)this.m_cmbTrueAction);
        this.m_lblTrueAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Custom.Action.mnem").charAt(0));
        this.m_pnlFalse = new JPanel();
        TitledBorder borderFalse = BorderFactory.createTitledBorder(bundle.getString("DataValidationEditPanel.FalseBox.label.txt"));
        this.m_pnlFalse.setBorder(borderFalse);
        this.m_tblFalse = new DataValidationTableViewer();
        List falseList = (List)this.m_rowValues.get(this.m_handler.getAssignIndex()[0]);
        this.m_tblFalseModel = new DataValidationCustomAssignTableModel("FALSE", falseList);
        this.m_tblFalseModel.setHandler(this.m_tableModel.getHandler());
        this.m_tblFalse.setupViewer("FALSE", this.m_tblFalseModel, this.waum);
        this.m_tblFalse.setNewButtonMnemonic(bundle.getString("DataValidationTableViewer.NewButton2.mnem").charAt(0));
        this.m_tblFalse.setEditButtonMnemonic(bundle.getString("DataValidationTableViewer.EditButton2.mnem").charAt(0));
        this.m_tblFalse.setDeleteButtonMnemonic(bundle.getString("DataValidationTableViewer.DeleteButton2.mnem").charAt(0));
        this.m_tblFalse.setPreferredSize(dim);
        this.m_chkFalseException = new JCheckBox(bundle.getString("DataValidationEditPanel.Exception.label.txt"));
        this.m_chkFalseException.setToolTipText(bundle.getString("DataValidationEditPanel.Exception.tooltip.txt"));
        this.m_chkFalseException.setMnemonic(bundle.getString("DataValidationEditPanel.Exception2.mnem").charAt(0));
        this.m_cmbFalseAction = new WAComboBox();
        this.m_cmbFalseAction.setToolTipText(bundle.getString("DataValidationEditPanel.Custom.Action.tooltip.txt"));
        this.m_lblFalseAction = new JLabel(bundle.getString("DataValidationEditPanel.Custom.Action.label.txt"));
        this.m_lblFalseAction.setLabelFor((Component)this.m_cmbFalseAction);
        this.m_lblFalseAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Custom.Action2.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblCondition, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_expCondition, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlTrue.setLayout(new GridBagLayout());
        this.m_pnlTrue.add((Component)((Object)this.m_tblTrue), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTrue.add((Component)this.m_chkTrueException, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTrue.add((Component)this.m_lblTrueAction, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTrue.add((Component)this.m_cmbTrueAction, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_pnlTrue, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.setLayout(new GridBagLayout());
        this.m_pnlFalse.add((Component)((Object)this.m_tblFalse), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.add((Component)this.m_chkFalseException, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.add((Component)this.m_lblFalseAction, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlFalse.add((Component)this.m_cmbFalseAction, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_pnlFalse, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.m_tblTrueModel.setClassifierMap(this.m_classifierMap);
            this.m_tblFalseModel.setClassifierMap(this.m_classifierMap);
            this.m_tblTrue.moveDataToView();
            this.m_tblFalse.moveDataToView();
        } else {
            WsDefaultTableRowModel mdlRows = this.m_tblTrue.getRowModel();
            this.m_tblTrueModel.setRowMappings(mdlRows.getRowMappings());
            mdlRows = this.m_tblFalse.getRowModel();
            this.m_tblFalseModel.setRowMappings(mdlRows.getRowMappings());
        }
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        String name = (String)this.m_rowValues.get(this.m_handler.getNameIndex());
        if (name == null || name.trim().length() <= 0) {
            name = bundle.getString("DataValidationEditPanel.DefaultName.txt");
        }
        this.m_txtName.setText(name);
        String condition = (String)this.m_rowValues.get(this.m_handler.getConditionIndex());
        this.m_expCondition.setText(condition);
        if (this.m_rowValues.get(this.m_handler.getExceptionIndex()[1]) != null) {
            Boolean bExcpFlag = (Boolean)this.m_rowValues.get(this.m_handler.getExceptionIndex()[1]);
            if (bExcpFlag == null) {
                bExcpFlag = Boolean.FALSE;
            }
            this.m_chkTrueException.setSelected(bExcpFlag);
        }
        this.m_actionList = this.m_handler.getActionList();
        this.m_cmbTrueAction.addItems(this.m_actionList);
        String trueAction = (String)this.m_rowValues.get(this.m_handler.getCustomActionIndex()[1]);
        if (trueAction == null) {
            this.m_cmbTrueAction.setSelectedIndex(0);
        } else {
            this.m_cmbTrueAction.setSelectedItem((Object)trueAction);
        }
        if (this.m_rowValues.get(this.m_handler.getExceptionIndex()[1]) != null) {
            Boolean bExcpFlag = (Boolean)this.m_rowValues.get(this.m_handler.getExceptionIndex()[0]);
            if (bExcpFlag == null) {
                bExcpFlag = Boolean.FALSE;
            }
            this.m_chkFalseException.setSelected(bExcpFlag);
        }
        this.m_cmbFalseAction.addItems(this.m_actionList);
        String falseAction = (String)this.m_rowValues.get(this.m_handler.getCustomActionIndex()[0]);
        if (falseAction == null) {
            this.m_cmbFalseAction.setSelectedIndex(0);
        } else {
            this.m_cmbFalseAction.setSelectedItem((Object)falseAction);
        }
        this.setListeningForChanges(true);
    }

    @Override
    public boolean validateData() {
        if (this.m_txtName.getText().equals("")) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingName.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingName.Title.txt"), (int)0);
            this.m_txtName.requestFocus();
            return false;
        }
        if (this.m_expCondition.getText().equals("")) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingCondition.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingCondition.Title.txt"), (int)0);
            this.m_expCondition.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public List getRow() {
        ArrayList<Object> rowValues = new ArrayList<Object>(this.m_handler.getNumValues());
        for (int i = 0; i < this.m_handler.getNumValues(); ++i) {
            rowValues.add(null);
        }
        rowValues.set(this.m_handler.getNameIndex(), this.m_txtName.getText());
        rowValues.set(this.m_handler.getConditionIndex(), this.m_expCondition.getText());
        rowValues.set(this.m_handler.getExceptionIndex()[1], this.m_chkTrueException.isSelected());
        rowValues.set(this.m_handler.getCustomActionIndex()[1], this.m_cmbTrueAction.getSelectedItem());
        this.m_tblTrueModel = (DataValidationCustomAssignTableModel)this.m_tblTrue.getModel();
        rowValues.set(this.m_handler.getAssignIndex()[1], this.m_tblTrueModel.getTableRows());
        rowValues.set(this.m_handler.getExceptionIndex()[0], this.m_chkFalseException.isSelected());
        rowValues.set(this.m_handler.getCustomActionIndex()[0], this.m_cmbFalseAction.getSelectedItem());
        this.m_tblFalseModel = (DataValidationCustomAssignTableModel)this.m_tblFalse.getModel();
        rowValues.set(this.m_handler.getAssignIndex()[0], this.m_tblFalseModel.getTableRows());
        return rowValues;
    }
}

