/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Change;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;

public class ChangeTextDialog
extends WAStandardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(ChangeTextDialog.class);
    protected WATextArea m_fullText;
    protected JScrollPane m_fullTextPane;
    protected Change m_oChange;

    public ChangeTextDialog(Dialog dlgOwner, String title, Change oChange) {
        super(dlgOwner, title, true);
        this.m_oChange = oChange;
        this._initialize();
        this.setCancelButtonVisible(false);
        this.setHelpButtonVisible(false);
        this.setHelpProduct("wdb");
        this.setHelpTopic("cm_checkin_win");
    }

    public ChangeTextDialog(Frame frmOwner, String title, Change oChange) {
        super(frmOwner, title, true);
        this.m_oChange = oChange;
        this._initialize();
        this.setCancelButtonVisible(false);
        this.setHelpButtonVisible(false);
        this.setHelpProduct("wdb");
        this.setHelpTopic("cm_checkin_win");
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.moveDataToView();
        }
        return true;
    }

    public void moveDataToView() {
        String template = "<Templates><Notes/></Templates>";
        Vector<String> complex = new Vector<String>();
        complex.add("Notes");
        try {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oChange, null, complex, template, 12, true);
            AssociationList notesList = this.m_oChange.getNotes(false);
            if (!notesList.isEmpty()) {
                TextStore ts = (TextStore)notesList.elementAt(0);
                String sStoredText = ts.getStoredText();
                if (sStoredText.length() > 0) {
                    this.m_fullText.setText(sStoredText);
                } else if (this.m_oChange.getDesc().length() > 0) {
                    this.m_fullText.setText(this.m_oChange.getDesc());
                } else {
                    this.m_fullText.setText(bundle.getString("ChangeTextDialog.NoDescription.txt"));
                }
            } else if (this.m_oChange.getDesc().length() > 0) {
                this.m_fullText.setText(this.m_oChange.getDesc());
            } else {
                this.m_fullText.setText(bundle.getString("ChangeTextDialog.NoDescription.txt"));
            }
            this.m_fullText.setAutoSelect(false);
        }
        catch (MdException mde) {
            mde.printStackTrace();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean validateData() {
        return true;
    }

    protected void _initialize() {
        this.setResizable(true);
        WAPanel pnlCheckIn = new WAPanel();
        pnlCheckIn.setLayout((LayoutManager)new GridBagLayout());
        this.m_fullText = new WATextArea();
        this.m_fullText.setBehavior(2);
        this.m_fullText.setAutosize(true);
        this.m_fullTextPane = new JScrollPane((Component)this.m_fullText, 20, 31);
        this.m_fullTextPane.setBorder(BorderFactory.createBevelBorder(1));
        this.m_fullTextPane.setPreferredSize(new Dimension(500, 400));
        pnlCheckIn.add((Component)this.m_fullTextPane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setMainPanel(pnlCheckIn);
    }

    public Component getDefaultFocusComponent() {
        return this.m_btnOk;
    }
}

