/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.impl.TableConnectionManager;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import java.rmi.RemoteException;
import java.sql.SQLException;

public class MetadataConnectionManager
extends TableConnectionManager {
    private static WAdminResource bundle = WAdminResource.getBundle(MetadataConnectionManager.class);
    private DataTable m_dataTable;
    private SASLibrary m_library;

    public MetadataConnectionManager(DataTable dataTable) {
        this(dataTable, false);
    }

    public MetadataConnectionManager(DataTable dataTable, WsAppServer appServer) {
        this(dataTable, false, appServer);
    }

    public MetadataConnectionManager(DataTable dataTable, boolean editable) {
        this(dataTable, editable, null);
    }

    public MetadataConnectionManager(DataTable dataTable, boolean editable, WsAppServer appServer) {
        super(appServer, editable);
        this.m_dataTable = dataTable;
    }

    @Override
    public void initExistingAppServerConnection() throws ViewDataException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        WsAppServer appServer = this.getAppServer();
        try {
            SASLibrary iLib = LibraryUtil.getLibrary((DataTable)this.m_dataTable, (ServerContext)appServer.getServerContext());
            if (iLib == null) {
                return;
            }
            this.m_library = LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)appServer.getServerContext());
            if (this.m_library == null) {
                throw new ViewDataException(bundle.getString("MetadataConnectionManager.LibrefFetchFail.txt"));
            }
            appServer.assignLibref(this.m_library);
            return;
        }
        finally {
            this.setServerSQLID(appServer.openAssignedSQLConnection(this.getConnectionProperties()));
        }
    }

    @Override
    public String getTableServerID() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNewAppServerConnection() throws ViewDataException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        WsAppServer defAppServer = WsAppServer.createDefaultAppServer();
        if (defAppServer == null) {
            throw new ViewDataException(bundle.getString("MetadataConnectionManager.DefAppServerCreationFailed.txt"));
        }
        WsAppServer appServer = null;
        try {
            ServerContext iDefault = defAppServer.getServerContext();
            SASLibrary iLib = LibraryUtil.getLibrary((DataTable)this.m_dataTable, (ServerContext)iDefault);
            if (iLib == null) {
                throw new ViewDataException(bundle.getString("MetadataConnectionManager.LibraryFetchFail.txt"));
            }
            this.m_library = LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
            if (this.m_library == null) {
                throw new ViewDataException(bundle.getString("MetadataConnectionManager.LibrefFetchFail.txt"));
            }
            appServer = LibraryUtil.interactiveAccessPath((SASLibrary)this.m_library, (WsAppServer)defAppServer);
            if (appServer == null) {
                throw new ViewDataException(bundle.getString("MetadataConnectionManager.AppServerFetchFail.txt"));
            }
            this.setAppServer(appServer);
        }
        finally {
            if (appServer != defAppServer) {
                defAppServer.dispose();
            }
        }
        this.setServerSQLID(appServer.openAssignedSQLConnection(this.getConnectionProperties()));
    }

    protected void submitMacroDefinitions() throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException {
        String macros = this.getMacroDeclarationCode();
        if (macros != null) {
            this.submitSASCode(macros);
        }
    }

    @Override
    public String getMacroDeclarationCode() throws MdException, RemoteException {
        StringBuffer code = new ParametersModel((Root)this.m_dataTable).getParameterMacroCode();
        return code == null ? null : code.toString();
    }

    @Override
    public boolean isTableSpecialCharacters() throws MdException, RemoteException {
        String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)this.m_dataTable);
        return "Y".equals(specChar);
    }

    public SASLibrary getSASLibrary() {
        return this.m_library;
    }

    @Override
    public boolean isLibraryAvailable() {
        return this.m_library != null;
    }

    @Override
    public String getPublicType() throws RemoteException {
        if ("WorkTable".equals(this.m_dataTable.getCMetadataType())) {
            return "WorkTable";
        }
        return this.m_dataTable.getPublicType();
    }

    public String getTableName() {
        try {
            return ((PhysicalTable)this.m_dataTable).getSASTableName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnList() {
        StringBuffer columnList = new StringBuffer();
        try {
            AssociationList columns = ((PhysicalTable)this.m_dataTable).getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                Column col = (Column)columns.get(i);
                String colName = col.getColumnName();
                if (colName == null || colName.length() <= 0) continue;
                columnList.append(" ").append(colName);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        finally {
            return columnList.toString();
        }
    }

    @Override
    public boolean doesTableExist() throws ViewDataException, SQLException, WsAppServerFailException, MdException {
        try {
            SASLibrary lib = this.getSASLibrary();
            String libname = "WORK";
            if (lib != null) {
                libname = lib.getLibref();
            }
            String tableName = ((PhysicalTable)this.m_dataTable).getSASTableName();
            return this.getAppServer().doesTableExist(libname.toUpperCase(), tableName, DBMSNamesUtil.isTableQuoted((DataTable)this.m_dataTable));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable() throws ViewDataException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        WsAppServer appServer = this.getAppServer();
        BaseModel model = new BaseModel();
        OMRAdapter omr = new OMRAdapter((IModel)model, Workspace.getMdFactory(), "MetadataConnectionManager");
        try {
            IPhysicalTable table = (IPhysicalTable)omr.acquireObjectUsingTemplate((Root)this.m_dataTable);
            CodeGenerationEnvironment env = new CodeGenerationEnvironment(ModelUIUtilities.getServerForAppServer((IModel)model, appServer));
            env.setGenerateRCSetCalls(false);
            ICodeSegment codeSegment = env.createNewCodeSegment((IObject)table);
            codeSegment.setQuoting(table.isQuoted());
            table.getDBMSType().create(codeSegment, table, false, true, true, false, "", null);
            appServer.submitSASCode(codeSegment.getGeneratedCode().toString());
        }
        finally {
            model.dispose();
            omr.dispose();
        }
    }
}

