/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.impl.TableConnectionManager;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.visuals.SubmitType;
import java.rmi.RemoteException;
import java.sql.SQLException;

public class JobTableConnectionManager
extends TableConnectionManager {
    private static WAdminResource bundle = WAdminResource.getBundle(JobTableConnectionManager.class);
    private ITable m_table;

    public JobTableConnectionManager(ITable table, WsAppServer appServer) {
        super(appServer, false);
        this.m_table = table;
    }

    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public String getPublicType() {
        return this.m_table.getPublicType();
    }

    @Override
    public boolean isLibraryAvailable() {
        if (this.m_table instanceof IPhysicalTable) {
            return ((IPhysicalTable)this.m_table).getLibrary() != null;
        }
        return false;
    }

    @Override
    public String getMacroDeclarationCode() throws MdException, RemoteException {
        try {
            return this.m_table.getDefaultParameterCode().toString();
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (CodegenException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initExistingAppServerConnection() throws ViewDataException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        WsAppServer appServer = this.getAppServer();
        if (this.m_table instanceof IPhysicalTable) {
            IModel mdl = this.m_table.getModel();
            OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), this.m_table.getName() + " view data initExistingAppServerConnection()");
            try {
                IServer server = ModelUIUtilities.getServerForAppServer(mdl, appServer);
                ILibrary clientLibrary = null;
                try {
                    clientLibrary = ((IPhysicalTable)this.m_table).getClientLibrary(server);
                }
                catch (BadLibraryDefinitionException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                Root metadataLibrary = null;
                if (clientLibrary != null) {
                    omr.populateFor((IOMRPersistable)clientLibrary);
                    metadataLibrary = omr.acquireOMRObject((IOMRPersistable)clientLibrary);
                    if (metadataLibrary != null) {
                        appServer.assignLibref((SASLibrary)metadataLibrary);
                    }
                }
            }
            finally {
                omr.dispose();
            }
        }
        this.setServerSQLID(appServer.openAssignedSQLConnection(this.getConnectionProperties()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableServerID() {
        String serverId = "";
        IModel mdl = this.m_table.getModel();
        OMRAdapter omr = null;
        try {
            omr = new OMRAdapter(mdl, Workspace.getMdFactory(), this.m_table.getName() + " view data JobTableConnectionManager:getTableServerId()");
            if (this.m_table instanceof IPhysicalTable) {
                IPhysicalTable pTable = (IPhysicalTable)this.m_table;
                WsAppServer appServer = this.getAppServer();
                if (appServer != null) {
                    IServer server = pTable.getServer(ModelUIUtilities.getServerForAppServer(mdl, appServer));
                    if (server != null) {
                        serverId = server.getID();
                    }
                } else {
                    serverId = WsAppServer.getDefaultAppServerFQID();
                }
            }
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (BadLibraryDefinitionException e) {
            Workspace.getDefaultLogger().error((Object)"BadLibraryDefinitionException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadServerDefinitionException e) {
            Workspace.getDefaultLogger().error((Object)"BadServerDefinitionException", (Throwable)e);
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)e);
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        finally {
            if (omr != null) {
                omr.dispose();
            }
        }
        return serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNewAppServerConnection() throws ViewDataException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
        WsAppServer appServer;
        block17: {
            appServer = WsAppServer.createDefaultAppServer();
            if (appServer == null) {
                throw new ViewDataException(bundle.getString("MetadataConnectionManager.DefAppServerCreationFailed.txt"));
            }
            IModel mdl = this.m_table.getModel();
            OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), this.m_table.getName() + " view data initExistingAppServerConnection()");
            try {
                if (this.m_table instanceof IPhysicalTable) {
                    IServer defaultServer = ModelUIUtilities.getServerForAppServer(mdl, appServer);
                    IServer bestServer = ((IPhysicalTable)this.m_table).getServer(defaultServer);
                    if (bestServer != defaultServer) {
                        appServer.dispose();
                        appServer = WsAppServer.createAppServer((String)bestServer.getID());
                    }
                    ILibrary clientLibrary = null;
                    try {
                        clientLibrary = ((IPhysicalTable)this.m_table).getClientLibrary(bestServer);
                    }
                    catch (BadLibraryDefinitionException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                    }
                    Root metadataLibrary = null;
                    if (clientLibrary != null) {
                        omr.populateFor((IOMRPersistable)clientLibrary);
                        metadataLibrary = omr.acquireOMRObject((IOMRPersistable)clientLibrary);
                    }
                    if (metadataLibrary != null) {
                        appServer.assignLibref((SASLibrary)metadataLibrary);
                    }
                    this.setAppServer(appServer);
                    break block17;
                }
                if (this.m_table instanceof IExternalTable) {
                    IServer server = ((IExternalTable)this.m_table).getServer();
                    if (server != null && !server.getID().equals(appServer.getServerFQID())) {
                        appServer.dispose();
                        appServer = WsAppServer.createAppServer((String)server.getID());
                    }
                    this.setAppServer(appServer);
                }
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            finally {
                if (omr != null) {
                    omr.dispose();
                }
            }
        }
        this.setServerSQLID(appServer.openAssignedSQLConnection(this.getConnectionProperties()));
    }

    @Override
    public boolean isTableSpecialCharacters() {
        return this.m_table.isSpecialCharacters();
    }

    @Override
    public boolean doesTableExist() throws ViewDataException, SQLException, WsAppServerFailException, MdException {
        if (!(this.m_table instanceof IPhysicalTable)) {
            return false;
        }
        String libname = SubmitType.getInstance().getSubmittedWorkLibrary();
        ILibrary lib = ((IPhysicalTable)this.m_table).getLibrary();
        if (lib != null) {
            libname = lib.getLibref();
        }
        String tableName = ((IPhysicalTable)this.m_table).getSASTableName();
        return this.getAppServer().doesTableExist(libname.toUpperCase(), tableName, this.m_table.isQuoted());
    }

    @Override
    public void createTable() throws ViewDataException, MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        WsAppServer appServer = this.getAppServer();
        CodeGenerationEnvironment env = new CodeGenerationEnvironment(ModelUIUtilities.getServerForAppServer(this.m_table.getModel(), appServer));
        env.setGenerateRCSetCalls(false);
        ICodeSegment codeSegment = env.createNewCodeSegment((IObject)this.m_table);
        codeSegment.setQuoting(this.m_table.isQuoted());
        ((IPhysicalTable)this.m_table).getDBMSType().create(codeSegment, (IPhysicalTable)this.m_table, false, true, true, false, "", null);
        appServer.submitSASCode(codeSegment.getGeneratedCode().toString());
    }
}

