/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.JobTableModel;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;

public class JobExternalTableModel
extends JobTableModel {
    IExternalTable m_externalTable;
    private boolean m_workTableCreated = false;

    public JobExternalTableModel(IExternalTable table, ConnectionManager manager) {
        super((ITable)table);
        this.m_externalTable = table;
        this.setConnectionManager(manager);
    }

    @Override
    public String getLibRef() {
        if (this.m_externalTable.isUsingUserWrittenCode()) {
            return "";
        }
        return "work";
    }

    @Override
    protected String getTableOptions() {
        return "";
    }

    @Override
    protected void postFetchDataProcessing() throws ViewDataException {
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isFilterable() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return true;
    }

    @Override
    public boolean isSubsetable() {
        return true;
    }

    protected boolean isQuotingRequired() {
        return this.m_externalTable.isCaseSensitive() || this.m_externalTable.isSpecialCharacters();
    }

    @Override
    public String getTableDisplayName() {
        return this.m_externalTable.getName();
    }

    @Override
    public String getTableSQLName() {
        if (this.m_externalTable.isUsingUserWrittenCode()) {
            return "&SYSLAST";
        }
        return "ETLS_EFITABLE";
    }

    @Override
    protected void fetchDataPreemptive() throws ViewDataException {
        try {
            this.createWorkTable();
            super.fetchDataPreemptive();
        }
        catch (MdException e) {
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (WsAppServerFailException e) {
            throw new ViewDataException(e);
        }
        catch (WsAppServerCodeException e) {
            throw new ViewDataException(e);
        }
        catch (ServerException e) {
            throw new ViewDataException(e);
        }
        catch (CodegenException e) {
            throw new ViewDataException(e);
        }
        catch (BadLibraryDefinitionException e) {
            throw new ViewDataException(e);
        }
        catch (BadServerDefinitionException e) {
            throw new ViewDataException(e);
        }
    }

    protected void createWorkTable() throws WsAppServerFailException, WsAppServerCodeException, MdException, RemoteException, ServerException, BadServerDefinitionException, CodegenException, BadLibraryDefinitionException {
        if (this.isWorkTableCreated()) {
            return;
        }
        StringBuffer datastep = this.m_externalTable.getDataStepCodeToCreateTable(CodeGenerationEnvironmentFactory.getInstance().createCodeGenerationEnvironment(null, null), "", true, "", false);
        this.getConnectionManager().submitSASCode(datastep.toString());
        this.setWorkTableCreated(true);
    }

    @Override
    public String getTrueColumnSQLName(int column) {
        if (this.isQuotingRequired()) {
            return DBMSNamesUtil.getQuotedString((String)this.getTrueColumnName(column), (boolean)false);
        }
        return this.getTrueColumnName(column);
    }

    protected void setWorkTableCreated(boolean workTableCreated) {
        this.m_workTableCreated = workTableCreated;
    }

    protected boolean isWorkTableCreated() {
        return this.m_workTableCreated;
    }

    @Override
    protected String getTableClause(String libref) throws MdException, RemoteException {
        String clause = " FROM ";
        if (libref != null && !"".equals(libref)) {
            clause = clause + libref + ".";
        }
        clause = clause + this.getTableSQLName();
        clause = clause + this.getTableOptions();
        return clause;
    }
}

