/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2.impl;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.ViewDataDataTableModel;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.impl.MetadataConnectionManager;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.EFIDataModel;
import java.rmi.RemoteException;

public class ExternalTableModel
extends ViewDataDataTableModel {
    private boolean m_workTableCreated = false;
    private EFIDataModel m_efiModel;

    public ExternalTableModel(EFIDataModel efiModel, ConnectionManager connManager) {
        super((DataTable)efiModel.getExternalTable());
        this.m_efiModel = efiModel;
        this.setConnectionManager(connManager);
    }

    @Override
    protected void initLibrary() throws MdException, RemoteException {
        this.setLibrary(null);
    }

    @Override
    protected void fetchDataPreemptive() throws ViewDataException {
        try {
            this.createWorkTable();
            super.fetchDataPreemptive();
        }
        catch (MdException e) {
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (WsAppServerFailException e) {
            throw new ViewDataException(e);
        }
        catch (WsAppServerCodeException e) {
            throw new ViewDataException(e);
        }
    }

    @Override
    protected void postFetchDataProcessing() throws ViewDataException {
        this.fireTableStructureChanged();
    }

    protected void createWorkTable() throws WsAppServerFailException, WsAppServerCodeException, MdException, RemoteException {
        if (this.isWorkTableCreated()) {
            return;
        }
        StringBuffer datastep = new StringBuffer();
        if (this.isQuotingRequired()) {
            datastep.append("options VALIDVARNAME = ANY VALIDMEMNAME = EXTEND;\n");
        }
        datastep.append(this.m_efiModel.getDataStep(""));
        if (this.isParameterized()) {
            datastep.insert(0, this.getParameterizedMacroDeclaration()).append("\n");
        }
        ((MetadataConnectionManager)this.getConnectionManager()).submitSASCode(datastep.toString());
        this.setWorkTableCreated(true);
    }

    protected boolean isQuotingRequired() {
        return this.m_efiModel.isCaseSensitiveColumnNamesEnabled() || this.m_efiModel.isSpecialCharactersInColumnNamesEnabled();
    }

    @Override
    public String getTableDisplayName() {
        try {
            return this.getDataTable().getName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    @Override
    public String getTableSQLName() {
        if (this.m_efiModel.isUserWritten()) {
            return "&SYSLAST";
        }
        return "ETLS_EFITABLE";
    }

    @Override
    public String getLibRef() {
        if (this.m_efiModel.isUserWritten()) {
            return "";
        }
        return super.getLibRef();
    }

    @Override
    public String getTrueColumnSQLName(int column) {
        try {
            if (this.isQuotingRequired()) {
                return DBMSNamesUtil.getQuotedString((String)this.getTrueColumnMetadata(column).getSASColumnName(), (boolean)false);
            }
            return this.getTrueColumnMetadata(column).getSASColumnName();
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    protected void setWorkTableCreated(boolean workTableCreated) {
        this.m_workTableCreated = workTableCreated;
    }

    protected boolean isWorkTableCreated() {
        return this.m_workTableCreated;
    }

    @Override
    protected String getTableClause(String libref) throws MdException, RemoteException {
        String clause = " FROM ";
        if (libref != null && !"".equals(libref)) {
            clause = clause + libref + ".";
        }
        clause = clause + this.getTableSQLName();
        clause = clause + this.getTableOptions();
        return clause;
    }
}

