/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.etl.models.data.ITable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.impl.ExternalTablePanel;
import com.sas.wadmin.viewdata2.impl.PhysicalTablePanel;
import com.sas.wadmin.viewdata2.impl.WorkTablePanel;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractOMAView;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.models.SimpleObject;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.Icon;

public class ViewDataView
extends WsAbstractOMAView {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataView.class);
    public static final String KEY_APPSERVER = "AppServer";
    public static final String KEY_EDITABLE = "Editable";
    public static final String KEY_SHOW_TOOLBAR = "ShowToolBar";
    public static final String KEY_USE_NEW_VIEWDATA = "NewViewData";
    private ViewDataPanel m_viewDataTablePanel;
    private ITable m_table;

    public WAPanel createMainPanel() {
        try {
            this.m_table = (ITable)this.getUserDataObject(KEY_USE_NEW_VIEWDATA, null);
            if (this.m_table != null) {
                this.m_viewDataTablePanel = new PhysicalTablePanel(this.m_table, PhysicalTablePanel.Mode.BROWSE, this.getUserDataBoolean(KEY_EDITABLE, true), (WsAppServer)this.getUserDataObject(KEY_APPSERVER, null));
            } else if (this.m_metadata.getCMetadataType().equals("PhysicalTable")) {
                this.m_viewDataTablePanel = new PhysicalTablePanel((PhysicalTable)this.m_metadata, PhysicalTablePanel.Mode.BROWSE, this.getUserDataBoolean(KEY_EDITABLE, true), (WsAppServer)this.getUserDataObject(KEY_APPSERVER, null));
            } else if (this.m_metadata.getCMetadataType().equals("ExternalTable")) {
                this.m_viewDataTablePanel = new ExternalTablePanel((ExternalTable)this.m_metadata);
            } else if (this.m_metadata.getCMetadataType().equals("WorkTable")) {
                this.m_viewDataTablePanel = this.userDataHasKey(KEY_APPSERVER) ? new WorkTablePanel((WorkTable)this.m_metadata, (WsAppServer)this.getUserDataObject(KEY_APPSERVER, null)) : new WorkTablePanel((WorkTable)this.m_metadata);
            }
            this.m_viewDataTablePanel.setToolBarShowing(this.getUserDataBoolean(KEY_SHOW_TOOLBAR, true));
            this.m_viewDataTablePanel.addPropertyChangeListener(new DisplayTitleChangeListener());
        }
        catch (ViewDataException viewDataException) {
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
        if (this.m_viewDataTablePanel != null) {
            this.m_viewDataTablePanel.setPreferredSize(new Dimension(700, 700));
        }
        return this.m_viewDataTablePanel;
    }

    protected boolean getUserDataBoolean(String key, boolean def) {
        if (this.userDataHasKey(key)) {
            return Boolean.valueOf(((HashMap)this.getUserData()).get(key).toString());
        }
        return def;
    }

    protected Object getUserDataObject(String key, Object def) {
        if (this.userDataHasKey(key)) {
            return ((HashMap)this.getUserData()).get(key);
        }
        return def;
    }

    protected boolean userDataHasKey(String key) {
        HashMap userData = (HashMap)this.getUserData();
        return userData != null && userData.containsKey(key);
    }

    public boolean shouldFrameButtonsPanelBeVisible() {
        return false;
    }

    public void setFrame(WAInternalFrame frame) {
        super.setFrame(frame);
        frame.setEditable(true);
    }

    protected String getFrameTitle() {
        try {
            if (this.m_viewDataTablePanel == null) {
                return bundle.formatString("ViewDataPanel.TitleError.fmt.txt", (Object)this.m_metadata.getName());
            }
            return this.m_viewDataTablePanel.getDisplayTitle();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public Icon getFrameIcon() {
        if (this.m_table != null) {
            return AppIconFactory.getInstance().getIconForSimpleObject((SimpleObject)this.m_table);
        }
        try {
            String sType = this.getMetadata().getCMetadataType();
            if ("ExternalTable".equals(sType)) {
                return AppIconFactory.getInstance().getIconForPublicType("ExternalFile");
            }
            return AppIconFactory.getInstance().getIconForPublicType("Table");
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            return AppIconFactory.getInstance().getIconForPublicType("Table");
        }
    }

    public String getID() {
        if (this.m_table != null) {
            return this.m_table.getID();
        }
        return super.getID();
    }

    class DisplayTitleChangeListener
    implements PropertyChangeListener {
        DisplayTitleChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("DisplayTitle".equals(e.getPropertyName()) && ViewDataView.this.getFrame() != null) {
                ViewDataView.this.updateFrameTitle();
            }
        }
    }
}

