/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class ViewDataToolBar
extends JToolBar {
    protected static final Dimension DEFAULT_SPACE = new Dimension(4, 10);
    private List m_actions;
    private List m_invisibleActions;

    public ViewDataToolBar() {
        this.initialize();
        this.m_actions = new ArrayList();
        this.m_invisibleActions = new ArrayList();
        this.setFloatable(false);
        this.setRollover(true);
    }

    private void initialize() {
    }

    protected void dispose() {
        this.setEnabled(false);
        this.setActive(false);
        this.setVisible(false);
        this.m_actions.clear();
        this.m_invisibleActions.clear();
        this.removeAll();
    }

    @Override
    public void setEnabled(boolean enabled) {
        int i;
        super.setEnabled(enabled);
        for (i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) instanceof AbstractButton && ((AbstractButton)this.getComponent(i)).getAction() != null) {
                ((AbstractButton)this.getComponent(i)).getAction().setEnabled(enabled);
                continue;
            }
            this.getComponent(i).setEnabled(enabled);
        }
        for (i = 0; i < this.m_invisibleActions.size(); ++i) {
            ((WsAbstractAction)this.m_invisibleActions.get(i)).setEnabled(enabled);
        }
    }

    public void setActive(boolean active) {
        int i;
        for (i = 0; i < this.m_actions.size(); ++i) {
            ((WsAbstractAction)this.m_actions.get(i)).setActive(active);
        }
        for (i = 0; i < this.m_invisibleActions.size(); ++i) {
            ((WsAbstractAction)this.m_invisibleActions.get(i)).setActive(active);
        }
    }

    public void addComponent(JComponent component) {
        this.add(component);
    }

    public void addFlatTextButton(WsAbstractAction action) {
        this.addComponent(WsUIUtilities.createTextButton((WsAbstractAction)action));
        this.m_actions.add(action);
    }

    public void addFlatToolButton(WsAbstractAction action) {
        this.addComponent(WsUIUtilities.createFlatToolButton((WsAbstractAction)action));
        this.m_actions.add(action);
    }

    public void addFlatToggleButton(WsAbstractToggleAction action) {
        this.addComponent(WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)action));
        this.m_actions.add(action);
    }

    public void addInvisibleAction(WsAbstractAction action) {
        this.m_invisibleActions.add(action);
    }

    @Override
    public void addSeparator() {
        this.addComponent(this.getSeparator());
    }

    protected Dimension getToolItemsSpace() {
        return DEFAULT_SPACE;
    }

    protected JSeparator getSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        return separator;
    }
}

