/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ColumnDisplayLabelHelper;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.DataManager;
import com.sas.wadmin.viewdata2.RSAbsoluteEstimator;
import com.sas.wadmin.viewdata2.ViewDataDataTableModel;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.event.ViewDataModelListener;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class ViewDataModel
extends WsAbstractTableModel {
    private int m_iRowLimit = 0;
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataModel.class);
    public static final String PROPERTY_APPLY_FORMATS = "ApplyFormats";
    private static boolean RUN_DEAD_CODE = false;
    public static final String SAS_TYPE_CHARACTER = "C";
    public static final String SAS_TYPE_NUMERIC = "N";
    public static final String SAS_TYPE_DATE = "D";
    public static final Object UNCHANGED_VALUE;
    public static final int UNKNOWN_ROW_COUNT = -1;
    public static final Date UNKNOWN_DATE;
    public static final Double UNKNOWN_DOUBLE;
    public static final String PROPERTY_ROW_COUNT = "RowCount";
    public static final String PROPERTY_MAX_ROW_COUNT_YET = "MaxRowCountYet";
    public static final String PROPERTY_COLUMN_DISPLAY_LABEL = "ColumnDisplayLabel";
    private ConnectionManager m_connManager;
    private DataManager m_dataManager;
    private boolean m_fetchDataRunning = false;
    private boolean m_hasDataFetchError = false;
    private String m_filter;
    private int[] m_sortColumns;
    private SortDirection[] m_sortDirections;
    private int[] m_displayColumns;
    private ColumnDisplayLabelHelper m_labelHelper;
    private boolean m_applyFormats = true;
    private boolean m_displayColumnsChanged = false;
    private boolean m_bParameterized;
    private ArrayList m_viewDataListeners;
    private DataManagerListener m_dataManagerListener;
    private RSAbsoluteEstimator m_RSAbsoluteEstimator;
    private ViewDataPanel m_viewDataPanel;
    private byte[] mutex = new byte[0];

    public ViewDataModel() {
        this.m_viewDataListeners = new ArrayList();
        this.m_dataManagerListener = new DataManagerListener();
        this.m_labelHelper = new ColumnDisplayLabelHelper(this);
        this.m_RSAbsoluteEstimator = new RSAbsoluteEstimator(this);
    }

    public RSAbsoluteEstimator getRSAbsoluteEstimator() {
        return this.m_RSAbsoluteEstimator;
    }

    public ViewDataPanel getViewDataPanel() {
        return this.m_viewDataPanel;
    }

    public void setViewDataPanel(ViewDataPanel panel) {
        this.m_viewDataPanel = panel;
    }

    public void setDataManager(DataManager manager) {
        if (this.m_dataManager != null) {
            this.m_dataManager.removePropertyChangeListener(this.m_dataManagerListener);
        }
        this.m_dataManager = manager;
        if (this.m_dataManager != null) {
            this.m_dataManager.addPropertyChangeListener(this.m_dataManagerListener);
        }
    }

    public DataManager getDataManager() {
        return this.m_dataManager;
    }

    public void setConnectionManager(ConnectionManager manager) {
        this.m_connManager = manager;
    }

    public ConnectionManager getConnectionManager() {
        return this.m_connManager;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.setApplyFormats(file.getPropertyBoolean("ViewData.ShowFormattedData", true));
        String sParametersMacro = this.getParameterizedMacroDeclaration();
        this.setParameterized(sParametersMacro != null && sParametersMacro.length() > 0);
        if (this.getTrueColumnCount() == 0) {
            throw new MdException(bundle.getString("ViewDataDataTableModel.NoColumns.txt"));
        }
        this.fireTableStructureChanged();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void refresh() throws ViewDataException {
        this.fetchData();
    }

    public void dispose() throws ViewDataException {
        this.clearDataObjects();
        this.removeAllViewDataModelListeners();
    }

    protected void updateColumnInformation() {
        int nColumns = this.getDisplayColumns().length;
        this.m_aColumns = new WsAbstractTableColumn[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            String label = this.getColumnDisplayName(i);
            String type = this.getColumnSASType(i);
            this.m_aColumns[i] = SAS_TYPE_NUMERIC.equals(type) || SAS_TYPE_DATE.equals(type) ? new WsIntegerTableColumn(i, label, 75) : new WsStringTableColumn(i, label, 75);
            this.m_aColumns[i].setEditable(this.isEditable());
        }
    }

    public void fireTableStructureChanged() {
        this.updateColumnInformation();
        super.fireTableStructureChanged();
    }

    public void fetchData() throws ViewDataException {
        this.verifyFetchDataNotRunning();
        this.preFetchDataProcessing();
        this.updateRowLimit();
        Thread dataFetcher = new Thread(this.getDataFetchRunnable());
        this.setFetchDataRunning(true);
        this.fireFetchStarted();
        dataFetcher.start();
    }

    protected void preFetchDataProcessing() throws ViewDataException {
        this.clearDataObjects();
        this.setHasDataFetchError(false);
        if (this.isDisplayColumnsChanged()) {
            this.fireTableStructureChanged();
        }
    }

    public Statement createStatement() throws ViewDataException, SQLException {
        return this.getConnectionManager().getConnection().createStatement(1004, 1007);
    }

    protected void fetchDataPreemptive() throws ViewDataException {
        try {
            Statement smt = this.createStatement();
            smt.setFetchSize(50);
            int rowLimit = this.getRowLimit();
            if (rowLimit > 0) {
                smt.setMaxRows(rowLimit);
            }
            ResultSet rs = smt.executeQuery(this.getQuery());
            DataManager dataManager = new DataManager(rs, this.isApplyFormats());
            this.setDataManager(dataManager);
        }
        catch (SQLException e) {
            throw new ViewDataException(e);
        }
        catch (MdException e) {
            throw new ViewDataException(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected abstract void postFetchDataProcessing() throws ViewDataException;

    protected Runnable getDataFetchRunnable() {
        return new DataFetchRunnable();
    }

    public boolean isFetchDataRunning() {
        return this.m_fetchDataRunning;
    }

    public void setFetchDataRunning(boolean running) {
        this.m_fetchDataRunning = running;
        if (!this.m_fetchDataRunning && this.m_viewDataPanel.isFromClosingFrame()) {
            this.m_viewDataPanel.closeParentFrame();
        }
    }

    protected void verifyFetchDataNotRunning() throws ViewDataException {
        if (this.isFetchDataRunning()) {
            throw new ViewDataException("Fetch data running.");
        }
    }

    public boolean hasDataFetchError() {
        return this.m_hasDataFetchError;
    }

    protected void setHasDataFetchError(boolean hasDataFetchError) {
        this.m_hasDataFetchError = hasDataFetchError;
    }

    protected void clearDataObjects() throws ViewDataException {
        if (this.getDataManager() != null) {
            this.getDataManager().dispose();
            this.setDataManager(null);
            this.fireTableRowsDeleted(0, this.getRowCount());
        }
    }

    public abstract String getLibRef();

    public abstract String getTableDisplayName();

    public abstract String getTableSQLName();

    protected abstract String getParameterizedMacroDeclaration();

    protected abstract String getTableOptions();

    public int getColumnCount() {
        return this.getDisplayColumns().length;
    }

    public String getColumnName(int column) {
        return this.getTrueColumnName(this.convertColumnIndexToTrue(column));
    }

    public String getColumnDisplayName(int column) {
        return this.getTrueColumnDisplayName(this.convertColumnIndexToTrue(column));
    }

    public String getColumnSQLName(int column) {
        return this.getTrueColumnSQLName(this.convertColumnIndexToTrue(column));
    }

    public String getColumnSASType(int column) {
        return this.getTrueColumnSASType(this.convertColumnIndexToTrue(column));
    }

    public int getColumnPrecision(int column) {
        return this.getTrueColumnPrecision(this.convertColumnIndexToTrue(column));
    }

    public abstract int getTrueColumnCount();

    public abstract String getTrueColumnName(int var1);

    public abstract String getTrueColumnObjectName(int var1);

    public abstract String getTrueColumnDescription(int var1);

    public abstract String getTrueColumnFormat(int var1);

    public abstract String getTrueColumnSQLName(int var1);

    public abstract String getTrueColumnSASType(int var1);

    public abstract int getTrueColumnPrecision(int var1);

    public String getTrueColumnDisplayName(int column) {
        try {
            return this.m_labelHelper.getColumnDisplayName(column);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return bundle.getString("ViewDataMetadataModel.UnknownColumnName.txt");
    }

    public int convertColumnIndexToTrue(int column) {
        return this.getDisplayColumns()[column];
    }

    public int convertTrueIndexToColumn(int column) {
        for (int i = 0; i < this.getDisplayColumns().length; ++i) {
            if (this.getDisplayColumns()[i] != column) continue;
            return i;
        }
        return -1;
    }

    public boolean isApplyFormats() {
        return this.m_applyFormats;
    }

    public void setApplyFormats(boolean applyFormats) {
        if (this.m_applyFormats == applyFormats) {
            return;
        }
        this.m_applyFormats = applyFormats;
        this.firePropertyChanged(PROPERTY_APPLY_FORMATS, !this.m_applyFormats, this.m_applyFormats);
    }

    public void setShowColumnName(boolean show) {
        this.m_labelHelper.setShowColumnName(show);
    }

    public void setShowLabel(boolean show) {
        this.m_labelHelper.setShowLabel(show);
    }

    public void setShowMetadataName(boolean show) {
        this.m_labelHelper.setShowMetadataName(show);
    }

    public boolean isShowColumnName() {
        return this.m_labelHelper.getShowColumnName();
    }

    public boolean isShowLabel() {
        return this.m_labelHelper.getShowLabel();
    }

    public boolean isShowMetadataName() {
        return this.m_labelHelper.getShowMetadataName();
    }

    protected void setParameterized(boolean isParameterized) {
        this.m_bParameterized = isParameterized;
    }

    protected boolean isParameterized() {
        return this.m_bParameterized;
    }

    public int getRowCount() {
        return this.getDataManager() != null ? this.getDataManager().getMaxRowCountYet() : 0;
    }

    public void setRowCount(int rowCount) {
        if (this.getDataManager() == null) {
            return;
        }
        this.getDataManager().setRowCount(rowCount);
    }

    public Object getValueAt(int row, int column) {
        try {
            return this.m_dataManager.getValueAt(row, column);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        return null;
    }

    public List getRowValues(int iRow) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            list.add(this.getValueAt(iRow, i));
        }
        return list;
    }

    public boolean peek(int row) throws SQLException {
        return this.getDataManager().peek(row);
    }

    public void gotoRow(int row) throws ViewDataException, SQLException {
        this.getDataManager().goToRow(row);
    }

    public void gotoLastRow() throws SQLException, ViewDataException {
        this.getDataManager().goToLastRow();
    }

    public boolean isRowCountKnown() {
        if (this.getDataManager() != null) {
            return this.getDataManager().getRowCount() != -1;
        }
        return false;
    }

    public boolean isFilterable() {
        return false;
    }

    public boolean isSortable() {
        return false;
    }

    public boolean isSubsetable() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public int[] getSortedColumns() {
        return this.m_sortColumns;
    }

    public void setSortedColumns(int[] sortColumns, SortDirection[] sortDirections) throws ViewDataException {
        if (!this.isFilterable()) {
            throw new ViewDataException("Model does not support sorting.");
        }
        if (sortColumns.length != sortDirections.length) {
            throw new IllegalArgumentException("Sorted columns and sort orders do not correspond.");
        }
        this.m_sortColumns = sortColumns;
        this.m_sortDirections = sortDirections;
    }

    public SortDirection[] getSortedColumnOrder() {
        return this.m_sortDirections;
    }

    public boolean hasSortColumns() {
        return this.getSortedColumns() != null && this.getSortedColumns().length != 0;
    }

    public void clearSortColumns() {
        this.m_sortColumns = null;
        this.m_sortDirections = null;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) throws ViewDataException {
        if (!this.isFilterable()) {
            throw new ViewDataException("Model does not support filter.");
        }
        this.m_filter = filter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null && !"".equals(this.getFilter().trim());
    }

    public void clearFilter() {
        try {
            this.setFilter(null);
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
    }

    public int[] getDisplayColumns() {
        if (this.m_displayColumns == null || this.m_displayColumns.length == 0) {
            this.setDisplayColumnsAll();
        }
        return this.m_displayColumns;
    }

    public void setDisplayColumns(int[] displayColumns) throws ViewDataException {
        if (!this.isSubsetable()) {
            throw new ViewDataException("Model does not support subsetting.");
        }
        this.m_displayColumnsChanged = true;
        if (displayColumns == null || displayColumns.length == 0 && this.m_aColumns.length != 0) {
            this.setDisplayColumnsAll();
        } else {
            this.m_displayColumns = displayColumns;
        }
    }

    protected void setDisplayColumnsAll() {
        this.m_displayColumns = new int[this.getTrueColumnCount()];
        for (int i = 0; i < this.m_displayColumns.length; ++i) {
            this.m_displayColumns[i] = i;
        }
        this.m_displayColumnsChanged = true;
    }

    protected boolean isDisplayColumnsChanged() {
        return this.m_displayColumnsChanged;
    }

    protected void setDisplayColumnsChanged(boolean displayColumnsChanged) {
        this.m_displayColumnsChanged = displayColumnsChanged;
    }

    public boolean hasSubsetClause() {
        return this.getColumnCount() != this.getTrueColumnCount();
    }

    public void resetDisplayColumns() {
        this.setDisplayColumnsAll();
    }

    public void clearQueryOptions() {
        this.clearSortColumns();
        this.clearFilter();
        this.resetDisplayColumns();
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        try {
            this.setValueAt1(value, iRow, iCol);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.fireCellUpdateFailed(value, iRow, iCol, e);
        }
    }

    public void setValueAt1(Object value, int iRow, int iCol) throws SQLException {
        this.getDataManager().setValueAt(value, iRow, iCol);
        this.fireTableCellUpdated(iRow, iCol);
    }

    public void setRowValues(int iRow, List lRowValues) {
        try {
            this.setRowValues1(iRow, lRowValues);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.fireRowUpdateFailed(iRow, lRowValues, e);
        }
    }

    public void setRowValues1(int iRow, List lRowValues) throws SQLException {
        this.getDataManager().setRowValues(iRow, lRowValues);
        this.fireTableRowsUpdated(iRow, iRow);
    }

    public void insertRow(int iRow, List lRowValues) {
        try {
            this.appendRow(lRowValues);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.fireRowAppendFailed(lRowValues, e);
        }
    }

    public void appendRow(List lRowValues) throws SQLException {
        this.getDataManager().appendRow(lRowValues);
        this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
    }

    public void deleteRow(int iRow) {
        try {
            this.deleteRow1(iRow);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            this.fireRowDeleteFailed(iRow, e);
        }
    }

    public void deleteRow1(int iRow) throws SQLException {
        this.getDataManager().deleteRow(iRow);
    }

    public void addViewDataModelListener(ViewDataModelListener listener) {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            this.m_viewDataListeners = new ArrayList();
        }
        this.m_viewDataListeners.add(listener);
    }

    public void removeViewDataModelListener(ViewDataModelListener listener) {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            return;
        }
        this.m_viewDataListeners.remove(listener);
    }

    public void removeAllViewDataModelListeners() {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            return;
        }
        this.m_viewDataListeners.clear();
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChanged(new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue));
    }

    public void firePropertyChanged(PropertyChangeEvent event) {
        if (this.m_viewDataListeners == null || this.m_viewDataListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_viewDataListeners.size(); ++i) {
            ViewDataModelListener listener = (ViewDataModelListener)this.m_viewDataListeners.get(i);
            listener.propertyChange(event);
        }
    }

    protected void fireFetchStarted() {
        for (ViewDataModelListener listener : this.m_viewDataListeners) {
            listener.fetchStarted();
        }
    }

    protected void fireDataFetchSuccess() {
        if (this.getViewDataPanel() != null && !this.getViewDataPanel().isFromClosingFrame()) {
            ArrayList cloneLisners = (ArrayList)this.m_viewDataListeners.clone();
            for (ViewDataModelListener listener : cloneLisners) {
                listener.fetchSuccessful();
            }
            this.fireFetchCompleted();
        }
    }

    protected void fireDataFetchError(Exception e) {
        this.fireDataFetchError(new ViewDataException(e));
    }

    protected void fireDataFetchError(ViewDataException e) {
        this.fireDataFetchError(e.getMessage(), e);
    }

    protected void fireDataFetchError(String msg, ViewDataException e) {
        for (int i = 0; i < this.m_viewDataListeners.size(); ++i) {
            ViewDataModelListener listener = (ViewDataModelListener)this.m_viewDataListeners.get(i);
            listener.fetchError(msg, e);
        }
        this.fireFetchCompleted();
    }

    protected void fireFetchCompleted() {
        if (!this.getViewDataPanel().isFromClosingFrame()) {
            ArrayList cloneLisners = (ArrayList)this.m_viewDataListeners.clone();
            for (int i = 0; i < cloneLisners.size(); ++i) {
                ViewDataModelListener listener = (ViewDataModelListener)cloneLisners.get(i);
                listener.fetchComplete();
            }
        }
    }

    public void fireCellUpdateFailed(Object value, int row, int col, Exception e) {
        this.fireCellUpdateFailed(value, row, col, new ViewDataException(e));
    }

    public void fireCellUpdateFailed(Object value, int row, int col, ViewDataException e) {
        for (ViewDataModelListener listener : this.m_viewDataListeners) {
            listener.cellUpdateFailed(value, row, col, e);
        }
    }

    public void fireRowUpdateFailed(int row, List values, Exception e) {
        this.fireRowUpdateFailed(row, values, new ViewDataException(e));
    }

    public void fireRowUpdateFailed(int row, List values, ViewDataException e) {
        for (ViewDataModelListener listener : this.m_viewDataListeners) {
            listener.rowUpdateFailed(row, values, e);
        }
    }

    public void fireRowAppendFailed(List values, Exception e) {
        this.fireRowAppendFailed(values, new ViewDataException(e));
    }

    public void fireRowAppendFailed(List values, ViewDataException e) {
        for (ViewDataModelListener listener : this.m_viewDataListeners) {
            listener.rowAppendFailed(values, e);
        }
    }

    public void fireRowDeleteFailed(int row, Exception e) {
        this.fireRowDeleteFailed(row, new ViewDataException(e));
    }

    public void fireRowDeleteFailed(int row, ViewDataException e) {
        for (ViewDataModelListener listener : this.m_viewDataListeners) {
            listener.rowDeleteFailed(row, e);
        }
    }

    public void waitOnDataFetch() {
        this.waitOnDataFetch(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnDataFetch(long timeout) {
        byte[] byArray = this.mutex;
        synchronized (this.mutex) {
            if (!this.isFetchDataRunning()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            try {
                this.mutex.wait(timeout);
            }
            catch (InterruptedException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataFetch() {
        byte[] byArray = this.mutex;
        synchronized (this.mutex) {
            this.mutex.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getQuery() throws MdException, RemoteException, ViewDataException, SQLException {
        String query = "SELECT ";
        query = query + this.getColumnsClause();
        query = query + this.getTableClause(this.getLibRef());
        query = query + this.getWhereClause();
        query = query + this.getOrderByClause();
        Workspace.getDefaultLogger().info((Object)query);
        return query;
    }

    protected String getColumnsClause() throws MdException, RemoteException {
        String clause = "";
        int cols = this.getDisplayColumns().length;
        for (int i = 0; i < cols; ++i) {
            String format;
            String colName = this.getTrueColumnSQLName(this.getDisplayColumns()[i]);
            clause = clause + colName;
            if (this.isApplyFormats() && (format = this.getTrueColumnFormat(this.getDisplayColumns()[i])) != null && format.length() > 0) {
                clause = clause + " FORMAT=";
                clause = clause + format;
                if (format.indexOf(".") == -1) {
                    clause = clause + ".";
                }
            }
            if (i == cols - 1) continue;
            clause = clause + ",";
        }
        return clause;
    }

    protected String getTableClause(String libref) throws MdException, RemoteException, ViewDataException, SQLException {
        String clause = " FROM " + libref + ".";
        clause = clause + this.getTableSQLName();
        clause = clause + this.getTableOptions();
        if (this instanceof ViewDataDataTableModel) {
            ViewDataDataTableModel tempModel = (ViewDataDataTableModel)this;
            if (this.hasSortColumns() && tempModel.getLibrary().getEngine().equalsIgnoreCase("SASIOIMP")) {
                String obsOption = "( obs=";
                obsOption = obsOption + this.getTableRows();
                obsOption = obsOption + " ";
                if (this.getTableOptions().length() != 0) {
                    int position = clause.indexOf("(");
                    String tempStr = clause;
                    clause = tempStr.substring(0, position).concat(obsOption).concat(tempStr.substring(position + 1));
                } else {
                    clause = clause + obsOption;
                    clause = clause + ") ";
                }
            }
        }
        return clause;
    }

    protected String getWhereClause() {
        if (!this.hasFilter()) {
            return "";
        }
        return " WHERE " + this.getFilter();
    }

    protected String getOrderByClause() {
        if (!this.hasSortColumns()) {
            return "";
        }
        int[] sortColumns = this.getSortedColumns();
        String query = " ORDER BY ";
        int size = sortColumns.length;
        for (int i = 0; i < size; ++i) {
            String columnName = this.getTrueColumnSQLName(sortColumns[i]);
            query = query + columnName;
            if (this.getSortedColumnOrder()[i] == SortDirection.DIRECTION_DESCENDING) {
                query = query + " DESC";
            }
            if (i >= size - 1) continue;
            query = query + ",";
        }
        return query;
    }

    protected int getTableRows() throws RemoteException, MdException, ViewDataException, SQLException {
        String query = "SELECT count(*) ";
        query = query + " FROM " + this.getLibRef() + ".";
        query = query + this.getTableSQLName();
        query = query + this.getWhereClause();
        Statement smt = this.createStatement();
        ResultSet rs = smt.executeQuery(query);
        rs.next();
        return rs.getInt(1);
    }

    public int updateRowLimit() {
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        boolean isLimited = file.getPropertyBoolean("ViewData.RowLimit", false);
        this.m_iRowLimit = isLimited ? file.getPropertyInt("ViewData.RowLimitValue", 100000) : 0;
        return this.m_iRowLimit;
    }

    public int getRowLimit() {
        return this.m_iRowLimit;
    }

    static {
        if (RUN_DEAD_CODE) {
            new SortDirection();
        }
        UNCHANGED_VALUE = DataManager.UNCHANGED_VALUE;
        UNKNOWN_DATE = new Date(Long.MAX_VALUE);
        UNKNOWN_DOUBLE = new Double(Double.MAX_VALUE);
    }

    class DataManagerListener
    implements PropertyChangeListener {
        DataManagerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ViewDataModel.PROPERTY_MAX_ROW_COUNT_YET.equals(evt.getPropertyName())) {
                int newRowCount;
                int oldRowCount = (Integer)evt.getOldValue();
                if (oldRowCount < (newRowCount = ((Integer)evt.getNewValue()).intValue())) {
                    if (newRowCount - oldRowCount < 3000000) {
                        ViewDataModel.this.fireTableRowsInserted(oldRowCount, newRowCount - 1);
                    } else {
                        ViewDataModel.this.fireTableDataChanged();
                    }
                } else if (oldRowCount > newRowCount) {
                    ViewDataModel.this.fireTableRowsDeleted(newRowCount, oldRowCount - 1);
                }
                ViewDataModel.this.firePropertyChanged(new PropertyChangeEvent((Object)ViewDataModel.this, ViewDataModel.PROPERTY_MAX_ROW_COUNT_YET, evt.getOldValue(), evt.getNewValue()));
            } else if (ViewDataModel.PROPERTY_ROW_COUNT.equals(evt.getPropertyName())) {
                ViewDataModel.this.firePropertyChanged(new PropertyChangeEvent((Object)ViewDataModel.this, ViewDataModel.PROPERTY_ROW_COUNT, evt.getOldValue(), evt.getNewValue()));
            }
        }
    }

    class DataFetchRunnable
    implements Runnable {
        DataFetchRunnable() {
        }

        @Override
        public void run() {
            try {
                ViewDataModel.this.fetchDataPreemptive();
                ViewDataModel.this.setFetchDataRunning(false);
                ViewDataModel.this.fireDataFetchSuccess();
            }
            catch (ViewDataException e) {
                ViewDataModel.this.setFetchDataRunning(false);
                ViewDataModel.this.setHasDataFetchError(true);
                ViewDataModel.this.fireDataFetchError(e);
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ViewDataModel.this.postFetchDataProcessing();
                        }
                        catch (ViewDataException e) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
            ViewDataModel.this.notifyDataFetch();
        }
    }

    public static final class SortDirection {
        public static final SortDirection DIRECTION_ASCENDING = new SortDirection();
        public static final SortDirection DIRECTION_DESCENDING = new SortDirection();

        private SortDirection() {
        }
    }
}

