/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class ViewDataJDBCModel
extends ViewDataModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataJDBCModel.class);
    private ColumnDisplayLabelHelper m_labelHelper = new ColumnDisplayLabelHelper();
    private boolean m_bUpdatingColumns = false;

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateColumnInformation() {
        if (this.getDataManager() == null) {
            return;
        }
        if (this.m_bUpdatingColumns) {
            return;
        }
        this.m_bUpdatingColumns = true;
        try {
            int colCount = this.getColumnCount();
            this.m_aColumns = new WsAbstractTableColumn[colCount];
            for (int i = 0; i < colCount; ++i) {
                String label = this.getColumnDisplayName(i);
                String type = this.getColumnSASType(i);
                this.m_aColumns[i] = "C".equals(type) ? new WsStringTableColumn(i, label, 75) : new WsIntegerTableColumn(i, label, 75);
            }
            this.fireTableStructureChanged();
        }
        finally {
            this.m_bUpdatingColumns = false;
        }
    }

    @Override
    public Statement createStatement() throws ViewDataException, SQLException {
        return this.getConnectionManager().getConnection().createStatement(1004, 1008);
    }

    @Override
    protected void postFetchDataProcessing() throws ViewDataException {
        this.updateColumnInformation();
    }

    @Override
    public int getColumnCount() {
        if (this.getDataManager() == null) {
            return 0;
        }
        try {
            return this.getRSMetadata().getColumnCount();
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return -1;
        }
    }

    @Override
    public int getTrueColumnCount() {
        return this.getColumnCount();
    }

    @Override
    public String getTrueColumnName(int column) {
        try {
            return this.getRSMetadata().getColumnName(column + 1);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return bundle.getString("ViewDataJDBCModel.UnknownColumnName");
        }
    }

    @Override
    public String getTrueColumnObjectName(int iColumn) {
        return this.getTrueColumnName(iColumn);
    }

    @Override
    public String getTrueColumnDescription(int iColumn) {
        return "";
    }

    @Override
    public String getTrueColumnDisplayName(int column) {
        try {
            return this.m_labelHelper.getColumnDisplayName(column);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return bundle.getString("ViewDataJDBCModel.UnknownColumnName");
        }
    }

    @Override
    public String getTrueColumnSQLName(int column) {
        try {
            return this.getRSMetadata().getColumnName(column + 1);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getTrueColumnSASType(int column) {
        try {
            int columnType = this.getColumnJDBCType(column);
            switch (columnType) {
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    return "N";
                }
                case 91: 
                case 92: 
                case 93: {
                    return "D";
                }
            }
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        return "C";
    }

    @Override
    public int getTrueColumnPrecision(int column) {
        try {
            return this.getRSMetadata().getPrecision(column + 1);
        }
        catch (SQLException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return -1;
        }
    }

    protected String getTrueColumnLabel(int column) throws SQLException {
        return this.getRSMetadata().getColumnLabel(column + 1);
    }

    protected int getColumnJDBCType(int column) throws SQLException {
        return this.getRSMetadata().getColumnType(column + 1);
    }

    @Override
    public void setShowColumnName(boolean show) {
        this.m_labelHelper.setShowColumnName(show);
    }

    @Override
    public void setShowLabel(boolean show) {
        this.m_labelHelper.setShowLabel(show);
    }

    public boolean getShowColumnName() {
        return this.m_labelHelper.getShowColumnName();
    }

    public boolean getShowLabel() {
        return this.m_labelHelper.getShowLabel();
    }

    protected ResultSetMetaData getRSMetadata() {
        return this.getDataManager().getRSMetadata();
    }

    public class ColumnDisplayLabelHelper {
        private boolean m_showColumnName;
        private boolean m_showLabel;

        public ColumnDisplayLabelHelper() {
            this.init();
        }

        private void init() {
            WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_showColumnName = file.getPropertyBoolean("ViewData.ShowColumnNameInColumnHeader", true);
            this.m_showLabel = file.getPropertyBoolean("ViewData.ShowDescriptionInColumnHeader", false);
        }

        public void setShowColumnName(boolean show) {
            if (this.m_showColumnName == show) {
                return;
            }
            this.m_showColumnName = show;
            ViewDataJDBCModel.this.firePropertyChanged("ColumnDisplayLabel", new Boolean(!this.m_showColumnName), new Boolean(this.m_showColumnName));
        }

        public void setShowLabel(boolean show) {
            if (this.m_showLabel == show) {
                return;
            }
            this.m_showLabel = show;
            ViewDataJDBCModel.this.firePropertyChanged("ColumnDisplayLabel", new Boolean(!this.m_showLabel), new Boolean(this.m_showLabel));
        }

        public boolean getShowColumnName() {
            return this.m_showColumnName;
        }

        public boolean getShowLabel() {
            return this.m_showLabel;
        }

        public String getColumnDisplayName(int column) throws SQLException {
            String name = ViewDataJDBCModel.this.getTrueColumnName(column);
            String label = ViewDataJDBCModel.this.getTrueColumnLabel(column);
            if (this.m_showColumnName) {
                if (this.m_showLabel) {
                    return this.getFormattedLabel(name, label);
                }
                return name;
            }
            if (this.m_showLabel) {
                return label != null && !"".equals(label) ? label : name;
            }
            return name;
        }

        private String getFormattedLabel(String s1, String s2) {
            return s1 + " (" + s2 + ")";
        }
    }
}

