/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.viewdata2.CommonActionsFactory;
import com.sas.wadmin.viewdata2.ConnectionManager;
import com.sas.wadmin.viewdata2.QueryOptionsDialog;
import com.sas.wadmin.viewdata2.SearchToolArea;
import com.sas.wadmin.viewdata2.ViewDataException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.wadmin.viewdata2.ViewDataPanel;
import com.sas.wadmin.viewdata2.ViewDataTable;
import com.sas.wadmin.viewdata2.ViewDataToolBar;
import com.sas.wadmin.viewdata2.ViewDataUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoManager;

public abstract class ViewDataAbstractFactory {
    private static WAdminResource bundle = WAdminResource.getBundle(ViewDataAbstractFactory.class);
    private ConnectionManager m_connManager;
    private ViewDataModel m_model;
    private SearchToolArea m_searchToolArea;
    private QueryOptionsDialog m_queryOptions;
    private ViewDataToolBar m_toolbar;
    private JPopupMenu m_tablePopup;
    private ViewDataUndoManager m_undoManager;
    private ViewDataTable m_table;
    private Map m_mapActions = new HashMap();
    protected WsAppServer m_appServer;
    private boolean m_canDisposeFactory = true;

    public ConnectionManager createDefaultConnectionManager() throws ViewDataException {
        if (!this.hasDefaultConnectionManager()) {
            this.m_connManager = this.createConnectionManager();
        }
        return this.m_connManager;
    }

    public ViewDataModel createDefaultModel() throws ViewDataException {
        if (!this.hasDefaultModel()) {
            this.m_model = this.createModel();
        }
        return this.m_model;
    }

    public SearchToolArea createDefaultSearchToolArea() throws ViewDataException {
        if (!this.hasDefaultSearchToolArea()) {
            this.m_searchToolArea = this.createSearchToolArea();
        }
        return this.m_searchToolArea;
    }

    public QueryOptionsDialog createDefaultQueryOptionsDialog() throws ViewDataException {
        if (!this.hasDefaultQueryOptionsDialog()) {
            this.m_queryOptions = this.createQueryOptionsDialog();
        }
        return this.m_queryOptions;
    }

    public ViewDataToolBar createDefaultToolBar() throws ViewDataException {
        if (!this.hasDefaultToolBar()) {
            this.m_toolbar = this.createToolBar();
        }
        return this.m_toolbar;
    }

    public ViewDataTable createDefaultTable() throws ViewDataException {
        if (!this.hasDefaultTable()) {
            this.m_table = this.createTable();
        }
        return this.m_table;
    }

    public JPopupMenu createDefaultTablePopupMenu() throws ViewDataException {
        if (!this.hasDefaultTablePopupMenu()) {
            this.m_tablePopup = this.createTablePopupMenu();
        }
        return this.m_tablePopup;
    }

    public JPopupMenu createDefaultTableRowHeaderPopup() throws ViewDataException {
        return this.createTableRowHeaderPopupMenu();
    }

    public ViewDataUndoManager createDefaultUndoManager() {
        if (!this.hasDefaultUndoManager()) {
            this.m_undoManager = this.createUndoManager();
        }
        return this.m_undoManager;
    }

    public ConnectionManager getDefaultConnectionManager() {
        return this.m_connManager;
    }

    public ViewDataModel getDefaultModel() {
        return this.m_model;
    }

    public SearchToolArea getDefaultSearchToolArea() {
        return this.m_searchToolArea;
    }

    public QueryOptionsDialog getDefaultQueryOptionsDialog() {
        return this.m_queryOptions;
    }

    public ViewDataToolBar getDefaultToolBar() {
        return this.m_toolbar;
    }

    public ViewDataTable getDefaultTable() {
        return this.m_table;
    }

    public JPopupMenu getDefaultTablePopupMenu() {
        return this.m_tablePopup;
    }

    public JPopupMenu getDefaultTableRowHeaderPopup() {
        try {
            return this.createTableRowHeaderPopupMenu();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return null;
        }
    }

    public ViewDataUndoManager getDefaultUndoManager() {
        return this.m_undoManager;
    }

    public void setAppServer(WsAppServer appServer) {
        this.m_appServer = appServer;
    }

    protected WsAppServer getAppServer() {
        return this.m_appServer;
    }

    public boolean hasDefaultConnectionManager() {
        return this.m_connManager != null;
    }

    public boolean hasDefaultModel() {
        return this.m_model != null;
    }

    public boolean hasDefaultSearchToolArea() {
        return this.m_searchToolArea != null;
    }

    public boolean hasDefaultQueryOptionsDialog() {
        return this.m_queryOptions != null;
    }

    public boolean hasDefaultToolBar() {
        return this.m_toolbar != null;
    }

    public boolean hasDefaultTable() {
        return this.m_table != null;
    }

    public boolean hasDefaultTablePopupMenu() {
        return this.m_tablePopup != null;
    }

    public boolean hasDefaultTableRowHeaderPopup() {
        return true;
    }

    public boolean hasDefaultUndoManager() {
        return this.m_undoManager != null;
    }

    public void disposeDefaultConnectionManager() throws ViewDataException {
        if (this.hasDefaultConnectionManager()) {
            this.getDefaultConnectionManager().dispose();
        }
        this.m_connManager = null;
    }

    public void disposeDefaultModel() throws ViewDataException {
        if (this.hasDefaultModel()) {
            this.getDefaultModel().dispose();
        }
        this.m_model = null;
    }

    public void disposeDefaultSearchToolArea() throws ViewDataException {
        if (this.hasDefaultSearchToolArea()) {
            this.getDefaultSearchToolArea().setVisible(false);
            this.getDefaultSearchToolArea().saveSettingsAndCleanUp();
        }
        this.m_searchToolArea = null;
    }

    public void disposeDefaultQueryOptionsDialog() throws ViewDataException {
        if (this.hasDefaultQueryOptionsDialog()) {
            this.getDefaultQueryOptionsDialog().setVisible(false);
            this.getDefaultQueryOptionsDialog().dispose();
        }
        this.m_queryOptions = null;
    }

    public void disposeDefaultToolBar() throws ViewDataException {
        if (this.hasDefaultToolBar()) {
            this.getDefaultToolBar().dispose();
        }
        this.m_toolbar = null;
    }

    public void disposeDefaultTable() throws ViewDataException {
        if (this.hasDefaultTable()) {
            this.getDefaultTable().cancelRowEditing();
            this.getDefaultTable().setVisible(false);
        }
        this.m_table = null;
    }

    public void disposeDefaultTablePopupMenu() throws ViewDataException {
        if (this.hasDefaultTablePopupMenu()) {
            this.getDefaultTablePopupMenu().setVisible(false);
            this.m_tablePopup = null;
        }
    }

    public void disposeDefaultTableRowHeaderPopup() throws ViewDataException {
    }

    public void disposeDefaultUndoManager() throws ViewDataException {
        if (this.hasDefaultUndoManager()) {
            this.getDefaultTable().getUndoManager().discardAllEdits();
        }
        this.m_undoManager = null;
    }

    protected abstract ConnectionManager createConnectionManager() throws ViewDataException;

    public abstract ViewDataModel createModel() throws ViewDataException;

    protected SearchToolArea createSearchToolArea() throws ViewDataException {
        return new SearchToolArea(this.createDefaultTable());
    }

    protected QueryOptionsDialog createQueryOptionsDialog() throws ViewDataException {
        return new QueryOptionsDialog(this.createDefaultModel());
    }

    protected ViewDataToolBar createToolBar() throws ViewDataException {
        ViewDataToolBar toolbar = new ViewDataToolBar();
        WsAbstractAction actRefresh = CommonActionsFactory.getRefreshAction(this.createDefaultModel(), new CommonActionsFactory.ShowMessageExceptionHandler(bundle.getString("ViewDataAbstractFactory.RefreshErrorHandlerUserMessage.fmt.txt")));
        WsAbstractAction actPrint = CommonActionsFactory.getPrintAction(this.createDefaultTable());
        toolbar.addInvisibleAction(actRefresh);
        toolbar.addInvisibleAction(actPrint);
        toolbar.addInvisibleAction(CommonActionsFactory.getViewDataMenuAction());
        this.putAction("Common:Print", actPrint);
        this.putAction("Common:Refresh", actRefresh);
        return toolbar;
    }

    protected void addAccelerators(ViewDataPanel pnl) throws ViewDataException {
        InputMap mapInput = pnl.getInputMap(1);
        mapInput.put(KeyStroke.getKeyStroke(116, 0), "refresh");
        mapInput.put(KeyStroke.getKeyStroke(80, 2), "print");
        ActionMap mapActions = pnl.getActionMap();
        mapActions.put("print", (Action)this.getAction("Common:Print"));
        mapActions.put("refresh", (Action)this.getAction("Common:Refresh"));
    }

    protected WsAbstractAction getAction(String sAction) {
        return (WsAbstractAction)this.m_mapActions.get(sAction);
    }

    private void putAction(String sAction, WsAbstractAction act) {
        this.m_mapActions.put(sAction, act);
    }

    protected JPopupMenu createTablePopupMenu() throws ViewDataException {
        JPopupMenu tablePopup = new JPopupMenu();
        tablePopup.add((Action)CommonActionsFactory.getGoToFirstRowAction(this.createDefaultTable()));
        tablePopup.add((Action)CommonActionsFactory.getGoToLastRowAction(this.createDefaultTable()));
        tablePopup.addSeparator();
        tablePopup.add((Action)CommonActionsFactory.getCopyAction(this.createDefaultTable()));
        return tablePopup;
    }

    protected JPopupMenu createTableRowHeaderPopupMenu() throws ViewDataException {
        return this.createDefaultTable().createRowHeaderPopupMenu();
    }

    protected ViewDataTable createTable() throws ViewDataException {
        ViewDataTable table = new ViewDataTable(this.createDefaultModel());
        table.setUndoManager((UndoManager)((Object)this.createDefaultUndoManager()));
        return table;
    }

    protected ViewDataUndoManager createUndoManager() {
        return new ViewDataUndoManager(1);
    }

    public void dispose() throws ViewDataException {
        ViewDataException ve = null;
        try {
            this.disposeDefaultToolBar();
            this.disposeDefaultUndoManager();
            this.disposeDefaultTable();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            ve = e;
        }
        try {
            this.disposeDefaultModel();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            ve = e;
        }
        try {
            this.disposeDefaultConnectionManager();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            ve = e;
        }
        try {
            this.disposeDefaultSearchToolArea();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            ve = e;
        }
        try {
            this.disposeDefaultQueryOptionsDialog();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            ve = e;
        }
        try {
            this.disposeDefaultTablePopupMenu();
        }
        catch (ViewDataException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            ve = e;
        }
        if (ve != null) {
            throw ve;
        }
    }

    protected void setFactoryDisposable(boolean bDispose) {
        this.m_canDisposeFactory = bDispose;
        if (this.m_canDisposeFactory && this.getDefaultModel() != null && this.getDefaultModel().getViewDataPanel() != null && this.getDefaultModel().getViewDataPanel().isFromClosingFrame()) {
            this.getDefaultModel().getViewDataPanel().closeParentFrame();
        }
    }

    protected boolean isFactoryDisposable() {
        return this.m_canDisposeFactory;
    }

    protected abstract PhysicalTable getPhysicalTable() throws ViewDataException;

    protected abstract boolean isDatasetEditable() throws ViewDataException;

    protected boolean isDefaultAppServerWorkspace() throws MdException, RemoteException, ViewDataException {
        String sServerFQID = WsAppServer.getDefaultAppServerFQID();
        if (sServerFQID.length() == 0) {
            WsAppServer.showDefaultAppServerPrompt();
            sServerFQID = WsAppServer.getDefaultAppServerFQID();
            if (sServerFQID.length() == 0) {
                return false;
            }
        }
        ServerContext iSCx = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.getPhysicalTable().getObjectStore(), "", "ServerContext", sServerFQID);
        AssociationList lLogicals = iSCx.getUsingComponents();
        for (int j = 0; j < lLogicals.size(); ++j) {
            LogicalServer iLs = (LogicalServer)lLogicals.get(j);
            if ("440196D4-90F0-11D0-9F41-00A024BB830C".compareTo(iLs.getClassIdentifier()) != 0) continue;
            return true;
        }
        return false;
    }
}

