/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.DNDObject;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoManager;

public class QueryOptionsSortTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(QueryOptionsSortTab.class);
    private static final int SCROLL_PANE_WIDTH = 165;
    private static final int SCROLL_PANE_HEIGHT = 315;
    private static String[] m_sortDirectionArray = new String[]{bundle.getString("QueryOptionsSortTab.Ascending.txt"), bundle.getString("QueryOptionsSortTab.Descending.txt")};
    private DNDTable m_table;
    private DNDScrollPane m_tableScrollPane;
    private DNDList m_list;
    private DefaultListModel m_listModel;
    private JScrollPane m_listScrollPane;
    private JButton m_addItemButton;
    private JButton m_addAllButton;
    private JButton m_removeItemButton;
    private JButton m_removeAllButton;
    private AddItemAction m_actAddItem;
    private AddAllItemAction m_actAddAllItem;
    private RemoveItemAction m_actRemoveItem;
    private RemoveAllItemAction m_actRemoveAllItem;
    private ArrayList m_unselectedColumns;
    private ViewDataModel m_model;
    private ViewDataSortByModel m_tableModel;

    public QueryOptionsSortTab(ViewDataModel model) {
        this.m_model = model;
        this.constructColumnWrappers();
        this.initialize();
        this.layoutWidgets();
        this.updateFromModel();
    }

    public void initialize() {
        this.m_addItemButton = new JButton();
        this.m_addAllButton = new JButton();
        this.m_removeItemButton = new JButton();
        this.m_removeAllButton = new JButton();
        this.m_actAddItem = new AddItemAction();
        this.m_actAddAllItem = new AddAllItemAction();
        this.m_actRemoveItem = new RemoveItemAction();
        this.m_actRemoveAllItem = new RemoveAllItemAction();
        this.m_addItemButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actAddItem);
        this.m_addAllButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actAddAllItem);
        this.m_removeItemButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actRemoveItem);
        this.m_removeAllButton = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actRemoveAllItem);
        this.m_listModel = new DefaultListModel();
        this.m_list = new DNDList(this.m_listModel);
        this.m_list.initialize();
        ListSelectionModel llsm = this.m_list.getSelectionModel();
        llsm.addListSelectionListener(new ListBoxListSelectionListener());
        this.m_list.addMouseListener(new ListMouseListener());
        this.m_list.addFocusListener(new ListFocusListener());
        this.m_listScrollPane = new JScrollPane(this.m_list);
        this.m_listScrollPane.setPreferredSize(new Dimension(115, 315));
        this.m_tableModel = new ViewDataSortByModel();
        this.m_table = new DNDTable(this.m_tableModel);
        this.m_table.initialize();
        this.m_table.setAutoResizeMode(1);
        this.m_table.setSelectionMode(2);
        this.m_table.setColumnHidingEnabled(false);
        this.m_table.setColumnHoldingEnabled(false);
        this.m_table.setRowHoldingEnabled(false);
        this.m_table.setRowHeaderVisible(true);
        this.m_table.setMultipleSelectionDragEnabled(true);
        this.m_table.setUndoManager((UndoManager)this.waum);
        ((WsDefaultTableRowModel)this.m_table.getRowModel()).addRowModelListener((WsTableRowModelListener)new TableRowModelListener());
        ListSelectionModel tlsm = this.m_table.getSelectionModel();
        tlsm.addListSelectionListener(new TableSelectionListener());
        this.m_table.addMouseListener(new ListMouseListener());
        this.m_tableScrollPane = new DNDScrollPane();
        this.m_tableScrollPane.getViewport().setView((Component)((Object)this.m_table));
        this.m_tableScrollPane.setPreferredSize(new Dimension(215, 315));
        this.setHelpProduct("wdb");
        this.setHelpTopic("view_data_sort_by_columns");
    }

    protected void layoutWidgets() {
        WAPanel m_panel = new WAPanel();
        WAPanel m_buttonPanel = new WAPanel();
        JLabel m_tableLabel = new JLabel(bundle.getString("QueryOptionsSortTab.SortByColumnsLabel.txt"));
        m_tableLabel.setLabelFor((Component)((Object)this.m_table));
        m_tableLabel.setDisplayedMnemonic(bundle.getString("QueryOptionsSortTab.SortByColumnsLabel.mnem").charAt(0));
        JLabel m_listBoxLabel = new JLabel(bundle.getString("QueryOptionsSortTab.ColumnsLabel.txt"));
        m_listBoxLabel.setLabelFor(this.m_list);
        m_listBoxLabel.setDisplayedMnemonic(bundle.getString("QueryOptionsSortTab.ColumnsLabel.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        m_panel.setLayout((LayoutManager)new GridBagLayout());
        m_buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        m_panel.add((Component)m_listBoxLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        m_panel.add((Component)this.m_listScrollPane, (Object)new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        m_panel.add((Component)m_tableLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        m_panel.add((Component)this.m_tableScrollPane, (Object)new GridBagConstraints(2, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        m_panel.add((Component)m_buttonPanel, (Object)new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        m_buttonPanel.add((Component)this.m_addItemButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_addAllButton, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_removeItemButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        m_buttonPanel.add((Component)this.m_removeAllButton, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)m_panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() {
        this.m_tableModel.moveDataToModel();
    }

    protected void updateFromModel() {
        this.constructColumnWrappers();
        this.setSelectedColumns(this.m_model.getSortedColumns(), this.m_model.getSortedColumnOrder());
    }

    protected void constructColumnWrappers() {
        this.m_unselectedColumns = new ArrayList();
        for (int i = 0; i < this.m_model.getTrueColumnCount(); ++i) {
            this.m_unselectedColumns.add(new ColumnWrapper(i));
        }
    }

    public void setSelectedColumns(int[] sortedColumns, ViewDataModel.SortDirection[] sortedDirections) {
        if (this.m_table.getRowCount() != 0) {
            this.m_table.selectAll();
            this.removeItemsFromTable();
        }
        if (sortedColumns != null) {
            for (int i = 0; i < sortedColumns.length; ++i) {
                for (int j = 0; j < this.m_listModel.size(); ++j) {
                    if (((ColumnWrapper)this.m_listModel.elementAt(j)).getModelIndex() != sortedColumns[i]) continue;
                    this.m_list.setSelectedIndex(j);
                    this.addItemsToTable();
                    break;
                }
                String sortDirection = sortedDirections[i] == ViewDataModel.SortDirection.DIRECTION_ASCENDING ? m_sortDirectionArray[0] : m_sortDirectionArray[1];
                this.m_table.getModel().setValueAt(sortDirection, i, 1);
            }
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.enableButtons();
        this.m_list.setEnabled(bEditable);
        this.m_table.setEnabled(bEditable);
        this.m_table.setCellSelectionEnabled(bEditable);
        this.m_table.getTableHeader().setReorderingAllowed(bEditable);
    }

    public void addItemsToTable() {
        if (!this.isEditable()) {
            return;
        }
        int[] index = this.m_list.getSelectedIndices();
        if (index.length == 0) {
            return;
        }
        int count = 0;
        for (int i = 0; i < index.length; ++i) {
            this.m_tableModel.insertRow(this.m_listModel.remove(index[i] - count++));
        }
        this.m_list.setSelectedIndex(0);
        this.enableButtons();
        this.m_table.requestFocus();
    }

    public void removeItemsFromTable() {
        if (!this.isEditable()) {
            return;
        }
        int[] index = this.m_table.getSelectedRowsFromSelectedCells();
        if (index.length == 0) {
            return;
        }
        int count = 0;
        for (int i = 0; i < index.length; ++i) {
            int lastSelection = index[i] - count;
            ColumnWrapper column = (ColumnWrapper)this.m_table.getValueAt(lastSelection, this.m_table.convertColumnIndexToView(0));
            this.m_tableModel.deleteRow(this.m_table.convertRowIndexToModel(lastSelection));
            this.m_listModel.addElement(column);
            ++count;
        }
        this.enableButtons();
        this.m_list.requestFocus();
    }

    public void enableButtons() {
        boolean addEnabled = this.m_list.getModel().getSize() != 0 && this.m_list.getSelectedIndex() > -1 && this.isEditable();
        this.m_addItemButton.setEnabled(addEnabled);
        this.m_addItemButton.setVisible(addEnabled);
        this.m_addAllButton.setEnabled(addEnabled);
        this.m_addAllButton.setVisible(addEnabled);
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        boolean removeEnabled = selectedRows != null && selectedRows.length > 0 && this.isEditable();
        this.m_removeItemButton.setEnabled(removeEnabled);
        this.m_removeItemButton.setVisible(removeEnabled);
        this.m_removeAllButton.setEnabled(removeEnabled);
        this.m_removeAllButton.setVisible(removeEnabled);
        if (!addEnabled && !removeEnabled) {
            this.m_addItemButton.setEnabled(false);
            this.m_addItemButton.setVisible(true);
            this.m_addAllButton.setEnabled(false);
            this.m_addAllButton.setVisible(true);
        }
    }

    public ArrayList getSortByColumns() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int size = this.m_table.getRowCount();
        for (int i = 0; i < size; ++i) {
            ColumnWrapper column = (ColumnWrapper)this.m_table.getValueAt(i, this.m_table.convertColumnIndexToView(0));
            String sortDirection = (String)this.m_table.getValueAt(i, this.m_table.convertColumnIndexToView(1));
            Object[] row = new Object[]{new Integer(column.getModelIndex()), sortDirection.equals(m_sortDirectionArray[0]) ? ViewDataModel.SortDirection.DIRECTION_ASCENDING : ViewDataModel.SortDirection.DIRECTION_DESCENDING};
            list.add(row);
        }
        return list;
    }

    public boolean hasClauseChanged() {
        ArrayList list = this.getSortByColumns();
        if (this.m_model.getSortedColumns() == null ? list.size() != 0 : list.size() != this.m_model.getSortedColumns().length) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object[] row = (Object[])list.get(i);
            int column = (Integer)row[0];
            ViewDataModel.SortDirection sortDirection = (ViewDataModel.SortDirection)row[1];
            if (column == this.m_model.getSortedColumns()[i] && sortDirection == this.m_model.getSortedColumnOrder()[i]) continue;
            return true;
        }
        return false;
    }

    public void drop(DropTargetDropEvent event) {
        try {
            Vector dndObj = null;
            Transferable transfer = event.getTransferable();
            if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                Object tempObj = dndObj.get(0);
                if (tempObj instanceof DNDList) {
                    event.acceptDrop(2);
                    this.addItemsToTable();
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            event.rejectDrop();
        }
    }

    class DNDTable
    extends WsTable
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private DragSource m_dragSource;

        public DNDTable(ViewDataSortByModel ssbm) {
            super((WsAbstractTableModel)ssbm);
            this.setSortingEnabled(false);
            this.setColumnHoldingEnabled(false);
            this.setColumnHidingEnabled(false);
            this.setRowHoldingEnabled(false);
        }

        public void initialize() {
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 2, this);
            new DropTarget((Component)((Object)this), this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (QueryOptionsSortTab.this.m_table.getSelectedRowsFromSelectedCells().length == 1) {
                DNDObject DNDO = new DNDObject((Object)this);
                this.m_dragSource.startDrag(dge, null, (Transferable)DNDO, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof DNDList) {
                        event.acceptDrop(2);
                        QueryOptionsSortTab.this.addItemsToTable();
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class DNDList
    extends JList
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        private DragSource m_dragSource;

        public DNDList(DefaultListModel dlm) {
            super(dlm);
        }

        public void initialize() {
            this.m_dragSource = new DragSource();
            this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            new DropTarget(this, this);
            for (int i = 0; i < QueryOptionsSortTab.this.m_unselectedColumns.size(); ++i) {
                QueryOptionsSortTab.this.m_listModel.addElement(QueryOptionsSortTab.this.m_unselectedColumns.get(i));
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (QueryOptionsSortTab.this.m_list.getSelectedIndices().length == 1) {
                DNDObject DNDO = new DNDObject((Object)this);
                this.m_dragSource.startDrag(dge, null, (Transferable)DNDO, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof DNDTable) {
                        event.acceptDrop(2);
                        QueryOptionsSortTab.this.removeItemsFromTable();
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class AddItemAction
    extends WsAbstractAction {
        public AddItemAction() {
            super(bundle, "QueryOptionsSortTab.ButtonAddItem", 18);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsSortTab.this.addItemsToTable();
        }
    }

    class AddAllItemAction
    extends WsAbstractAction {
        public AddAllItemAction() {
            super(bundle, "QueryOptionsSortTab.ButtonAddAll", 18);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsSortTab.this.m_list.setSelectionInterval(0, QueryOptionsSortTab.this.m_listModel.getSize() - 1);
            QueryOptionsSortTab.this.addItemsToTable();
        }
    }

    class RemoveItemAction
    extends WsAbstractAction {
        public RemoveItemAction() {
            super(bundle, "QueryOptionsSortTab.ButtonRemoveItem", 18);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsSortTab.this.removeItemsFromTable();
        }
    }

    class RemoveAllItemAction
    extends WsAbstractAction {
        public RemoveAllItemAction() {
            super(bundle, "QueryOptionsSortTab.ButtonRemoveAll", 18);
        }

        public void actionPerformed(ActionEvent e) {
            QueryOptionsSortTab.this.m_table.selectAll();
            QueryOptionsSortTab.this.removeItemsFromTable();
        }
    }

    class ListBoxListSelectionListener
    implements ListSelectionListener {
        ListBoxListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || !QueryOptionsSortTab.this.isEditable()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                QueryOptionsSortTab.this.m_table.clearSelection();
            }
            QueryOptionsSortTab.this.enableButtons();
        }
    }

    class ListMouseListener
    extends MouseAdapter {
        ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (QueryOptionsSortTab.this.m_list == e.getSource()) {
                    QueryOptionsSortTab.this.addItemsToTable();
                } else {
                    QueryOptionsSortTab.this.removeItemsFromTable();
                }
            }
        }
    }

    class ListFocusListener
    extends FocusAdapter {
        ListFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JList list = (JList)e.getComponent();
            if (list.getSelectedIndex() == -1 && QueryOptionsSortTab.this.isEditable() && list.getModel().getSize() > 0) {
                list.setSelectedIndex(0);
            }
            QueryOptionsSortTab.this.enableButtons();
        }
    }

    public class ViewDataSortByModel
    extends WsAbstractTableModel {
        private boolean[] isColumnEditable = new boolean[]{false, true};

        public ViewDataSortByModel() {
            this.m_aColumns = new WsAbstractTableColumn[2];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("QueryOptionsSortTab.ColumnNameLabel.txt"), 75);
            this.m_aColumns[0].setEditable(false);
            WsEnumeratedTableColumn sortDirectionColumn = new WsEnumeratedTableColumn(1, bundle.getString("QueryOptionsSortTab.SortDirectionLabel.txt"), 75);
            sortDirectionColumn.setPossibleValues(m_sortDirectionArray);
            this.m_aColumns[1] = sortDirectionColumn;
        }

        public void populateStore() {
        }

        public void moveDataToModel() {
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public boolean isCellEditable(int row, int col) {
            return this.isColumnEditable[col];
        }

        public void insertRow(Object column, String sortDirection) {
            ArrayList<Object> m = new ArrayList<Object>();
            m.add(column);
            m.add(sortDirection);
            super.insertRow(this.getRowCount() - 1, m);
        }

        public void insertRow(Object column) {
            this.insertRow(column, m_sortDirectionArray[0]);
        }
    }

    class TableRowModelListener
    implements WsTableRowModelListener {
        TableRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent e) {
            QueryOptionsSortTab.this.setDataChanged(true);
        }

        public void rowsHidden(WsTableRowModelEvent e) {
        }

        public void rowsShown(WsTableRowModelEvent e) {
        }

        public void rowsRemapped(ChangeEvent e) {
            QueryOptionsSortTab.this.setDataChanged(true);
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || !QueryOptionsSortTab.this.isEditable()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                QueryOptionsSortTab.this.m_list.clearSelection();
            }
            QueryOptionsSortTab.this.enableButtons();
        }
    }

    class DNDScrollPane
    extends JScrollPane
    implements DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        public DNDScrollPane() {
            new DropTarget(this, this);
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Vector dndObj = null;
                Transferable transfer = event.getTransferable();
                if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    dndObj = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                    Object tempObj = dndObj.get(0);
                    if (tempObj instanceof DNDList) {
                        event.acceptDrop(2);
                        QueryOptionsSortTab.this.addItemsToTable();
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        event.rejectDrop();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                event.rejectDrop();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    class ColumnWrapper {
        private int m_columnModelIndex;

        private ColumnWrapper(int columnModelIndex) {
            this.m_columnModelIndex = columnModelIndex;
        }

        protected int getModelIndex() {
            return this.m_columnModelIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnWrapper) {
                return ((ColumnWrapper)obj).m_columnModelIndex == this.m_columnModelIndex;
            }
            return false;
        }

        public int hashcode() {
            return super.hashCode();
        }

        public String toString() {
            return QueryOptionsSortTab.this.m_model.getTrueColumnName(this.m_columnModelIndex);
        }
    }
}

