/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.viewdata2.ViewDataModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public abstract class JobTableModel
extends ViewDataModel {
    private ITable m_table;

    public JobTableModel(ITable table) {
        this.m_table = table;
    }

    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public String getTableDisplayName() {
        return this.m_table.getName();
    }

    @Override
    public String getTableSQLName() {
        String tableName = ((IPhysicalTable)this.m_table).getSASTableName();
        if (this.isParameterized()) {
            int indexOfAmp = tableName.lastIndexOf(38);
            int indexOfPeriod = tableName.lastIndexOf(46);
            if (indexOfAmp != -1 && indexOfPeriod < indexOfAmp) {
                tableName = tableName + ".";
            }
        }
        return DBMSNamesUtil.getQuotedName((String)tableName, (boolean)this.m_table.isQuoted(), (boolean)true, (boolean)false);
    }

    @Override
    public int getTrueColumnCount() {
        return this.m_table.getColumnCount();
    }

    @Override
    public String getTrueColumnDescription(int iColumn) {
        return this.m_table.getColumns()[iColumn].getDescription();
    }

    @Override
    public String getTrueColumnFormat(int iColumn) {
        return this.m_table.getColumns()[iColumn].getFormat();
    }

    @Override
    public String getTrueColumnName(int column) {
        return this.m_table.getColumns()[column].getColumnName(false);
    }

    @Override
    public String getTrueColumnObjectName(int iColumn) {
        return this.m_table.getColumns()[iColumn].getName();
    }

    @Override
    public int getTrueColumnPrecision(int column) {
        return this.m_table.getColumns()[column].getLength();
    }

    @Override
    public String getTrueColumnSASType(int column) {
        if (this.m_table.getColumns()[column].getType() == 1) {
            return "N";
        }
        return "C";
    }

    @Override
    public String getTrueColumnSQLName(int column) {
        return this.getTableSQLName() + "." + this.m_table.getColumns()[column].getColumnName(this.m_table.isQuoted());
    }

    @Override
    protected String getParameterizedMacroDeclaration() {
        try {
            return this.m_table.getDefaultParameterCode().toString();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (CodegenException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return "";
    }
}

