/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.viewdata2;

import com.sas.wadmin.viewdata2.ViewDataException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DataManager {
    public static final Object UNCHANGED_VALUE = new Object();
    public static final int UNKNOWN_ROWCOUNT = -1;
    public static final String PROPERTY_ROW_COUNT = "RowCount";
    public static final String PROPERTY_MAX_ROW_COUNT_YET = "MaxRowCountYet";
    private ResultSet m_rs;
    private ResultSetMetaData m_rsMetadata;
    private DataCache m_mainCache;
    private DataCache m_extendedCache = new DataCache();
    private int m_rowCount = -1;
    private int m_maxRowCountYet = -1;
    private ArrayList m_propertyChangeListeners;
    private boolean isApplyFormat;

    public DataManager(boolean applyFormat) {
        this.m_mainCache = new DataCache();
        this.isApplyFormat = applyFormat;
    }

    public DataManager(ResultSet rs, boolean applyFormat) throws SQLException {
        this(applyFormat);
        this.setResultSet(rs);
    }

    public void dispose() throws ViewDataException {
        try {
            this.closeResultSet();
        }
        catch (SQLException e) {
            throw new ViewDataException(e);
        }
    }

    public void setResultSet(ResultSet rs) throws SQLException {
        this.clearExtendedCache();
        this.clearMainCache();
        this.m_rs = rs;
        this.m_rowCount = -1;
        this.m_maxRowCountYet = -1;
        this.ensureResultSetOnRow();
        this.checkIfLastRowLoaded();
        this.setRSMetadata();
    }

    public ResultSet getResultSet() {
        return this.m_rs;
    }

    protected void setRSMetadata() throws SQLException {
        if (this.m_rs != null) {
            this.m_rsMetadata = this.m_rs.getMetaData();
        }
    }

    public ResultSetMetaData getRSMetadata() {
        return this.m_rsMetadata;
    }

    public void closeResultSet() throws SQLException {
        if (this.m_rs != null) {
            this.m_rs.close();
            this.m_rs = null;
        }
        this.clearExtendedCache();
        this.clearMainCache();
    }

    public int getColumnCount() throws SQLException {
        return this.m_rsMetadata.getColumnCount();
    }

    public Object getValueAt(int row, int col) throws SQLException, ViewDataException {
        this.validateRowNumber(row);
        if (this.m_rowCount == -1 && row == this.m_maxRowCountYet - 1) {
            this.peekRow(row + 1);
        }
        if (this.m_mainCache.isAbsoluteRowInCache(row)) {
            return this.m_mainCache.getAbsoluteValueAt(row, col);
        }
        if (this.m_extendedCache.isAbsoluteRowInCache(row)) {
            return this.m_extendedCache.getAbsoluteValueAt(row, col);
        }
        this.loadRow(row);
        return this.m_mainCache.getAbsoluteValueAt(row, col);
    }

    public boolean peek(int row) throws SQLException {
        return this.peekRow(row);
    }

    public void goToRow(int row) throws SQLException, ViewDataException {
        this.loadRow(row);
    }

    public void goToLastRow() throws SQLException, ViewDataException {
        this.loadLastRow();
    }

    public void setValueAt(Object value, int row, int col) throws SQLException {
        if (col >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException(col);
        }
        if (value == UNCHANGED_VALUE) {
            return;
        }
        ArrayList<Object> values = new ArrayList<Object>(this.getColumnCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i != col) {
                values.add(UNCHANGED_VALUE);
                continue;
            }
            values.add(value);
        }
        this.setRowValues(row, values);
    }

    public void setRowValues(int row, List values) throws SQLException {
        try {
            if (!this.m_rs.absolute(row + 1)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.updateCurrentRow(values);
            this.m_rs.updateRow();
            if (this.m_mainCache.isAbsoluteRowInCache(row)) {
                this.m_mainCache.updateCache(row);
            }
            if (this.m_extendedCache.isAbsoluteRowInCache(row)) {
                this.m_extendedCache.updateCache(row);
            }
        }
        finally {
            this.m_rs.cancelRowUpdates();
        }
    }

    public void appendRow(List values) throws SQLException {
        try {
            this.m_rs.moveToInsertRow();
            this.updateCurrentRow(values);
            this.m_rs.insertRow();
            this.m_rs.moveToCurrentRow();
            this.m_rs.next();
            if (this.getRowCount() != -1) {
                if (this.m_mainCache.isAbsoluteRowInCache(this.getRowCount() - 1) && this.m_mainCache.getCacheSize() != this.m_rs.getFetchSize()) {
                    if (this.isRowInRowCache(this.getRowCount() - 1)) {
                        this.m_mainCache.appendRow();
                    } else {
                        this.m_mainCache.clearCache();
                    }
                }
                if (this.m_extendedCache.isAbsoluteRowInCache(this.getRowCount() - 1) && this.m_extendedCache.getCacheSize() != 75) {
                    if (this.isRowInRowCache(this.getRowCount() - 1)) {
                        this.m_extendedCache.appendRow();
                    } else {
                        this.m_extendedCache.clearCache();
                    }
                }
                this.setRowCount(this.getRowCount() + 1);
            }
        }
        finally {
            this.m_rs.cancelRowUpdates();
            this.m_rs.moveToCurrentRow();
        }
    }

    public void deleteRow(int row) throws SQLException {
        if (!this.m_rs.absolute(row + 1)) {
            throw new IllegalArgumentException("Invalid row: " + row);
        }
        this.m_rs.deleteRow();
        if (this.m_mainCache.isAbsoluteRowInCache(row) || row < this.m_mainCache.getStartRow()) {
            this.m_mainCache.clearCache();
        }
        if (this.m_extendedCache.isAbsoluteRowInCache(row) || row < this.m_extendedCache.getStartRow()) {
            this.m_extendedCache.clearCache();
        }
        if (this.getRowCount() != -1) {
            this.setRowCount(this.getRowCount() - 1);
        } else if (row + 1 <= this.getMaxRowCountYet()) {
            this.setMaxRowCountYet(this.getMaxRowCountYet() - 1);
        }
    }

    protected void updateCurrentRow(List values) throws SQLException {
        block7: for (int i = 0; i < this.getColumnCount(); ++i) {
            Object value = values.get(i);
            if (value == UNCHANGED_VALUE) continue;
            if (value == null) {
                this.m_rs.updateObject(i + 1, value);
                continue;
            }
            switch (this.getRSMetadata().getColumnType(i + 1)) {
                case 4: {
                    this.m_rs.updateInt(i + 1, (int)((Integer)value));
                    continue block7;
                }
                case 8: {
                    this.m_rs.updateDouble(i + 1, (double)((Double)value));
                    continue block7;
                }
                case 12: {
                    this.m_rs.updateString(i + 1, (String)value);
                    continue block7;
                }
                case 91: {
                    this.m_rs.updateDate(i + 1, new java.sql.Date(((Date)value).getTime()));
                    continue block7;
                }
                case 93: {
                    this.m_rs.updateTimestamp(i + 1, new Timestamp(((Date)value).getTime()));
                    continue block7;
                }
                default: {
                    this.m_rs.updateObject(i + 1, value);
                }
            }
        }
    }

    private void loadRow(int row) throws SQLException, ViewDataException {
        this.validateRowNumber(row);
        if (this.m_mainCache.isAbsoluteRowInCache(row)) {
            return;
        }
        int contiguous = this.isRowInContiguousRowCache(row);
        if (contiguous == -1) {
            boolean result = this.m_rs.absolute(row + 1);
            this.checkIfLastRowLoaded();
            if (!result) {
                if (this.m_rs.isAfterLast()) {
                    throw new ViewDataException(new ArrayIndexOutOfBoundsException(row));
                }
                throw new ViewDataException("Error loading specified row");
            }
            this.cacheRowCache();
            this.clearExtendedCache();
            return;
        }
        int fetchSize = this.m_rs.getFetchSize();
        int currentRow = this.m_rs.getRow();
        int first = currentRow - (currentRow - 1) % fetchSize;
        int last = first + fetchSize - 1;
        last = this.m_rowCount != -1 && last > this.m_rowCount ? this.m_rowCount : last;
        int cacheSize = Math.min(75, last - first + 1);
        if (contiguous == 1) {
            this.m_extendedCache.cache(first - 1, cacheSize);
        } else if (contiguous == 0) {
            this.m_extendedCache.cache(last - cacheSize, cacheSize);
        }
        boolean result = this.m_rs.absolute(row + 1);
        this.checkIfLastRowLoaded();
        if (!result) {
            throw new ViewDataException("Error loading specified row");
        }
        this.cacheRowCache();
    }

    private void cacheRowCache() throws SQLException {
        int fetchSize = this.m_rs.getFetchSize();
        int currentRow = this.m_rs.getRow();
        int first = currentRow - (currentRow - 1) % fetchSize;
        int last = first + fetchSize - 1;
        last = this.m_rowCount != -1 && last > this.m_rowCount ? this.m_rowCount : last;
        int cacheSize = last - first + 1;
        this.m_mainCache.cache(first - 1, cacheSize);
    }

    private void loadLastRow() throws SQLException, ViewDataException {
        if (this.m_rowCount != -1) {
            this.loadRow(this.m_rowCount - 1);
        }
        boolean result = this.m_rs.last();
        this.checkIfLastRowLoaded();
        if (!result) {
            throw new ViewDataException("Error loading specified row");
        }
    }

    private boolean peekRow(int row) throws SQLException {
        boolean result;
        int current;
        if (row < 0 || this.m_rowCount != -1 && row > this.m_rowCount - 1) {
            return false;
        }
        if (this.m_maxRowCountYet - 1 >= row) {
            return true;
        }
        this.ensureResultSetOnRow();
        int currentRow = current = this.m_rs.getRow();
        if (current < row) {
            this.m_rs.absolute(row);
            currentRow = this.m_rs.getRow();
        }
        if (result = this.m_rs.absolute(row + 1)) {
            this.checkIfLastRowLoaded();
        } else if (this.m_rs.isAfterLast() && currentRow == row) {
            this.setRowCount(row);
        }
        this.m_rs.absolute(current);
        return result;
    }

    protected void clearMainCache() {
        this.m_mainCache.clearCache();
    }

    protected void clearExtendedCache() {
        this.m_extendedCache.clearCache();
    }

    private int isRowInContiguousRowCache(int row) throws SQLException {
        this.ensureResultSetOnRow();
        int fetchSize = this.m_rs.getFetchSize();
        int currentRow = this.m_rs.getRow();
        int currentRowSet = (currentRow - 1) / fetchSize + 1;
        int tempRowSet = row / fetchSize + 1;
        if (tempRowSet - currentRowSet == 1) {
            return 0;
        }
        if (tempRowSet - currentRowSet == -1) {
            return 1;
        }
        return -1;
    }

    private boolean isRowInRowCache(int row) throws SQLException {
        this.ensureResultSetOnRow();
        int fetchSize = this.m_rs.getFetchSize();
        int currentRow = this.m_rs.getRow();
        int first = currentRow - (currentRow - 1) % fetchSize;
        int last = first + fetchSize - 1;
        last = this.m_rowCount != -1 && last > this.m_rowCount ? this.m_rowCount : last;
        return row + 1 >= first && row + 1 <= last;
    }

    private void ensureResultSetOnRow() throws SQLException {
        if (this.m_rs.isBeforeFirst() && this.m_rs.isAfterLast()) {
            return;
        }
        if (this.m_rs.isBeforeFirst()) {
            this.m_rs.next();
        }
        if (this.m_rs.isAfterLast()) {
            this.m_rs.previous();
        }
    }

    private void validateRowNumber(int row) throws ViewDataException {
        if (row < 0 || this.m_rowCount != -1 && row > this.m_rowCount - 1) {
            throw new ViewDataException(new ArrayIndexOutOfBoundsException(row));
        }
    }

    private void checkIfLastRowLoaded() throws SQLException {
        if (this.m_rowCount != -1) {
            return;
        }
        if (this.m_rs.isAfterLast()) {
            if (this.m_rs.isBeforeFirst()) {
                this.setRowCount(0);
            } else if (this.m_rs.getRow() == 0 && this.getMaxRowCountYet() == -1) {
                this.setRowCount(0);
            }
            return;
        }
        int fetchSize = this.m_rs.getFetchSize();
        int currentRow = this.m_rs.getRow();
        int lastRow = currentRow - (currentRow - 1) % fetchSize + fetchSize - 1;
        if (lastRow <= this.m_maxRowCountYet) {
            return;
        }
        boolean result = this.m_rs.absolute(lastRow);
        if (!result) {
            if (this.m_rs.isAfterLast()) {
                this.m_rs.previous();
                this.setRowCount(this.m_rs.getRow());
            }
            return;
        }
        this.checkAndSetMaxRowCountYet(this.m_rs.getRow());
    }

    public void setRowCount(int rowCount) {
        if (this.m_rowCount == rowCount) {
            return;
        }
        int old = this.m_rowCount;
        this.m_rowCount = rowCount;
        this.setMaxRowCountYet(this.m_rowCount);
        this.notifyPropertyChange(PROPERTY_ROW_COUNT, old, this.m_rowCount);
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    private void checkAndSetMaxRowCountYet(int row) {
        if (row > this.m_maxRowCountYet) {
            this.setMaxRowCountYet(row);
        }
    }

    private void setMaxRowCountYet(int row) {
        if (this.m_maxRowCountYet == row || row == -1) {
            return;
        }
        int old = this.m_maxRowCountYet;
        this.m_maxRowCountYet = row;
        this.notifyPropertyChange(PROPERTY_MAX_ROW_COUNT_YET, old, this.m_maxRowCountYet);
    }

    public int getMaxRowCountYet() {
        return this.m_maxRowCountYet;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propertyChangeListeners == null) {
            this.m_propertyChangeListeners = new ArrayList();
        }
        this.m_propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeListeners.remove(listener);
    }

    private void notifyPropertyChange(String property, int oldValue, int newValue) {
        this.notifyPropertyChange(property, new Integer(oldValue), new Integer(newValue));
    }

    private void notifyPropertyChange(String property, Object oldValue, Object newValue) {
        this.notifyPropertyChange(new PropertyChangeEvent(this, property, oldValue, newValue));
    }

    private void notifyPropertyChange(PropertyChangeEvent event) {
        if (this.m_propertyChangeListeners == null) {
            return;
        }
        for (int i = 0; i < this.m_propertyChangeListeners.size(); ++i) {
            ((PropertyChangeListener)this.m_propertyChangeListeners.get(i)).propertyChange(event);
        }
    }

    class DataCache {
        protected static final int DEFAULT_CACHE_SIZE = 75;
        private Object[][] m_acache;
        private int m_startRow = -1;

        DataCache() {
        }

        void cache(int startRow) throws SQLException {
            this.cache(startRow, 75);
        }

        void cache(int startRow, int cacheSize) throws SQLException {
            this.clearCache();
            this.m_startRow = startRow;
            int colCount = DataManager.this.getColumnCount();
            this.initCache(cacheSize, colCount);
            for (int i = 0; i < cacheSize; ++i) {
                DataManager.this.m_rs.absolute(this.m_startRow + i + 1);
                for (int j = 0; j < colCount; ++j) {
                    Object objectValue = DataManager.this.m_rs.getObject(j + 1);
                    if (DataManager.this.isApplyFormat && DataManager.this.m_rs.wasNull()) {
                        objectValue = DataManager.this.m_rs.getString(j + 1);
                    }
                    this.m_acache[i][j] = objectValue;
                }
            }
        }

        void updateCache(int row) throws SQLException {
            if (!this.isAbsoluteRowInCache(row)) {
                throw new IllegalArgumentException("Row not in row cache");
            }
            int colCount = DataManager.this.getColumnCount();
            DataManager.this.m_rs.absolute(row + 1);
            for (int j = 0; j < colCount; ++j) {
                this.m_acache[row - this.m_startRow][j] = DataManager.this.m_rs.getObject(j + 1);
            }
        }

        void appendRow() throws SQLException {
            int colCount = DataManager.this.getColumnCount();
            Object[][] temp = new Object[this.m_acache.length + 1][colCount];
            System.arraycopy(this.m_acache, 0, temp, 0, this.m_acache.length);
            DataManager.this.m_rs.absolute(this.m_startRow + this.getCacheSize() + 1);
            for (int j = 0; j < colCount; ++j) {
                temp[temp.length - 1][j] = DataManager.this.m_rs.getObject(j + 1);
            }
            this.m_acache = temp;
        }

        void initCache(int rows, int cols) {
            this.m_acache = new Object[rows][cols];
        }

        void clearCache() {
            this.m_startRow = -1;
            this.m_acache = null;
        }

        int getCacheSize() {
            return this.m_acache == null ? 0 : this.m_acache.length;
        }

        int getStartRow() {
            return this.m_startRow;
        }

        boolean isAbsoluteRowInCache(int row) {
            if (this.getStartRow() < 0) {
                return false;
            }
            return row >= this.getStartRow() && row + 1 <= this.getStartRow() + this.getCacheSize();
        }

        Object getValueAt(int row, int column) {
            return this.m_acache[row][column];
        }

        Object getAbsoluteValueAt(int row, int column) {
            return this.getValueAt(row - this.m_startRow, column);
        }
    }
}

